/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.Duration;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class DateTime
extends GregorianCalendar {
    SimpleDateFormat isoFormatter;
    String isoFormat;
    String dateOnlyFormat;
    SimpleDateFormat dateFormatter;
    String dateFormat;
    static HashMap fieldmap = new HashMap(17);

    public DateTime() {
        this.isoFormat = "yyyyMMdd'T'HHmmss'Z'";
        this.dateOnlyFormat = "yyyyMMdd";
        this.dateFormat = "EEE MMM dd hh:mm:ss zzz yyyy";
        this.init();
    }

    public DateTime(TimeZone timezone) {
        this.isoFormat = "yyyyMMdd'T'HHmmss'Z'";
        this.dateOnlyFormat = "yyyyMMdd";
        this.dateFormat = "EEE MMM dd hh:mm:ss zzz yyyy";
        this.init();
        this.setTimeZone(timezone);
        this.computeFields();
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second) {
        this.isoFormat = "yyyyMMdd'T'HHmmss'Z'";
        this.dateOnlyFormat = "yyyyMMdd";
        this.dateFormat = "EEE MMM dd hh:mm:ss zzz yyyy";
        this.init();
        this.set(year, month, day, hour, minute, second);
        this.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateTime(String datestr) throws ParseException {
        this.isoFormat = "yyyyMMdd'T'HHmmss'Z'";
        this.dateOnlyFormat = "yyyyMMdd";
        this.dateFormat = "EEE MMM dd hh:mm:ss zzz yyyy";
        this.init();
        try {
            this.setTime(this.isoFormatter.parse(datestr));
        }
        catch (Exception e) {
            this.isoFormatter.applyPattern(this.dateOnlyFormat);
            this.setTime(this.isoFormatter.parse(datestr));
        }
        finally {
            this.isoFormatter.applyPattern(this.isoFormat);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DateTime(String datestr, TimeZone timezone) throws ParseException {
        block4: {
            this.isoFormat = "yyyyMMdd'T'HHmmss'Z'";
            this.dateOnlyFormat = "yyyyMMdd";
            this.dateFormat = "EEE MMM dd hh:mm:ss zzz yyyy";
            this.init();
            TimeZone oldTz = this.isoFormatter.getTimeZone();
            try {
                try {
                    this.setTime(this.isoFormatter.parse(datestr));
                }
                catch (Exception e) {
                    this.isoFormatter.setTimeZone(timezone);
                    this.isoFormatter.applyPattern(this.dateOnlyFormat);
                    this.setTime(this.isoFormatter.parse(datestr));
                    Object var6_5 = null;
                    this.isoFormatter.applyPattern(this.isoFormat);
                    this.isoFormatter.setTimeZone(oldTz);
                    break block4;
                }
                Object var6_4 = null;
                this.isoFormatter.applyPattern(this.isoFormat);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.isoFormatter.applyPattern(this.isoFormat);
                this.isoFormatter.setTimeZone(oldTz);
                throw throwable;
            }
            this.isoFormatter.setTimeZone(oldTz);
        }
        this.setTimeZone(timezone);
        this.computeFields();
    }

    public void init() {
        this.isoFormatter = new SimpleDateFormat(this.isoFormat);
        this.isoFormatter.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.isoFormatter.setLenient(false);
        this.dateFormatter = new SimpleDateFormat(this.dateFormat);
        this.dateFormatter.setLenient(false);
    }

    public int getYear() {
        return this.get(1);
    }

    public void setYear(int year) {
        this.set(1, year);
    }

    public int getMonth() {
        return this.get(2);
    }

    public void setMonth(int month) {
        this.set(2, month);
    }

    public int getDay() {
        return this.get(5);
    }

    public void setDay(int day) {
        this.set(5, day);
    }

    public int getHours() {
        return this.get(11);
    }

    public void setHours(int hours) {
        this.set(11, hours);
    }

    public int getMinutes() {
        return this.get(12);
    }

    public void setMinutes(int minutes) {
        this.set(12, minutes);
    }

    public int getSeconds() {
        return this.get(13);
    }

    public void setSeconds(int seconds) {
        this.set(13, seconds);
    }

    public void setDate(int year, int month, int day) {
        this.set(1, year);
        this.set(2, month);
        this.set(5, day);
    }

    public void setTime(int hour, int minute, int second) {
        this.set(11, hour);
        this.set(12, minute);
        this.set(13, second);
    }

    public void add(Duration duration) {
        if (null == duration) {
            return;
        }
        int sign = duration.getSign();
        this.add(3, sign * duration.getWeeks());
        this.add(6, sign * duration.getDays());
        this.add(11, sign * duration.getHours());
        this.add(12, sign * duration.getMinutes());
        this.add(13, sign * duration.getSeconds());
    }

    public String toISO8601() {
        return this.isoFormatter.format(this.getTime());
    }

    public String toISOString() {
        return this.toISO8601();
    }

    public String toString() {
        this.dateFormatter.setTimeZone(this.getTimeZone());
        return this.dateFormatter.format(this.getTime());
    }

    public static Integer mapField(String field) {
        return (Integer)fieldmap.get(field);
    }

    static {
        fieldmap.put("AM", new Integer(0));
        fieldmap.put("PM", new Integer(1));
        fieldmap.put("AM_PM", new Integer(9));
        fieldmap.put("HOUR", new Integer(10));
        fieldmap.put("HOUR_OF_DAY", new Integer(11));
        fieldmap.put("MINUTE", new Integer(12));
        fieldmap.put("SECOND", new Integer(13));
        fieldmap.put("MILLISECOND", new Integer(14));
        fieldmap.put("DATE", new Integer(5));
        fieldmap.put("DAY_OF_MONTH", new Integer(5));
        fieldmap.put("DAY_OF_WEEK", new Integer(7));
        fieldmap.put("DAY_OF_YEAR", new Integer(6));
        fieldmap.put("MONTH", new Integer(2));
        fieldmap.put("YEAR", new Integer(1));
        fieldmap.put("WEEK_OF_MONTH", new Integer(4));
        fieldmap.put("WEEK_OF_YEAR", new Integer(3));
        fieldmap.put("ZONE_OFFSET", new Integer(15));
        fieldmap.put("DST_OFFSET", new Integer(16));
        fieldmap.put("ERA", new Integer(0));
    }
}

