/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.CalendarSession;
import com.sun.comclient.calendar.CalendarStoreException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.ICalendar;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.URLName;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public abstract class CalendarStore {
    private CalendarSession session;
    private URLName serviceUrl;
    private Hashtable calendarCache;

    protected CalendarStore(CalendarSession session) {
        this.session = session;
        this.calendarCache = new Hashtable();
    }

    public final void connect(String hostname) throws CalendarStoreException {
        this.connect(hostname, -1);
    }

    public void connect(String hostname, int port) throws CalendarStoreException {
        String protocol = this.session.getProperty("cal.protocol", "http");
        String user = this.session.getProperty("cal.user", "");
        String password = this.session.getProperty("cal.password", "");
        if (port <= 0) {
            port = -1;
        }
        this.serviceUrl = new URLName(protocol, hostname, port, "", user, password);
        this.connect(this.serviceUrl);
    }

    public final void connect(URLName url) throws CalendarStoreException {
        this.serviceUrl = url;
        this.connectURL(url);
    }

    protected abstract void connectURL(URLName var1) throws CalendarStoreException;

    public abstract void disconnect() throws CalendarStoreException;

    public abstract boolean isConnected();

    public void update() {
        Enumeration all = this.calendarCache.elements();
        ICalendar tmp = null;
        while (all.hasMoreElements()) {
            tmp = (ICalendar)all.nextElement();
            tmp.update();
        }
    }

    public CalendarSession getSession() {
        return this.session;
    }

    public URLName getServiceUrl() {
        return this.serviceUrl;
    }

    public ICalendar openCalendar() throws CalendarStoreException {
        String defaultCalendarID = null;
        defaultCalendarID = this.getDefaultCalendarId();
        return this.openCalendar(defaultCalendarID);
    }

    public ICalendar openCalendar(String cid) throws CalendarStoreException {
        ICalendar cal = (ICalendar)this.calendarCache.get(cid);
        if (cal == null && (cal = this.loadCalendar(cid)) != null) {
            this.calendarCache.put(cid, cal);
        }
        return cal;
    }

    public abstract ICalendar[] getCalendars() throws CalendarStoreException, OperationNotSupportedException;

    public abstract String[] getSubscribedCalenders() throws CalendarStoreException, OperationNotSupportedException;

    public abstract String verifyCalendarId(String var1) throws CalendarStoreException, OperationNotSupportedException;

    protected abstract String getDefaultCalendarId() throws CalendarStoreException;

    protected abstract ICalendar loadCalendar(String var1) throws CalendarStoreException;

    public abstract ICalendar[] searchCalendars(String var1) throws CalendarStoreException, OperationNotSupportedException;

    public abstract ICalendar[] searchCalendars(String var1, Properties var2) throws CalendarStoreException, OperationNotSupportedException;

    public abstract ICalendar[] searchCalendars(String var1, int var2, int var3) throws CalendarStoreException, OperationNotSupportedException;

    public abstract ICalendar[] searchCalendars(String var1, int var2, int var3, Properties var4) throws CalendarStoreException, OperationNotSupportedException;

    protected abstract void unloadCalendar(ICalendar var1) throws CalendarStoreException;

    public void closeCalendar(String cid) throws CalendarStoreException {
        ICalendar cal = null;
        if (cid != null) {
            cal = (ICalendar)this.calendarCache.get(cid);
        }
        this.closeCalendar(cal);
    }

    public void closeCalendar(ICalendar cal) throws CalendarStoreException {
        if (cal != null) {
            this.unloadCalendar(cal);
            String theCalId = cal.getCalID();
            if (null != theCalId) {
                this.calendarCache.remove(theCalId);
            }
        }
    }

    public abstract ICalendar createCalendar(String var1) throws CalendarStoreException, OperationNotSupportedException;

    public abstract ICalendar createCalendar(String var1, Properties var2) throws CalendarStoreException, OperationNotSupportedException;

    public abstract void deleteCalendar(String var1) throws CalendarStoreException, OperationNotSupportedException;

    public abstract BufferedReader exportCalendar(String var1, DateTime var2, DateTime var3, String var4) throws CalendarStoreException, OperationNotSupportedException;

    public abstract BufferedReader exportCalendar(String var1, DateTime var2, DateTime var3, String var4, String var5, int var6) throws CalendarStoreException, OperationNotSupportedException;

    public abstract void importCalendar(String var1, String var2, InputStream var3) throws CalendarStoreException, OperationNotSupportedException;

    public abstract void importCalendar(String var1, DateTime var2, DateTime var3, String var4, InputStream var5) throws CalendarStoreException, OperationNotSupportedException;
}

