/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.Organizer;
import com.sun.comclient.calendar.PropertiesException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Attendee
extends Organizer {
    public static final String ROLE = "ROLE";
    public static final String USERTYPE = "CUTYPE";
    public static final String PARTICIPANT_STATUS = "PARTSTAT";
    public static final String RSVP = "RSVP";
    public static final String MEMBER = "MEMBER";
    public static final String DELEGATED_TO = "DELEGATED-TO";
    public static final String DELEGATED_FROM = "DELEGATED-FROM";
    public static final String VALUE = "ATTENDEE";
    public static final String INDIVIDUAL = "INDIVIDUAL";
    public static final String GROUP = "GROUP";
    public static final String RESOURCE = "RESOURCE";
    public static final String ROOM = "ROOM";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String CHAIR = "CHAIR";
    public static final String REQ_PARTICIPANT = "REQ-PARTICIPANT";
    public static final String OPT_PARTICIPANT = "OPT-PARTICIPANT";
    public static final String NON_PARTICIPANT = "NON-PARTICIPANT";
    public static final String NEEDS_ACTION = "NEEDS-ACTION";
    public static final String ACCEPTED = "ACCEPTED";
    public static final String DECLINED = "DECLINED";
    public static final String TENTATIVE = "TENTATIVE";
    public static final String COMPLETED = "COMPLETED";
    public static final String IN_PROCESS = "IN-PROCESS";
    public static final String DELEGATED = "DELEGATED";
    private static final Hashtable _userTypeValues = new Hashtable();
    private static final Hashtable _roleValues = new Hashtable();
    private static final Hashtable _partStatValues = new Hashtable();
    private String userType;
    private String role;
    private String participantStatus;
    private boolean isRSVP;
    private String memberOf;
    private String delegatedTo;
    private String delegatedFrom;

    public Attendee() {
        this.userType = INDIVIDUAL;
        this.role = REQ_PARTICIPANT;
        this.participantStatus = NEEDS_ACTION;
        this.isRSVP = false;
    }

    public Attendee(String userType, String val) throws PropertiesException {
        this.userType = INDIVIDUAL;
        this.role = REQ_PARTICIPANT;
        this.participantStatus = NEEDS_ACTION;
        this.isRSVP = false;
        this.setUserType(userType);
        this.myValue = val;
    }

    public Attendee(String userType, String role, String val) throws PropertiesException {
        this.userType = INDIVIDUAL;
        this.role = REQ_PARTICIPANT;
        this.participantStatus = NEEDS_ACTION;
        this.isRSVP = false;
        this.setUserType(userType);
        this.role = role;
        this.myValue = val;
    }

    public Attendee(String rfcFormat) throws IllegalArgumentException, PropertiesException {
        block11: {
            this.userType = INDIVIDUAL;
            this.role = REQ_PARTICIPANT;
            this.participantStatus = NEEDS_ACTION;
            this.isRSVP = false;
            StreamTokenizer st = new StreamTokenizer(new StringReader(rfcFormat));
            st.wordChars(32, 32);
            st.wordChars(64, 64);
            st.ordinaryChars(48, 57);
            st.ordinaryChar(46);
            String value = "";
            try {
                if (st.nextToken() != -3 || !st.sval.equalsIgnoreCase(VALUE)) {
                    throw new IllegalArgumentException("Invalid ATTENDEE definition format(see RFC2445)");
                }
                char ch = (char)st.nextToken();
                String avPair = "";
                while (ch == ';') {
                    st.nextToken();
                    avPair = avPair + st.sval;
                    st.nextToken();
                    avPair = avPair + "=";
                    st.nextToken();
                    avPair = avPair + st.sval;
                    this.processParams(avPair);
                    avPair = "";
                    ch = (char)st.nextToken();
                }
                if (ch != ':') {
                    throw new IllegalArgumentException("Missing ATTENDEE value(see RFC2445)");
                }
                block7: while (st.nextToken() != -1) {
                    switch (st.ttype) {
                        case -3: {
                            value = value + st.sval;
                            continue block7;
                        }
                        case -2: {
                            value = value + String.valueOf(st.nval);
                            continue block7;
                        }
                    }
                    char[] c = new char[]{(char)st.ttype};
                    value = value + new String(c);
                }
                this.myValue = value;
            }
            catch (Exception e) {
                if (e instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)e;
                }
                if (!(e instanceof PropertiesException)) break block11;
                throw (PropertiesException)e;
            }
        }
    }

    public String getUserType() {
        return this.userType;
    }

    public String getRole() {
        return this.role;
    }

    public String getParticipantStatus() {
        return this.participantStatus;
    }

    public String getMember() {
        return this.memberOf;
    }

    public boolean isRSVPRequired() {
        return this.isRSVP;
    }

    public String getDelegatedTo() {
        return this.delegatedTo;
    }

    public String getDelegatedFrom() {
        return this.delegatedFrom;
    }

    public void setDelegatedTo(String to) {
        this.delegatedTo = to;
    }

    public void setDelegatedFrom(String from) {
        this.delegatedFrom = from;
    }

    public void setUserType(String userType) throws PropertiesException {
        if (_userTypeValues.get(userType.toUpperCase()) == null) {
            PropertiesException ex = new PropertiesException(PropertiesException.errorMessages[1]);
            throw ex;
        }
        this.userType = userType.toUpperCase();
    }

    public void setRole(String role) throws PropertiesException {
        if (_roleValues.get(role.toUpperCase()) == null) {
            PropertiesException ex = new PropertiesException(PropertiesException.errorMessages[1]);
            throw ex;
        }
        this.role = role.toUpperCase();
    }

    public void setRSVPRequired(boolean val) {
        this.isRSVP = val;
    }

    public void setParticipantStatus(String partStat) throws PropertiesException {
        if (_partStatValues.get(partStat.toUpperCase()) == null) {
            PropertiesException ex = new PropertiesException(PropertiesException.errorMessages[1]);
            throw ex;
        }
        this.participantStatus = partStat.toUpperCase();
    }

    public void setMember(String url) {
        this.memberOf = url;
    }

    protected void processParams(String avPair) throws IllegalArgumentException, PropertiesException {
        super.processParams(avPair);
        StringTokenizer st = new StringTokenizer(avPair, "=");
        if (st.countTokens() <= 1) {
            throw new IllegalArgumentException("Syntax error in Recurrence Pattern");
        }
        String attr = st.nextToken();
        String val = st.nextToken();
        if ((attr = attr.toUpperCase()).equals(USERTYPE)) {
            this.setUserType(val);
        } else if (attr.equals(ROLE)) {
            this.setRole(val);
        } else if (attr.equals(PARTICIPANT_STATUS)) {
            this.setParticipantStatus(val);
        } else if (attr.equals(RSVP) && val.equalsIgnoreCase("TRUE")) {
            this.isRSVP = true;
        } else if (attr.equals(MEMBER)) {
            this.memberOf = val;
        } else if (attr.equals(DELEGATED_TO)) {
            this.delegatedTo = val;
        } else if (attr.equals(DELEGATED_FROM)) {
            this.delegatedFrom = val;
        }
    }

    public String toRFC2445() {
        String out = VALUE;
        out = out + ";CUTYPE=" + this.userType;
        out = out + ";ROLE=" + this.role;
        out = out + ";PARTSTAT=" + this.participantStatus;
        out = out + ";RSVP=" + (this.isRSVP ? "TRUE" : "FALSE");
        if (this.commonName != null) {
            out = out + ";CN=" + this.commonName;
        }
        if (this.memberOf != null) {
            out = out + ";MEMBER=" + this.memberOf;
        }
        if (this.dirURL != null) {
            out = out + ";DIR=" + this.dirURL;
        }
        if (this.delegatedTo != null) {
            out = out + ";DELEGATED-TO=" + this.delegatedTo;
        }
        if (this.delegatedFrom != null) {
            out = out + ";DELEGATED-FROM=" + this.delegatedFrom;
        }
        if (this.sentBy != null) {
            out = out + ";SENT-BY=" + this.sentBy;
        }
        if (this.lang != null) {
            out = out + ";LANGUAGE=" + this.lang;
        }
        if (this.myValue != null) {
            out = out + ":" + this.myValue;
        }
        return out;
    }

    static {
        _userTypeValues.put(INDIVIDUAL, "Dummy1");
        _userTypeValues.put(GROUP, "Dummy2");
        _userTypeValues.put(RESOURCE, "Dummy3");
        _userTypeValues.put(ROOM, "Dummy4");
        _userTypeValues.put(UNKNOWN, "Dummy5");
        _roleValues.put(CHAIR, "Dummy1");
        _roleValues.put(REQ_PARTICIPANT, "Dummy2");
        _roleValues.put(OPT_PARTICIPANT, "Dummy3");
        _roleValues.put(NON_PARTICIPANT, "Dummy4");
        _partStatValues.put(NEEDS_ACTION, "Dummy1");
        _partStatValues.put(ACCEPTED, "Dummy2");
        _partStatValues.put(DECLINED, "Dummy3");
        _partStatValues.put(TENTATIVE, "Dummy4");
        _partStatValues.put(IN_PROCESS, "Dummy5");
        _partStatValues.put(DELEGATED, "Dummy6");
    }
}

