/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comclient.calendar;

import com.sun.comclient.calendar.PropertiesException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.StringTokenizer;

public class Attach {
    private String fileType = null;
    private String myValue = null;

    private void processParams(String avPair) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(avPair, "=");
        if (st.countTokens() <= 1) {
            throw new IllegalArgumentException("Syntax error in Organizer(or subclass) object");
        }
        String attr = st.nextToken();
        String val = st.nextToken();
        if (!(attr = attr.toUpperCase()).equals("FMTTYPE")) {
            throw new IllegalArgumentException("Invalid ATTACH property parameter");
        }
        this.fileType = val;
    }

    private String[] _split(String src, char delim, int limit) {
        String[] result = new String[limit];
        int len = src.length();
        int start = 0;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            if (src.charAt(i) != delim) continue;
            if (count >= limit - 1) break;
            result[count] = src.substring(start, i);
            start = i + 1;
            ++count;
        }
        if (count < limit) {
            result[count] = src.substring(start, len);
        }
        return result;
    }

    public Attach() {
    }

    public Attach(String calURI) {
        this.myValue = calURI;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Attach(String fileType, String url) throws IllegalArgumentException, PropertiesException {
        if (fileType == "RFC") {
            StreamTokenizer st = new StreamTokenizer(new StringReader(url));
            st.wordChars(47, 47);
            String value = "";
            try {
                if (st.nextToken() != -3 || !st.sval.equalsIgnoreCase("ATTACH")) {
                    throw new IllegalArgumentException("Invalid ATTACH definition format(see RFC2445)");
                }
                char ch = (char)st.nextToken();
                String avPair = "";
                while (ch == ';') {
                    st.nextToken();
                    avPair = avPair + st.sval;
                    st.nextToken();
                    avPair = avPair + "=";
                    st.nextToken();
                    avPair = avPair + st.sval;
                    this.processParams(avPair);
                    avPair = "";
                    ch = (char)st.nextToken();
                }
                if (ch != ':') {
                    throw new PropertiesException("ATTACH:" + PropertiesException.errorMessages[3]);
                }
                String[] tokens = this._split(url, ':', 2);
                this.myValue = tokens[1];
                return;
            }
            catch (Exception e) {
                if (e instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)e;
                }
                if (!(e instanceof PropertiesException)) return;
                throw (PropertiesException)e;
            }
        } else {
            this.fileType = fileType;
            this.myValue = url;
        }
    }

    public String getFileType() {
        return this.fileType;
    }

    public String getValue() {
        return this.myValue;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setValue(String val) {
        this.myValue = val;
    }

    public String toRFC2445() {
        String rfcFormat = "ATTACH";
        if (this.fileType != null) {
            rfcFormat = rfcFormat + ";FMTTYPE=" + this.fileType;
        }
        if (this.myValue != null) {
            rfcFormat = rfcFormat + ":" + this.myValue;
        }
        return rfcFormat;
    }
}

