
<!-- 
  Method usage:
   In the jsp code tag:  out.print(getLocalizedLabel(session, "uwc-common-options-label-DefaultEmailClient"));
   As an expression:: getLocalizedLabel(session, "uwc-common-options-label-DefaultEmailClient")
-->

<%@ page import="java.lang.String" %>
<%@ page import="java.util.logging.Logger" %>
<%@ page import="java.util.logging.Level" %>
<%@ page import="com.sun.uwc.common.util.UWCLogger" %>
<%@ page import="com.sun.uwc.common.model.UWCResourceBundleModel" %>
<%@ page import="com.sun.uwc.common.util.UWCConstants" %>
<%@ page import="com.sun.uwc.common.SessionConstants" %>
<%@ page import="java.util.Enumeration" %>
<%@ page import="com.iplanet.jato.util.NonSyncStringBuffer" %>
<%@ page import="com.sun.uwc.common.util.UWCPreferences" %>
<%@ page import="com.sun.uwc.UWCServletBase" %>
<%@ page import="javax.servlet.http.HttpSession" %>

<%!
  private static Logger _log = null;

  static {
    _log = UWCLogger.getLogger(UWCConstants.UWC_LOGGER);
  }

  public String getLocalizedLabel(HttpSession s, String label)
  {
    return getLocalizedLabel(s, "i18nModel", label, null);
  }

  public String getLocalizedLabel(HttpSession s, String label, String defaultLabel)
  {
    return getLocalizedLabel(s, "i18nModel", label, defaultLabel);
  }

  public String getLocalizedLabel(HttpSession s, String modelName, String label, String defaultLabel)
  {   

    if((null == s) || (null == modelName) || (null == label)) {
      // if(_log.isLoggable(Level.FINEST)) _log.finest("javascript: getLocalizedLabel: Returning null");
      return null;
    }

    UWCResourceBundleModel theModel = (UWCResourceBundleModel) s.getAttribute(modelName);
    if(null == theModel) {
      // if(_log.isLoggable(Level.FINEST)) _log.finest("javascript: getLocalizedLabel: Couldn't get the model: " + theModel);
      // if(_log.isLoggable(Level.FINEST)) _log.finest("javascript: getLocalizedLabel: So returning default label: " + defaultLabel);
      return defaultLabel;
    }

    String value = (String) theModel.getValue(label);
    if(null == value) {
      if(_log.isLoggable(Level.FINEST)) _log.finest("javascript: getLocalizedLabel: Value is null: So returning default label: " + defaultLabel);
      return defaultLabel;
    }   

    return value;
  }

  private String getTitleForExtraHtml(HttpSession s, String key, String defaultValue)
  {
    return "title=\"" + getLocalizedLabel(s, key, defaultValue) + "\"";
  }

  private String trim(String s) 
  {
      return s.trim();
  }

  public String getContextURI(HttpServletRequest request) {
    String path = request.getContextPath();  
    if( path.equals("/") )
     path="";        
    
    return path;
  }
  
  public boolean isMailEnabled(HttpServletRequest request) {
    HttpSession session = request.getSession(false);
    String mailstat = (String)session.getAttribute(SessionConstants.MAIL_SERVICE_ENABLED);
    if(mailstat.equals("true")) 
       return true;
    else
       return false;
  }


  public String getMailURI(HttpServletRequest request){
    String url = null; 
    String flag = "false";
    HttpSession session = request.getSession();
    String userdomain = (String)session.getAttribute(SessionConstants.DOMAIN_NAME);
    flag = (String)session.getAttribute("hosteddomain");
    if(null == flag)
     flag ="false";
    if (flag.equalsIgnoreCase("true"))
           url = request.getSession().getAttribute("mailurl") + "/" + request.getSession().getAttribute("domainname") + "/history.html?cfg.msc?fromuwc=1";
    else
           url = request.getSession().getAttribute("mailurl") + "/history.html?cfg.msc?fromuwc=1"; 
     return url;
  }

  public String getHistoryURI(HttpServletRequest request) {
    String url = null; 
    if(isMailEnabled(request)) {
       String uwcurl = request.getRequestURL().toString();
       int ind = uwcurl.indexOf("//");
       ind = uwcurl.indexOf("/", ind+2);
       _log.fine("domain name: " + request.getSession().getAttribute("domainname"));
       String flag = "false";
       HttpSession session = request.getSession();
       String userdomain = (String)session.getAttribute(SessionConstants.DOMAIN_NAME);
       flag = (String)session.getAttribute("hosteddomain");
       if(null == flag)
          flag ="false";
       if (flag.equalsIgnoreCase("true"))
           url = request.getSession().getAttribute("mailurl") + "/" + request.getSession().getAttribute("domainname") + "/history.html?" + uwcurl.substring(0,ind) + getContextURI(request);
       else
           url = request.getSession().getAttribute("mailurl") + "/history.html?" + uwcurl.substring(0,ind) + getContextURI(request);
    }else
       url = getContextURI(request);
    return url;
  }

  public String getHistoryTarget(HttpServletRequest request) {
     if(isMailEnabled(request))
        return "historyFrame";
     else
        return "_parent";
  }

  public String getQueryString(HttpServletRequest request) 
  { 
    //** Having it temporary unless figure out why would querystring not give the value
    Enumeration paramNames = request.getParameterNames();
    String queryString = null;
    if( paramNames != null ) {
        NonSyncStringBuffer sb = new NonSyncStringBuffer(256);
        sb.append(UWCConstants.QUERY_START_SEPARATOR);
        while( paramNames.hasMoreElements() ) {                      
          String paramName = (String)paramNames.nextElement();
          sb.append(paramName);
          sb.append(UWCConstants.QUERY_NAMEVALUE_SEPARATOR);
          sb.append(request.getParameter(paramName));
          sb.append(UWCConstants.QUERY_PARAMETER_SEPARATOR);
        }
        queryString = sb.toString();
    }

    int len = ((null == queryString)? -1 : queryString.length());
    if(len > 0) //there have been query params
      queryString = queryString.substring(0, len - 1);

    if(_log.isLoggable(Level.FINEST)) _log.finest("javascript: getQueryString: Returing: " + queryString);

    return queryString;
  }

  /** Pass the help context uri to 'helpCtx' argument */
  public String getHelpCtxUrl(HttpSession s, HttpServletRequest request, String helpCtx)
  { 
    String lang = (String) s.getAttribute(SessionConstants.USER_LANG);
    if(null == lang) {
      lang = "en";
      // _log.finest("javascript: getHelpCtxUrl: USER_LANG is null: So using 'en' help url");
    }

    // if(_log.isLoggable(Level.FINEST)) _log.finest("javascript: getHelpCtxUrl: Returning: " + getContextURI(request) + "/help/" + lang + helpCtx);
  
    return getContextURI(request) + "/help/" + lang + helpCtx;
  }

  public String getExtraHtml(String field, String value)
  {     
     if( field == null || value == null )
       return "";
           
     return field + "='" + value + "'";
  }
     
  public String getCalendarViewUri(HttpServletRequest request)
  {
    return "/calclient/" + UWCConstants.CAL_VIEW_DAY;

   /*=====
    * Commented on 12-Aug-2003: Commented as we are not retaining the
    * context data acrooss the tabs such as calendar. mail, address_nook,
    * option tabs.
    *
    *
    * String lastCalView = request.getParameter(UWCConstants.LAST_CAL_VIEW_IN_URL);    
    * if(_log.isLoggable(Level.FINEST)) {
    *   _log.finest("javascript: getCalendarViewUri: lastCalView: " + lastCalView);
    * }
    *
    * if(UWCConstants.CAL_VIEW_DAY.equalsIgnoreCase(lastCalView) ||
    *    UWCConstants.CAL_VIEW_WEEK.equalsIgnoreCase(lastCalView) ||
    *    UWCConstants.CAL_VIEW_MONTH.equalsIgnoreCase(lastCalView) ||
    *    UWCConstants.CAL_VIEW_YEAR.equalsIgnoreCase(lastCalView) ||
    *    UWCConstants.CAL_VIEW_INVITATIONS.equalsIgnoreCase(lastCalView) ||
    *    UWCConstants.CAL_VIEW_EVENTS.equalsIgnoreCase(lastCalView) ||
    *    UWCConstants.CAL_VIEW_TASKS.equalsIgnoreCase(lastCalView) ||
    *    UWCConstants.CAL_VIEW_MANAGE_CALENDAR.equalsIgnoreCase(lastCalView))
    * {
    *   lastCalView = "/calclient/" + lastCalView;
    * }
    * else { // Default is day view
    *   lastCalView = "/calclient/" + UWCConstants.CAL_VIEW_DAY;
    * }
    *
    * if(_log.isLoggable(Level.FINEST)) {
    *     _log.finest("javascript: getCalendarViewUri: Returning: " + lastCalView);
    * }
    *
    * return lastCalView;
    *
    =====*/
  }

%>

