<%@page info="New Calendar" pageEncoding="utf-8" language="java" contentType="text/html; charset=UTF-8"%>
<%@taglib uri="/WEB-INF/jato.tld" prefix="jato" %>
<jato:useViewBean className="com.sun.uwc.calclient.NewCalendarDataViewBean" fireChildDisplayEvents="true">
<%@include file="/uwc/js/resourceBundleUtils.js"%>
<html>
<head>
<title><%= getThePageTitle(session, request) %></title>
<%  String path = request.getContextPath();  
   if( path.equals("/") )
     path="";
%>
<SCRIPT language="JavaScript" src="../uwc/js/scripts.js"></SCRIPT>
<SCRIPT language="JavaScript" src="../uwc/js/uwcUtils.js"></SCRIPT>
<SCRIPT src="../uwc/js/browserVersion.js" type="text/javascript"></SCRIPT>

<script type="text/javascript">
 if (is_ie5up) // IE5
  {
   document.write("<LINK href=<%=getLocalizedLabel(session, "skinModel", "Style-Sheet-IE", "../uwc/css/css_ie5win.css") %> type=text/css rel=stylesheet>") 
  }
  else if (is_gecko) // Netscape 6/7 or Mozilla
  {
   document.write("<LINK href=<%=getLocalizedLabel(session, "skinModel", "Style-Sheet-NN", "../uwc/css/css_ns6up.css") %> type=text/css rel=stylesheet>") 
  }
  else  // All others
  {
   document.write("<LINK href=<%=getLocalizedLabel(session, "skinModel", "Style-Sheet-NN", "../uwc/css/css_ns6up.css") %> type=text/css rel=stylesheet>") 
  }

</script>

<%!

  public String getThePageTitle(HttpSession s, HttpServletRequest sr) {
    if(null == sr.getParameter(UWCConstants.CALID_IN_URL)) {
      return getLocalizedLabel(s, "uwc-calclient-new-calendar-title", "New Calendar");
    }
    else {
      return getLocalizedLabel(s, "uwc-calclient-edit-calendar-title", "Edit Calendar");
    }
  }

%>

<script language=JavaScript type=text/javascript>

//Client side function for removal of owners.

function handleSave(typeOfSubmission)
{
  document.NewCalendarData.submissionType.value = typeOfSubmission;
  document.NewCalendarData.submit();
}
  
function checkSelection(isUser)
{
  var selectedUser;
  if( isUser )
    selectedUser = document.NewCalendarData.elements["permissionName"].value;
  else
    selectedUser = document.NewCalendarData.elements["ownerName"].value;

  selectedUser = trim(selectedUser);
  if( selectedUser == null || (selectedUser != null && selectedUser.length == 0) ) {
    UWCAlert('<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-no-add-sel-alert", "You cannot leave this field blank. Enter a user ID.")%>');
    return false;
  }

  return true;
}
   
function checkRemoveSelection(isUser)
{
  var selectedUser = false;
  var form = document.NewCalendarData.elements;
  var s = new Array();
  if( isUser ) {
    for(i=0;;i++) {
      s[i]="NewCalendarData.tilePermissions["+i+"].userSelect";
      if( form[s[i]]== undefined )
       break;

      if( form[s[i]].checked == true )
      {
        selectedUser = true;
        break;
      }
    }
  }
  else {
    var form = document.NewCalendarData.elements;
    var ownerList = form["NewCalendarData.ownersList"];
    
    if(!anyOwnersExists(ownerList)) {
      selectedUser = false;
    } else {    
       for (var i = 0; i < ownerList.options.length; i++) {
        if (ownerList.options[i].selected)
        {
           selectedUser = true;
           break;
        } 
       }
    }
  }

  if( !selectedUser  ) {
    UWCAlert('<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-no-rem-sel-alert", "Please select user(s) to be removed from the list.")%>');
    return false;
  }

  return true;
} 
      
//Integration with AddressBook.
//Open the Address Book Popup for adding users.
//Common shared object
var selectWnd = null;
var sharedObj = new Object();
var optSelected = "adduser";

function openWinAutoHeight(x) 
{  
  button_label = "_addaddresses";
  if(x == '1')
    optSelected="adduser";
  else
    optSelected="addowner";
   
  url="<%=path%>/abs/select-popup-main.xml?";
  args = "wcfg_ablist=0&wcfg_abtype=1&wcfg_buttonlabel=" + button_label;       
  args += "&wcfg_col1=dnnolink&wcfg_col2=primemailnolink";    
  selectWnd = window.open(url+args, 'select', 'height=600,width=700,status=yes,titlebar=yes,resizable=yes,scrollbars=yes');
}

function GetSharedObject()
{ 
  sharedObj.fieldsToReturn = new Array("uid");  
  sharedObj.type = optSelected;
  return sharedObj;
}

function AcceptData(inputArray) {
   
   if( inputArray == null || (inputArray != null && inputArray.length == 0) )
     return;
   
   var form = document.NewCalendarData.elements;
   
   if( sharedObj.type == "adduser" )  
      field = form["NewCalendarData.permissionName"];
   else 
      field = form["NewCalendarData.ownerName"];
   
     
   var userList = "";   
         
   var uidArray = inputArray[0];
   for(i=0; i<uidArray.length; i++) {   
     userList += uidArray[i] + ",";        
   }
   
   if( userList != '' )
     userList = userList.substr(0, userList.length - 1);
     
   field.value = userList;
   if( sharedObj.type == "adduser" )
     form["addUser"].click();
   else 
     form["addOwner"].click();
        
}

function checkAll(){
    var form=document.NewCalendarData.elements;
    var s= new Array();
    //Iterate until we don't get a checkbox to select.
    
    for(i=0;;i++) {
      s[i]="NewCalendarData.tilePermissions["+i+"].userSelect";
      if( form[s[i]]== undefined )
       break;
      form[s[i]].checked=true;
    }
        
    return false;    
}
    
function unCheckAll() {
    var form=document.NewCalendarData.elements;
    var s = new Array();
    
    for(i=0;;i++)  {
       s[i]="NewCalendarData.tilePermissions["+i+"].userSelect";
       if( form[s[i]]== undefined )
         break;
       form[s[i]].checked=false;
    }
    
    return false;
}

function consolidateOwners(){
  var form = document.NewCalendarData.elements;
  var ownerList = form["NewCalendarData.ownersList"];
  var count = ownerList.options.length;
  var selectedOwners = "";
  
  for(i=0;i<count; i++) {
    selectedOwners += ownerList.options[i].value + ";";
  }
   
  form["NewCalendarData.ownersAll"].value=selectedOwners;
  return false;       
}

function setTimeZoneInfo(val)
{
  var form = document.NewCalendarData.elements;  
  if( val == "default" ) {
    form["defaultzone"].checked = true;
    form["customzone"].checked = false;
  }
  else {
    form["customzone"].checked = true;
    form["defaultzone"].checked = false;
  }
  
  form["NewCalendarData.selectedTimeZone"].value = val;   
}
   
var SHARE_ANCHOR = "#shareSpecific";
var OWNERS_ANCHOR = "#owners";
var TIMEZONE_ANCHOR = "#timezone"; 
var anchorArray = new Array();
anchorArray["share"] = SHARE_ANCHOR;
anchorArray["owners"] = OWNERS_ANCHOR;
anchorArray["timezone"] = TIMEZONE_ANCHOR;

function initPage()
{
  var form = document.NewCalendarData.elements;
  var selectedTimeZone = form["NewCalendarData.selectedTimeZone"].value;  
  
  if(selectedTimeZone =="custom") {
     form["defaultzone"].checked = false;
     form["customzone"].checked = true;
  }
  else {
     form["customzone"].checked = false;
     form["defaultzone"].checked = true;
  }

  var form = document.forms[0].elements;
  var found = false;
                                         
  for(i=0;;i++)
  {
    var s="NewCalendarData.tilePermissions["+ i +"].userIDHidden";

    if( form[s] == undefined ) {
      found = false;
      break;
    }

    var checkread = false;
    deleteField = form["NewCalendarData.tilePermissions[" + i + "].delete"];
    writeField = form["NewCalendarData.tilePermissions[" + i + "].write"];

    readField =  form["NewCalendarData.tilePermissions[" + i + "].read"];
    if( deleteField.checked || writeField.checked )
      checkread = true;
    
    if( checkread ) 
      readField.checked = true;
  }

  parent.focus();
  var anchor = form["NewCalendarData.Anchor"].value;

  if( anchor != null && anchor.length > 0 ) {
    var ahref = anchorArray[anchor];
    form["NewCalendarData.Anchor"].value = "";
    window.location = window.location + ahref;
  }

}   

function deleteOrWriteSelected(userID) {
  var form = document.forms[0].elements;
  var found = false;
 
  for(i=0;;i++)  
  {
    var s="NewCalendarData.tilePermissions["+ i +"].userIDHidden";
    if( form[s].value ==  userID ) {
      found = true;
      break;
    }

    if( form[s] == undefined ) {
      found = false;
      break;
    }
  }
  
  if( found ) {
    var checkread = false; 
    deleteField = form["NewCalendarData.tilePermissions[" + i + "].delete"];
    writeField = form["NewCalendarData.tilePermissions[" + i + "].write"];

    readField =  form["NewCalendarData.tilePermissions[" + i + "].read"];
    
    if( deleteField.checked || writeField.checked )
      checkread = true;

    if( checkread ) 
      readField.checked = true;
  }
}   

function isValidCalName()
{
  var form = document.NewCalendarData.elements;
  var calname = form["NewCalendarData.calName"].value;
  var result = false;
  for(i=0; i<calname.length; i++)
  {
    var intVal = parseInt(calname.charAt(i));
    if( (calname.charCodeAt(i)>=97 && calname.charCodeAt(i)<=122) || (calname.charCodeAt(i)>=65 && calname.charCodeAt(i)<=90) 
     || (intVal != NaN && intVal>=0 && intVal<=9) || calname.charAt(i) == '.' || calname.charAt(i) == '_'
     ||  calname.charAt(i) == '-') {
    }
    else {
      result = true;
      break;
    }
  }
      
  if((calname == '') || (calname.indexOf(" ") > -1) || result) { 
    UWCAlert('<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-invalid-calname", "Enter a valid calendar name. A calendar name cannot contain spaces, but can include the following characters: alphabetic (A-Z, a-z) and numeric (0-9) and special characters: period(.), underscore (_), dash (-). You cannot leave this field blank.")%>');
    return false;
  }

  return true;
}

function handleCreateCal()
{
  if(false == isValidCalName()) {
    return;
  }
  document.NewCalendarData.submit();
}

function handleEditCal()
{
  document.NewCalendarData.submissionType.value = 'EditCal';
  document.NewCalendarData.submit();
}

function handleDeleteCal()
{
  if(UWCConfirm('<%= getLocalizedLabel(session, "uwc-calclient-edit-calendar-DeleteCalendar-confirm-alert", "Are you sure you want to delete this calendar?")%>'))
  {
    document.NewCalendarData.submissionType.value = 'DeleteCal';
    document.NewCalendarData.submit();
  }
}

function cancel() {
  if( selectWnd != null && !selectWnd.closed ) {
    if( UWCConfirm('<%= getLocalizedLabel(session, "uwc-calclient-cal-window-close-alert", "Browser pop-up(s) opened from this window are still open. Do you want to close them as well?")%>') )
    {
      selectWnd.close();
      parent.close();
    }
  } else parent.close();     
}

function anyOwnersExists(ownersList) {
  var ownersLength = ownersList.length;
  if((0 == ownersLength) || (1 == ownersLength)) {
    return false;
  }       
  if(2 == ownersLength) {
    var ownersOpts = document.NewCalendarData.elements["NewCalendarData.ownersList"].options;
    var theOwnerValue = ownersOpts[0].value; 
    if("NoOwnersSelected" == theOwnerValue) {
      return false;
    }
  }
  return true;
}

document.onkeypress =
 function (evt) {
    var c = document.layers ? evt.which
           : document.all ? event.keyCode
           : evt.keyCode;
    var t = document.layers ? evt.target
           : document.all ? event.srcElement
           : evt.target;

    if(c == 13)  {
     var form = document.NewCalendarData.elements;

     if( t.name == 'NewCalendarData.permissionName' ) {
       form["addUser"].click();
       return false;
     }
     else if( t.name == 'NewCalendarData.ownerName' ) {
       form["addOwner"].click();
       return false;
     }
     else if( t.name == 'NewCalendarData.calDesc' ) {}
     else parent.handleSave();
    }

    if (is_ie5up) {
      if(c != 13)
         return true;
      else
         return false;
    } else {
       return true;
    }
 };

 if (document.layers)
      document.captureEvents(Event.KEYPRESS);
</script>
</head>

<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" class="Popup" onLoad="initPage()">
<jato:form name="NewCalendarData" method="post" defaultCommandChild="/save">
<jato:hidden name="Anchor"/>
<table width="100%" border="0" cellspacing="0" cellpadding="0" title="">
<tr>
<td class="PopupTitle"><span class="PopupTitleText"><jato:text name="ViewBanner" escape="false"/></span></td>
</tr>
</table>
<!-- Error pagelet -->
<jato:containerView name="errorPlugin">
      <%@include file="/uwc/common/error.jsp"%>
</jato:containerView>

<div class="ConJmpScnDiv">
<table border="0" cellspacing="0" cellpadding="0">
<tbody><tr>
<td valign="top">
<div class="ConJmpLnkDiv"><a href="#general" class="JmpLnk" title="<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-jumpto-general", "Jump Down to the General Information Section")%>"<img
src="<%= getLocalizedLabel(session, "skinModel", "uwc-common-To-Anchor-image", "../uwc/images/to_anchor.gif") %>" alt="<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-jumpto-general", "Jump Down to the General Information Section")%>" width="16" height="10" border="0"><%=getLocalizedLabel(session, "uwc-calclient-new-calendar-general-information", "General Information")%></a></div>
</td>
<td valign="top">
<div class="ConJmpLnkDiv"><a href="#shareSpecific" class="JmpLnk" title='<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-jumpto-share", "Jump Down to the Share this Calendar with Specific Users Section")%>'><img src="<%= getLocalizedLabel(session, "skinModel", "uwc-common-To-Anchor-image", "../uwc/images/to_anchor.gif") %>" alt="<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-jumpto-share", "Jump Down to the Share this Calendar with Specific Users Section")%>" width="16" height="10"
border="0"><%=getLocalizedLabel(session, "uwc-calclient-new-calendar-share-specific-users", "Share this Calendar with Specific Users")%></a></div>
</td>
<td valign="top">
<div class="ConJmpLnkDiv"><a href="#timezone" class="JmpLnk" title="<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-jumpdown-timezone", "Jump Down to the Time Zones Section")%>"><img
src="<%= getLocalizedLabel(session, "skinModel", "uwc-common-To-Anchor-image", "../uwc/images/to_anchor.gif") %>" alt="<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-jumpdown-timezone", "Jump Down to the Time Zones Section")%>" width="16" height="10" border="0"><%=getLocalizedLabel(session, "uwc-calclient-new-calendar-timezone","Time Zones")%></a></div>
</td>
</tr>
<tr>
<td valign="top">
<div class="ConJmpLnkDiv"><a href="#share" class="JmpLnk" title="<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-jumpone-shareall", "Jump Down to the Share This Calendar Section")%>"><img
src="<%= getLocalizedLabel(session, "skinModel", "uwc-common-To-Anchor-image", "../uwc/images/to_anchor.gif") %>" alt="<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-jumpone-shareall", "Jump Down to the Share This Calendar Section")%>" width="16" height="10" border="0"><%=getLocalizedLabel(session, "uwc-calclient-new-calendar-share-clandar", "Share This Calendar")%></a></div>
</td>
<td valign="top">
<div class="ConJmpLnkDiv"><a href="#owners" class="JmpLnk" title="<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-jumpto-owner-section", "Jump Down to the Owners Section")%>"><img src="<%= getLocalizedLabel(session, "skinModel", "uwc-common-To-Anchor-image", "../uwc/images/to_anchor.gif") %>" alt="<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-jumpto-owner-section", "Jump Down to the Owners Section")%>" width="16" height="10" border="0"><%=getLocalizedLabel(session, "uwc-calclient-new-calendar-owners", "Owners")%></a></div>
</td>
<td valign="top"> </td>
</tr>
</tbody></table>
</div>

<jato:content name="EditableCalName">
<!-- Required field indicator div -->
<div class="ConRqdDiv"><img src="<%= getLocalizedLabel(session, "skinModel", "uwc-common-Required-image", "../uwc/images/required.gif") %>" alt="Required" width="7" height="14"> <span class="ConRqdTxt"><%=getLocalizedLabel(session, "uwc-calclient-new-calendar-required-feild", "Indicates required field ")%></span>
</div>
</jato:content>

<a name="general" id="general"></a>
<!-- Sub-Section Header -->
<table width="100%" border="0" cellspacing="0" cellpadding="0" title="">
<tr>
<td><img src="../uwc/images/spacer.gif" width="10" height="5" alt=""></td>
<td class="SectionDivider" width="100%"><img src="../uwc/images/spacer.gif" width="1" height="5" alt=""></td>
<td><img src="../uwc/images/spacer.gif" width="10" height="5" alt=""></td>
</tr>
<tr>
<td colspan="3" class="SectionHeader"><span
class="SectionHeader"><%=getLocalizedLabel(session, "uwc-calclient-new-calendar-general-information", "General Information ")%></span></td>
</tr>
</table>

<!-- Calendar general properties input section -->
<table class="FormInputTable" width="100%" border="0" cellspacing="0" cellpadding="0" title="">
<tr>
<jato:content name="EditableCalName">
<td class="PropLabel" nowrap valign="top"><img src="<%= getLocalizedLabel(session, "skinModel", "uwc-common-Required-image", "../uwc/images/required.gif") %>" alt="Required" width="7" height="14"> <span class="Lbl2"><label for="calName">
<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-name", "Calendar Name")%>:</label></span></td>
<td class="PropInput" width="100%">
<jato:textField name="calName" size="50" onClick="return false;" tabIndex="1"/>
<br>
<span class="HlpFldTxt"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel"
modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-name-comment" defaultValue="Calendar name may not contain embedded spaces " escape="false"/>.</span>
</td>
</jato:content>
<jato:content name="StaticCalName">
  <td class="PropLabel" nowrap valign="top"><span class="Lbl2"><label for="calName">
  <%= getLocalizedLabel(session, "uwc-calclient-edit-calendar-CalendarIDLabel", "Calendar ID") %>:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</label></span></td>
  <td class="PropInput" width="100%">
    <jato:getDisplayFieldValue name="hiddenCalIDForEditCalendarView"/>
    <jato:hidden name="hiddenCalName"/>
    <jato:hidden name="hiddenCalIDForEditCalendarView"/>
  </td>
</jato:content>
</tr>
<tr>
<td class="PropLabel"><span class="Lbl2"><label for="calDisplay"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel"
modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-display-name" defaultValue="Display Name" escape="false"/>:</label></span></td>
<td class="PropInput">
<jato:textField name="calDisplay" size="50" tabIndex="2"/>
</td>
</tr>
<tr>
<td class="PropLabel" valign="top"><span class="Lbl2"><label for="calDesc"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel" modelName="i18nModel" lookInSession="true"
name="uwc-common-description" defaultValue="Description " escape="false"/>:</label></span></td>
<td class="PropInput" nowrap>
<jato:textArea name="calDesc" wrap="VIRTUAL" elementId="calDesc" cols="70" rows="2" tabIndex="3" />

</td>
</tr>
<tr>
<td class="PropLabel"><span class="Lbl2"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel"
modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-availibilty" defaultValue="Availability " escape="false"/>:</span></td>
<td class="PropInput">
<jato:checkBox name="includeCal" elementId="includeCal" tabIndex="4"/>
<label for="includeCal"><span class="Lbl2"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel"
modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-include-availibilty-comment" defaultValue="Include this calendar when calculating your availability " escape="false"/></span></label></td>
</tr>
</table>
<div class="ConJmpTopDiv"><a href="#top" class="JmpTopLnk" title='<%=getLocalizedLabel(session, "uwc-calclient-view-importExport-topAlt", "Jump to Top of Page") %>'><img src="<%= getLocalizedLabel(session, "skinModel", "uwc-common-To-Top-image", "../uwc/images/to_top.gif") %>" alt="Jump to Top of Page" width="11" height="10" border="0">
<jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel" modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-backto-top" defaultValue="Back to top " escape="false"/></a></div>

<a name="share" id="share"></a>
<!-- Sub-Section Header -->
<table width="100%" border="0" cellspacing="0" cellpadding="0" title="">
<tr>
<td colspan="3"><img src="../uwc/images/spacer.gif" width="1" height="20"
alt=""></td>
</tr>
<tr>
<td><img src="../uwc/images/spacer.gif" width="10" height="5" alt=""></td>
<td class="SectionDivider" width="100%"><img src="../uwc/images/spacer.gif" width="1" height="5" alt=""></td>
<td><img src="../uwc/images/spacer.gif" width="10" height="5" alt=""></td>
</tr>
<tr>
<td colspan="3" class="SectionHeader"><span class="SectionHeader"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel"
modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-share-clandar" defaultValue="Share This Calendar " escape="false"/></span></td>
</tr>
</table>

<!-- Calendar Sharing Properties -->
<table class="FormInputTable" width="100%" border="0" cellspacing="0"
cellpadding="0" title="">
<tr>
<td class="PropLabel"><span class="Lbl2"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel"
modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-select-all-apply" defaultValue="Select all that apply " escape="false"/>:</span></td>
</tr>
<tr>
<td class="PropLabel">
<jato:checkBox name="share1" elementId="share1" tabIndex="5"/>
<label for="share1"><span class="Lbl2"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel"
modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-anyone-availibity" defaultValue="Anyone can view my availability " escape="false"/></span></label></td>
</tr>
<tr>
<td class="PropLabel">
<jato:checkBox name="share2" elementId="share2" tabIndex="6"/>
<label for="share2"><span class="Lbl2"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel"
modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-anyone-read" defaultValue="Anyone can read my calendar " escape="false"/></span></label></td>
</tr>
<tr>
<td class="PropLabel">
<jato:checkBox name="share3" elementId="share3" tabIndex="7"/>
<label for="share3"><span class="Lbl2"><%=getLocalizedLabel(session, "uwc-calclient-new-calendar-anyone-invite", "Anyone can invite me to an event ")%></span></label></td>
</tr>
<tr>
<td class="PropLabel">
<jato:checkBox name="share4" elementId="share4" tabIndex="8"/>
<label for="share4"><span class="Lbl2"><%=getLocalizedLabel(session, "uwc-calclient-new-calendar-anyone-modify", "Anyone can modify events, tasks and invitations of my calendar")%></span></label></td>
</tr>
<tr>
<td class="PropLabel">
<jato:checkBox name="share5" elementId="share5" tabIndex="9"/>
<label for="share5"><span class="Lbl2"><%=getLocalizedLabel(session, "uwc-calclient-new-calendar-anyone-delete", "Anyone can delete events, tasks and invitation of my calendar")%></span></label></td>
</tr>
</table>
<div class="ConJmpTopDiv"><a href="#top" class="JmpTopLnk" title='<%=getLocalizedLabel(session, "uwc-calclient-view-importExport-topAlt", "Jump to Top of Page") %>'><img src="<%= getLocalizedLabel(session, "skinModel", "uwc-common-To-Top-image", "../uwc/images/to_top.gif") %>" alt="Jump to Top of Page" width="11" height="10" border="0"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel" modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-backto-top" defaultValue="Back to top " escape="false"/></a></div>

<a name="shareSpecific" id="shareSpecific"></a>
<div id="shareON">
<!-- Subsection Header -->
<table width="100%" border="0" cellspacing="0" cellpadding="0" title="">
<tr>
<td colspan="3"><img src="../uwc/images/spacer.gif" width="1" height="20" alt=""></td>
</tr>
<tr>
<td><img src="../uwc/images/spacer.gif" width="10" height="5" alt=""></td>
<td class="SectionDivider" width="100%"><img src="../uwc/images/spacer.gif" width="1" height="5" alt=""></td>
<td><img src="../uwc/images/spacer.gif" width="10" height="5" alt=""></td>
</tr>
<tr>
<td colspan="3" class="SectionHeader"><span class="SectionHeader"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel" modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-share-users" defaultValue="Share Calendar with Specific Users " escape="false"/></span> </td>
</tr>
</table>
<table border="0" cellpadding="0" cellspacing="0" width="100%" title="">
<tr>
<td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
<td width="100%">
<div class="TableDiv">
<table border="0" cellpadding="0" cellspacing="0" class="Tbl" width="100%" summary="Table contains list of Events.">
<tbody>
<tr>
<td class="TblTtlTd" colspan="7"><span class="TblTtlTxt"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel" modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-permission-list" defaultValue="Permissions List " escape="false"/></span></td>
</tr>
<tr>
<td class="TblActTd" colspan="7">
<jato:content name="showUsers">
<jato:button styleClass="Btn1"  name="removeUser" elementId="removeUser" defaultValue='<%=getLocalizedLabel(session, "uwc-common-remove", "Remove")%>' onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if(this.disabled==0)this.className='Btn1'"  extraHtml='<%=getExtraHtml("title", getLocalizedLabel(session, "uwc-calclient-new-calendar-remove-user", "Remove Selected Users from the Permissions List"))%>' tabIndex="10" onClick="return checkRemoveSelection(true)"/>
</jato:content>
<jato:content name="hideUsers">
<jato:button styleClass="Btn1Dis" disabled="true" name="removeUser" elementId="removeUser" defaultValue='<%=getLocalizedLabel(session, "uwc-common-remove", "Remove")%>' onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if(this.disabled==0)this.className='Btn1'" extraHtml='<%=getExtraHtml("title", getLocalizedLabel(session, "uwc-calclient-new-calendar-remove-user", "Remove Selected Users from the Permissions List"))%>' tabIndex="10"/>
</jato:content>
<img src="../uwc/images/actions_separator.gif" width="18" height="18">
<label for="permissionName"><span class="Lbl2"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel" modelName="i18nModel" lookInSession="true" name="uwc-common-name" defaultValue="Name " escape="false"/>:</span></label>
<jato:textField name="permissionName" elementId="permissionName" tabIndex="11"/> 
<jato:button styleClass="Btn1" name="addUser" elementId="addUser" defaultValue='<%=getLocalizedLabel(session, "uwc-common-add", "Add")%>' onMouseOver="if (this.disabled==0)this.className='Btn1Hov'" onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0)this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" extraHtml='<%=getExtraHtml("title", getLocalizedLabel(session, "uwc-calclient-new-calendar-add-name", "Add Name to Permissions List")) %>' tabIndex="12" onClick="return checkSelection(true)"/>
<input onClick="javascript:openWinAutoHeight('1');return;" class="Btn2" type="button" name="addAddressBook2" id="addAddressBook2" value='<%=getLocalizedLabel(session, "uwc-common-add-from-address-book", "Add from Address book")%>' onMouseOver="if (this.disabled==0) this.className='Btn2Hov'" onFocus="if(this.disabled==0) this.className='Btn2Hov'" onMouseOut="if(this.disabled==0) this.className='Btn2'" onBlur="if (this.disabled==0)this.className='Btn2'" title='<%=getLocalizedLabel(session, "uwc-common-add-from-address-book", "Add from Address book")%>' tabindex="13">
</td>
</tr>
<jato:content name="showUsers">
<tr>
<th width="5%" nowrap class="TblThCl1">
<div style="text-align:center">
<input name="SelectAllPermUsers" type="image" value="SelectAllPermUsers" src="<%= getLocalizedLabel(session, "skinModel", "uwc-calclient-Select-All-image", "../uwc/images/check_all.gif") %>" alt="Select All Items Displayed in Table" align="top" width="15" height="13" border="0" title='<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-select-all-users", "Select All Items Displayed in Table")%>' onclick="checkAll(); return false;">
<input name="DeselectAllPermUsers" type="image" value="DeselectAllPermUsers" src="<%= getLocalizedLabel(session, "skinModel", "uwc-calclient-Deselect-All-image", "../uwc/images/uncheck_all.gif") %>" alt="Deselect All Items Displayed in Table") align="top" width="15" height="13" border="0" title='<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-deselect-all-users","Deselect All Items Displayed in Table")%>' onclick="unCheckAll(); return false;">
</div>
</th>
<th class="TblThSrt" scope="col" width="35%"><%=getLocalizedLabel(session, "uwc-common-name", "Name")%></th>
<th scope="col" width="15%"><a href="#" class="TblHdrLnk" title="View my availability"><%= getLocalizedLabel(session, "uwc-calclient-new-calendar-availibilty", "Availability")%></a></th>
<th scope="col" width="15%"><a href="#" class="TblHdrLnk" title="Read my calendar"><%= getLocalizedLabel(session, "uwc-calclient-new-calendar-read", "Read")%></a></th>
<th scope="col" width="15%"><a href="#" class="TblHdrLnk" title="Invite me to an event"><%= getLocalizedLabel(session, "uwc-calclient-new-calendar-invite", "Invite")%></a></th>
<th scope="col" width="15%"><a href="#" class="TblHdrLnk" title="Modify my calendar"><%= getLocalizedLabel(session, "uwc-calclient-new-calendar-modify", "Modify")%></a></th>
<th scope="col" width="15%"><a href="#" class="TblHdrLnk" title="Delete my calendar"><%= getLocalizedLabel(session, "uwc-calclient-new-calendar-delete", "Delete")%></a></th>
</tr>
<jato:tiledView name="tilePermissions" type="com.sun.uwc.calclient.NewCalendarUserPermissionsTiledView" >
<tr>
<td class="TblTdCl1" align="center"><jato:checkBox name="userSelect" /></td>
<td class="TblTdSrt"><jato:text name="userName" /> <jato:hidden name="userNameHidden" />(<jato:text name="userID" />) <jato:hidden name="userIDHidden"/> </td>
<td><jato:checkBox name="availibilty" /></td>
<td><jato:checkBox name="read" /></td>
<td><jato:checkBox name="invite" /></td>
<td><jato:checkBox name="write"/></td>
<td><jato:checkBox name="delete"/></td>
</tr>
</jato:tiledView>
</jato:content>
<jato:content name="hideUsers">
<tr>
<td><%= getLocalizedLabel(session, "uwc-calclient-new-calendar-no-perm-msg", "Add users to the permission list using 'Add' or 'Add from Address Book' option")%>
</td>
</tr>
</jato:content> 
</tbody>
</table>
</div>
</td>
<td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
</tr>
</table>
<div class="ConJmpTopDiv">
<a href="#top" class="JmpTopLnk" title='<%=getLocalizedLabel(session, "uwc-calclient-view-importExport-topAlt", "Jump to Top of Page") %>'><img src="<%= getLocalizedLabel(session, "skinModel", "uwc-common-To-Top-image", "../uwc/images/to_top.gif") %>" alt="Jump to Top of Page" width="11" height="10" border="0"><%=getLocalizedLabel(session, "uwc-calclient-new-calendar-backto-top", "Back to top")%></a> </div>

<a name="owners" id="owners"></a>
<!-- Div displayed when the Owners section is expanded -->
<table width="100%" border="0" cellspacing="0" cellpadding="0" title="">
<tr>
<td colspan="3"><img src="../uwc/images/spacer.gif" width="1" height="10"
alt=""></td>
</tr>
<tr>
<td><img src="../uwc/images/spacer.gif" width="10" height="5" alt=""></td>
<td class="SectionDivider" width="100%"><img src="../uwc/images/spacer.gif" width="1" height="5" alt=""></td>
<td><img src="../uwc/images/spacer.gif" width="10" height="5" alt=""></td>
</tr>
<tr>
<td colspan="3" class="SectionHeader"><span class="SectionHeader"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel" modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-owners" defaultValue="Owners" escape="false"/></span></td>
</tr>
</table>

<!-- Calendar Owner List -->
<table class="FormInputTable" width="100%" border="0" cellspacing="0" cellpadding="0" title="">
<tr>
<td class="PropLabel" colspan="2">
<jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel" modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-owner-desc" defaultValue="A calendar may have multiple owners. Each owner may act on your behalf to reply to invitations, and to create,modify,or delete events " escape="false"/>.</td>
</tr>
<tr>
<td class="PropLabel" nowrap><span class="Lbl2"><label for="ownerName"><%=getLocalizedLabel(session, "uwc-calclient-new-calendar-owner-name", "Owner Name")%>:</label></span></td>
<td class="PropInputWHelp" width="100%">
<jato:textField name="ownerName" size="40" elementId="ownerName" tabIndex="19"/>
<jato:button styleClass="Btn1" name="addOwner" elementId="addOwner" defaultValue='<%=getLocalizedLabel(session, "uwc-common-add", "Add")%>' onMouseOver="if (this.disabled==0)this.className='Btn1Hov'" onFocus="if (this.disabled==0)this.className='Btn1Hov'" onMouseOut="if (this.disabled==0)this.className='Btn1'" onBlur="if (this.disabled==0)this.className='Btn1'" extraHtml='<%=getExtraHtml("title", getLocalizedLabel(session, "uwc-calclient-new-calendar-add-owner", "Add Owner"))%>' tabIndex="20" onClick="return checkSelection(false)"/>&nbsp;
<input class="Btn2" type="button" name="addAddressBook22" id="addAddressBook" value=' <%=getLocalizedLabel(session, "uwc-common-add-from-address-book", "Add from Address book")%>' onClick="openWinAutoHeight('2')" onMouseOver="if (this.disabled==0) this.className='Btn2Hov'" onFocus="if (this.disabled==0) this.className='Btn2Hov'" onMouseOut="if (this.disabled==0) this.className='Btn2'" onBlur="if (this.disabled==0) this.className='Btn2'" title='<%=getLocalizedLabel(session, "uwc-calclient-new-calendar-add-owner-from-addressbook", "Add Owner from Address Book")%>'>
</td>
</tr>
<tr>
<td colspan="2"><img src="../uwc/images/spacer.gif" width="1" height="1"
alt=""></td>
</tr>
<tr>
<td class="PropLabel" nowrap valign="top"><span class="Lbl2"><label for="ownersList"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel" modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-owners-list" defaultValue="Owner List " escape="false"/>:</label></span></td>
<td class="PropInput">
<table border="0" cellspacing="0" cellpadding="0">
<tr>
<td valign="top">
<jato:listbox name="ownersList" elementId="ownersList" tabIndex="22"/>
</td>
<td>
<table class="AddRmvBtnTbl" border="0" cellspacing="0" cellpadding="0"
title="">
<tbody>
<tr>
<td align="center"><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
<td class="PropInput" align="center">
<div class="AddRmvHrzWin">
<jato:button styleClass="Btn2"  name="removeOwner" elementId="removeOwner" defaultValue='<%=getLocalizedLabel(session, "uwc-common-remove", "Remove")%>'  onMouseOver="if (this.disabled==0)this.className='Btn2Hov'" onMouseOut="if (this.disabled==0)this.className='Btn2'"  extraHtml='<%=getExtraHtml("title", getLocalizedLabel(session, "uwc-calclient-new-calendar-remove-owners", "Remove Selected Owners"))%>' tabIndex="25" onClick="return checkRemoveSelection(false)"/>
</div>
</td>
</tr>
</tbody>
</table>
</td>
</tr>
</table>
</td>
</tr>
</table>
<div class="ConJmpTopDiv"><a href="#top" class="JmpTopLnk" title='<%=getLocalizedLabel(session, "uwc-calclient-view-importExport-topAlt", "Jump to Top of Page") %>'><img src="<%= getLocalizedLabel(session, "skinModel", "uwc-common-To-Top-image", "../uwc/images/to_top.gif") %>" alt="Jump to Top of Page" width="11" height="10" border="0"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel" modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-backto-top" defaultValue="Back to top" escape="false"/></a></div>
<a name="timezone" id="timezone"></a>
<table width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <tr> 
    <td colspan="3"><img src="../uwc/images/spacer.gif" width="1" height="10" alt=""></td>
  </tr>
  <tr> 
<td><img src="../uwc/images/spacer.gif" width="10" height="5" alt=""></td>
<td class="SectionDivider" width="100%"><img src="../uwc/images/spacer.gif" width="1" height="5" alt=""></td>
<td><img src="../uwc/images/spacer.gif" width="10" height="5" alt=""></td>
</tr>
<tr>
<td colspan="3" class="SectionHeader"><span class="SectionHeader"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel" modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-timezone" defaultValue="Time Zones" escape="false"/></span></td>
  </tr>
</table>

<table class="FormInputTable" width="100%" border="0" cellspacing="0" cellpadding="0" title="">
<tr>
<td class="PropLabel">
<table border="0" cellspacing="0" cellpadding="4" class="tinyCopy">
<tr>
<td>

<input type="radio" name="defaultzone" value="default" onClick="setTimeZoneInfo('default')">
</td>
<td><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel" modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-use-defzone" defaultValue="Use my default time zone" escape="false"/></td>
</tr>
<tr>
<td valign="top">
<input type="radio" name="customzone" value="custom" onClick="setTimeZoneInfo('custom')" >
</td>
<td>
<table border="0" cellspacing="0" cellpadding="2">
<tr>
<td>
<jato:combobox name="Region" elementId="Region" tabIndex="12" onChange="handleSave('TimeZones');return false; "/>
</td>
</tr>
<tr>
<td>
<jato:listbox name="TimeZones" elementId="TimeZones" size="5" tabIndex="13" />
</td>
</tr>
</table>
</td>
</tr>
</table>
</td>
</tr>
</table>
<div class="ConJmpTopDiv"><a href="#top" class="JmpTopLnk" title='<%=getLocalizedLabel(session, "uwc-calclient-view-importExport-topAlt", "Jump to Top of Page") %>'><img src="<%= getLocalizedLabel(session, "skinModel", "uwc-common-To-Top-image", "../uwc/images/to_top.gif") %>" alt="Jump to Top of Page" width="11" height="10" border="0"><jato:getModelFieldValue modelClass="com.sun.uwc.common.model.UWCResourceBundleModel" modelName="i18nModel" lookInSession="true" name="uwc-calclient-new-calendar-backto-top" defaultValue="Back to top" escape="false"/></a></div>
<jato:hidden name="ownersAll" />
<input type="hidden" name="submissionType" value="Save">
<jato:hidden name="selectedTimeZone" defaultValue="default"/>
</jato:form>
</body>
</html>
</jato:useViewBean>
