<html>

<%@page info="SearchCalendarData" language="java" pageEncoding="utf-8" contentType="text/html; charset=UTF-8"%>
<%@taglib uri="/WEB-INF/jato.tld" prefix="jato"%>

<%@include file="../../uwc/js/resourceBundleUtils.js"%>

<jato:useViewBean className="com.sun.uwc.calclient.SearchCalendarDataViewBean">

<head>
<title><jato:getDisplayFieldValue escape="false" name="ViewBanner"/></title>
<script src="../uwc/js/browserVersion.js" type="text/javascript"> </script>
<script type="text/javascript">
<!--
  if (is_ie5up) // IE5
  {
   document.write("<LINK href=<%= getLocalizedLabel(session, "skinModel", "Style-Sheet-IE", "../uwc/css/css_ie5win.css") %> type=text/css rel=stylesheet>")
  }
  else if (is_gecko) // Netscape 6/7 or Mozilla
  {
   document.write("<LINK href=<%= getLocalizedLabel(session, "skinModel", "Style-Sheet-NN", "../uwc/css/css_ns6up.css") %> type=text/css rel=stylesheet>")
  }
  else  // All others
  {
   document.write("<LINK href=<%= getLocalizedLabel(session, "skinModel", "Style-Sheet-NN", "../uwc/css/css_ns6up.css") %> type=text/css rel=stylesheet>")
  }
//-->
</script>
<script>
<!--
function handleEnter(event) {
     if (is_ie5up) {
         if(event.keyCode == 13) {
            var calsearchText = document.forms[0].elements["TextEnteredForSearchCalendar"].value;
            if((null == calsearchText) || ("" == trim(calsearchText))) {
                        UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-BlankSearchString-alert", "Please enter a search string") %>');
            return false;
            }
            document.forms[0].elements["ButtonForSearchCalendar"].click();
          }
     }
     else {
        if(event.which == 13) {
            var calsearchText = document.forms[0].elements["TextEnteredForSearchCalendar"].value;
            if((null == calsearchText) || ("" == trim(calsearchText))) {
                        UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-BlankSearchString-alert", "Please enter a search string") %>');
            return false;
            }
            document.forms[0].elements["ButtonForSearchCalendar"].click();
         }
     }
     return true
}
//-->
</script>

</head>

<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" class="Popup">

<jato:form name="SearchCalendarData" method="post" defaultCommandChild="/Save">

<input type="hidden" name="submitType">
<jato:hidden name="ViewSearchMode"/>

<!-- Page Title -->
<table width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <tr>
      <td class="PopupTitle"><span class="PopupTitleText"><jato:getDisplayFieldValue escape="false" name="ViewBanner"/></span></td>
  </tr>
</table>

<!-- Error pagelet -->
<jato:containerView name="errorPlugin">
  <%@include file="/uwc/common/popuperror2.jsp"%>
</jato:containerView>

<!-- Search fields -->
<table class="FormInputTable" width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <tr> 
    <td><img src="../uwc/images/spacer.gif" width="1" height="10" alt=""></td>
  </tr>
  <tr> 
    <td class="PropLabel" nowrap>
      <jato:textField name="SearchText" elementId="TextEnteredForSearchCalendar" size="25" defaultValue="Search for Calendar" tabIndex="1" onKeyPress="return handleEnter(event)"/>
      <input class="Btn1" type="button" name="SearchCalendar" id="ButtonForSearchCalendar" value=" <%= getLocalizedLabel(session, "uwc-common-search", "Search") %> " onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" onClick="handleSearch(); return false;" title="<%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-Search-title", "Search for Calendar") %>" tabindex="2">
      <br>
      <span class="inlineHelpText"><jato:getDisplayFieldValue escape="false" name="ViewIntro"/></span></td>
  </tr>
</table>

<!-- Table containing search results -->
<table border="0" cellpadding="0" cellspacing="0" width="100%" title="">
  <tr>
    <td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
    <td width="98%"> 
      <div class="TableDiv"> 
          <table border="0" cellpadding="0" cellspacing="0" class="Tbl" width="100%" summary="Table contains list of Calendars." title="">
            <tbody> 
            <tr> 
              <td class="TblTtlTd" colspan="4"><span class="TblTtlTxt"><%= getLocalizedLabel(session, "uwc-common-SearchResultsFor", "Search results for") %>&nbsp;"<jato:text name="SearchText"/>"</span></td>
            </tr>
  <jato:content name="NonZeroCals">
            <tr> 
              <td class="TblActTd" colspan="2">&nbsp;</td>
              <td class="TblActTd" colspan="2" align="right" nowrap><jato:text name="CalTileMessage"/></td>
            </tr>
            <tr> 
              <th width="5%" nowrap class="TblThCl1"> 
                <div style="text-align:center"> 
                  <input name="SelectAllCalendars" type="image" value="SelectAllCalendars" src="<%= getLocalizedLabel(session, "skinModel", "uwc-calclient-Select-All-image", "../uwc/images/check_all.gif") %>" alt="<%= getLocalizedLabel(session, "uwc-common-SelectAll-title", "Select All Items Displayed in Table") %>" align="top" width="15" height="13" border="0" title="<%= getLocalizedLabel(session, "uwc-common-SelectAll-title", "Select All Items Displayed in Table") %>" onclick="selectCalendars(true); return false;">
                  <input name="DeselectAllCalendars" type="image" value="DeselectAllCalendars" src="<%= getLocalizedLabel(session, "skinModel", "uwc-calclient-Deselect-All-image", "../uwc/images/uncheck_all.gif") %>" alt="<%= getLocalizedLabel(session, "uwc-common-DeselectAll-title", "Deselect All Items Displayed in Table") %>" align="top" width="15" height="13" border="0" title="<%= getLocalizedLabel(session, "uwc-common-DeselectAll-title", "Deselect All Items Displayed in Table") %>" onclick="selectCalendars(false); return false;">
                </div>
              </th>
              <th class="TblThSrt" scope="col" width="35%"><%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-NameLabel", "Name") %></th>
              <th scope="col" width="40%"><%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-DescriptionLabel", "Description") %></th>
              <th scope="col" width="20%"><%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-OwnerLabel", "Owner") %></th>
            </tr>
        <jato:tiledView name="SearchCalendarTileView" type="com.sun.uwc.calclient.SearchCalendarTileView">
            <jato:hidden name="CalID"/>
            <jato:hidden name="CalDisplayName"/>
            <jato:hidden name="CalOwnerName"/>
            <tr> 
              <td class="TblTdCl1" align="center">
                <jato:content name="AllowCalSelection">
                  <jato:checkbox name="SelectCalendar" elementId="CheckBoxOfSearchedCalendar"/>
                </jato:content>
                <jato:content name="DisallowCalSelection">
                  <img name="AlreadySubscribedOrAlreadySelected" src='<%= getLocalizedLabel(session, "skinModel", "uwc-common-Subscribed-image", "../uwc/images/LrlSub_1.gif") %>' width="16" height="16" title='<%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-AlreadySubscribedOrAlreadySelected-alert", "Either this calendar has been subscribed to or added to the Selected Calendars list.") %>' alt='<%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-AlreadySubscribedOrAlreadySelected-alert", "Either this calendar has been subscribed to or added to the Selected Calendars list.") %>'>
                </jato:content>
              </td>
              <td class="TblTdSrt">
                <jato:text name="CalDisplayableInfo"/>
                <jato:content name="IsSubscribed">
                  &nbsp;<font color="#594FBF">(<%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-SubscribedLabel", "Subscribed") %>)</font>
                </jato:content>
              </td>
              <td><jato:content name="DescriptionHtmlText"/></td>
              <td><jato:content name="OwnerNameHtmlText"/></td>
            </tr>
        </jato:tiledView>
  </jato:content>
  <jato:content name="ZeroCals">
            <tr>
              <th colspan="2" nowrap class="TblThCl1"><%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-NameLabel", "Name") %></th>
              <th scope="col" width="40%"><%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-DescriptionLabel", "Description") %></th>
              <th scope="col" width="20%"><%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-OwnerLabel", "Owner") %></th>
            </tr>
            <tr>
              <td class="TblTdCl1" align="left" colspan="4"><%= getLocalizedLabel(session, "uwc-common-NoSearchResultsFound", "The search found no results. Try again by modifying your search.") %></td>
            </tr>
  </jato:content>
        <jato:content name="SelectedCalsContent">
            <tr> 
              <td class="TblActTdLst" colspan="4"><span class="Lbl4"><%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-SelectedCalendarsLabel", "Selected Calendars") %></span>&nbsp; 
                <input class="Btn1Mni" type="button" name="deselect" id="deselect" value="<%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-Deselect", "Deselect Calendars") %>" onMouseOver="if (this.disabled==0) this.className='Btn1MniHov'" onFocus="if (this.disabled==0) this.className='Btn1MniHov'" onMouseOut="if (this.disabled==0) this.className='Btn1Mni'" onBlur="if (this.disabled==0) this.className='Btn1Mni'" onClick="selectTheSelectedCalendars(false); return false;" title="<%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-Deselect-title", "Deselect Calendars") %>">
              </td>
            </tr>
        </jato:content>
        <jato:tiledView name="SelectedCalendarTileView" type="com.sun.uwc.calclient.SearchCalendarTileView">
            <jato:hidden name="CalID"/>
            <jato:hidden name="CalDisplayName"/>
            <jato:hidden name="CalOwnerName"/>
            <tr> 
              <td class="TblTdCl1" align="center">
                <jato:checkbox name="SelectCalendar" elementId="CheckBoxOfSelectedCalendar" extraHtml="checked"/>
              </td>
              <td colspan="3"><jato:text name="CalDisplayableInfo"/></td>
            </tr>
       </jato:tiledView>
  <jato:content name="NonZeroCals">
            <tr> 
              <td class="TblActTdLst" colspan="2">&nbsp; </td>
              <td class="TblActTdLst" colspan="2" align="right" nowrap><jato:text name="CalTileMessage"/></td>
            </tr>
  </jato:content>
            </tbody> 
          </table>
      </div>
    </td>
    <td><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
  </tr>
</table>

<!-- Defined a hidden button called 'Save' which requires for triggering default form action or as a place holder for default command child to call handleSearch() method in assoicated view bean. This 'Save' button will *always* be *hidden* because it is put inside a non-visible div tag. -->
<div style="visibility: hidden;">
  <jato:button styleClass="Btn2" name="Save" onClick="handleSearch(); return false;" extraHtml="title=\"A hidden button for internal use\""/>
</div>

</jato:form>

<script src="../uwc/js/scripts.js" type="text/javascript"> </script>
<script src="../uwc/js/uwcUtils.js" type="text/javascript"> </script>
<script src="../uwc/js/date_utils.js" type="text/javascript"> </script>

<script language="JavaScript">
<!--

var SEARCH_KEY = "search";
var SUBSCRIBE_KEY = "subscribe";

function isCalCheckBox(theElement, theTileType) {
  if((null == theElement) || (null == theTileType)) {
    return false;
  }
  if("checkbox" == theElement.type) {
    if((-1 != theElement.name.indexOf(theTileType)) && (-1 != theElement.name.indexOf("SelectCalendar")))
    {
      return true;
    }
  }
  return false;
}

function selectCalendars(isChecked) {
  var elementArray = document.SearchCalendarData.elements;
  for(var i=0; i < elementArray.length; i++) {
    if(isCalCheckBox(elementArray[i], "SearchCalendarTileView")) {
      elementArray[i].checked = isChecked;
    }
  }
}

function selectTheSelectedCalendars(isChecked) {
  var elementArray = document.SearchCalendarData.elements;
  for(var i=0; i < elementArray.length; i++) {
    if(isCalCheckBox(elementArray[i], "SelectedCalendarTileView")) {
      elementArray[i].checked = isChecked;
    }
  }
}

function isAnyCalendarsExists() {
  var elementArray = document.SearchCalendarData.elements;
  for(var i=0; i < elementArray.length; i++) 
  {
    if(isCalCheckBox(elementArray[i], "SearchCalendarTileView") ||
       isCalCheckBox(elementArray[i], "SelectedCalendarTileView"))
    {
      return true;
    }
  }

  return false;
}

function isAnyCalendarSelected() {
  var elementArray = document.SearchCalendarData.elements;
  for(var i=0; i < elementArray.length; i++) 
  {
    if(isCalCheckBox(elementArray[i], "SearchCalendarTileView") ||
       isCalCheckBox(elementArray[i], "SelectedCalendarTileView"))
    {
      if(elementArray[i].checked) {
        return true;
      }
    }
  }

  return false;
}

var calidValues = null;
var dispNameValues = null;
var ownerCNValues = null;
var currentCalidValuesIndex = 0;

function buildSelectedCalendarsArray() {
  calidValues = new Array();
  dispNameValues = new Array();
  ownerCNValues = new Array();
  currentCalidValuesIndex = 0;

  collectSelectedCalendars("SearchCalendarTileView");
  collectSelectedCalendars("SelectedCalendarTileView");
}

function collectSelectedCalendars(calTileName) {

  var elementArray = document.SearchCalendarData.elements;
  var tileIndex = -1;

  // The check (tileIndex < elementArray.length) -- is put up just as a gaurd
  // against breaking the loop if falls to for-ever loop
  //
  while(tileIndex < elementArray.length)
  {
    tileIndex++;

    var theTileName = "SearchCalendarData." + calTileName + "[" + tileIndex + "]." ;

    var calidName = theTileName + "CalID";
    var calidElem = elementArray[calidName];

    if((undefined == calidElem) || (null == calidElem)) {
      break;
    }

    var selectCalName = theTileName + "SelectCalendar";
    var calDispName = theTileName + "CalDisplayName";
    var ownerCNName =theTileName + "CalOwnerName";

    var selectCalElem = elementArray[selectCalName];
    var calDispElem = elementArray[calDispName];
    var ownerCNElem =elementArray[ownerCNName];

    if((undefined != selectCalElem) && (null != selectCalElem))
    {
      if(selectCalElem.checked)
      {
        if((undefined != calidElem) && (null != calidElem)) {
          calidValues[currentCalidValuesIndex] = calidElem.value;
        }
        else {
          calidValues[currentCalidValuesIndex] = null;
        }

        if((undefined != calDispElem) && (null != calDispElem)) {
          dispNameValues[currentCalidValuesIndex] = calDispElem.value;
        }
        else {
          dispNameValues[currentCalidValuesIndex] = null;
        }

        if((undefined != ownerCNElem) && (null != ownerCNElem)) {
          ownerCNValues[currentCalidValuesIndex] = ownerCNElem.value;
        }
        else {
          ownerCNValues[currentCalidValuesIndex] = null;
        }

        currentCalidValuesIndex++;
      }
    }
  }
}

function handleSearch() {
  var theStr = document.SearchCalendarData.TextEnteredForSearchCalendar.value;
  if((null == theStr) || ("" == trim(theStr))) {
    UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-BlankSearchString-alert", "Please enter a search string") %>');
    return;
  }
  document.SearchCalendarData.submitType.value = SEARCH_KEY;
  document.SearchCalendarData.submit();
}

function handleAddCalendars() {
  if(false == isAnyCalendarsExists()) {
    UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-Add-PleaseSearchAndSelectTheCalendars-alert", "Please do search for calendars and select the calendars, then click on Add Calendar(s)") %>');
    return;
  }
  if(false == isAnyCalendarSelected()) {
    UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-Add-PleaseSelectTheCalendars-alert", "Please select the calendars to add") %>');
    return;
  }

  buildSelectedCalendarsArray()

  returnArray = new Array();
  returnArray[returnArray.length] = calidValues;
  returnArray[returnArray.length] = dispNameValues;
  returnArray[returnArray.length] = ownerCNValues;

  parent.opener.AcceptSelectedCalendarsData(returnArray);

  parent.close();
}   

function handleSubscribe() {
  if(false == isAnyCalendarsExists()) {
    UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-Subscribe-PleaseSearchAndSelectTheCalendars-alert", "Please do search for calendars and select the calendars, then click on Subscribe to Calendar(s)") %>');
    return;
  }
  if(false == isAnyCalendarSelected()) {
    UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-Subscribe-PleaseSelectTheCalendars-alert", "Please select the calendars to subscribe") %>');
    return;
  }

  document.SearchCalendarData.submitType.value = SUBSCRIBE_KEY;
  document.SearchCalendarData.submit();
}   

//-->
</script>

</body>

</jato:useViewBean>

</html>
