<html>

<%@page info="EditCalGroupData" language="java" pageEncoding="utf-8" contentType="text/html; charset=UTF-8"%>
<%@taglib uri="/WEB-INF/jato.tld" prefix="jato"%>
<%@taglib uri="/WEB-INF/uwc.tld" prefix="uwc"%>

<%@include file="../../uwc/js/resourceBundleUtils.js"%>

<jato:useViewBean className="com.sun.uwc.calclient.EditCalGroupDataViewBean">

<head>
<title><jato:getDisplayFieldValue escape="false" name="ViewBanner"/></title>
<script src="../uwc/js/browserVersion.js" type="text/javascript"> </script>
<script src="../uwc/js/scripts.js" type="text/javascript"> </script>
<script src="../uwc/js/uwcUtils.js" type="text/javascript"> </script>
<script src="../uwc/js/date_utils.js" type="text/javascript"> </script>
<script type="text/javascript">
<!--
  if (is_ie5up) // IE5
  {
   document.write("<LINK href=<%= getLocalizedLabel(session, "skinModel", "Style-Sheet-IE", "../uwc/css/css_ie5win.css") %> type=text/css rel=stylesheet>")
  }
  else if (is_gecko) // Netscape 6/7 or Mozilla
  {
   document.write("<LINK href=<%= getLocalizedLabel(session, "skinModel", "Style-Sheet-NN", "../uwc/css/css_ns6up.css") %> type=text/css rel=stylesheet>")
  }
  else  // All others
  {
   document.write("<LINK href=<%= getLocalizedLabel(session, "skinModel", "Style-Sheet-NN", "../uwc/css/css_ns6up.css") %> type=text/css rel=stylesheet>")
  }
//-->
</script>

<script language=JavaScript type=text/javascript>
<!--

function MM_openBrWindow(theURL,winName,features) { //v2.0
  window.open(theURL,winName,features);
}

function handleSave(theSubmitType) {
  var grpName = document.EditCalGroupData.elements["EditCalGroupData.GroupName"].value;
  if((null == grpName) || ("" == trim(grpName))) {
    UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-edit-calgroup-BlankGroupName-alert", "Please enter a valid Group Name. You cannot leave this field blank.") %>');
    return;
  }

  var pat = /[^a-zA-Z0-9-_\. ]/g;
  var result = pat.test(grpName);
  if(grpName == '' || result) {
    UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-edit-calgroup-invalid-calgroupname-alert", "Enter a valid name for your calendar group in the Group Name input box. This will be the name you see for your calendar group. A calendar group must have a unique name. It cannot contain spaces, but can include the following characters: Alphabetic (A-Z, a-z) and Numeric (0-9) and Special characters: underscore (_), period (.) and Hyphen (-)")%>');
    return;
  }

  // Commented 29-Dec-2004, Fix for #5060293 - Now allowing to create a 
  // calendar group without any members in it
  //
  // if(false == anyMemberExists()) {
  //   UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-edit-calgroup-NoMembersExistsToAdd-alert", "Cannot save - No memebers exists in the members list, please add at least one member to the Member List") %>');
  //   return;
  // }

  document.EditCalGroupData.submitType.value = 'Save';
  document.EditCalGroupData.submit();
}

function handleDelete() {
  if(UWCConfirm('<%= getLocalizedLabel(session, "uwc-calclient-edit-calgroup-DeleteCalendarGroupConfirm-question", "Are you sure you want to delete this calendar group?") %>'))
  {
    document.EditCalGroupData.submitType.value = 'Delete';
    document.EditCalGroupData.submit();
  }
}

function handleRemove() {
  if(false == anyMemberExists()) {
    UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-edit-calgroup-NoMembersExistsToDelete-alert", "Cannot remove - No members exists in the members list to remove") %>');
    return false;
  }

  var memberOpts = document.EditCalGroupData.elements["memberList"].options;
  if(-1 == memberOpts.selectedIndex) {
    UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-edit-calgroup-SelectMemberToDelete-alert", "Please select the member(s) to delete") %>');
    return false;
  }

  return UWCConfirm('<%= getLocalizedLabel(session, "uwc-calclient-edit-calgroup-DeleteMemberConfirm-question", "Are you sure you want to delete the selected members?") %>');
}

function handleQuickCalendarList(selectedCal) {
  if("QuickCalSelect" == selectedCal) {
    return;
  }
  document.EditCalGroupData.submitType.value = "QuickCalendarList";
  document.EditCalGroupData.submit();
}

function openSearchForCalendarsPopup() {
  MM_openBrWindow('<%= getContextURI(request) %>/calclient/SearchCalendar','searchAndAddCalendars','scrollbars=yes,resizable=yes,width=700,height=500');
}

function AcceptSelectedCalendarsData(inputArray) {
  if(null == inputArray) {
    UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-NoCalendarsSelectedToAddToMembersList-alert", "No calendars selected to add to the members list") %>');
    return;
  }

  if(inputArray.length < 1) {
    UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-NoCalendarsDataToAdd-alert", "Cannot add calendars to the members list - No data available from Search for Calendars window") %>');
    return;
  }

  if(inputArray[0].length > 0) {
    var theCalids = "";
    var theLength = inputArray[0].length;
    for(i=0; i < theLength; i++) {
      var calID = ((null == inputArray[0][i])? "" : trim(inputArray[0][i])); 
      theCalids = theCalids + calID;
      if(i < (theLength - 1)) {
        theCalids = theCalids + ";";
      }
    }
    document.EditCalGroupData.SelectedCalendars.value = theCalids;
    document.EditCalGroupData.submitType.value = "SearchForCalendar";
    document.EditCalGroupData.submit();
  } 
  else {
    UWCAlert('<%= getLocalizedLabel(session, "uwc-calclient-searchcalendar-NoCalendarsDataToAdd-alert", "Cannot add calendars to the members list - No data available from Search for Calendars window") %>');
  }
}

function handleHelp(theHelp) {
  NotImplemented("Help called for '" + theHelp + "'");
}   

function anyMemberExists() {
  var membersLength = document.EditCalGroupData.elements["memberList"].length;
  if(0 == membersLength) {
    return false;
  }       
  if(1 == membersLength) {
    var memberOpts = document.EditCalGroupData.elements["memberList"].options;
    var theMemberValue = memberOpts[0].value; 
    if("NoMembersSelected" == theMemberValue) {
      return false;
    }
  }
  return true;
}

//-->
</script>

</head>

<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0" class="Popup">

<jato:form name="EditCalGroupData" method="post" defaultCommandChild="/Save">

<input type="hidden" name="submitType">
<input type="hidden" name="SelectedCalendars">

<table width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <tr>
      <td class="PopupTitle"><span class="PopupTitleText"><jato:getDisplayFieldValue escape="false" name="ViewBanner"/></span></td>
  </tr>
</table>

<!-- Error pagelet -->
<jato:containerView name="errorPlugin">
  <%@include file="/uwc/common/popuperror2.jsp"%>
</jato:containerView>

<jato:content name="EditableCalGroupName">
<!-- Required field indicator div -->
  <td colspan="2"><img src="../uwc/images/spacer.gif" width="1" height="10" alt=""></td>
  <div class="ConRqdDiv"><img src="<%= getLocalizedLabel(session, "skinModel", "uwc-common-Required-image", "../uwc/images/required.gif") %>" alt='<%= getLocalizedLabel(session, "uwc-calclient-Required", "Required") %>' width="7" height="14">&nbsp;<span class="ConRqdTxt"><%= getLocalizedLabel(session, "uwc-common-IndicatesRequiredField", "Indicates required field") %></span>
  </div>
</jato:content>

<!-- Form Input for Group name and description -->
<table class="FormInputTable" width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <tr> 
    <td colspan="2"><img src="../uwc/images/spacer.gif" width="1" height="10" alt=""></td>
  </tr>
  <tr> 
    <jato:content name="EditableCalGroupName">
      <td class="PropLabel" nowrap><img src="<%= getLocalizedLabel(session, "skinModel", "uwc-common-Required-image", "../uwc/images/required.gif") %>" alt='<%= getLocalizedLabel(session, "uwc-calclient-Required", "Required") %>' width="7" height="14"><span class="Lbl2"><label for="groupName"><%= getLocalizedLabel(session, "uwc-calclient-edit-calgroup-GroupNameLabel", "Group Name:") %></label></span></td>
    </jato:content>
    <jato:content name="StaticCalGroupName">
      <td class="PropLabel" nowrap><span class="Lbl2"><label for="groupName"><%= getLocalizedLabel(session, "uwc-calclient-edit-calgroup-GroupNameLabel", "Group Name:") %></label></span></td>
    </jato:content>
    <td class="PropInput" width="100%"> 
      <jato:content name="EditableCalGroupName">
        <jato:textField name="GroupName" size="50" elementId="groupName" tabIndex="1"/>
      </jato:content>
      <jato:content name="StaticCalGroupName">
        <jato:text name="GroupName"/>
        <jato:hidden name="GroupName"/>
      </jato:content>
    </td>
  </tr>
  <tr> 
      <td class="PropLabel" valign="top"><span class="Lbl2"><label for="groupDescription"><%= getLocalizedLabel(session, "uwc-calclient-edit-calgroup-DescriptionLabel", "Description:") %></label></span></td>
    <td class="PropInput"> 
        <jato:textArea name="GroupDescription" wrap="VIRTUAL" cols="70" rows="2" elementId="groupDescription" tabIndex="2"/>
    </td>
  </tr>
</table>
<!-- Group Member sub-section header -->
<table width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <tr> 
    <td colspan="3"><img src="../uwc/images/spacer.gif" width="1" height="20" alt=""></td>
  </tr>
  <tr> 
    <td><img src="../uwc/images/spacer.gif" width="10" height="5" alt=""></td>
    <td class="SectionDivider" width="100%"><img src="../uwc/images/spacer.gif" width="1" height="5" alt=""></td>
	<td><img src="../uwc/images/spacer.gif" width="10" height="5" alt=""></td>
  </tr>
  <tr> 
    <td colspan="3" class="SectionHeader"><span class="SectionHeader"><%= getLocalizedLabel(session, "uwc-calclient-edit-calgroup-GroupMembersLabel", "Group Members") %></span></td>
  </tr>
</table>
<!-- Group Member input/selection -->
<table class="FormInputTable" width="100%" border="0" cellspacing="0" cellpadding="0" title="">
  <tr> 
    <td>&nbsp;</td>
      <td class="PropInputWHelp" width="100%"><%= getLocalizedLabel(session, "uwc-calclient-edit-calgroup-Intro", "Type the group member's calendar id, then click Add. You may also select members from your personal and subscribed calendars list or search for calendars.") %></td>
  </tr>
  <tr> 
    <td class="PropLabel"><span class="Lbl2"><label for="member"><%= getLocalizedLabel(session, "uwc-calclient-edit-calgroup-MemberLabel", "Member:") %></label></span></td>
    <td class="PropInput" width="100%"> 
      <jato:textField name="Member" size="40" elementId="member" tabIndex="3"/>&nbsp;
      <jato:button styleClass="Btn1" name="AddMember" elementId="add" defaultValue=" Add " onMouseOver="if (this.disabled==0) this.className='Btn1Hov'" onFocus="if (this.disabled==0) this.className='Btn1Hov'" onMouseOut="if (this.disabled==0) this.className='Btn1'" onBlur="if (this.disabled==0) this.className='Btn1'" tabIndex="4"/>
        <jato:button styleClass="Btn2" name="SearchForCalendar" elementId="searchCal" defaultValue="Search for Calendar" onClick="openSearchForCalendarsPopup(); return false;" onMouseOver="if (this.disabled==0) this.className='Btn2Hov'" onFocus="if (this.disabled==0) this.className='Btn2Hov'" onMouseOut="if (this.disabled==0) this.className='Btn2'" onBlur="if (this.disabled==0) this.className='Btn2'" tabIndex="5"/>
      </td>
  </tr>
  <tr> 
    <td class="PropLabel">&nbsp;</td>
    <td class="PropInput"> 
      <uwc:uwccombobox name="QuickCalendarList" elementId="calendarMenu" tabIndex="6" onClick="handleQuickCalendarList(this.value); return false;"/>
    </td>
  </tr>
  <tr> 
    <td class="PropLabel" nowrap valign="top"><span class="Lbl2"><label for="memberList"><%= getLocalizedLabel(session, "uwc-calclient-edit-calgroup-MemberListLabel", "Member List:") %></label></span></td>
    <td class="PropInput"> 
      <table border="0" cellspacing="0" cellpadding="0" title="">
        <tr> 
          <td valign="top"> 
            <jato:listbox name="MemberList" size="7" extraHtml="multiple" elementId="memberList" tabIndex="7"/>
          </td>
          <td valign="top"> 
            <table class="AddRmvBtnTbl" border="0" cellspacing="0" cellpadding="0" title="">
              <tbody> 
              <tr> 
                <td align="center"><img src="../uwc/images/spacer.gif" width="10" height="1" alt=""></td>
                <td class="PropInput" align="center"> 
                  <div class="AddRmvHrzWin"> 
                    <jato:button styleClass="Btn2" name="RemoveMember" elementId="remove" tabIndex="8" defaultValue="      Remove       " onMouseOver="if (this.disabled==0) this.className='Btn2Hov'" onMouseOut="if (this.disabled==0) this.className='Btn2'" onClick="return handleRemove();"/>
                  </div>
                </td>
              </tr>
              </tbody> 
            </table>
          </td>
        </tr>
      </table>
    </td>
  </tr>
</table>

<!-- Defined a hidden button called 'Save' which requires for triggering default form action or as a place holder for default command child to call handleSaveRequest method in assoicated view bean. This 'Save' button will *always* be *hidden* because it is put inside a non-visible div tag. -->
<div style="visibility: hidden;">
  <jato:button styleClass="Btn2" name="Save" onClick="handleSave('Save'); return false;" extraHtml="title=\"A hidden button for internal use\""/>
</div>

</jato:form>

</body>

</jato:useViewBean>

</html>
