<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:template name="commonjavascript">
  function addSession(url) {
    sessionString = '<xsl:value-of select="/xslui/@sessionstring"/>';
    return url + sessionString;
  }
  var i18n = new Object();
  i18n["Please make a valid selection"] = "<xsl:text>_Please make a valid selection</xsl:text>";
  i18n["This action is unavailable in this context."] ="<xsl:text>_This action is unavailable in this context.</xsl:text>";
  i18n["No entry of this type"] = "<xsl:text>_No entry of this type</xsl:text>";
  i18n["No entry containing a calendar address selected"] = "<xsl:text>_No entry containing a calendar address selected</xsl:text>";
  i18n["No entry containing an email address selected"] = "<xsl:text>_No entry containing an email address selected</xsl:text>";
  i18n["No entry containing an iPlanet IM selected"] = "<xsl:text>_No entry containing an iPlanet IM selected</xsl:text>";
  i18n["Selection is empty, please select entries to delete."] = "<xsl:text>_Selection is empty, please select entries to delete.</xsl:text>";
  i18n["Selection is empty, please select entries to copy."] = "<xsl:text>_Selection is empty, please select entries to copy.</xsl:text>";
  i18n["A year should be expressed using the four-digit format"] = "<xsl:text>_A year should be expressed using the four-digit format</xsl:text>.";
  i18n["A year should be a number"] = "<xsl:text>_A year should be a number</xsl:text>.";
  i18n["Default Book cannot be deleted"] = "<xsl:text>_This is the default book and cannot be deleted.</xsl:text>";
  i18n["Default Book cannot be unsubscribed"] = "<xsl:text>_This is the default book and cannot be unsubscribed.</xsl:text>";
  i18n["No integration provided"] = "<xsl:text>_This feature is not integrated yet.</xsl:text>";
  i18n["Delete Selected Cards"] = "<xsl:text>_Delete Selected Cards</xsl:text>";
  i18n["Are you sure you want to delete this contact"] = "<xsl:text>_Are you sure you want to delete this contact</xsl:text>";
  i18n["Are you sure you want to delete this group"] = "<xsl:text>_Are you sure you want to delete this group</xsl:text>";
  i18n["No entry containing email address selected in order to view calendar"] = "<xsl:text>_No entry containing email address selected in order to view calendar</xsl:text>";
  i18n["Invalid Email Address"] = "<xsl:text>_Invalid Email Address</xsl:text>";
  i18n["Day"] = "<xsl:text>_Day</xsl:text>";
  i18n["Month"] = "<xsl:text>_Month</xsl:text>";
  i18n["Enter search string first"] = "<xsl:text>_Enter search string first</xsl:text>";

function reloadParent(loadOpener, qs) {
   var reloadWin = parent.opener.parent;
   var parentOpenerLoc = parent.opener.location.href;
 
   if( qs != null &#38;&#38; parentOpenerLoc.indexOf("?") &lt; 0) {
       parent.opener.location = parent.opener.location + "?bookid=" + document.iabform.bookid.value + "&amp;" + qs;
     //else
     //  parent.opener.location = parent.opener.location + "&amp;" + qs;
   }
   else parent.opener.location = parent.opener.location;

    //** need to do so that the opener frame can be reloaded	
   if( reloadWin &#38;&#38; loadOpener) {
     reloadWin.location = reloadWin.location;
   }

   reloadWin.focus();
}

function printLocalizedLabel(sourcestring, posParams)
{
  if( sourcestring == null )
    return "";

  if( posParams.length == 0 )
    return sourcestring;

  var openBraceIndex, closeBraceIndex, startIndex;
  openBraceIndex = closeBraceIndex, startIndex = 0;

  var finalString = "";
  while( true ) {
    openBraceIndex = sourcestring.indexOf("{", startIndex);
    if( openBraceIndex &lt; 0 ) {
      finalString += sourcestring.substring(startIndex);
      break;
    }

    finalString += sourcestring.substring(startIndex, openBraceIndex);
    closeBraceIndex = sourcestring.indexOf("}", openBraceIndex);
    if( closeBraceIndex &gt; -1 ) {
      var posIndex = sourcestring.substring(openBraceIndex+1, closeBraceIndex);
      finalString += posParams[posIndex - 1];
      startIndex = closeBraceIndex + 1;
    } else {
      startIndex = openBraceIndex + 1;
    }
  }

  document.write(finalString);
}

function setHiddenEmailParam(hiddenEmailParam)
{
  var hiddenEmailPar = document.iabform.elements[hiddenEmailParam];
  if( !hiddenEmailPar )
    return;
  var emailSelected = document.iabform.elements["email"];
  if( !emailSelected )
     return;
  hiddenEmailPar.value = emailSelected.options[emailSelected.selectedIndex].value;
}
</xsl:template>

<!--
*******************************************************************************
* This template prints the javascript that determines the style-sheet for the page
*******************************************************************************
-->
<xsl:template name="cssjavascript">
function cssStyle() {
  if (is_ie5up) // IE5
  {    
   return "../absimx/css_ie5win.css";
  }
  else if (is_gecko) // Netscape 6/7 or Mozilla
  {
    return "../absimx/css_ie5win.css";   
  }
  else  // All others
  {
   return "../absimx/css_ie5win.css";   
  }
}
</xsl:template>
<!--
*******************************************************************************
* This template prints the javascript to execute when the page loads
* @param action The action attribute of the xslui node
* @param rootnode The node which contains the members
*******************************************************************************
-->
<xsl:template name="processAction">
  <xsl:param name="action"/>
  <xsl:param name="rootnode"/>
  <script language="javascript">
  function onLoadAction()
  {
    <xsl:choose>
      <xsl:when test="$action = 'sendemail'">
        var i =0;
        var emailArray = new Array();
        <xsl:for-each select="$rootnode/*">
          <xsl:if test="string-length(email[@priority='1']) > 0">
            emailArray[i++] = '<xsl:value-of select="email[@priority='1']"/>';
          </xsl:if>
          <xsl:if test="string-length(mail) > 0">
            emailArray[i++] = '<xsl:value-of select="mail"/>';
          </xsl:if>
        </xsl:for-each>
        var mailpref = '<xsl:value-of select="/xslui/profileinfo/xmlprofile/generalprefs/@webmail"/>';
        var mailEnabled = '<xsl:value-of select="/xslui/usersession/@mailenabled"/>';
        var mailType = 'desktop';
        if( mailpref == 'uc' &#38;&#38; mailEnabled == 'true' )
          mailType = 'uc';

        sendMail('<xsl:value-of select="/xslui/usersession/@mailurl"/>', mailType ,emailArray);
      </xsl:when>
      <xsl:when test="$action = 'viewcalendar'">
        var i=0;
        var calArray = new Array();
        <xsl:for-each select="$rootnode/*">
          <xsl:if test="string-length(email[@priority='1']) > 0">
            calArray[i++] = '<xsl:value-of select="email[@priority='1']"/>';
          </xsl:if>
        </xsl:for-each>
        viewUWCCalendar(calArray, '<xsl:value-of select="/xslui/@contexturi"/>');
      </xsl:when>
      <xsl:when test="$action='startconference'">
        var imArray = new Array(
        <xsl:for-each select="$rootnode/*">
          <xsl:if test="string-length(im[@service='iPlanet']) > 0">
            '<xsl:value-of select="im[@service='iPlanet']"/>',
          </xsl:if>
        </xsl:for-each>'');
        sendIM('iPlanet', imArray);
      </xsl:when>
      <xsl:when test="$action='login'">
      </xsl:when>
      <xsl:otherwise>
      </xsl:otherwise>
    </xsl:choose>
  }
  </script><noscript></noscript> 
</xsl:template>

<!--
*******************************************************************************
* This templates outputs the javascript functions to handle dates properly in the edit contact page
*******************************************************************************
-->
<xsl:template name="i18n-dates">
  var monthNames = new Array (
  '<xsl:text>_January</xsl:text>', 
  '<xsl:text>_February</xsl:text>', 
  '<xsl:text>_March</xsl:text>',
  '<xsl:text>_April</xsl:text>',
  '<xsl:text>_May</xsl:text>',
  '<xsl:text>_June</xsl:text>',
  '<xsl:text>_July</xsl:text>',
  '<xsl:text>_August</xsl:text>',
  '<xsl:text>_September</xsl:text>',
  '<xsl:text>_October</xsl:text>',
  '<xsl:text>_November</xsl:text>',
  '<xsl:text>_December</xsl:text>');
</xsl:template> 


<!--
*******************************************************************************
* Prints the function which fills the displayname field
*******************************************************************************
-->
<xsl:template name="autoFillDisplayName">
  <xsl:param name="fieldPrefix" select="'abperson_'" />
  
  modifiedFields = "";
  var display_entered = false;
  var curr_val_is_autofill = false;
  function autoFillDisplayName(field)
  {
    var f  = document.iabform; 
    var existing_dn = f.<xsl:value-of select="concat($fieldPrefix, 'displayName')" />.value;
    /*if display name has been explicitly entered and is not blank, return.
     */
    if ( (existing_dn.trim().length > 0) &#38;&#38; window.display_entered)
	return;

    /* in case of edit contact, even through no keystroke had happened in the display field, 
     * (ie last condition was false)
     * we want to retain
     * a non-blank value 
     */
    if ( (existing_dn.trim().length > 0) &#38;&#38; (window.curr_val_is_autofill == false) )
        return;

    /* reset display_entered (by the user's keystrokes) flag to false
     */    
    window.display_entered = false;
    var dn = "";
    fLastname  = f.<xsl:value-of select="concat($fieldPrefix, 'sn')" />;
    fFirstname = f.<xsl:value-of select="concat($fieldPrefix, 'givenName')" />;
    fCompany   = f.<xsl:value-of select="concat($fieldPrefix, 'company')" />;
    lastname  = (fLastname == null)?"":fLastname.value.trim();
    firstname = (fFirstname == null)?"":fFirstname.value.trim();
    company   = (fCompany == null)?"":fCompany.value.trim();
    if (lastname.length > 0) {
      if (firstname.length > 0) {
        dn = lastname + ", " + firstname; 
      }
      else {
        dn = lastname; 
      }
    }
    else {
      dn = firstname;
    }
    if (dn.trim() == "") dn = company;
    
    f.<xsl:value-of select="concat($fieldPrefix, 'displayName')" />.value = dn.trim();
    window.curr_val_is_autofill = true;
  }


</xsl:template> 
</xsl:stylesheet>


