<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:output method="html" version="4" encoding="UTF-8"/>

<xsl:include href="commonimages.xsl"/>

<xsl:include href="commonattributes.xsl"/>
<xsl:include href="common-uielements.xsl"/>
<xsl:include href="commonjavascript.xsl"/>
<xsl:include href="commonattributes-hidden.xsl"/>
<xsl:include href="commonattributes-list.xsl"/>
<xsl:include href="entries-list.xsl"/>
<xsl:include href="errors.xsl"/>
<xsl:include href="search-template.xsl"/>
<xsl:include href="search-images.xsl"/>
<xsl:include href="css-select.xsl"/>


<!--
*******************************************************************************
* This templates prints the action bar
* @param id The unique id of the action bar. It is used when generating the field names
* @param searchResult The node containing the results of the current search. It is only used for page navigation.
*******************************************************************************
-->
<xsl:template name="search-actionbar">
  <xsl:param name="id" select="'0'" />
  <xsl:param name="searchResult" />
  <xsl:param name="displaySeparators" select="0" />
  <xsl:param name="isCorporateAB" select="boolean(/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]/@bookremoteurl)" />
  
  <table border="0" cellspacing="0" cellpadding="0" width="100&#37;" class="second-strip">
    <xsl:if test="boolean($displaySeparators)">
      <tr class="fourth-strip"> 
        <td colspan="2">
          <img src="{$spacer.gif}" width="1" height="2" alt=""/>
        </td>
      </tr>
    </xsl:if>
    <tr> 
      <td colspan="2">
        <img src="{$spacer.gif}" alt="" width="1" height="6"/>
      </td>
    </tr>
    <tr> 
      <td> 
        <table border="0" cellspacing="0" cellpadding="0">
          <tr> 
            <td>
              <img src="{$spacer.gif}" alt="" width="12" height="1"/>
            </td>
            <td> 
              <xsl:call-template name="uwcbutton">
                <xsl:with-param name="label">
                  <xsl:text>_Select All</xsl:text>
                </xsl:with-param>
                <xsl:with-param name="href">
                  <xsl:text>javascript:checkAll(document.iabform.selectedentry,true)</xsl:text> 
                </xsl:with-param> 
              </xsl:call-template>
            </td>
            <td>
              <img src="{$spacer.gif}" alt="" width="3" height="1"/>
            </td>
            <td> 
              <xsl:call-template name="uwcbutton">
                <xsl:with-param name="label">
                  <xsl:text>_Deselect All</xsl:text>
                </xsl:with-param>
                <xsl:with-param name="href">
                  <xsl:text>javascript:checkAll(document.iabform.selectedentry,false)</xsl:text>
                </xsl:with-param> 
              </xsl:call-template>
            </td>
          </tr>
        </table>
      </td>
      <td align="right">
        <xsl:call-template name="search-template-paging">
          <xsl:with-param name="searchresult" select="$searchResult"/>
        </xsl:call-template>        
      </td>
    </tr>
    <tr> 
      <td colspan="2">
        <img src="{$spacer.gif}" alt="" width="1" height="6"/>
      </td>
    </tr>
    <xsl:if test="boolean($displaySeparators)">
      <tr class="fourth-strip"> 
        <td colspan="2">
          <img src="{$spacer.gif}" alt="" width="1" height="1"/>
        </td>
      </tr>
    </xsl:if>
  </table>
</xsl:template> 


<!--
*******************************************************************************
* Core of the template stylesheet search.xsl
*******************************************************************************
-->
<xsl:template match="/">
  <html>
    <head>
      <title>
        <xsl:text>_SunONE Address Book</xsl:text>
      </title>
      <script language="javascript" src="../absjs/common.js"/>
      <script language="javascript" src="../absjs/integration.js"/>       
                
      <script src="../absjs/scripts.js"></script>
      <script src="../absjs/browserVersion.js"></script>
      <script>      
          if (is_ie5up) // IE5
          {    
           document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ie5win.css"&gt;');
          }
          else if (is_gecko) // Netscape 6/7 or Mozilla
          {
            document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
          }
          else  // All others
          {
           document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
          }
      </script>                        
      <script language="Javascript">
        <xsl:call-template name="commonjavascript"/>
        var opener = parent.opener;        	 
        var inputObj = (opener != null)? opener.GetSharedObject():null;        	 
        <!-- Hard coded the return fields 'cause this is the only purpose of this popup -->	 
        if (inputObj != null) 	 
           inputObj.fieldsToReturn = new Array('to', 'cc', 'bcc');	 
                 	 
        var toStr   = ((inputObj != null) &#38;&#38; (inputObj.to != null))?inputObj.to.toString():"";	 
        var ccStr   = ((inputObj != null) &#38;&#38; (inputObj.cc != null))?inputObj.cc.toString():"";	 
        var bccStr   = ((inputObj != null) &#38;&#38; (inputObj.bcc != null))?inputObj.bcc.toString():"";

        function cancel() {
          document.iabform.stopsearch.value = "1";
          goToUsingForm('closesearchpopup.xml');
        }

        function expandSelection(entryArray, checkBoxesName)
        {
          <!-- first build the arrays of things we are interested in -->
          var lastEntryIndex = 0;
          var needsExpand = false;
          var selectedTable = eval("document.iabform."+checkBoxesName);
          var nbEntries = (selectedTable == null)?null:selectedTable.length;
          var selectedEntry = null;
          if (nbEntries != null) {
            selectedEntry = selectedTable[0];
          }
          else {
            nbEntries = 1;
            selectedEntry = selectedTable;
          }
          for (var i = 0;i &lt; nbEntries; i++) {
            if (nbEntries == 1)
              selectedEntry = selectedTable;
            else
              selectedEntry = selectedTable[i];

            if (selectedEntry.checked) {
              var entryID = selectedEntry.value;
              var entryType = 'abperson';
              var entryField = null;
              var entryTypeObj = document.iabform['id_' + entryID + '_entrytype'];
              if (entryTypeObj != null) {
                  if ((entryTypeObj.length != null) &amp;&amp; (entryTypeObj.length > 0)) {
                    entryType = entryTypeObj[0].value;
                  }
                  else
                    entryType = entryTypeObj.value;
              }
              
              var entryFieldObj = document.iabform['id_' + entryID + '_' + 'email_1'];
              var displayName = document.iabform['id_' + entryID + '_' + 'displayname'];

              if (entryFieldObj != null) {
                  if( entryField == null )
                    entryField = new Array();
                    
                  if ((entryFieldObj.length != null) &amp;&amp; (entryFieldObj.length > 0)) {
                    entryField[0] = displayName[0].value; //for displayname
                    entryField[1] = entryFieldObj[0].value;
                  }
                  else {
                    entryField[0] = displayName.value;
                    entryField[1] = entryFieldObj.value;
                  }
              }
              if ((entryType == 'group') &amp;&amp; (entryField == null)) {
                needsExpand = true;
                break;
              }
              if (entryField != null)
                entryArray[lastEntryIndex++] = entryField;
            }
          }
          return needsExpand;
        }

        function ok() {        
          if (inputObj != null) {
            var toArray = new Array();
            var ccArray = new Array();
            var bccArray = new Array();
            if (expandSelection(toArray, 'to') ||
                expandSelection(ccArray, 'cc') ||
                expandSelection(bccArray, 'bcc')) {                
              document.iabform.expandselectedgroup.value=1;
              document.iabform.expandonmissing.value='mail';
              submitForm('callerAcceptData');
            }
            else {              
              returnArray = new Object();
              returnArray.toAdd = toArray;
              returnArray.ccAdd = ccArray;
              returnArray.bccAdd = bccArray;
              window.opener.AcceptData(returnArray);
              goToUsingForm('closesearchpopup.xml');
            }
          } else {
            alert("inputObj is null");
          }
          
        }

        function onLoad() {
          <xsl:if test="/xslui/@uiaction = 'callerAcceptData'">
            toArray = new Array();
            <xsl:for-each select="/xslui/iab/alreadyselected[@fieldname='to']/*">
              var displayname = "<xsl:call-template name="escape"><xsl:with-param name="text" select="entry/displayname"/></xsl:call-template>";
              var email = "<xsl:call-template name="escape"><xsl:with-param name="text" select="email[@priority='1']"/></xsl:call-template>";
              <xsl:if test="string-length(email[@priority='1']) > 0">
                var fieldArray = new Array(displayname, email);
            	toArray[toArray.length] = fieldArray;
              </xsl:if>
            </xsl:for-each> 
            ccArray = new Array();
            <xsl:for-each select="/xslui/iab/alreadyselected[@fieldname='cc']/*">
              var displayname = "<xsl:call-template name="escape"><xsl:with-param name="text" select="entry/displayname"/></xsl:call-template>";
              var email = "<xsl:call-template name="escape"><xsl:with-param name="text" select="email[@priority='1']"/></xsl:call-template>";
               <xsl:if test="string-length(email[@priority='1']) > 0">
                var fieldArray = new Array(displayname, email);
            	ccArray[ccArray.length] = fieldArray;
               </xsl:if>
            </xsl:for-each> 
            bccArray = new Array();
            <xsl:for-each select="/xslui/iab/alreadyselected[@fieldname='bcc']/*">
              var displayname = "<xsl:call-template name="escape"><xsl:with-param name="text" select="entry/displayname"/></xsl:call-template>";
              var email = "<xsl:call-template name="escape"><xsl:with-param name="text" select="email[@priority='1']"/></xsl:call-template>";
               <xsl:if test="string-length(email[@priority='1']) > 0">
                var fieldArray = new Array(displayname, email);
            	bccArray[bccArray.length] = fieldArray;
               </xsl:if>
            </xsl:for-each> 
            returnArray = new Object();
            returnArray.toAdd = toArray;
            returnArray.ccAdd = ccArray;
            returnArray.bccAdd = bccArray;
            window.opener.AcceptData(returnArray);
            goToUsingForm('closesearchpopup.xml');
          </xsl:if> 
          document.iabform.searchstring.focus();
        }

        function writeSelect(entryID, email, type) {
          s = eval(type+"Str");
          if (((s != null) &#38;&#38; (s.length > 0)) &#38;&#38; 
              ((email != null) &#38;&#38; (email.length > 0)) &#38;&#38;
              (s.indexOf(email) != -1)) {
            document.write('&lt;img src="<xsl:value-of select="$checkmark_skinny.gif"/>" width="16" height="16"&gt;');
          }
          else {
            document.write('&lt;input type="checkbox" name="'+type+'" value="'+entryID.replace(/\"/g,"&amp;#34;")+'"&gt;');
          }
        }
      </script>
      <xsl:call-template name="search-template-javascript"/>
    </head>

    <body leftmargin="0" topmargin="0" rightmargin="0" marginwidth="0" marginheight="0" onload="onLoad()">

      <form method="post" name="iabform" action="addressing-popup.xml" onsubmit="return false">
        <input type="hidden" name="j_encoding" value="{/xslui/@charset}"/>
        <input type="hidden" name="uiaction" value=""/>
        <input type="hidden" name="entryid" value=""/>
        <input type="hidden" name="dumpXML" value="0"/>
        <input type="hidden" name="isNewRequest" value="no"/>
        <xsl:variable name="pagedSearch" select="/xslui/iab/pagedsearch"/>
        <xsl:variable name="searchmode" select="boolean(/xslui/iab/entrycontext/layoutinfo/searchmode[@value='true'])"/>         
        <xsl:variable name="searchResult" select="/xslui/iab/pagedsearch/searchresult"/>        
        <xsl:variable name="selectedBook" select="/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]"/>                            
        <xsl:variable name="htmlPrefs" select="xslui/profileinfo/xmlprofile/htmlprefs"/>
        <xsl:variable name="isCorporateAB" select="boolean(/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]/@bookremoteurl)"/>
        
        <xsl:call-template name="contextKeeper">
          <xsl:with-param name="pagedSearch" select="/xslui/iab/pagedsearch"/>
        </xsl:call-template>
        <!-- Page Title -->
        <table width="100%" border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td><img src="{$spacer.gif}" alt="" width="1" height="1"/></td>
            <td with="100%" class="PopupTitle">
             <span class="PopupTitleText">
               <xsl:text>_Add From Address Book</xsl:text>
             </span>
            </td>  
            <td><img src="{$spacer.gif}" alt="" width="1" height="1"/></td>          
          </tr>
        </table>        
        <xsl:variable name="error" select="/xslui/errormessages/error"/>
        <xsl:apply-templates select="$error" mode="plain">                                                        
          <xsl:with-param name="type" >
           <xsl:choose>     
            <xsl:when test="$error/@errnum=7">
              <xsl:value-of select="'warning'"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="'error'"/>
            </xsl:otherwise>
           </xsl:choose>
         </xsl:with-param>          
        </xsl:apply-templates>       
        <xsl:variable name="bookType" select="/xslui/iab/entrycontext/layoutinfo/abtype/@display"/>
        <xsl:variable name="personalab" select="/xslui/iab/booklist/book[string-length(@bookurl) &gt; 0]"/>
        <xsl:variable name="corporateab" select="/xslui/iab/booklist/book[string-length(@corporatedir) &gt; 0]"/>                      
                             
        <xsl:call-template name="search-template-searchbar">
          <xsl:with-param name="bookList" select="/xslui/iab/booklist"/>
          <xsl:with-param name="bookType" select="$bookType"/>
          <xsl:with-param name="selectedBook" select="$selectedBook"/>
          <xsl:with-param name="selectedBookID">
            <xsl:choose>
              <xsl:when test="$searchmode">
                 <xsl:value-of select="$selectedBook/entry/@entryID"/>
              </xsl:when>
              <xsl:when test="$bookType = 0">
                <xsl:value-of select="/xslui/iab/booklist/book[string-length(@bookurl) &gt; 0]/entry/@entryID"/>          
              </xsl:when>
              <xsl:when test="$bookType = 1">
                <xsl:value-of select="/xslui/iab/booklist/book[string-length(@corporatedir) &gt; 0]/entry/@entryID"/> 
              </xsl:when>
              <xsl:otherwise>
                 <xsl:value-of select="$selectedBook/entry/@entryID"/>
              </xsl:otherwise>
              </xsl:choose>   
          </xsl:with-param>
          <xsl:with-param name="searchmode" select="$searchmode"/>               
          <xsl:with-param name="popup" select="true()"/>
          <xsl:with-param name="showBookList" select="boolean(/xslui/iab/entrycontext/layoutinfo/ablist[@display='1'])"/>            
        </xsl:call-template>                

      <table border="0" cellpadding="0" cellspacing="0" width="100%" title="">
      <tr>        
        <td><img src="{$spacer.gif}" width="10" height="1" alt=""/></td>
        <td width="98%"> 
        <div class="TableDiv"> 
        <table class="TblMail" border="0" cellpadding="0" cellspacing="0" width="100%" title="">                  
        <xsl:call-template name="search-template-header">          
          <xsl:with-param name="header">
             <xsl:choose>
               <xsl:when test="not($searchmode) and $bookType = 0">
                 <xsl:copy-of select="$personalab/entry/displayname"/>          
               </xsl:when>
               <xsl:when test="not($searchmode) and $bookType = 1">
                  <xsl:copy-of select="$corporateab/entry/displayname"/> 
               </xsl:when>
               <xsl:otherwise>
                 <xsl:copy-of select="$selectedBook/entry/displayname"/>
               </xsl:otherwise>
             </xsl:choose>
          </xsl:with-param>
          <xsl:with-param name="searchmode" select="$searchmode"/>
          <xsl:with-param name="searchCriteria" select="$searchResult/@filter"/>
          <xsl:with-param name="popup" select="true()"/>        
        </xsl:call-template>                
        
        <xsl:choose>          
          <xsl:when test="$searchmode">
           <tr>
           <xsl:call-template name="search-template-paging">
             <xsl:with-param name="searchresult" select="$searchResult"/>            
             <xsl:with-param name="tdClass" select="'TblActTd'"/>
           </xsl:call-template> 
           </tr>     
          </xsl:when>
          <xsl:otherwise>
           <tr>
           <td class="TblActTd" colspan="4">
             <xsl:attribute name="nowrap"/>
             <xsl:text>&nbsp;</xsl:text>
           </td>
           </tr>
          </xsl:otherwise>
        </xsl:choose>
        
        <xsl:choose>
          <xsl:when test="$searchResult/@error">
            <xsl:value-of select="$searchResult/@error"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:variable name="layoutinfo" select="/xslui/iab/entrycontext[@formentryname='layoutinfo']/layoutinfo"/>
            <xsl:if test="$layoutinfo">
              <input type="hidden" name="prefix" value="wcfg_"/>
              <input type="hidden" name="wcfg_entrytype" value="layoutinfo"/>
              <input type="hidden" name="wcfg_ablist" value="{/xslui/iab/entrycontext/layoutinfo/ablist/@display}"/>
              <input type="hidden" name="wcfg_abtype" value="{/xslui/iab/entrycontext/layoutinfo/abtype/@display}"/>
              <input type="hidden" name="wcfg_buttonlabel" value="{/xslui/iab/entrycontext/layoutinfo/buttonlabel/@display}"/>
              <input type="hidden" name="wcfg_searchmode" value="{/xslui/iab/entrycontext/layoutinfo/searchmode/@value}"/>
              <xsl:for-each select="$layoutinfo/displayelt">
                <input type="hidden" name="wcfg_col{./@order}" value="{.}"/>
              </xsl:for-each> 
            </xsl:if>                  
            
            <xsl:call-template name="search-template-searchresult">
              <xsl:with-param name="pagedSearch" select="/xslui/iab/pagedsearch"/>              
              <xsl:with-param name="selectedbook" select="$selectedBook"/>
              <xsl:with-param name="displayMode" select="'to-cc-bcc'"/>
              <xsl:with-param name="searchmode" select="$searchmode"/>                              
              <xsl:with-param name="popup" select="true()"/>
              <xsl:with-param name="formaction" select="'addressing-popup.xml'"/>
              <xsl:with-param name="linkOnIcon" select="false()"/>
              <xsl:with-param name="displayAttr1">
                <xsl:choose>
                  <xsl:when test="boolean($layoutinfo)">
                    <xsl:value-of select="$layoutinfo/displayelt[@order='1']" /> 
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="'dnnolink'" /> 
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
              <xsl:with-param name="displayAttr2">
                <xsl:choose>
                  <xsl:when test="boolean($layoutinfo)">
                    <xsl:value-of select="$layoutinfo/displayelt[@order='2']" /> 
                  </xsl:when>
                  <xsl:otherwise>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
              <xsl:with-param name="displayAttr3">
                <xsl:choose>
                  <xsl:when test="boolean($layoutinfo)">
                    <xsl:value-of select="$layoutinfo/displayelt[@order='3']" /> 
                  </xsl:when>
                  <xsl:otherwise>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
              <xsl:with-param name="displayAttr4">
                <xsl:choose>
                  <xsl:when test="boolean($layoutinfo)">
                    <xsl:value-of select="$layoutinfo/displayelt[@order='4']" /> 
                  </xsl:when>
                  <xsl:otherwise>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
              <xsl:with-param name="displayAttr5">
                <xsl:choose>
                  <xsl:when test="boolean($layoutinfo)">
                    <xsl:value-of select="$layoutinfo/displayelt[@order='5']" /> 
                  </xsl:when>
                  <xsl:otherwise>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
              <xsl:with-param name="displayAttr6">
                <xsl:choose>
                  <xsl:when test="boolean($layoutinfo)">
                    <xsl:value-of select="$layoutinfo/displayelt[@order='6']" /> 
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:value-of select="''" /> 
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
              <xsl:with-param name="displayAttr7">
                <xsl:choose>
                  <xsl:when test="boolean($layoutinfo)">
                    <xsl:value-of select="$layoutinfo/displayelt[@order='7']" /> 
                  </xsl:when>
                  <xsl:otherwise>
                  </xsl:otherwise>
                </xsl:choose>
              </xsl:with-param>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>

        
        <xsl:variable name="totalentries" select="number($searchResult/@totalentries)"/>       
        <xsl:choose>          
          <xsl:when test="$searchmode and $totalentries > 0">
           <xsl:call-template name="to-cc-bcc">
             <xsl:with-param name="alreadyselected" select="/xslui/iab/alreadyselected"/>
           </xsl:call-template>
           <tr>           
           <xsl:call-template name="search-template-paging">
             <xsl:with-param name="searchresult" select="$searchResult"/>            
             <xsl:with-param name="tdClass" select="'TblActTdLst'"/>
           </xsl:call-template> 
           </tr>     
          </xsl:when>
          <xsl:when test="$totalentries=0">
          <tr>
           <td colspan="4">
            <xsl:attribute name="class"><xsl:value-of select="TblActTdLst"/></xsl:attribute> 
            <xsl:text>_No cards found. Verify or review your search criteria.</xsl:text>
           </td>
           </tr>
           <xsl:call-template name="to-cc-bcc">
             <xsl:with-param name="alreadyselected" select="/xslui/iab/alreadyselected"/>
           </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
           <tr>
           <td colspan="4">
            <xsl:attribute name="class"><xsl:value-of select="TblActTdLst"/></xsl:attribute> 
            <xsl:text>_This table contains no cards. Use Search to view cards.</xsl:text>
           </td>
           </tr>
          </xsl:otherwise>
        </xsl:choose>      
        </table>
        </div>
       </td>      
       <td><img src="{$spacer.gif}" width="10" height="1" alt=""/></td>
      </tr>
      </table>      
      </form>
    </body>
  </html>
</xsl:template>


<!--
*******************************************************************************
* This template displays the check mark for the already selected items in the list
*******************************************************************************
-->
<xsl:template name="displaySelect">
  <xsl:choose>
    <xsl:when test="name()!='group' and string-length(./email[@priority='1'])&lt;=0">
      <td colspan="3">&nbsp;</td>
    </xsl:when>
    <xsl:otherwise>
      <td align="center">
        <xsl:choose>
          <xsl:when test="/xslui/iab/alreadyselected[@fieldname='to']/*/entry[@selectedfromui='1']/@entryID = current()/entry/@entryID">
            <img src="{$checkmark_skinny.gif}" width="16" height="16">
              <xsl:attribute name="alt">
                <xsl:text>_Already Selected</xsl:text>
              </xsl:attribute>
            </img>
          </xsl:when>
          <xsl:otherwise>
            <script language="javascript">
              writeSelect("<xsl:call-template name="escape"><xsl:with-param name="text" select="./entry/@entryID"/></xsl:call-template>",'<xsl:value-of select="./email[@priority='1']"/>','to');
            </script>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td align="center">
        <xsl:choose>
          <xsl:when test="/xslui/iab/alreadyselected[@fieldname='cc']/*/entry[@selectedfromui='1']/@entryID = current()/entry/@entryID">
            <img src="{$checkmark_skinny.gif}" width="16" height="16">
              <xsl:attribute name="alt">
                <xsl:text>_Already Selected</xsl:text>
              </xsl:attribute>
            </img>
          </xsl:when>
          <xsl:otherwise>
            <script language="javascript">
              writeSelect("<xsl:call-template name="escape"><xsl:with-param name="text" select="./entry/@entryID"/></xsl:call-template>",'<xsl:value-of select="./email[@priority='1']"/>','cc');
            </script>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td align="center">
        <xsl:choose>
          <xsl:when test="/xslui/iab/alreadyselected[@fieldname='bcc']/*/entry[@selectedfromui='1']/@entryID = current()/entry/@entryID">
            <img src="{$checkmark_skinny.gif}" width="16" height="16">
              <xsl:attribute name="alt">
                <xsl:text>_Already Selected</xsl:text>
              </xsl:attribute>
            </img>
          </xsl:when>
          <xsl:otherwise>
            <script language="javascript">
              writeSelect("<xsl:call-template name="escape"><xsl:with-param name="text" select="./entry/@entryID"/></xsl:call-template>",'<xsl:value-of select="./email[@priority='1']"/>','bcc');
            </script>
          </xsl:otherwise>
        </xsl:choose>
      </td>
    </xsl:otherwise>
  </xsl:choose> 
</xsl:template>

<!--
*******************************************************************************
* Print the already selected elements
*******************************************************************************
-->
<xsl:template name="to-cc-bcc">
<xsl:param name="alreadyselected"/>
<xsl:if test="boolean($alreadyselected/child::node())">
<tr> 
    <td class="TblActTdLst" colspan="5">
    <span class="Lbl4">
     <xsl:text>_Selected Cards</xsl:text></span>&nbsp;
     <input class="Btn1Mni" type="button" name="deselect" id="deselect" onMouseOver="if (this.disabled==0) this.className='Btn1MniHov'" onFocus="if (this.disabled==0) this.className='Btn1MniHov'" onMouseOut="if (this.disabled==0) this.className='Btn1Mni'" onBlur="if (this.disabled==0) this.className='Btn1Mni'" onClick="javascript:checkAll(document.iabform.to,false);checkAll(document.iabform.cc,false);checkAll(document.iabform.bcc,false);return false;">       
    <xsl:attribute name="value"><xsl:text>_Deselect Cards</xsl:text></xsl:attribute>
    <xsl:attribute name="title"><xsl:text>_Deselect Cards</xsl:text></xsl:attribute>
    </input>
    </td>           
</tr>  
<xsl:for-each select="$alreadyselected/child::node()"> 
<xsl:variable name="fieldname" select="string(parent::node()/@fieldname)"/>  
  <xsl:if test="./entry/@selectedfromui=1">
    <tr>                   
     <td class="TblTdCl1"> 
       <input type="checkbox" value="{./entry/@entryID}">
          <xsl:attribute name="name">
            <xsl:value-of select="'to'"/>
          </xsl:attribute>           
          <xsl:if test="boolean('to'=$fieldname)">            
            <xsl:attribute name="checked"/>
          </xsl:if>
        </input>
     </td>
     <td class="TblTdCl1"> 
       <input type="checkbox" value="{./entry/@entryID}">
          <xsl:attribute name="name">
            <xsl:value-of select="'cc'"/>
          </xsl:attribute>           
          <xsl:if test="boolean('cc'=$fieldname)">
            <xsl:attribute name="checked"/>
          </xsl:if>
        </input>
     </td>
     <td class="TblTdCl1"> 
       <input type="checkbox" value="{./entry/@entryID}">
          <xsl:attribute name="name">
            <xsl:value-of select="'bcc'"/>
          </xsl:attribute>           
          <xsl:if test="boolean('bcc'=$fieldname)">
            <xsl:attribute name="checked"/>
          </xsl:if>
        </input>
     </td>
     <td class="TblTdSrt">
      <xsl:value-of select="entry/displayname"/>
      <xsl:text>&nbsp;</xsl:text>
    </td>    
    <td>
       <xsl:attribute name="nowrap"/>       
       <xsl:if test="email[@priority='1']">         
          <xsl:value-of select="email[@priority='1']"/>         
       </xsl:if> 
     </td>
     <xsl:apply-templates mode="hidden" select="."/> 
   </tr>      
   </xsl:if>               
</xsl:for-each> 
</xsl:if>
</xsl:template> 



<!--
*******************************************************************************
* This prints the error messages on the search page
* @param err The error element from which to extract the error code
*******************************************************************************
-->
<xsl:template name="error-message">
  <xsl:param name="err" select="." />

  <xsl:choose>
  <xsl:when test="$err/@errnum = '7'">            
      <script> printLocalizedLabel('<xsl:text>_Min Char Warning</xsl:text>', new Array('<xsl:value-of select="/xslui/iab/booklist/book[entry/@entryID = $err/@bookid]/@wildcardsearch"/>'));</script>      
  </xsl:when>
    <xsl:when test="$err/@errnum = '286'">
      <xsl:text>_Timeout exceeded</xsl:text>
      <xsl:text>&nbsp;</xsl:text>
    </xsl:when>
    <xsl:when test="$err/@errnum = '512'">
      <xsl:choose>
      <xsl:when test="/xslui/iab/booklist/book[entry/@entryID = /xslui/iab/pagedsearch/searchresult/@bookid]/@subscribed">
         <xsl:text>_Search not allowed</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:text>_Search Limit Exceeded</xsl:text>
      </xsl:otherwise>
      </xsl:choose>
    </xsl:when>
  <xsl:otherwise>
     <xsl:text>_Unknown error (</xsl:text>
     <xsl:value-of select="$err/@errnum" /> 
     <xsl:text>)</xsl:text>
     <xsl:if test="$err/@rawmsg">
       <br/>
       <xsl:value-of select="$err/@rawmsg" />&nbsp;
     </xsl:if> 
  </xsl:otherwise>
  </xsl:choose>
</xsl:template> 
</xsl:stylesheet>
