<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>

<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:output method="html" version="4" encoding="UTF-8"/>

<xsl:include href="banner.xsl"/>
<xsl:include href="commonimages.xsl"/>
<xsl:include href="viewcontact-images.xsl"/>
<xsl:include href="common-uielements.xsl"/>
<xsl:include href="commonjavascript.xsl"/>
<xsl:include href="commonattributes-hidden.xsl"/>
<xsl:include href="common-editcontact.xsl"/>
<xsl:include href="errors.xsl"/>
<xsl:include href="css-select.xsl"/>

<!--
*******************************************************************************
* Core of the template stylesheet addcontact.xsl
*******************************************************************************
-->
<xsl:template match="/">
  <xsl:variable name="curBookID">
    <xsl:choose>
      <xsl:when test="/xslui/iab/bookentry/abperson">
        <xsl:choose>
          <xsl:when test="/xslui/iab/entrycontext/book">
            <xsl:value-of select="/xslui/iab/entrycontext/book/entry/@entryID" /> 
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="/xslui/iab/booklist/book[string-length(@bookurl)>0][1]/entry/@entryID" /> 
          </xsl:otherwise>
        </xsl:choose> 
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="/xslui/iab/pagedsearch/searchresult/@bookid" /> 
      </xsl:otherwise>
    </xsl:choose> 
  </xsl:variable> 
  
  <html lang="en">
    <head>
      <title>
        <xsl:text>_New Contact</xsl:text>
      </title>
      <script language="javascript" src="../absjs/common.js"/>
      <script language="javascript" src="../absjs/integration.js"/>       
                
      <script src="../absjs/scripts.js"></script>
      <script src="../absjs/browserVersion.js"></script>
      <script>
 	  window.focus();      
          if (is_ie5up) // IE5
          {    
           document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ie5win.css"&gt;');
          }
          else if (is_gecko) // Netscape 6/7 or Mozilla
          {
            document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
          }
          else  // All others
          {
           document.write('&lt;link type="text/css" rel="stylesheet" href="../absimx/ab_css_ns6up.css"&gt;');
          }
      </script>
      
      <script language="javascript" src="../absjs/contact.js"/>
      <script language="javascript" src="../absjs/dates.js"/>
      <script language="javascript">
        <xsl:call-template name="autoFillDisplayName"/>
        <xsl:call-template name="commonjavascript"/>
        <xsl:call-template name="bannerScripts"/>
        <xsl:call-template name="i18n-dates"/>
        function save(addAnother) {        
          if((document.iabform["<xsl:value-of select="$fieldPrefix"/>displayName"].value).trim()=="")
          {
           alert("<xsl:text>_Display name cannot be blank or only whitespaces</xsl:text>");
           return false;
          }
          if(checkDates()) {
            alert("<xsl:text>_One or more of the dates entered is incomplete. Please correct it.</xsl:text>");
            return false;
          }
       
          if(false == areEmailsValid()){
            alert("<xsl:text>_invalidEmails</xsl:text>");
            return false;
          }
                  
          <!-- Compulsary for the add to personnal address book feature -->
          document.iabform.bookid.value = (document.iabform.localBooks != null)?getSelectValue(document.iabform.localBooks)
                                                                               :'<xsl:value-of select='$curBookID'/>'; 
          
          addContact(false, addAnother);          
        }

        function cancel() {                    
          parent.opener.focus();
          parent.close();
        }
        
        function initPage() {
          var errornum = '<xsl:value-of select="/xslui/errormessages/error/@errnum"/>';
          var uiaction = '<xsl:value-of select="/xslui/@uiaction"/>';

          if( errornum != null &#38;&#38;  errornum != '' &#38;&#38;  errornum == '3' ) {
            var reloadWin = parent.opener.parent;
            var parentOpener = parent.opener;
            
            if( !reloadWin )
              reloadWin = parent.opener;
                        
            var parentLoc = parentOpener.location.href;
            var i= parentLoc.indexOf("?");
            if( i > -1 )
              parentLoc = parentLoc.substring(0, i);
            parentOpener.location.href = parentLoc + "?bookid=" + document.iabform.bookid.value + "&amp;stopsearch=1";
            //if( parentLoc.indexOf("stopsearch") > -1 )
            //  parentOpener.location.href = parentLoc;
            //else 
            //  parentOpener.location.href = parentLoc + (parentLoc.indexOf("?") &gt; 0?"&amp;":"?") + "stopsearch=1";
            //
 	    if(uiaction != 'savecontactandaddanother') {
	        reloadWin.focus();
		parent.close();
	    }
          } else {
            document.iabform.<xsl:value-of select="$fieldPrefix"/>givenName.focus();
          }
        }

        function help() {
          var helpurl = '<xsl:value-of select="/xslui/@contexturi"/>/help/<xsl:text>_languagepath</xsl:text>/addressbk/ncontact.html';
          openhelp(helpurl);
        }

      </script>
    </head>
    <body leftmargin="0" topmargin="0" rightmargin="0" marginwidth="0" marginheight="0">
      <xsl:attribute name="onload">
        javascript:initPage();        
      </xsl:attribute>

      <form method="post" name="iabform" action="addcontact.xml">

  <table cellspacing="0" cellpadding="0" width="100%" border="0" bgcolor="#CCCCFF">
    <tr>
      <td class="SkpMst"><a href="#nameandcompany">
      <img src="{$spacer.gif}" height="1" width="1" border="0"> 
      <xsl:attribute name="alt">
        <xsl:text>_skipToNameCompany</xsl:text>
      </xsl:attribute>
      </img></a></td>
    <td class="SkpMst"><a href="#phone">
    <img src="{$spacer.gif}" height="1" width="1" border="0">
      <xsl:attribute name="alt">
        <xsl:text>_skipToPhone</xsl:text>
      </xsl:attribute>
    </img></a></td>
    <td class="SkpMst"><a href="#email">
    <img src="{$spacer.gif}" height="1" width="1" border="0">
      <xsl:attribute name="alt">
        <xsl:text>_skipToEmail</xsl:text>
      </xsl:attribute>
    </img></a></td>
    <td class="SkpMst"><a href="#addresses">
    <img src="{$spacer.gif}" height="1" width="1" border="0">
      <xsl:attribute name="alt">
        <xsl:text>_skipToAddress</xsl:text>
      </xsl:attribute>
    </img></a></td>
    <td class="SkpMst"><a href="#online">
    <img src="{$spacer.gif}" height="1" width="1" border="0">
      <xsl:attribute name="alt">
        <xsl:text>_skipToOnline</xsl:text>
      </xsl:attribute>
    </img></a></td>
    <td class="SkpMst"><a href="#dates">
    <img src="{$spacer.gif}" height="1" width="1" border="0">
      <xsl:attribute name="alt">
        <xsl:text>_skipToDates</xsl:text>
      </xsl:attribute>
    </img></a></td>
    <td class="SkpMst"><a href="#notes">
    <img src="{$spacer.gif}" height="1" width="1" border="0">
      <xsl:attribute name="alt">
        <xsl:text>_skipToNotes</xsl:text>
      </xsl:attribute>
    </img></a></td>
  </tr>
</table>


        <input type="hidden" name="j_encoding" value="{/xslui/@charset}"/>
        <input type="hidden" name="uiaction" value=""/>
        <input type="hidden" name="entryid" value=""/>
        <input type="hidden" name="stopsearch" value=""/>
        <input type="hidden" name="stopalreadyselected" value=""/>  
        <input type="hidden" name="prefix" value="{$fieldPrefix}"/>
        <input type="hidden" name="{$fieldPrefix}entrytype" value="abperson"/>
        <xsl:call-template name="contextKeeper">
          <xsl:with-param name="pagedSearch" select="/xslui/iab/pagedsearch"/>
        </xsl:call-template>     
       <a name="top"></a> 
       <table width="100%" border="0" cellspacing="0" cellpadding="0" summary="This table contains a form to add a contact">
        <tr> 
          <td class="PopupTitle" width="100%" colspan="5"><span class="PopupTitleText"><xsl:text>_New Contact</xsl:text></span></td>
        </tr>
        <tr> 
          <td align="right" colspan="5"><img alt="required field" src="../absimx/required.gif" width="7" height="14"/> 
            <xsl:text>_indicates a required field</xsl:text><img alt="" src="{$spacer.gif}" width="10" height="15"/></td>
        </tr>
        </table>

   <xsl:variable name="error" select="/xslui/errormessages/error"/>
   <xsl:variable name="showError">
     <xsl:choose>
     <xsl:when test="/xslui/@uiaction != 'saveandaddanother' and $error/@errnum = '3'">
       <xsl:value-of select="false()"/>
     </xsl:when>
     <xsl:otherwise>
       <xsl:value-of select="true()"/>
     </xsl:otherwise>
     </xsl:choose>
   </xsl:variable>

	<xsl:apply-templates select="$error" mode="plain">
          <xsl:with-param name="type">
             <xsl:choose>
                <xsl:when test="$error/@errnum=6 or $error/@errnum=10 or $error/@errnum=2 or $error/@errnum=3 or $error/@errnum=9">
                   <xsl:value-of select="'information'"/>
                </xsl:when>
                <xsl:when test="$error/@errnum=7">
                   <xsl:value-of select="'warning'"/>
                </xsl:when>
                <xsl:otherwise>
                   <xsl:value-of select="'error'"/>
                </xsl:otherwise>
             </xsl:choose>
          </xsl:with-param>
        </xsl:apply-templates>

        <table width="100%" border="0" cellspacing="0" cellpadding="0" summary="This table contains a form to add a contact">
        <tr> 
          <td colspan="5"> 
            <div class="ConJmpScnDiv"> 
	
            <xsl:variable name="errornum" select="/xslui/errormessages/error/@errnum"/>
            <xsl:variable name="uiaction" select="/xslui/@uiaction"/>
		
              <table border="0" cellspacing="0" cellpadding="0" summary="This table contains jump links">
    
                <tbody> 
                <tr> 
                  <td valign="top"> 
                    <div class="ConJmpLnkDiv"><a href="#nameandcompany" class="JmpLnk" tabindex="1">
                   <xsl:attribute name="title">
                     <xsl:text>_Jump Down to the Name and Company Section</xsl:text>
                   </xsl:attribute>
                   <img src="../absimx//LrlToAnchor_1.gif" alt="Jump Down to the Online Section" width="16" height="10" border="0"/>
                   <xsl:text>_Name and Company</xsl:text></a></div>
                  </td>
                  <td valign="top"> 
                    <div class="ConJmpLnkDiv"><a href="#phone" class="JmpLnk" tabindex="2">
                    <xsl:attribute name="title">
                     <xsl:text>_Jump Down to the Phone Section</xsl:text>
                    </xsl:attribute>
                    <img src="../absimx/LrlToAnchor_1.gif" alt="Jump Down to the Phone Section" width="16" height="10" border="0"/>
                    <xsl:text>_Phone</xsl:text></a></div>
                  </td>
                  <td valign="top"> 
                    <div class="ConJmpLnkDiv"><a href="#email" class="JmpLnk" tabindex="3">
                    <xsl:attribute name="title">
                     <xsl:text>_Jump Down to the Email Section</xsl:text>
                    </xsl:attribute>
                    <img src="../absimx/LrlToAnchor_1.gif" alt="Jump Down to the Email Section" width="16" height="10" border="0"/>
                    <xsl:text>_Email</xsl:text></a></div>    
                  </td>
                  <td valign="top"> 
                    <div class="ConJmpLnkDiv"><a href="#addresses" class="JmpLnk" tabindex="4">
                    <xsl:attribute name="title">
                     <xsl:text>_Jump Down to the Addresses Section</xsl:text>
                    </xsl:attribute><img src="../absimx/LrlToAnchor_1.gif" alt="Jump Down to the Addresses Section" width="16" height="10" border="0"/>
                    <xsl:text>_Addresses</xsl:text></a></div>
                  </td>
                </tr>
                <tr> 
                  <td valign="top"> 
                    <div class="ConJmpLnkDiv"><a href="#online" class="JmpLnk" tabindex="5">
                    <xsl:attribute name="title">
                     <xsl:text>_Jump Down to the Addresses Section</xsl:text>
                    </xsl:attribute>
                    <img src="../absimx/LrlToAnchor_1.gif" alt="Jump Down to the Online Section" width="16" height="10" border="0"/>
                    <xsl:text>_Online</xsl:text></a></div>
                  </td>
    
                  <td valign="top"> 
                    <div class="ConJmpLnkDiv"><a href="#dates" class="JmpLnk" tabindex="6">
                    <xsl:attribute name="title">
                     <xsl:text>_Jump Down to the dates Section</xsl:text>
                    </xsl:attribute>
                    <img src="../absimx/LrlToAnchor_1.gif" alt="Jump Down to the Dates Section" width="16" height="10" border="0"/>
                    <xsl:text>_Dates</xsl:text></a></div>
                  </td>
                  <td valign="top"> 
                    <div class="ConJmpLnkDiv"><a href="#notes" class="JmpLnk" tabindex="7">
                    <xsl:attribute name="title">
                     <xsl:text>_Jump Down to the notes Section</xsl:text>
                    </xsl:attribute>
                    <img src="../absimx/LrlToAnchor_1.gif" alt="Jump Down to the Notes Section" width="16" height="10" border="0"/>
                    <xsl:text>_Notes</xsl:text></a></div>
                  </td>
                  <td valign="top">&nbsp;</td>
                </tr>
                </tbody> 
              </table>
    
            </div>
          </td>
          <a name="nameandcompany"></a> 
        </tr>
        <tr> 
         <td colspan="5"> 
            <table width="100%" border="0" cellspacing="0" cellpadding="0">
              <tr> 
                <td width="1%"><img alt="" src="{$spacer.gif}" width="10" height="5"/></td>
                <td width="98%" class="SectionDivider"><img alt="" src="{$spacer.gif}" width="1" height="5"/></td>
                <td width="1%"><img alt="" src="{$spacer.gif}" width="10" height="5"/></td>
    
              </tr>
            </table>
          </td>
       </tr>
       <tr> 
          <td class="SectionHeader" colspan="5"><span class="SectionHeader"><xsl:text>_Name and Company</xsl:text></span></td>
       </tr>                 
      </table>       

      <xsl:call-template name="edit-abperson">
            <xsl:with-param name="abperson" select="/xslui/iab/bookentry/abperson"/>
            <xsl:with-param name="curBookID" select="$curBookID"/>
      </xsl:call-template>         
       
        <!-- These calls keeps the already selected context -->
        <xsl:for-each select="/xslui/iab/alreadyselected/*">
          <input type="hidden" name="selectedentry" value="{entry/@entryID}"/>
        </xsl:for-each>
        <xsl:apply-templates select="/xslui/iab/alreadyselected" mode="hidden"/>
      </form>
    </body>
  </html>
</xsl:template>

<!--
*******************************************************************************
* Match the node abperson and print the HTML Form
*******************************************************************************
-->
<xsl:template name="edit-abperson">
  <xsl:param name="abperson" select="''" />
  <xsl:param name="curBookID" select="''" />

  <table width="100&#37;" cellspacing="0" cellpadding="0" border="0">
    <tbody>
      <xsl:call-template name="nameAndCompany">
        <xsl:with-param name="autoFillDisplayName" select="true()"/>
        <xsl:with-param name="abperson" select="$abperson"/>
      </xsl:call-template>
      
      <xsl:if test="$curBookID and string-length($curBookID)&#62;0">
        <script language="javascript">
          autoFillDisplayName();
        </script>
      </xsl:if> 
      
      <xsl:call-template name="phoneEmailAndIM">
        <xsl:with-param name="abperson" select="$abperson"/>
      </xsl:call-template>

      <xsl:call-template name="address">              
        <xsl:with-param name="abperson" select="$abperson"/>
      </xsl:call-template>

      <xsl:call-template name="onlineInfos">
        <xsl:with-param name="abperson" select="$abperson"/>
      </xsl:call-template>

      <xsl:call-template name="importantDates">
        <xsl:with-param name="dateFormat" select="/xslui/profileinfo/xmlprofile/generalprefs/@dateorder"/>
        <xsl:with-param name="abperson" select="$abperson"/>
      </xsl:call-template>

      <xsl:call-template name="notes">
        <xsl:with-param name="abperson" select="$abperson"/>
      </xsl:call-template>      
    </tbody>
  </table>
</xsl:template> 

<xsl:template match="error" mode="new-contact">  
   <xsl:apply-templates select="." mode="plain"/>    
</xsl:template> 

</xsl:stylesheet>
