<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [<!ENTITY nbsp "&#160;">]>
<!--
*******************************************************************************
* This template formats an exports an address book in a csv format.
*******************************************************************************
-->
<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:include href="common-export.xsl"/>

<xsl:output method="text" encoding="UTF-8" omit-xml-declaration="yes"/>

 <!--
 * For each contact, outputs the value in a coma separated way. All values are included between 
 * double quotes : "value1","value2",.... If a value is null or empty the result will be 
 * empty quotes : "value1","","value3"
 -->
<xsl:template name="data-export-csv">
  <xsl:for-each select="/searchresult/abperson">
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="entry/displayname">
     <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="entry/displayname"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="person/givenname">
     <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/givenname"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="person/middlename">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/middlename"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>  
    <xsl:if test="person/surname">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/surname"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>  
     <xsl:if test="person/nickname">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/nickname"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="organization/company">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="organization/company"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>  
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="organization/organizationalunit">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="organization/organizationalunit"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>  
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>  
    <xsl:if test="organization/title">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="organization/title"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='work']/street">  
        <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='work']/street"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='work']/city">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='work']/city"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='work']/state">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='work']/state"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='work']/postalcode">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='work']/postalcode"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='work']/country">  
     <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='work']/country"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='home']/street">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='home']/street"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='home']/city">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='home']/city"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='home']/state">  
       <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='home']/state"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='home']/postalcode">  
       <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='home']/postalcode"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="postaladdress[@type='home']/country">  
       <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='home']/country"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="phone[@type='fax']">
       <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@type='fax']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="phone[@type='work']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@type='work']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="phone[@type='home']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@type='home']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="phone[@type='mobile']">
     <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@type='mobile']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>  
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>  
    <xsl:if test="phone[@type='pager']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@type='pager']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text> 
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>  
    <xsl:if test="person/date[@type='anniversary']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/date[@type='anniversary']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>    
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="person/date[@type='birthday']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/date[@type='birthday']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>    
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="email[@priority='1']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="email[@priority='1']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>    
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="email[@priority='2']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="email[@priority='2']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>    
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="email[@priority='3']">
     <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="email[@priority='3']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>    
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>  
    <xsl:if test="entry/description">    
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="entry/description"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
      </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>  
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="organization/location/office">
       <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="organization/location/office"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="weburl[@priority='1']/urladdr">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="weburl[@priority='1']/urladdr"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="weburl[@priority='2']/urladdr">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="weburl[@priority='2']/urladdr"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="im[@priority='1']">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="im[@priority='1']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="im[@priority='2']">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="im[@priority='2']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="calendar[@type='calendar']">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="calendar[@type='calendar']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>,</xsl:text>
    <xsl:text>&quot;</xsl:text>
    <xsl:if test="calendar[@type='freebusy']">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="calendar[@type='freebusy']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>&quot;</xsl:text>
    <xsl:text>&#xA;</xsl:text>
  </xsl:for-each>
</xsl:template>

<xsl:template name="data-export-csv-th">
  <xsl:for-each select="/searchresult/abperson">     
    <xsl:if test="entry/displayname">
     <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="entry/displayname"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:value-of select="$replaced_text"/>
    </xsl:if> 
    <xsl:text>,</xsl:text>
    <xsl:if test="person/givenname">
     <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/givenname"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:if test="person/surname">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/surname"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>  
    <xsl:text>,</xsl:text>    
     <xsl:if test="person/nickname">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/nickname"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
     <xsl:if test="email[@priority='1']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="email[@priority='1']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>     
    <xsl:text>,</xsl:text>  
    <xsl:if test="email[@priority='2']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="email[@priority='2']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if> 
    <xsl:text>,</xsl:text>    
    <xsl:if test="phone[@type='work']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@type='work']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if> 
    <xsl:text>,</xsl:text>    
    <xsl:if test="phone[@type='home']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@type='home']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>   
    <xsl:if test="phone[@type='fax']">
       <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@type='fax']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:if test="phone[@type='pager']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@type='pager']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>  
    <xsl:if test="phone[@type='mobile']">
     <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="phone[@type='mobile']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>  
    <xsl:if test="postaladdress[@type='home']/street">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='home']/street"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
     <xsl:if test="postaladdress[@type='home']/street2">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='home']/street2"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:if test="postaladdress[@type='home']/city">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='home']/city"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:if test="postaladdress[@type='home']/state">  
       <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='home']/state"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:if test="postaladdress[@type='home']/postalcode">  
       <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='home']/postalcode"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:if test="postaladdress[@type='home']/country">  
       <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='home']/country"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:if test="postaladdress[@type='work']/street">  
        <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='work']/street"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:if test="postaladdress[@type='work']/street2">  
        <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='work']/street2"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:if test="postaladdress[@type='work']/city">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='work']/city"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:if test="postaladdress[@type='work']/state">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='work']/state"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:if test="postaladdress[@type='work']/postalcode">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='work']/postalcode"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:if test="postaladdress[@type='work']/country">  
     <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="postaladdress[@type='work']/country"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
     <xsl:if test="organization/title">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="organization/title"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
     <xsl:text>,</xsl:text>  
      <xsl:if test="organization/department">  
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="organization/department"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>  
    <xsl:text>,</xsl:text>  
    <xsl:if test="organization/company">  
    <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="organization/company"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>  
    <xsl:text>,</xsl:text>  
    <xsl:if test="weburl[@priority='1']/urladdr">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="weburl[@priority='1']/urladdr"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:if test="weburl[@priority='2']/urladdr">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="weburl[@priority='2']/urladdr"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:if test="person/date[@type='birthday1']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/date[@type='birthday1']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>    
    <xsl:text>,</xsl:text>   
     <xsl:if test="person/date[@type='birthday2']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/date[@type='birthday2']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>    
    <xsl:text>,</xsl:text>   
      <xsl:if test="person/date[@type='birthday']">
      <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="person/date[@type='birthday']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>    
    <xsl:text>,</xsl:text>   
    <xsl:if test="organization/location/office">
       <xsl:variable name="replaced_text">
        <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="organization/location/office"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>    
    <xsl:if test="im[@priority='1']">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="im[@priority='1']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:if test="im[@priority='2']">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="im[@priority='2']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>
    <xsl:if test="calendar[@type='calendar']">
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="calendar[@type='calendar']"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>
    <xsl:text>,</xsl:text>   
     <xsl:if test="entry/description">    
      <xsl:variable name="replaced_text">
      <xsl:call-template name="replace-string">
          <xsl:with-param name="text" select="entry/description"/>
          <xsl:with-param name="replace" select="'&#x22;'"/>
          <xsl:with-param name="with" select="'&#x22;&#x22;'"/>
      </xsl:call-template>
      </xsl:variable> 
      <xsl:value-of select="$replaced_text"/>
    </xsl:if>     
    <xsl:text>,</xsl:text> 
    <xsl:text>&#xA;</xsl:text>
  </xsl:for-each>
</xsl:template>
</xsl:stylesheet>
