/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.view;

import com.iplanet.jato.command.CommandDescriptor;
import com.iplanet.jato.command.CommandEvent;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.sql.SelectQueryModel;
import com.iplanet.jato.view.CommandField;
import com.iplanet.jato.view.CommandFieldDescriptor;
import com.iplanet.jato.view.CommandSourceTargetPair;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayField;
import com.iplanet.jato.view.DisplayFieldImpl;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class CommandFieldBase
extends DisplayFieldImpl
implements CommandField {
    private Map extraValues = null;

    public CommandFieldBase(ContainerView parent, String name, Object value) {
        super(parent, name, value);
    }

    public CommandFieldBase(ContainerView parent, String name, String boundName, Object value) {
        super(parent, name, boundName, value);
    }

    public CommandFieldBase(View parent, Model model, String name, Object value) {
        super(parent, model, name, value);
    }

    protected CommandFieldBase(View parent, Model model, String name, String boundName, CommandFieldDescriptor descriptor) {
        super(parent, model, name, boundName, null, descriptor);
    }

    public CommandFieldBase(View parent, Model model, String name, String boundName, Object value) {
        super(parent, model, name, boundName, value);
    }

    public CommandFieldBase(View parent, Model model, String name, String boundName, Object value, CommandFieldDescriptor descriptor) {
        super(parent, model, name, boundName, value, descriptor);
    }

    public CommandDescriptor getCommandDescriptor() {
        if (this.getDescriptor() != null && this.getDescriptor() instanceof CommandFieldDescriptor) {
            return this.getCommandFieldDescriptor().getCommandDescriptor();
        }
        return null;
    }

    public CommandFieldDescriptor getCommandFieldDescriptor() {
        return (CommandFieldDescriptor)this.getDescriptor();
    }

    public void beforeCommand(CommandEvent event) {
        this.mapSourceTargetValues();
    }

    public Map getExtraValuesMap() {
        if (this.extraValues == null) {
            this.extraValues = new HashMap();
        }
        return this.extraValues;
    }

    public void setExtraValuesMap(Map value) {
        this.extraValues = value;
    }

    public void addExtraValue(String name, String value) {
        this.getExtraValuesMap().put(name, value);
    }

    public void removeExtraValue(String name) {
        this.getExtraValuesMap().remove(name);
    }

    public void clearExtraValues() {
        this.getExtraValuesMap().clear();
    }

    public void mapSourceTargetNVPs() {
    }

    protected void mapSourceTargetValues() {
        if (this.getCommandFieldDescriptor() == null) {
            return;
        }
        HashMap<Class, Model> modelMap = new HashMap<Class, Model>();
        CommandSourceTargetPair[] pairs = this.getCommandFieldDescriptor().getSourceTargetPairs();
        int i = 0;
        while (i < pairs.length) {
            CommandSourceTargetPair nextPair = pairs[i];
            String[] targetPath = nextPair.getTargetPath();
            Object sourceValue = this.getSourceValue(nextPair, i);
            switch (nextPair.getTargetType()) {
                case 1: {
                    Class targetModelClass = nextPair.getTargetClass();
                    Model targetModel = null;
                    if (modelMap.containsKey(targetModelClass)) {
                        targetModel = (SelectQueryModel)modelMap.get(targetModelClass);
                    } else {
                        targetModel = (SelectQueryModel)this.getParentViewBean().getModel(targetModelClass);
                        targetModel.clearUserWhereCriteria();
                        modelMap.put(targetModelClass, targetModel);
                    }
                    targetModel.addUserWhereCriterion(nextPair.getTargetPath()[1], "=", sourceValue);
                    break;
                }
                case 3: {
                    ViewBean targetParentViewBean = this.getParentViewBean().getViewBean(nextPair.getTargetClass());
                    DisplayField child = this.getDisplayField(targetParentViewBean, targetPath);
                    child.setValue(sourceValue);
                    break;
                }
                case 2: {
                    Class targetModelClass = nextPair.getTargetClass();
                    Model targetModel = null;
                    if (modelMap.containsKey(targetModelClass)) {
                        targetModel = (Model)modelMap.get(targetModelClass);
                    } else {
                        targetModel = this.getParentViewBean().getModel(targetModelClass);
                        modelMap.put(targetModelClass, targetModel);
                    }
                    targetModel.setValue(nextPair.getTargetPath()[1], sourceValue);
                    break;
                }
                case 4: {
                    if (sourceValue == null) break;
                    ViewBean targetParentViewBean = this.getParentViewBean().getViewBean(nextPair.getTargetClass());
                    targetParentViewBean.setPageSessionAttribute(nextPair.getQualifiedTargetName(), (Serializable)sourceValue);
                    break;
                }
                case 5: {
                    if (sourceValue == null) break;
                    this.getParentViewBean().getSession().setAttribute(nextPair.getQualifiedTargetName(), sourceValue);
                    break;
                }
            }
            ++i;
        }
    }

    protected DisplayField getDisplayField(ContainerView rootView, String[] namePath) {
        ContainerView parentView = rootView;
        int j = 1;
        while (j < namePath.length - 1) {
            parentView = (ContainerView)parentView.getChild(namePath[j]);
            ++j;
        }
        View child = parentView.getChild(namePath[namePath.length - 1]);
        return (DisplayField)child;
    }

    protected abstract Object getSourceValue(CommandSourceTargetPair var1, int var2);
}

