/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.view;

import com.iplanet.jato.model.Model;
import com.iplanet.jato.view.BooleanDisplayField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.DisplayFieldDescriptor;
import com.iplanet.jato.view.DisplayFieldImpl;
import com.iplanet.jato.view.View;

public class BooleanDisplayFieldImpl
extends DisplayFieldImpl
implements BooleanDisplayField {
    private Object trueValue;
    private Object falseValue;

    public BooleanDisplayFieldImpl(ContainerView parent, String name, Object trueValue, Object falseValue, boolean initialState) {
        super(parent, parent.getDefaultModel(), name, name, null, null);
        this.setTrueValue(trueValue);
        this.setFalseValue(falseValue);
        if (initialState) {
            this.setValue(trueValue, false);
        } else {
            this.setValue(falseValue, false);
        }
    }

    public BooleanDisplayFieldImpl(View parent, Model model, String name, Object trueValue, Object falseValue, boolean initialState) {
        super(parent, model, name, name, null, null);
        this.setTrueValue(trueValue);
        this.setFalseValue(falseValue);
        if (initialState) {
            this.setValue(trueValue, false);
        } else {
            this.setValue(falseValue, false);
        }
    }

    public BooleanDisplayFieldImpl(ContainerView parent, Model model, String name, String boundName, Object trueValue, Object falseValue, boolean initialState, DisplayFieldDescriptor descriptor) {
        super(parent, model, name, boundName, null, descriptor);
        this.setTrueValue(trueValue);
        this.setFalseValue(falseValue);
        if (initialState) {
            this.setValue(trueValue, false);
        } else {
            this.setValue(falseValue, false);
        }
    }

    public Object getValue() {
        Object value = super.getValue();
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return this.getTrueValue();
            }
            return this.getFalseValue();
        }
        return value;
    }

    public void setValue(Object value) {
        this.setValue(value, true);
    }

    public void setValue(Object value, boolean overwrite) {
        if (value == null) {
            super.setValue(this.getFalseValue(), overwrite);
        } else if (value.equals(this.getTrueValue()) || value.equals(this.getFalseValue())) {
            super.setValue(value, overwrite);
        } else {
            throw new IllegalArgumentException("Attempt to set Field [" + this.getName() + "]" + " to a value [" + value + "]" + " which is not equal to the checked value [" + this.getTrueValue() + "]" + " or unchecked value [" + this.getFalseValue() + "]");
        }
    }

    public boolean booleanValue() {
        return this.getValue() != null && this.getValue().equals(this.getTrueValue());
    }

    public boolean getState() {
        return this.booleanValue();
    }

    public void setBooleanValue(boolean value) {
        super.setValue(value ? this.getTrueValue() : this.getFalseValue());
    }

    public Object getTrueValue() {
        return this.trueValue;
    }

    public Object getFalseValue() {
        return this.falseValue;
    }

    public void setTrueValue(Object value) {
        this.trueValue = value;
    }

    public void setFalseValue(Object value) {
        this.falseValue = value;
    }
}

