/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.util.validation;

import com.iplanet.jato.model.ValidationException;
import com.iplanet.jato.util.TypeConverter;
import com.iplanet.jato.util.validation.RuleBasedValidator;

public class RegexValidator
extends RuleBasedValidator {
    public boolean validate(Object value) {
        if (this.getValidationRule() == null) {
            throw new ValidationException("No validation rule has been set");
        }
        String stringValue = null;
        try {
            stringValue = TypeConverter.asString(value);
        }
        catch (Exception e) {
            throw new ValidationException("Could not check value against regular expression \"" + this.getValidationRule() + "\" (conversion to type java.lang.String failed)", e);
        }
        if (stringValue == null) {
            return true;
        }
        try {
            boolean result = stringValue.matches(this.getValidationRule());
            return result;
        }
        catch (Exception e) {
            throw new ValidationException("Could not check value against regular expression \"" + this.getValidationRule() + "\" (invalid regular expression)", e);
        }
    }
}

