/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.util;

import com.iplanet.jato.util.ApplicationObjectInputStream;
import com.iplanet.jato.util.ConvertibleType;
import com.iplanet.jato.util.TypeConversion;
import com.iplanet.jato.util.TypeConversionListener;
import com.iplanet.jato.util.WrapperRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class TypeConverter {
    private static final Map typeConversions = new HashMap();
    public static final String TYPE_UNKNOWN = "null";
    public static final String TYPE_OBJECT = "object";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_INT = "int";
    public static final String TYPE_INTEGER = "integer";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_BYTE = "byte";
    public static final String TYPE_CHAR = "char";
    public static final String TYPE_CHARACTER = "character";
    public static final String TYPE_BIG_DECIMAL = "bigdecimal";
    public static final String TYPE_SQL_DATE = "sqldate";
    public static final String TYPE_SQL_TIME = "sqltime";
    public static final String TYPE_SQL_TIMESTAMP = "sqltimestamp";
    public static final TypeConversion UNKNOWN_TYPE_CONVERSION;
    public static final TypeConversion OBJECT_TYPE_CONVERSION;
    public static final TypeConversion STRING_TYPE_CONVERSION;
    public static final TypeConversion INTEGER_TYPE_CONVERSION;
    public static final TypeConversion DOUBLE_TYPE_CONVERSION;
    public static final TypeConversion BOOLEAN_TYPE_CONVERSION;
    public static final TypeConversion LONG_TYPE_CONVERSION;
    public static final TypeConversion FLOAT_TYPE_CONVERSION;
    public static final TypeConversion SHORT_TYPE_CONVERSION;
    public static final TypeConversion BIG_DECIMAL_TYPE_CONVERSION;
    public static final TypeConversion BYTE_TYPE_CONVERSION;
    public static final TypeConversion CHARACTER_TYPE_CONVERSION;
    public static final TypeConversion SQL_DATE_TYPE_CONVERSION;
    public static final TypeConversion SQL_TIME_TYPE_CONVERSION;
    public static final TypeConversion SQL_TIMESTAMP_TYPE_CONVERSION;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$com$iplanet$jato$util$TypeConverter$TestSuperclass;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    private TypeConverter() {
    }

    public static Map getTypeConversions() {
        return typeConversions;
    }

    public static void registerTypeConversion(Object key, TypeConversion conversion) {
        typeConversions.put(key, conversion);
    }

    public static Object asType(Object typeKey, Object value) {
        if (value == null) {
            return null;
        }
        if (typeKey == null) {
            return value;
        }
        if (typeKey instanceof Class && (Class)typeKey != (class$java$lang$Object == null ? (class$java$lang$Object = TypeConverter.class$("java.lang.Object")) : class$java$lang$Object) && ((Class)typeKey).isInstance(value)) {
            return value;
        }
        TypeConversion conversion = null;
        conversion = value instanceof ConvertibleType ? ((ConvertibleType)value).getTypeConversion(typeKey) : (TypeConversion)typeConversions.get(typeKey);
        if (conversion != null) {
            if (value instanceof TypeConversionListener) {
                ((TypeConversionListener)value).beforeConversion(typeKey);
                return ((TypeConversionListener)value).afterConversion(typeKey, conversion.convertValue(value));
            }
            return conversion.convertValue(value);
        }
        throw new IllegalArgumentException("Could not find type conversion for type \"" + typeKey + "\" (value = \"" + value + "\"");
    }

    public static byte asByte(Object value) {
        return TypeConverter.asByte(value, (byte)0);
    }

    public static byte asByte(Object value, byte defaultValue) {
        value = TypeConverter.asType(class$java$lang$Byte == null ? (class$java$lang$Byte = TypeConverter.class$("java.lang.Byte")) : class$java$lang$Byte, value);
        if (value != null) {
            return (Byte)value;
        }
        return defaultValue;
    }

    public static short asShort(Object value) {
        return TypeConverter.asShort(value, (short)0);
    }

    public static short asShort(Object value, short defaultValue) {
        value = TypeConverter.asType(class$java$lang$Short == null ? (class$java$lang$Short = TypeConverter.class$("java.lang.Short")) : class$java$lang$Short, value);
        if (value != null) {
            return (Short)value;
        }
        return defaultValue;
    }

    public static int asInt(Object value) {
        return TypeConverter.asInt(value, 0);
    }

    public static int asInt(Object value, int defaultValue) {
        value = TypeConverter.asType(class$java$lang$Integer == null ? (class$java$lang$Integer = TypeConverter.class$("java.lang.Integer")) : class$java$lang$Integer, value);
        if (value != null) {
            return (Integer)value;
        }
        return defaultValue;
    }

    public static long asLong(Object value) {
        return TypeConverter.asLong(value, 0L);
    }

    public static long asLong(Object value, long defaultValue) {
        value = TypeConverter.asType(class$java$lang$Long == null ? (class$java$lang$Long = TypeConverter.class$("java.lang.Long")) : class$java$lang$Long, value);
        if (value != null) {
            return (Long)value;
        }
        return defaultValue;
    }

    public static float asFloat(Object value) {
        return TypeConverter.asFloat(value, 0.0f);
    }

    public static float asFloat(Object value, float defaultValue) {
        value = TypeConverter.asType(class$java$lang$Float == null ? (class$java$lang$Float = TypeConverter.class$("java.lang.Float")) : class$java$lang$Float, value);
        if (value != null) {
            return ((Float)value).floatValue();
        }
        return defaultValue;
    }

    public static double asDouble(Object value) {
        return TypeConverter.asDouble(value, 0.0);
    }

    public static double asDouble(Object value, double defaultValue) {
        value = TypeConverter.asType(class$java$lang$Double == null ? (class$java$lang$Double = TypeConverter.class$("java.lang.Double")) : class$java$lang$Double, value);
        if (value != null) {
            return (Double)value;
        }
        return defaultValue;
    }

    public static char asChar(Object value) {
        return TypeConverter.asChar(value, '\u0000');
    }

    public static char asChar(Object value, char defaultValue) {
        value = TypeConverter.asType(class$java$lang$Character == null ? (class$java$lang$Character = TypeConverter.class$("java.lang.Character")) : class$java$lang$Character, value);
        if (value != null) {
            return ((Character)value).charValue();
        }
        return defaultValue;
    }

    public static boolean asBoolean(Object value) {
        return TypeConverter.asBoolean(value, false);
    }

    public static boolean asBoolean(Object value, boolean defaultValue) {
        value = TypeConverter.asType(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean, value);
        if (value != null) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public static String asString(Object value) {
        return (String)TypeConverter.asType(class$java$lang$String == null ? (class$java$lang$String = TypeConverter.class$("java.lang.String")) : class$java$lang$String, value);
    }

    public static String asString(Object value, String defaultValue) {
        value = TypeConverter.asType(class$java$lang$String == null ? (class$java$lang$String = TypeConverter.class$("java.lang.String")) : class$java$lang$String, value);
        if (value != null) {
            return (String)value;
        }
        return defaultValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TYPE_UNKNOWN = TYPE_UNKNOWN;
        TYPE_OBJECT = TYPE_OBJECT;
        TYPE_STRING = TYPE_STRING;
        TYPE_INT = TYPE_INT;
        TYPE_INTEGER = TYPE_INTEGER;
        TYPE_LONG = TYPE_LONG;
        TYPE_FLOAT = TYPE_FLOAT;
        TYPE_DOUBLE = TYPE_DOUBLE;
        TYPE_SHORT = TYPE_SHORT;
        TYPE_BOOLEAN = TYPE_BOOLEAN;
        TYPE_BYTE = TYPE_BYTE;
        TYPE_CHAR = TYPE_CHAR;
        TYPE_CHARACTER = TYPE_CHARACTER;
        TYPE_BIG_DECIMAL = TYPE_BIG_DECIMAL;
        TYPE_SQL_DATE = TYPE_SQL_DATE;
        TYPE_SQL_TIME = TYPE_SQL_TIME;
        TYPE_SQL_TIMESTAMP = TYPE_SQL_TIMESTAMP;
        UNKNOWN_TYPE_CONVERSION = new UnknownTypeConversion();
        OBJECT_TYPE_CONVERSION = new ObjectTypeConversion();
        STRING_TYPE_CONVERSION = new StringTypeConversion();
        INTEGER_TYPE_CONVERSION = new IntegerTypeConversion();
        DOUBLE_TYPE_CONVERSION = new DoubleTypeConversion();
        BOOLEAN_TYPE_CONVERSION = new BooleanTypeConversion();
        LONG_TYPE_CONVERSION = new LongTypeConversion();
        FLOAT_TYPE_CONVERSION = new FloatTypeConversion();
        SHORT_TYPE_CONVERSION = new ShortTypeConversion();
        BIG_DECIMAL_TYPE_CONVERSION = new BigDecimalTypeConversion();
        BYTE_TYPE_CONVERSION = new ByteTypeConversion();
        CHARACTER_TYPE_CONVERSION = new CharacterTypeConversion();
        SQL_DATE_TYPE_CONVERSION = new SqlDateTypeConversion();
        SQL_TIME_TYPE_CONVERSION = new SqlTimeTypeConversion();
        SQL_TIMESTAMP_TYPE_CONVERSION = new SqlTimestampTypeConversion();
        TypeConverter.registerTypeConversion(class$java$lang$Object == null ? (class$java$lang$Object = TypeConverter.class$("java.lang.Object")) : class$java$lang$Object, OBJECT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(class$java$lang$String == null ? (class$java$lang$String = TypeConverter.class$("java.lang.String")) : class$java$lang$String, STRING_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(class$java$lang$Integer == null ? (class$java$lang$Integer = TypeConverter.class$("java.lang.Integer")) : class$java$lang$Integer, INTEGER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Integer.TYPE, INTEGER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(class$java$lang$Double == null ? (class$java$lang$Double = TypeConverter.class$("java.lang.Double")) : class$java$lang$Double, DOUBLE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Double.TYPE, DOUBLE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean, BOOLEAN_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Boolean.TYPE, BOOLEAN_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(class$java$lang$Long == null ? (class$java$lang$Long = TypeConverter.class$("java.lang.Long")) : class$java$lang$Long, LONG_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Long.TYPE, LONG_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(class$java$lang$Float == null ? (class$java$lang$Float = TypeConverter.class$("java.lang.Float")) : class$java$lang$Float, FLOAT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Float.TYPE, FLOAT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(class$java$lang$Short == null ? (class$java$lang$Short = TypeConverter.class$("java.lang.Short")) : class$java$lang$Short, SHORT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Short.TYPE, SHORT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TypeConverter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, BIG_DECIMAL_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(class$java$lang$Byte == null ? (class$java$lang$Byte = TypeConverter.class$("java.lang.Byte")) : class$java$lang$Byte, BYTE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Byte.TYPE, BYTE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(class$java$lang$Character == null ? (class$java$lang$Character = TypeConverter.class$("java.lang.Character")) : class$java$lang$Character, CHARACTER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Character.TYPE, CHARACTER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(class$java$sql$Date == null ? (class$java$sql$Date = TypeConverter.class$("java.sql.Date")) : class$java$sql$Date, SQL_DATE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(class$java$sql$Time == null ? (class$java$sql$Time = TypeConverter.class$("java.sql.Time")) : class$java$sql$Time, SQL_TIME_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = TypeConverter.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, SQL_TIMESTAMP_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion((class$java$lang$Object == null ? (class$java$lang$Object = TypeConverter.class$("java.lang.Object")) : class$java$lang$Object).getName(), OBJECT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion((class$java$lang$String == null ? (class$java$lang$String = TypeConverter.class$("java.lang.String")) : class$java$lang$String).getName(), STRING_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion((class$java$lang$Integer == null ? (class$java$lang$Integer = TypeConverter.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), INTEGER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion((class$java$lang$Double == null ? (class$java$lang$Double = TypeConverter.class$("java.lang.Double")) : class$java$lang$Double).getName(), DOUBLE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion((class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), BOOLEAN_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion((class$java$lang$Long == null ? (class$java$lang$Long = TypeConverter.class$("java.lang.Long")) : class$java$lang$Long).getName(), LONG_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion((class$java$lang$Float == null ? (class$java$lang$Float = TypeConverter.class$("java.lang.Float")) : class$java$lang$Float).getName(), FLOAT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion((class$java$lang$Short == null ? (class$java$lang$Short = TypeConverter.class$("java.lang.Short")) : class$java$lang$Short).getName(), SHORT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TypeConverter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName(), BIG_DECIMAL_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion((class$java$lang$Byte == null ? (class$java$lang$Byte = TypeConverter.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), BYTE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion((class$java$lang$Character == null ? (class$java$lang$Character = TypeConverter.class$("java.lang.Character")) : class$java$lang$Character).getName(), CHARACTER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion((class$java$sql$Date == null ? (class$java$sql$Date = TypeConverter.class$("java.sql.Date")) : class$java$sql$Date).getName(), SQL_DATE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion((class$java$sql$Time == null ? (class$java$sql$Time = TypeConverter.class$("java.sql.Time")) : class$java$sql$Time).getName(), SQL_TIME_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = TypeConverter.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getName(), SQL_TIMESTAMP_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_UNKNOWN, UNKNOWN_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_OBJECT, OBJECT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_STRING, STRING_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_INT, INTEGER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_INTEGER, INTEGER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_DOUBLE, DOUBLE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_BOOLEAN, BOOLEAN_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_LONG, LONG_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_FLOAT, FLOAT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_SHORT, SHORT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_BIG_DECIMAL, BIG_DECIMAL_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_BYTE, BYTE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_CHAR, CHARACTER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_CHARACTER, CHARACTER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_SQL_DATE, SQL_DATE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_SQL_TIME, SQL_TIME_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_SQL_TIMESTAMP, SQL_TIMESTAMP_TYPE_CONVERSION);
    }

    private static class Test
    extends TestSuperclass
    implements TypeConversionListener,
    ConvertibleType {
        private Test() {
        }

        public void beforeConversion(Object targetTypeKey) {
            System.out.println("--- beforeConversion(" + targetTypeKey + ")");
        }

        public Object afterConversion(Object targetTypeKey, Object convertedValue) {
            System.out.println("--- afterConversion(" + targetTypeKey + "," + convertedValue + ")");
            return convertedValue;
        }

        public TypeConversion getTypeConversion(Object targetTypeKey) {
            return new TypeConversion(this, targetTypeKey){
                Object key;
                private final /* synthetic */ Object val$targetTypeKey;
                private final /* synthetic */ Test this$0;
                {
                    this.this$0 = this$0;
                    this.key = this.val$targetTypeKey = val$targetTypeKey;
                }

                public Object convertValue(Object value) {
                    System.out.println("--- Converting value to type \"" + this.key + "\": " + value);
                    return "Converted Test value";
                }
            };
        }

        public static void main(String[] args) {
            if (!(TypeConverter.asString(new Integer(12)) instanceof String)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$Integer == null ? (class$java$lang$Integer = TypeConverter.class$("java.lang.Integer")) : class$java$lang$Integer, "12") instanceof Integer)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$Long == null ? (class$java$lang$Long = TypeConverter.class$("java.lang.Long")) : class$java$lang$Long, "12") instanceof Long)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$Float == null ? (class$java$lang$Float = TypeConverter.class$("java.lang.Float")) : class$java$lang$Float, "12.0") instanceof Float)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$Double == null ? (class$java$lang$Double = TypeConverter.class$("java.lang.Double")) : class$java$lang$Double, "12.0") instanceof Double)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$Short == null ? (class$java$lang$Short = TypeConverter.class$("java.lang.Short")) : class$java$lang$Short, "12") instanceof Short)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TypeConverter.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, "12") instanceof BigDecimal)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TypeConverter.class$("java.lang.Boolean")) : class$java$lang$Boolean, "true") instanceof Boolean)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$Byte == null ? (class$java$lang$Byte = TypeConverter.class$("java.lang.Byte")) : class$java$lang$Byte, "12") instanceof Byte)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$Character == null ? (class$java$lang$Character = TypeConverter.class$("java.lang.Character")) : class$java$lang$Character, "1") instanceof Character)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$java$lang$String == null ? (class$java$lang$String = TypeConverter.class$("java.lang.String")) : class$java$lang$String, new Test()) instanceof String)) {
                throw new Error();
            }
            if (!(TypeConverter.asType(class$com$iplanet$jato$util$TypeConverter$TestSuperclass == null ? (class$com$iplanet$jato$util$TypeConverter$TestSuperclass = TypeConverter.class$("com.iplanet.jato.util.TypeConverter$TestSuperclass")) : class$com$iplanet$jato$util$TypeConverter$TestSuperclass, new Test()) instanceof Test)) {
                throw new Error();
            }
            System.out.println("Test passed.");
        }
    }

    private static class TestSuperclass {
        private TestSuperclass() {
        }
    }

    public static class ObjectTypeConversion
    implements TypeConversion {
        /*
         * Loose catch block
         */
        public Object convertValue(Object value) {
            block17: {
                if (value == null) {
                    return null;
                }
                if (value.getClass().isArray() && value.getClass().getComponentType() == Byte.TYPE) {
                    ByteArrayInputStream bis = new ByteArrayInputStream((byte[])value);
                    ApplicationObjectInputStream ois = null;
                    ois = new ApplicationObjectInputStream(bis);
                    value = ois.readObject();
                    Object var6_4 = null;
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    try {
                        if (bis != null) {
                            bis.close();
                        }
                        break block17;
                    }
                    catch (IOException e) {}
                    break block17;
                    {
                        catch (Exception e) {
                            throw new WrapperRuntimeException("Could not deserialize object", e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_5 = null;
                        try {
                            if (ois != null) {
                                ois.close();
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        try {
                            if (bis != null) {
                                bis.close();
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            return value;
        }
    }

    public static class SqlTimestampTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Timestamp)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : Timestamp.valueOf(v);
            }
            return value;
        }
    }

    public static class SqlTimeTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Time)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : Time.valueOf(v);
            }
            return value;
        }
    }

    public static class SqlDateTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Date)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : Date.valueOf(v);
            }
            return value;
        }
    }

    public static class CharacterTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Character)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Character(v.charAt(0));
            }
            return value;
        }
    }

    public static class ByteTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Byte)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Byte(v);
            }
            return value;
        }
    }

    public static class BigDecimalTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof BigDecimal)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new BigDecimal(v);
            }
            return value;
        }
    }

    public static class ShortTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Short)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Short(v);
            }
            return value;
        }
    }

    public static class FloatTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Float)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Float(v);
            }
            return value;
        }
    }

    public static class LongTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Long)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Long(v);
            }
            return value;
        }
    }

    public static class BooleanTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Boolean)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Boolean(v);
            }
            return value;
        }
    }

    public static class DoubleTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Double)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Double(v);
            }
            return value;
        }
    }

    public static class IntegerTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Integer)) {
                String v = value.toString();
                value = v.trim().length() == 0 ? null : new Integer(v);
            }
            return value;
        }
    }

    public static class StringTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (value.getClass().isArray()) {
                if (value.getClass().getComponentType() == Byte.TYPE) {
                    value = new String((byte[])value);
                } else if (value.getClass().getComponentType() == Character.TYPE) {
                    value = new String((char[])value);
                }
            } else if (!(value instanceof String)) {
                value = value.toString();
            }
            return value;
        }
    }

    public static class UnknownTypeConversion
    implements TypeConversion {
        public Object convertValue(Object value) {
            return value;
        }
    }
}

