/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.util;

import java.lang.reflect.Method;

public class MethodSpec {
    private String nameSpec;
    private String namePrefix;
    private String nameSuffix;
    private Class returnType;
    private Class[] parameterTypes;

    public MethodSpec(String nameSpec, Class returnType, Class[] parameterTypes) {
        this.nameSpec = nameSpec;
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.parseNameSpec(nameSpec);
    }

    private void parseNameSpec(String spec) {
        int index = spec.indexOf("*");
        if (index != -1) {
            if (index == 0) {
                this.namePrefix = null;
                this.nameSuffix = spec.substring(index + 1);
            } else if (index == spec.length() - 1) {
                this.namePrefix = spec.substring(0, index);
                this.nameSuffix = null;
            } else {
                this.namePrefix = spec.substring(0, index);
                this.nameSuffix = spec.substring(index + 1);
            }
        } else {
            this.namePrefix = spec;
            this.nameSuffix = null;
        }
    }

    public boolean matches(Method method) {
        if (this.namePrefix != null && !method.getName().startsWith(this.namePrefix)) {
            return false;
        }
        if (this.nameSuffix != null && !method.getName().endsWith(this.nameSuffix)) {
            return false;
        }
        if (method.getReturnType() != this.getReturnType()) {
            return false;
        }
        if (method.getParameterTypes().length != this.getParameterTypes().length) {
            return false;
        }
        int i = 0;
        while (i < this.getParameterTypes().length) {
            if (method.getParameterTypes()[i] != this.getParameterTypes()[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getNameSpec() {
        return this.nameSpec;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }
}

