/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.util;

import com.iplanet.jato.Log;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.util.WrapperRuntimeException;
import java.lang.reflect.Array;
import javax.servlet.Servlet;

public class ClassUtil {
    public static final String ARRAY_SUFFIX = "[]";
    static /* synthetic */ Class class$java$lang$Void;

    public static String getClassName(Class cls) {
        if (cls == null) {
            return null;
        }
        String name = cls.getName();
        int dimensions = 0;
        while (name.charAt(dimensions) == '[') {
            ++dimensions;
        }
        if (dimensions > 0) {
            switch (name.charAt(dimensions)) {
                case 'B': {
                    name = "byte";
                    break;
                }
                case 'C': {
                    name = "char";
                    break;
                }
                case 'D': {
                    name = "double";
                    break;
                }
                case 'F': {
                    name = "float";
                    break;
                }
                case 'I': {
                    name = "int";
                    break;
                }
                case 'J': {
                    name = "long";
                    break;
                }
                case 'L': {
                    name = name.substring(dimensions + 1, name.length() - 1);
                    break;
                }
                case 'S': {
                    name = "short";
                    break;
                }
                case 'V': {
                    name = "void";
                    break;
                }
                case 'Z': {
                    name = "boolean";
                }
            }
            NonSyncStringBuffer buf = new NonSyncStringBuffer(name);
            int count = 0;
            while (count < dimensions) {
                buf.append(ARRAY_SUFFIX);
                ++count;
            }
            name = buf.toString();
        }
        return name;
    }

    public static Class getClass(String type) throws ClassNotFoundException {
        if (type == null) {
            return null;
        }
        int dimensions = 0;
        Class<Object> componentType = null;
        while (type.endsWith(ARRAY_SUFFIX)) {
            type = type.substring(0, type.length() - ARRAY_SUFFIX.length());
            ++dimensions;
        }
        if (type.length() <= 0) {
            return null;
        }
        switch (type.charAt(0)) {
            case 'b': {
                if (type.equals("boolean")) {
                    componentType = Boolean.TYPE;
                    break;
                }
                if (!type.equals("byte")) break;
                componentType = Byte.TYPE;
                break;
            }
            case 'c': {
                if (!type.equals("char")) break;
                componentType = Character.TYPE;
                break;
            }
            case 'd': {
                if (!type.equals("double")) break;
                componentType = Double.TYPE;
                break;
            }
            case 'f': {
                if (!type.equals("float")) break;
                componentType = Float.TYPE;
                break;
            }
            case 'l': {
                if (!type.equals("long")) break;
                componentType = Long.TYPE;
                break;
            }
            case 'i': {
                if (!type.equals("int")) break;
                componentType = Integer.TYPE;
                break;
            }
            case 's': {
                if (!type.equals("short")) break;
                componentType = Short.TYPE;
                break;
            }
            case 'v': {
                if (!type.equals("void")) break;
                componentType = Void.TYPE;
            }
        }
        if (componentType == null) {
            try {
                Servlet refObject = RequestManager.getHandlingServlet();
                componentType = refObject == null ? Class.forName(type) : Class.forName(type, true, refObject.getClass().getClassLoader());
            }
            catch (ClassNotFoundException ex) {
                if (Log.isLevelEnabled(32)) {
                    Log.log(32, "Could not load class \"" + type + "\" via Class.forName(); attempting to use " + "current thread's context class loader");
                }
                componentType = Thread.currentThread().getContextClassLoader().loadClass(type);
            }
        }
        if (dimensions == 0) {
            return componentType;
        }
        return ClassUtil.getArrayClass(componentType, dimensions);
    }

    public static Class getArrayClass(Class componentType, int dimensions) {
        if (componentType == null || dimensions < 0) {
            return null;
        }
        if (dimensions == 0) {
            return componentType;
        }
        return Array.newInstance(componentType, new int[dimensions]).getClass();
    }

    public static Object instantiate(Class type) throws InstantiationException {
        if (type.isArray()) {
            int numDimensions = 1;
            Class<?> componentType = type.getComponentType();
            while (componentType.isArray()) {
                componentType = componentType.getComponentType();
                ++numDimensions;
            }
            int[] dimensions = new int[numDimensions];
            int count = 0;
            while (count < numDimensions) {
                dimensions[count] = 0;
                ++count;
            }
            return Array.newInstance(componentType, dimensions);
        }
        if (type.isPrimitive()) {
            switch (type.getName().charAt(0)) {
                case 'b': {
                    if (type.equals(Boolean.TYPE)) {
                        return new Boolean(false);
                    }
                    return new Byte(-1);
                }
                case 'c': {
                    return new Character('\u0000');
                }
                case 'd': {
                    return new Double(-1.0);
                }
                case 'f': {
                    return new Float(-1.0f);
                }
                case 'i': {
                    return new Integer(-1);
                }
                case 'l': {
                    return new Long(-1L);
                }
                case 's': {
                    return new Short(-1);
                }
                case 'v': {
                    return null;
                }
            }
        }
        if (type.isInterface()) {
            throw new IllegalArgumentException("Cannot instantiate an interface: \"" + type.getName() + "\"");
        }
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new WrapperRuntimeException(ex);
        }
    }

    public static Object primitiveArrayToObjectArray(Object primitiveArr) {
        if (primitiveArr == null) {
            return null;
        }
        Class<?> primitiveArrClass = primitiveArr.getClass();
        if (!primitiveArrClass.isArray()) {
            return primitiveArr;
        }
        Class<?> type = primitiveArrClass.getComponentType();
        if (!type.isPrimitive()) {
            return primitiveArr;
        }
        Class objType = null;
        try {
            objType = ClassUtil.instantiate(type).getClass();
        }
        catch (Exception ex) {
            throw new WrapperRuntimeException(ex);
        }
        if (objType == null) {
            objType = class$java$lang$Void == null ? (class$java$lang$Void = ClassUtil.class$("java.lang.Void")) : class$java$lang$Void;
        }
        int length = Array.getLength(primitiveArr);
        Object[] newArr = (Object[])Array.newInstance(objType, length);
        int count = 0;
        while (count < length) {
            newArr[count] = Array.get(primitiveArr, count);
            ++count;
        }
        return newArr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ARRAY_SUFFIX = ARRAY_SUFFIX;
    }
}

