/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.taglib.tree;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.taglib.JspWrapperException;
import com.iplanet.jato.taglib.tree.TreeTagBase;
import com.iplanet.jato.util.TypeConverter;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;

public class TreeNodeLevelTag
extends TreeTagBase
implements BodyTag {
    private BodyContent bodyContent = null;
    private boolean displayed = false;
    private int currentIteration = 0;
    private int maxIterations = 0;

    public void reset() {
        super.reset();
        this.bodyContent = null;
        this.displayed = false;
        this.currentIteration = 0;
        this.maxIterations = 0;
    }

    public int doStartTag() throws JspException {
        this.reset();
        try {
            if (this.matchLevel()) {
                this.maxIterations = this.getParentTreeView().getNodeLevel() - this.getMinLevelInt() + this.getOffsetInt();
                this.displayed = true;
            } else {
                this.displayed = false;
            }
        }
        catch (ModelControlException e) {
            throw new JspWrapperException("Exception during doStartTag() for level tag: ", e);
        }
        if (this.displayed) {
            return 2;
        }
        return 0;
    }

    public void doInitBody() throws JspException {
    }

    public int doAfterBody() throws JspException {
        if (++this.currentIteration < this.maxIterations) {
            return 2;
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        if (this.displayed && this.maxIterations > 0 && this.getBodyContent() != null) {
            JspWriter out = this.pageContext.getOut();
            try {
                this.getBodyContent().writeOut((Writer)out);
            }
            catch (IOException e) {
                throw new JspWrapperException("Exception writing to result output stream", e);
            }
        }
        return 6;
    }

    protected boolean matchLevel() throws JspException, ModelControlException {
        boolean isMatch = false;
        int actualLevel = this.getParentTreeView().getNodeLevel();
        isMatch = this.matchMinLevel(actualLevel);
        if (isMatch) {
            isMatch = this.matchMaxLevel(actualLevel);
        }
        return isMatch;
    }

    protected boolean matchMinLevel(int actualLevel) throws JspException {
        boolean isMatch = true;
        if (this.getMinLevel() != null) {
            int matchValue = Integer.parseInt(this.getMinLevel());
            isMatch = actualLevel >= matchValue;
        }
        return isMatch;
    }

    protected boolean matchMaxLevel(int actualLevel) throws JspException {
        boolean isMatch = true;
        if (this.getMaxLevel() != null) {
            int matchValue = Integer.parseInt(this.getMaxLevel());
            isMatch = actualLevel <= matchValue;
        }
        return isMatch;
    }

    public BodyContent getBodyContent() {
        return this.bodyContent;
    }

    public void setBodyContent(BodyContent value) {
        this.bodyContent = value;
    }

    public String getMinLevel() {
        return (String)this.getValue("minLevel");
    }

    protected int getMinLevelInt() {
        return TypeConverter.asInt(this.getMinLevel(), 0);
    }

    public void setMinLevel(String value) {
        this.setValue("minLevel", value);
    }

    public String getMaxLevel() {
        return (String)this.getValue("maxLevel");
    }

    protected int getMaxLevelInt() {
        return TypeConverter.asInt(this.getMaxLevel(), 0);
    }

    public void setMaxLevel(String value) {
        this.setValue("maxLevel", value);
    }

    public String getOffset() {
        return (String)this.getValue("offset");
    }

    protected int getOffsetInt() {
        return TypeConverter.asInt(this.getOffset(), 0);
    }

    public void setOffset(String value) {
        this.setValue("offset", value);
    }
}

