/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.taglib.html;

import com.iplanet.jato.taglib.AbstractVisualTag;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.BasicChoiceDisplayField;
import com.iplanet.jato.view.Choice;
import com.iplanet.jato.view.ChoiceDisplayField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.html.HtmlDisplayField;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.SelectableGroup;
import java.util.Arrays;
import java.util.HashSet;
import javax.servlet.jsp.JspException;

public class RadioButtonsTag
extends AbstractVisualTag {
    protected void generateTagContent(NonSyncStringBuffer buffer) throws JspException {
        ContainerView parentContainer = this.getParentContainerView();
        View child = parentContainer.getChild(this.getName());
        if (child instanceof SelectableGroup) {
            this.doEndTagSelectableGroup((SelectableGroup)child, buffer);
        } else if (child instanceof ChoiceDisplayField) {
            this.doEndTagChoiceDisplayField((ChoiceDisplayField)child, buffer);
        } else {
            throw new JspException("Unknown child type: " + child);
        }
    }

    protected void doEndTagChoiceDisplayField(ChoiceDisplayField field, NonSyncStringBuffer buffer) throws JspException {
        boolean noneSelected = true;
        Choice[] choices = field.getChoices();
        if (choices == null) {
            choices = new Choice[]{};
        }
        Choice[] selectedChoices = BasicChoiceDisplayField.getSelectedChoices(field);
        HashSet<Choice> choiceSet = new HashSet<Choice>();
        if (selectedChoices != null) {
            choiceSet.addAll(Arrays.asList(selectedChoices));
        }
        int i = 0;
        while (i < choices.length) {
            boolean isSelected = choiceSet.contains(choices[i]);
            if (isSelected) {
                noneSelected = false;
            }
            buffer.append("\n<input type=\"radio\" name=\"").append(field.getQualifiedName()).append("\" value=\"").append(choices[i].getValue() == null ? "" : HtmlUtil.escapeQuotes(choices[i].getValue().toString())).append("\"");
            if (isSelected) {
                buffer.append(" checked");
            }
            this.appendCommonHtmlAttributes(buffer);
            this.appendJavaScriptAttributes(buffer);
            this.appendStyleAttributes(buffer);
            if (field instanceof HtmlDisplayField) {
                this.appendExtraHtml((HtmlDisplayField)((Object)field), buffer);
            }
            buffer.append(">").append(choices[i].getLabel());
            if (!this.isHorizontalLayout()) {
                buffer.append("<br>");
            }
            ++i;
        }
        NonSyncStringBuffer buffer2 = new NonSyncStringBuffer(buffer.length() + 32);
        this.appendNullChoiceHtmlString(buffer2, field, noneSelected);
        buffer.insert(0, buffer2);
    }

    protected void appendNullChoiceHtmlString(NonSyncStringBuffer buffer, ChoiceDisplayField field, boolean nullChoiceSelected) throws JspException {
        String label;
        Object nullChoiceLabel = field.getNullChoiceLabel();
        if (nullChoiceLabel != null && (label = nullChoiceLabel.toString()).length() > 0) {
            buffer.append("\n<input type=\"radio\" name=\"").append(field.getQualifiedName()).append("\" value=\"\"");
            if (nullChoiceSelected) {
                buffer.append(" checked");
            }
            buffer.append(">").append(label);
            if (!this.isHorizontalLayout()) {
                buffer.append("<br>");
            }
        }
    }

    public void doEndTagSelectableGroup(SelectableGroup field, NonSyncStringBuffer buffer) throws JspException {
        boolean noneSelected = true;
        Option[] options = field.getOptions().toOptionArray();
        int i = 0;
        while (i < options.length) {
            boolean isSelected = field.isSelected(options[i].getValue());
            if (isSelected) {
                noneSelected = false;
            }
            buffer.append("\n<input type=\"radio\" name=\"").append(field.getQualifiedName()).append("\" value=\"").append(HtmlUtil.escapeQuotes(options[i].getValue())).append("\"");
            if (isSelected) {
                buffer.append(" checked");
            }
            this.appendCommonHtmlAttributes(buffer);
            this.appendJavaScriptAttributes(buffer);
            this.appendStyleAttributes(buffer);
            this.appendExtraHtml(field, buffer);
            buffer.append(">").append(options[i].getLabel());
            if (!this.isHorizontalLayout()) {
                buffer.append("<br>");
            }
            ++i;
        }
        buffer.insert(0, this.getNoneSelectedHtmlString(field, noneSelected));
    }

    protected String getNoneSelectedHtmlString(SelectableGroup field, boolean noneSelected) throws JspException {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(64);
        if (field.getLabelForNoneSelected() != null && field.getLabelForNoneSelected().length() > 0) {
            buffer.append("\n<input type=\"radio\" name=\"").append(field.getQualifiedName()).append("\" value=\"").append("").append("\"");
            if (noneSelected) {
                buffer.append(" checked");
            }
            buffer.append(">").append(field.getLabelForNoneSelected());
            if (!this.isHorizontalLayout()) {
                buffer.append("<br>");
            }
        }
        return buffer.toString();
    }

    public String getLayout() {
        return (String)this.getValue("layout");
    }

    public void setLayout(String value) {
        this.setValue("layout", value);
    }

    protected boolean isHorizontalLayout() throws JspException {
        String layout = this.getLayout();
        return layout != null && layout.startsWith("h");
    }

    public String getGroupHtmlLabel() {
        return (String)this.getValue("groupHtmlLabel");
    }

    public void setGroupHtmlLabel(String value) {
        this.setValue("groupHtmlLabel", value);
    }
}

