/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model.sql;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestParticipant;
import com.iplanet.jato.model.DatasetModelExecutionContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.sql.QueryFieldDescriptor;
import com.iplanet.jato.model.sql.ResultSetModelBase;
import com.iplanet.jato.model.sql.SQLModelExecutionContext;
import com.iplanet.jato.model.sql.StoredProcModel;
import com.iplanet.jato.model.sql.StoredProcParameterDescriptor;
import com.iplanet.jato.model.sql.StoredProcSchema;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.util.WrapperRuntimeException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class StoredProcModelBase
extends ResultSetModelBase
implements StoredProcModel,
RequestParticipant {
    public static final String RESULT_PARAM_NAME = "RESULT_PARAM";
    public static final boolean DEBUG_TRACE_PROC = true;
    protected static final boolean OPTION_UNILATERALLY_REGISTER_INPUT_TYPE = false;
    private transient RequestContext requestContext;
    private String dataSourceName;
    private transient StoredProcSchema procedureSchema;
    private Map parameterValues = new HashMap();
    private Map otherSQLTypeMap = new HashMap();
    private String defaultUser = null;
    private String defaultPassword = null;
    private String procedureName = null;
    static /* synthetic */ Class class$java$sql$CallableStatement;
    static /* synthetic */ Class class$com$iplanet$jato$model$DatasetModelExecutionContext;

    public StoredProcModelBase() {
    }

    public StoredProcModelBase(StoredProcSchema schema) {
        this.setProcedureSchema(schema);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String value) {
        this.dataSourceName = value;
    }

    private void syncSchemaProcedureName(boolean validate) {
        StoredProcSchema schema = this.getProcedureSchema();
        if (schema != null) {
            if (schema.getProcedureName() == null && this.procedureName != null) {
                schema.setProcedureName(this.procedureName);
            } else if (schema.getProcedureName() != null && null == this.procedureName) {
                this.procedureName = schema.getProcedureName();
            } else if (schema.getProcedureName() != null && !schema.getProcedureName().equals(this.procedureName)) {
                if (validate) {
                    throw new WrapperRuntimeException("JATO Runtime Validation Check: 'ProcedureName=" + this.procedureName + "' of the StoredProcModelBase does not " + "match the 'ProcedureName=" + schema.getProcedureName() + "' of the schema");
                }
                schema.setProcedureName(this.procedureName);
            }
        }
    }

    public String getProcedureName() {
        this.syncSchemaProcedureName(true);
        return this.procedureName;
    }

    public void setProcedureName(String name) {
        this.procedureName = name;
        this.syncSchemaProcedureName(false);
    }

    public StoredProcSchema getProcedureSchema() {
        return this.procedureSchema;
    }

    public void setProcedureSchema(StoredProcSchema value) {
        StoredProcSchema oldSchema = this.procedureSchema;
        if (null == this.procedureSchema && this.getProcedureName() != null) {
            value.setProcedureName(this.getProcedureName());
            this.setProcedureName(null);
        }
        this.procedureSchema = value;
    }

    protected String beforeExecute(ModelExecutionContext context, String sql) throws ModelControlException {
        return sql;
    }

    protected void afterExecute(ModelExecutionContext context, CallableStatement statement) throws ModelControlException {
    }

    protected void onDatabaseError(ModelExecutionContext context, SQLException exception) {
    }

    public Object execute(ModelExecutionContext context) throws ModelControlException {
        try {
            return this.executeProcedure(context);
        }
        catch (SQLException e) {
            throw new ModelControlException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object executeProcedure(ModelExecutionContext context) throws SQLException, ModelControlException {
        Object object;
        boolean usedDefaultConnection;
        Connection connection;
        block16: {
            CallableStatement statement = null;
            connection = null;
            usedDefaultConnection = false;
            boolean usedDefaultStatement = false;
            String sql = this.constructProcedureSQL();
            if ((sql = this.beforeExecute(context, sql)) == null) {
                return null;
            }
            try {
                try {
                    if (context != null && context instanceof SQLModelExecutionContext && ((SQLModelExecutionContext)context).getStatement() != null) {
                        if (((SQLModelExecutionContext)context).getStatement() instanceof CallableStatement) {
                            statement = (CallableStatement)((SQLModelExecutionContext)context).getStatement();
                            connection = ((SQLModelExecutionContext)context).getConnection();
                        } else {
                            Class clazz;
                            StringBuffer stringBuffer = new StringBuffer().append("If a statement is provided in the execution context it must be of type ");
                            if (class$java$sql$CallableStatement == null) {
                                clazz = class$java$sql$CallableStatement = StoredProcModelBase.class$("java.sql.CallableStatement");
                                throw new IllegalArgumentException(stringBuffer.append(clazz.getName()).toString());
                            }
                            clazz = class$java$sql$CallableStatement;
                            throw new IllegalArgumentException(stringBuffer.append(clazz.getName()).toString());
                        }
                    }
                    if (statement == null) {
                        if (connection == null) {
                            connection = this.getDefaultConnection();
                            usedDefaultConnection = true;
                        }
                        statement = connection.prepareCall(sql);
                        usedDefaultStatement = true;
                    }
                    this.registerParameters(statement);
                    super.clearResultSet();
                    boolean moreResults = statement.execute();
                    ResultSet resultSet = this.obtainResultSet(statement);
                    if (resultSet != null) {
                        if (context != null && !(context instanceof DatasetModelExecutionContext)) {
                            Class clazz;
                            StringBuffer stringBuffer = new StringBuffer().append("Context must be a valid instance of type ");
                            if (class$com$iplanet$jato$model$DatasetModelExecutionContext == null) {
                                clazz = class$com$iplanet$jato$model$DatasetModelExecutionContext = StoredProcModelBase.class$("com.iplanet.jato.model.DatasetModelExecutionContext");
                                throw new IllegalArgumentException(stringBuffer.append(clazz.getName()).append(" when a result set is returned from a procedure (context = ").append(context).append(")").toString());
                            }
                            clazz = class$com$iplanet$jato$model$DatasetModelExecutionContext;
                            throw new IllegalArgumentException(stringBuffer.append(clazz.getName()).append(" when a result set is returned from a procedure (context = ").append(context).append(")").toString());
                        }
                        this.setResultSet(resultSet);
                    }
                    if (resultSet != null) {
                        this.positionResultSet((DatasetModelExecutionContext)context);
                    }
                    Object result = this.mapOutputParameters(statement);
                    this.afterExecute(context, statement);
                    object = result;
                    Object var12_12 = null;
                    if (!usedDefaultStatement || statement == null) break block16;
                }
                catch (SQLException e) {
                    this.onDatabaseError(context, e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (usedDefaultStatement && statement != null) {
                    statement.close();
                }
                if (!usedDefaultConnection) throw throwable;
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            statement.close();
        }
        if (!usedDefaultConnection) return object;
        if (connection == null) return object;
        connection.close();
        return object;
    }

    protected ResultSet obtainResultSet(CallableStatement statement) throws SQLException {
        return statement.getResultSet();
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(RequestContext value) {
        this.requestContext = value;
    }

    public Connection getDefaultConnection() throws SQLException {
        RequestContext requestContext = this.getRequestContext();
        if (requestContext != null) {
            if (this.getDefaultConnectionUser() == null || this.getDefaultConnectionUser().trim().length() == 0) {
                return requestContext.getSQLConnectionManager().getConnection(this.getDataSourceName());
            }
            return requestContext.getSQLConnectionManager().getConnection(this.getDataSourceName(), this.getDefaultConnectionUser(), this.getDefaultConnectionPassword());
        }
        throw new SQLException("Could not obtain connection because request context is null");
    }

    public String getDefaultConnectionUser() {
        return this.defaultUser;
    }

    public void setDefaultConnectionUser(String value) {
        this.defaultUser = value;
    }

    public String getDefaultConnectionPassword() {
        return this.defaultPassword;
    }

    public void setDefaultConnectionPassword(String value) {
        this.defaultPassword = value;
    }

    protected String constructProcedureSQL() {
        NonSyncStringBuffer result = new NonSyncStringBuffer(128);
        StoredProcSchema schema = this.getProcedureSchema();
        if (schema.hasResultParameter()) {
            result.append("{?=call ");
        } else {
            result.append("{call ");
        }
        result.append(this.getProcedureName());
        result.append("(");
        StoredProcParameterDescriptor[] descriptors = schema.getParameterDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            if (i > 0) {
                result.append(",");
            }
            result.append("?");
            ++i;
        }
        result.append(")}");
        return result.toString();
    }

    protected void registerParameters(CallableStatement statement) throws SQLException {
        boolean log = true;
        StoredProcSchema schema = this.getProcedureSchema();
        StoredProcParameterDescriptor[] descriptors = schema.getParameterDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getParameterType() == 1 || descriptors[i].getParameterType() == 3) {
                Object value = this.getValue(descriptors[i].getName());
                System.out.println("REG_PARAM: Registering IN " + descriptors[i].getName() + " = " + value + ")");
                if (value == null) {
                    statement.setNull(i + 1, descriptors[i].getSQLType());
                } else {
                    statement.setObject(i + 1, value);
                }
            }
            if (descriptors[i].getParameterType() == 2 || descriptors[i].getParameterType() == 3) {
                System.out.println("REG_PARAM: Registering OUT " + descriptors[i].getName() + " (type = " + descriptors[i].getSQLType() + ")");
                statement.registerOutParameter(i + 1, descriptors[i].getSQLType());
            }
            ++i;
        }
        if (schema.hasResultParameter()) {
            System.out.println("REG_PARAM: Registering RESULT " + schema.getResultParameterDescriptor().getName() + " (type = " + schema.getResultParameterDescriptor().getSQLType() + ")");
            statement.registerOutParameter(i, schema.getResultParameterDescriptor().getSQLType());
        }
    }

    protected Object mapOutputParameters(CallableStatement statement) throws SQLException {
        Object value;
        StoredProcSchema schema = this.getProcedureSchema();
        StoredProcParameterDescriptor[] descriptors = schema.getParameterDescriptors();
        Map typeMap = this.getOtherSQLTypeMap();
        Object resultParam = null;
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i].getParameterType() == 2 || descriptors[i].getParameterType() == 3) {
                this.removeParameterValue(descriptors[i].getName());
                value = null;
                value = descriptors[i].getSQLType() == 1111 ? statement.getObject(i + 1, typeMap) : statement.getObject(i + 1);
                if (!statement.wasNull()) {
                    this.setParameterValue(descriptors[i].getName(), value);
                }
            }
            ++i;
        }
        if (schema.hasResultParameter()) {
            value = null;
            value = schema.getResultParameterDescriptor().getSQLType() == 1111 ? statement.getObject(i + 1, typeMap) : statement.getObject(i + 1);
            if (!statement.wasNull()) {
                this.setResultParameterValue(value);
                resultParam = value;
            }
        }
        return resultParam;
    }

    public Map getOtherSQLTypeMap() {
        return this.otherSQLTypeMap;
    }

    public void setOtherSQLTypeMap(Map value) {
        this.otherSQLTypeMap = value;
    }

    public Class getFieldClass(String name) {
        StoredProcParameterDescriptor pd = null;
        QueryFieldDescriptor fd = null;
        if (this.getProcedureSchema() != null) {
            pd = this.getProcedureSchema().getParameterDescriptor(name);
        }
        if (this.getFieldSchema() != null) {
            fd = this.getFieldSchema().getFieldDescriptor(name);
        }
        if (pd != null && fd != null) {
            throw new Error("Ambiguous field name \"" + name + "\".  This name appears in " + "both the parameter descriptors and the field " + "descriptors for this model");
        }
        Class result = null;
        if (pd != null) {
            result = pd.getParameterClass();
        } else if (fd != null) {
            result = fd.getFieldClass();
        }
        return result;
    }

    public Object getValue(String name) {
        Object value = this.getParameterValue(name);
        if (value != null) {
            return value;
        }
        return super.getValue(name);
    }

    public Object[] getValues(String name) {
        Object value = this.getParameterValue(name);
        if (value != null) {
            if (value.getClass().isArray() && value.getClass().getComponentType() instanceof Object) {
                return (Object[])value;
            }
            return new Object[]{value};
        }
        return super.getValues(name);
    }

    public Object getResultParameterValue() {
        return this.parameterValues.get(RESULT_PARAM_NAME);
    }

    protected void setResultParameterValue(Object value) {
        this.parameterValues.put(RESULT_PARAM_NAME, value);
    }

    public Object getParameterValue(String name) {
        return this.parameterValues.get(name);
    }

    public void setParameterValue(String name, Object value) {
        this.parameterValues.put(name, value);
    }

    public void removeParameterValue(String name) {
        this.parameterValues.remove(name);
    }

    public void clearParameterValues() {
        this.parameterValues.clear();
    }

    public void clear() {
        this.clearParameterValues();
        super.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        RESULT_PARAM_NAME = RESULT_PARAM_NAME;
        DEBUG_TRACE_PROC = true;
        OPTION_UNILATERALLY_REGISTER_INPUT_TYPE = false;
    }
}

