/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model.sql;

import com.iplanet.jato.model.DatasetModelExecutionContext;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.sql.QueryFieldDescriptor;
import com.iplanet.jato.model.sql.QueryFieldSchema;
import com.iplanet.jato.util.TypeConverter;
import com.iplanet.jato.util.WrapperRuntimeException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResultSetModelBase
extends DefaultModel {
    protected static final int SYNCROW_NO_MORE_DATA = 0;
    protected static final int SYNCROW_ALREADY_SYNCHRONIZED = 1;
    protected static final int SYNCROW_FOUND_DATA = 2;
    protected static final boolean OPTION_COERCE_VALUE_TYPES = true;
    protected static final boolean OPTION_COERCE_CACHED_RESULT_SET_VALUES = false;
    protected static final boolean DEBUG_UPDATE_MODEL = false;
    protected static final boolean DEBUG_SYNCROW = false;
    protected static final boolean DEBUG_NEXTROW = false;
    protected static final boolean DEBUG_POS_RESULTSET = false;
    private transient QueryFieldSchema fieldSchema;
    private transient ResultSet resultSet = null;
    private transient Set resultSetColumns = null;
    private int maxInitializedRow = -1;
    private int firstRowOffset = -1;
    private boolean hasPreviousResults = false;
    private boolean hasMoreResults = false;

    public ResultSetModelBase() {
        this.setUseDefaultValues(false);
    }

    public ResultSetModelBase(QueryFieldSchema schema) {
        this();
        this.setFieldSchema(schema);
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public void setResultSet(ResultSet value) {
        this.resultSet = value;
    }

    protected void resolveResultSetColumnSet() throws SQLException {
        if (this.getResultSet() != null) {
            this.resultSetColumns = new HashSet();
            ResultSetMetaData metadata = this.getResultSet().getMetaData();
            int i = 1;
            while (i <= metadata.getColumnCount()) {
                this.resultSetColumns.add(metadata.getColumnName(i));
                ++i;
            }
        } else {
            this.resultSetColumns = null;
        }
    }

    public QueryFieldSchema getFieldSchema() {
        return this.fieldSchema;
    }

    public void setFieldSchema(QueryFieldSchema value) {
        this.fieldSchema = value;
    }

    public int getSize() throws ModelControlException {
        if (this.getResultSet() == null) {
            return super.getSize();
        }
        return -1;
    }

    public void setSize(int value) throws ModelControlException {
        throw new ModelControlException("Cannot set size of a model of type" + this.getClass().getName());
    }

    public int getLocation() throws ModelControlException {
        return super.getLocation();
    }

    public void setLocation(int location) throws ModelControlException {
        super.setLocation(location);
        try {
            this.synchronizeRow(location);
        }
        catch (SQLException e) {
            throw new ModelControlException(e);
        }
    }

    protected int synchronizeRow(int row) throws SQLException {
        boolean log = false;
        int result = 0;
        int diffRows = row - this.maxInitializedRow;
        if (diffRows > 0) {
            if (this.getResultSet() == null) {
                if (row < super.getNumRows()) {
                    result = 1;
                    this.setRowIndex(row);
                } else {
                    result = 0;
                }
                return result;
            }
            this.setRowIndex(this.maxInitializedRow);
            int i = 0;
            while (i < diffRows) {
                if (!this.getResultSet().next()) break;
                result = 2;
                this.ensureRow(this.maxInitializedRow + i + 1);
                try {
                    super.next();
                }
                catch (ModelControlException e) {
                    throw new Error("ASSERT FAILED: next() should have been possible on this model");
                }
                this.updateModel();
                ++this.maxInitializedRow;
                ++i;
            }
        } else {
            result = 1;
            this.setRowIndex(row);
        }
        return result;
    }

    public void beforeFirst() throws ModelControlException {
        this.setRowIndex(-1);
    }

    public boolean first() throws ModelControlException {
        try {
            this.synchronizeRow(0);
            this.setRowIndex(0);
            return this.checkRowIndex();
        }
        catch (SQLException e) {
            throw new ModelControlException(e);
        }
    }

    public boolean last() throws ModelControlException {
        while (this.next()) {
        }
        return this.checkRowIndex();
    }

    public boolean next() throws ModelControlException {
        boolean log = false;
        try {
            int newRowIndex = this.getRowIndex() + 1;
            int syncResult = this.synchronizeRow(newRowIndex);
            boolean result = false;
            switch (syncResult) {
                case 0: {
                    result = false;
                    break;
                }
                case 1: {
                    result = true;
                    break;
                }
                case 2: {
                    result = true;
                    break;
                }
                default: {
                    result = false;
                }
            }
            return result;
        }
        catch (SQLException e) {
            throw new ModelControlException(e);
        }
    }

    public boolean previous() throws ModelControlException {
        return super.previous();
    }

    protected boolean checkRowIndex() {
        if (this.getNumRows() <= 0) {
            this.setRowIndex(-1);
            return false;
        }
        if (this.getRowIndex() >= this.getNumRows()) {
            this.setRowIndex(this.getNumRows() - 1);
            return false;
        }
        if (this.getRowIndex() < 0) {
            this.setRowIndex(0);
            return false;
        }
        return true;
    }

    public Class getFieldClass(String name) {
        QueryFieldDescriptor fd = this.getFieldSchema().getFieldDescriptor(name);
        if (fd != null) {
            return fd.getFieldClass();
        }
        return null;
    }

    public boolean hasValue(String name) {
        if (super.hasValue(name)) {
            return TypeConverter.asType(this.getFieldClass(name), this.getValue(name)) != null;
        }
        return false;
    }

    public void setValue(String name, Object value) {
        value = TypeConverter.asType(this.getFieldClass(name), value);
        super.setValues(name, new Object[]{value});
    }

    public void setValues(String name, Object[] values) {
        if (values.length > 0) {
            Object[] newValues = new Object[values.length];
            int i = 0;
            while (i < values.length) {
                newValues[i] = TypeConverter.asType(this.getFieldClass(name), values[i]);
                ++i;
            }
            values = newValues;
        }
        super.setValues(name, values);
    }

    public void clear() {
        super.clear();
        this.clearResultSet();
    }

    protected void clearResultSet() {
        this.setResultSet(null);
        this.maxInitializedRow = -1;
    }

    public int getLocationOffset() {
        return this.firstRowOffset;
    }

    protected void setLocationOffset(int value) {
        this.firstRowOffset = value;
    }

    protected void positionResultSet(DatasetModelExecutionContext context) throws SQLException {
        int offset = 0;
        if (context != null) {
            offset = context.getDatasetOffset();
        }
        int numRows = -1;
        if (context != null) {
            numRows = context.getDatasetSize();
        }
        this.positionResultSet(offset, numRows);
    }

    protected void positionResultSet(int offset, int numRows) throws SQLException {
        boolean hadRow;
        int rowIndex;
        boolean log = false;
        ResultSet resultSet = this.getResultSet();
        if (resultSet == null) {
            return;
        }
        boolean resultsAvailable = true;
        this.setPreviousResults(false);
        this.setMoreResults(true);
        this.setLocationOffset(offset);
        if (offset > 0) {
            rowIndex = 0;
            hadRow = resultSet.next();
            while (hadRow && ++rowIndex < offset) {
                hadRow = resultSet.next();
            }
            if (hadRow) {
                this.setLocationOffset(rowIndex);
            } else {
                resultsAvailable = false;
                this.setLocationOffset(offset - numRows);
                this.setMoreResults(false);
            }
            this.setPreviousResults(rowIndex > 0);
        }
        try {
            if (resultsAvailable && offset == -1 || offset < 0) {
                if (numRows == -2 || numRows == -1) {
                    throw new IllegalArgumentException("An offset of DATASET_OFFSET_END cannot be combined with the DATASET_SIZE_ALL_INCREMENTAL or DATASET_SIZE_ALL_PREFETCH directives");
                }
                this.last();
                this.setMoreResults(false);
                rowIndex = 0;
                if (numRows > 1) {
                    hadRow = this.previous();
                    while (hadRow && ++rowIndex < numRows - 1) {
                        hadRow = this.previous();
                    }
                    this.setPreviousResults(hadRow);
                }
                List rowList = super.getRowList();
                int currentRow = this.getRowIndex();
                if (rowList instanceof DefaultModel.RowValueArrayList) {
                    if (currentRow > 0) {
                        ((DefaultModel.RowValueArrayList)rowList).removeRange(0, currentRow);
                    }
                } else {
                    Iterator iterator = rowList.iterator();
                    int i = 0;
                    while (i < currentRow) {
                        iterator.next();
                        iterator.remove();
                        ++i;
                    }
                }
                this.setLocationOffset(currentRow);
            } else if (resultsAvailable && numRows == -2) {
                this.setPreviousResults(false);
                this.setMoreResults(true);
            } else if (resultsAvailable && numRows == -1) {
                this.last();
                this.setPreviousResults(false);
                this.setMoreResults(false);
            } else if (resultsAvailable && numRows >= 0) {
                int i = 0;
                while (i < numRows) {
                    if (!this.next()) {
                        this.setMoreResults(false);
                        break;
                    }
                    ++i;
                }
            }
            if (numRows != -2) {
                this.beforeFirst();
                this.setResultSet(null);
            }
        }
        catch (ModelControlException e) {
            if (e.getRootCause() instanceof SQLException) {
                throw (SQLException)e.getRootCause();
            }
            throw new SQLException("Unexpected ModelControlException while position result set: " + e);
        }
    }

    public boolean hasPreviousResults() {
        return this.hasPreviousResults;
    }

    protected void setPreviousResults(boolean value) {
        this.hasPreviousResults = value;
    }

    public boolean hasMoreResults() {
        return this.hasMoreResults;
    }

    protected void setMoreResults(boolean value) {
        this.hasMoreResults = value;
    }

    protected Map getValueMap(int row) {
        if (row == -1) {
            Map result = super.getValueMap(row);
            try {
                this.synchronizeRow(0);
            }
            catch (SQLException e) {
                throw new WrapperRuntimeException(e);
            }
            return result;
        }
        return super.getValueMap(row);
    }

    protected void updateModel() throws SQLException {
        boolean log = false;
        ResultSet resultSet = this.getResultSet();
        if (resultSet == null) {
            return;
        }
        if (this.getFieldSchema() == null) {
            throw new SQLException("No field schema has been provided");
        }
        QueryFieldDescriptor[] fieldDescriptors = this.getFieldSchema().getFieldDescriptors();
        int i = 0;
        while (i < fieldDescriptors.length) {
            QueryFieldDescriptor fd = fieldDescriptors[i];
            if (fd.isQueryTypeEnabled(1)) {
                Object value = resultSet.getObject(fd.getColumnName());
                super.setValues(fieldDescriptors[i].getName(), new Object[]{value});
            }
            ++i;
        }
    }

    static {
        SYNCROW_NO_MORE_DATA = 0;
        SYNCROW_ALREADY_SYNCHRONIZED = 1;
        SYNCROW_FOUND_DATA = 2;
        OPTION_COERCE_VALUE_TYPES = true;
        OPTION_COERCE_CACHED_RESULT_SET_VALUES = false;
        DEBUG_UPDATE_MODEL = false;
        DEBUG_SYNCROW = false;
        DEBUG_NEXTROW = false;
        DEBUG_POS_RESULTSET = false;
    }
}

