/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model.object.factory;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.object.ObjectFactory;
import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

public class JNDIFactory
implements ObjectFactory,
Serializable {
    private EnvironmentValue[] environment;
    private Hashtable table;
    private String JNDIName;

    public void setJNDIName(String JNDIName) {
        this.JNDIName = JNDIName;
    }

    public String getJNDIName() {
        return this.JNDIName;
    }

    public void setEnvironment(EnvironmentValue[] environment) {
        this.environment = environment;
        this.table = null;
    }

    public void setEnvironment(int index, EnvironmentValue value) {
        this.environment[index] = value;
        this.table = null;
    }

    public EnvironmentValue[] getEnvironment() {
        return this.environment;
    }

    public EnvironmentValue getEnvironment(int index) {
        return this.environment[index];
    }

    protected Hashtable getTable() {
        if (null == this.table) {
            this.table = new Hashtable();
            if (null == this.getEnvironment()) {
                return this.table;
            }
            int i = 0;
            while (i < this.getEnvironment().length) {
                this.table.put(this.getEnvironment(i).getName(), this.getEnvironment(i).getValue());
                ++i;
            }
        }
        return this.table;
    }

    public Object getObject(RequestContext requestContext) throws ModelControlException {
        if (null == this.getJNDIName()) {
            throw new ModelControlException("JNDI name property must not be null");
        }
        try {
            InitialContext context = null == this.getEnvironment() || this.getEnvironment().length == 0 ? new InitialContext() : new InitialContext(this.getTable());
            return context.lookup(this.getJNDIName());
        }
        catch (NameNotFoundException nnfe) {
            return null;
        }
        catch (NamingException ne) {
            throw new ModelControlException(ne);
        }
    }

    public static class EnvironmentValue
    implements Serializable {
        private String name;
        private Object value;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

