/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.model;

import com.iplanet.jato.model.ContextualModel;
import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.InvalidContextException;
import com.iplanet.jato.model.ModelControlException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class DefaultModel
implements ContextualModel,
DatasetModel,
Serializable {
    public static final int UNDEFINED_ROW_INDEX = -1;
    public static final String DEFAULT_CONTEXT_NAME = "DEFAULT";
    private String name;
    private Map contexts = new HashMap();
    private transient Context currentContext;
    private String currentContextName;
    private boolean useDefaultValues = true;

    public DefaultModel() {
        this(null);
    }

    public DefaultModel(String name) {
        this.setName(name);
        this.initializeDefaultContext();
        try {
            this.selectContext(DEFAULT_CONTEXT_NAME);
        }
        catch (InvalidContextException invalidContextException) {
            // empty catch block
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public boolean isUseDefaultValues() {
        return this.useDefaultValues;
    }

    public void setUseDefaultValues(boolean value) {
        this.useDefaultValues = value;
    }

    public void clear() {
        this.clearModelData();
    }

    protected final void clearModelData() {
        this.getCurrentContext().clear();
    }

    public void dumpValues(PrintStream out) {
        PrintWriter writer = new PrintWriter(out);
        this.dumpValues(writer);
        writer.flush();
    }

    public void dumpValues(PrintWriter out) {
        out.println("--- BEGIN dumping model values (name=\"" + this.getName() + "\", instance=\"" + this + "\") ---");
        try {
            int originalLocation = this.getLocation();
            this.beforeFirst();
            while (this.next()) {
                out.print("Row " + this.getLocation() + ": ");
                Map valueMap = this.getValueMap(this.getLocation());
                Iterator i = valueMap.keySet().iterator();
                while (i.hasNext()) {
                    String name = (String)i.next();
                    out.print(name + "={");
                    Object[] values = (Object[])valueMap.get(name);
                    if (values.length == 0) {
                        out.print("");
                    } else if (values.length == 1) {
                        out.print("'" + values[0] + "'");
                    } else {
                        out.print("[");
                        int j = 0;
                        while (j < values.length) {
                            if (j > 0) {
                                out.print(", ");
                            }
                            out.print("'" + values[j] + "'");
                            ++j;
                        }
                        out.print("]");
                    }
                    out.print("}; ");
                }
                out.println();
            }
            this.setLocation(originalLocation);
        }
        catch (Exception e) {
            out.println("ERROR dumping model values: " + e);
        }
        out.println("--- END dumping model values (name=\"" + this.getName() + "\", instance=\"" + this + "\") ---");
    }

    public int getSize() throws ModelControlException {
        return this.getNumRows();
    }

    public void setSize(int value) throws ModelControlException {
        this.setNumRows(value);
    }

    public int getLocationOffset() {
        return this.getCurrentContext().getLocationOffset();
    }

    protected void setLocationOffset(int value) {
        this.getCurrentContext().setLocationOffset(value);
    }

    public int getLocation() throws ModelControlException {
        return this.getRowIndex();
    }

    public void setLocation(int location) throws ModelControlException {
        this.setRowIndex(location);
    }

    public void beforeFirst() throws ModelControlException {
        this.setRowIndex(this.getLocationOffset() - 1);
    }

    public boolean first() throws ModelControlException {
        this.setRowIndex(this.getLocationOffset());
        return this.checkRowIndex();
    }

    public boolean last() throws ModelControlException {
        this.setRowIndex(this.getNumRows() - 1);
        return this.checkRowIndex();
    }

    public boolean next() throws ModelControlException {
        this.setRowIndex(this.getRowIndex() + 1);
        return this.checkRowIndex();
    }

    public boolean previous() throws ModelControlException {
        this.setRowIndex(this.getRowIndex() - 1);
        return this.checkRowIndex();
    }

    public int getNumRows() {
        return this.getRowList().size();
    }

    public void setNumRows(int value) {
        if (value >= this.getNumRows()) {
            this.ensureRow(value - 1);
        } else {
            List rowList = this.getRowList();
            if (rowList instanceof RowValueArrayList) {
                ((RowValueArrayList)rowList).removeRange(value, rowList.size());
            } else {
                ListIterator iterator = rowList.listIterator(value);
                int count = rowList.size() - value;
                int i = 0;
                while (i < count) {
                    iterator.next();
                    iterator.remove();
                    ++i;
                }
            }
            this.setRowList(rowList);
        }
    }

    public int getRowIndex() {
        return this.getCurrentContext().getCurrentRow();
    }

    public void setRowIndex(int value) {
        this.getCurrentContext().setCurrentRow(value);
    }

    public void appendRow() {
        int rowIndex = this.getNumRows();
        this.ensureRow(rowIndex);
        this.setRowIndex(rowIndex);
    }

    public void insertRow() {
        int rowIndex = this.getRowIndex();
        this.getCurrentContext().getValueList().add(rowIndex, this.createValueMap());
    }

    protected boolean checkRowIndex() {
        if (this.getNumRows() <= 0) {
            this.setRowIndex(-1);
            this.setLocationOffset(0);
            return false;
        }
        if (this.getRowIndex() >= this.getNumRows()) {
            this.setRowIndex(this.getNumRows() - 1);
            return false;
        }
        if (this.getRowIndex() < this.getLocationOffset() && this.getNumRows() > this.getLocationOffset()) {
            this.setRowIndex(this.getLocationOffset());
            return false;
        }
        return true;
    }

    protected void ensureRow(int row) {
        List valueList = this.getRowList();
        if (row >= valueList.size()) {
            while (valueList.size() <= row) {
                valueList.add(this.createValueMap());
            }
        }
    }

    protected List getRowList() {
        return this.getCurrentContext().getValueList();
    }

    protected void setRowList(List value) {
        this.getCurrentContext().setValueList(value);
        if (this.getRowIndex() >= this.getNumRows()) {
            this.setRowIndex(this.getNumRows() - 1);
        }
    }

    protected Map createValueMap() {
        return new HashMap();
    }

    protected Map getValueMap() {
        return this.getValueMap(this.getRowIndex());
    }

    protected Map getValueMap(int row) {
        if (row == -1) {
            row = 0;
            this.ensureRow(0);
            this.setRowIndex(0);
        }
        this.ensureRow(row);
        return (Map)this.getRowList().get(row);
    }

    protected Map getDefaultValueMap() {
        return this.getCurrentContext().getDefaultValueMap();
    }

    public Object getValue(String name) {
        Object[] values = this.getValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public void setValue(String name, Object value) {
        this.setValues(name, new Object[]{value});
    }

    public Object[] getValues(String name) {
        Object[] result = (Object[])this.getValueMap().get(name);
        if (result == null && this.isUseDefaultValues()) {
            result = this.getDefaultValues(name);
        }
        if (result == null) {
            result = new Object[]{};
        }
        return result;
    }

    public void setValues(String name, Object[] value) {
        Map defaultValueMap;
        if (value == null) {
            value = new Object[]{};
        }
        this.getValueMap().put(name, value);
        if (this.isUseDefaultValues() && (defaultValueMap = this.getDefaultValueMap()).get(name) == null) {
            defaultValueMap.put(name, value);
        }
    }

    public boolean hasValue(String name) {
        Object value = this.getValue(name);
        return value != null;
    }

    public Object getDefaultValue(String name) {
        Object[] values = this.getDefaultValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public void setDefaultValue(String name, Object value) {
        this.setDefaultValues(name, new Object[]{value});
    }

    public Object[] getDefaultValues(String name) {
        Object[] result = (Object[])this.getDefaultValueMap().get(name);
        if (result == null) {
            result = new Object[]{};
        }
        return result;
    }

    public void setDefaultValues(String name, Object[] value) {
        if (value == null) {
            value = new Object[]{};
        }
        this.getDefaultValueMap().put(name, value);
    }

    public String getCurrentContextName() {
        return this.currentContextName;
    }

    public String[] getContextNames() {
        return this.contexts.keySet().toArray(new String[0]);
    }

    public void selectContext(String name) throws InvalidContextException {
        this.currentContextName = name;
        this.currentContext = this.getContext(name);
        if (this.currentContext == null) {
            throw new InvalidContextException("Context \"" + name + "\" does not exist in model \"" + this.getName() + "\"");
        }
    }

    public void selectDefaultContext() throws InvalidContextException {
        this.selectContext(DEFAULT_CONTEXT_NAME);
    }

    public boolean isDefaultContext() {
        return this.getCurrentContextName().equals(DEFAULT_CONTEXT_NAME);
    }

    protected void initializeDefaultContext() {
        this.addContext(DEFAULT_CONTEXT_NAME);
    }

    protected Context getCurrentContext() {
        if (this.currentContext == null) {
            this.currentContext = this.getContext(this.currentContextName);
            return this.currentContext;
        }
        return this.currentContext;
    }

    protected Context addContext(String name) {
        Context result = (Context)this.contexts.get(name);
        if (result == null) {
            result = new Context(name);
            this.contexts.put(name, result);
        }
        return result;
    }

    protected Context getContext(String name) {
        return (Context)this.contexts.get(name);
    }

    protected void removeContext(String name) {
        this.contexts.remove(name);
    }

    public void sort(String fieldName) throws ModelControlException {
        this.sort(new SingleFieldValueComparator(fieldName));
    }

    public void sort(Comparator comparator) throws ModelControlException {
        Collections.sort(this.getRowList(), comparator);
        this.beforeFirst();
    }

    static {
        UNDEFINED_ROW_INDEX = -1;
        DEFAULT_CONTEXT_NAME = DEFAULT_CONTEXT_NAME;
    }

    public static class MultiFieldValueComparator
    implements Comparator {
        private String[] fieldNames;
        private Comparator delegateComparator;

        public MultiFieldValueComparator(String fieldNames) {
            this(new String[]{fieldNames});
        }

        protected MultiFieldValueComparator(String[] fieldNames) {
            if (fieldNames == null || fieldNames.length == 0) {
                throw new IllegalArgumentException("Parameter \"fieldName\" cannot be null or an empty array");
            }
            this.fieldNames = fieldNames;
        }

        public MultiFieldValueComparator(String[] fieldNames, Comparator delegateComparator) {
            this(fieldNames);
            if (delegateComparator == null) {
                throw new IllegalArgumentException("Parameter \"delegateComparator\" cannot be null");
            }
            this.delegateComparator = delegateComparator;
        }

        public final int compare(Object o1, Object o2) {
            int i = 0;
            while (i < this.fieldNames.length) {
                int result;
                Object value2;
                Object value1 = ((Map)o1).get(this.fieldNames[i]);
                if (value1 != null && !value1.getClass().isArray()) {
                    value1 = new Object[]{value1};
                }
                if ((value2 = ((Map)o2).get(this.fieldNames[i])) != null && !value2.getClass().isArray()) {
                    value2 = new Object[]{value2};
                }
                if ((result = this.compareFieldValues(this.fieldNames[i], (Object[])value1, (Object[])value2)) != 0) {
                    return result;
                }
                ++i;
            }
            return 0;
        }

        protected int compareFieldValues(String fieldName, Object[] values1, Object[] values2) {
            if (this.delegateComparator != null) {
                return this.delegateComparator.compare(values1, values2);
            }
            if (values1 == null || values2 == null || values1.length != values2.length) {
                return 0;
            }
            int i = 0;
            while (i < values1.length) {
                if (values1[i] instanceof Comparable && values2[i] != null) {
                    int result = ((Comparable)values1[i]).compareTo(values2[i]);
                    if (result != 0) {
                        return result;
                    }
                } else {
                    return 0;
                }
                ++i;
            }
            return 0;
        }
    }

    public static class SingleFieldValueComparator
    implements Comparator {
        private String[] fieldNames;
        private Comparator delegateComparator;

        public SingleFieldValueComparator(String fieldNames) {
            this(new String[]{fieldNames});
        }

        public SingleFieldValueComparator(String[] fieldNames) {
            if (fieldNames == null || fieldNames.length == 0) {
                throw new IllegalArgumentException("Parameter \"fieldNames\" cannot be null or an empty array");
            }
            this.fieldNames = fieldNames;
        }

        public SingleFieldValueComparator(String[] fieldNames, Comparator delegateComparator) {
            this(fieldNames);
            if (delegateComparator == null) {
                throw new IllegalArgumentException("Parameter \"delegateComparator\" cannot be null");
            }
            this.delegateComparator = delegateComparator;
        }

        public final int compare(Object o1, Object o2) {
            int i = 0;
            while (i < this.fieldNames.length) {
                int result;
                Object value2;
                Object value1 = ((Map)o1).get(this.fieldNames[i]);
                if (value1 != null && value1.getClass().isArray()) {
                    Object[] array = (Object[])value1;
                    value1 = array.length > 0 ? array[0] : null;
                }
                if ((value2 = ((Map)o2).get(this.fieldNames[i])) != null && value2.getClass().isArray()) {
                    Object[] array = (Object[])value2;
                    value2 = array.length > 0 ? array[0] : null;
                }
                if ((result = this.compareFieldValues(this.fieldNames[i], value1, value2)) != 0) {
                    return result;
                }
                ++i;
            }
            return 0;
        }

        protected int compareFieldValues(String fieldName, Object value1, Object value2) {
            if (this.delegateComparator != null) {
                return this.delegateComparator.compare(value1, value2);
            }
            if (value1 instanceof Comparable && value2 != null) {
                return ((Comparable)value1).compareTo(value2);
            }
            return 0;
        }
    }

    protected static class Context
    implements Serializable {
        private String name;
        private List valueList = new RowValueArrayList();
        private int currentRow = -1;
        private Map defaultValueMap;
        private int locationOffset = 0;

        public Context(String name) {
            this.name = name;
        }

        public List getValueList() {
            return this.valueList;
        }

        public void setValueList(List value) {
            this.valueList = value;
        }

        public Map getDefaultValueMap() {
            if (this.defaultValueMap == null) {
                this.defaultValueMap = new HashMap();
            }
            return this.defaultValueMap;
        }

        public void setDefaultValueMap(Map value) {
            this.defaultValueMap = value;
        }

        public int getCurrentRow() {
            return this.currentRow;
        }

        public void setCurrentRow(int value) {
            this.currentRow = value;
        }

        public int getLocationOffset() {
            return this.locationOffset;
        }

        public void setLocationOffset(int value) {
            this.locationOffset = value;
        }

        public void clear() {
            this.valueList = new RowValueArrayList();
            this.currentRow = -1;
            this.locationOffset = 0;
        }
    }

    protected static class RowValueArrayList
    extends ArrayList {
        public RowValueArrayList() {
        }

        public RowValueArrayList(Collection c) {
            super(c);
        }

        public RowValueArrayList(int initialCapacity) {
            super(initialCapacity);
        }

        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }
    }
}

