/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato.command;

import com.iplanet.jato.command.BasicCommand;
import com.iplanet.jato.command.Command;
import com.iplanet.jato.command.CommandChainEvent;
import com.iplanet.jato.command.CommandDescriptor;
import com.iplanet.jato.command.CommandEvent;
import com.iplanet.jato.command.CommandException;
import com.iplanet.jato.command.CommandFactory;

public class CommandChain
extends BasicCommand {
    private CommandDescriptor[] commands;

    public void execute(CommandEvent event) throws CommandException {
        CommandDescriptor[] commandDescriptors = this.getCommandDescriptors();
        if (commandDescriptors == null || commandDescriptors.length == 0) {
            return;
        }
        CommandChainEvent multiEvent = new CommandChainEvent(this, event);
        CommandDescriptor descriptor = null;
        int i = 0;
        while (i < commandDescriptors.length) {
            Command command;
            descriptor = commandDescriptors[i];
            if (descriptor != null && (command = CommandFactory.getCommand(descriptor)) != null) {
                multiEvent.setOperationName(descriptor.getOperationName());
                multiEvent.setParameters(descriptor.getParameters());
                this.executeCommand(command, multiEvent);
            }
            ++i;
        }
    }

    public CommandDescriptor[] getCommandDescriptors() {
        return this.commands;
    }

    public void setCommandDescriptors(CommandDescriptor[] value) {
        this.commands = value;
    }

    protected Object executeCommand(Command command, CommandEvent event) throws CommandException {
        if (!this.beginCommandExecution(command, event)) {
            return null;
        }
        try {
            command.execute(event);
        }
        catch (CommandException e) {
            this.handleCommandException(command, event, e);
        }
        this.endCommandExecution(command, event);
        return null;
    }

    public boolean beginCommandExecution(Command command, CommandEvent event) throws CommandException {
        return true;
    }

    public void endCommandExecution(Command command, CommandEvent event) throws CommandException {
    }

    public void handleCommandException(Command command, CommandEvent event, CommandException exception) throws CommandException {
        throw exception;
    }
}

