/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.jato;

import com.iplanet.jato.Log;
import com.iplanet.jato.RequestContext;
import com.iplanet.jato.util.Encoder;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class ClientSession {
    public static final String CLIENT_SESSION_ATTRIBUTE_NVP_NAME = "jato.clientSession";
    private static final boolean OPTION_COMPRESS_CLIENT_SESSION = true;
    private static final int CLIENT_SESSION_COMPRESSION_THRESHOLD = 1024;
    private String id;
    private Map attributes;
    private String encodedSessionString;
    private boolean valid;
    private boolean modified;

    protected ClientSession(RequestContext context) {
        this.encodedSessionString = context.getRequest().getParameter(CLIENT_SESSION_ATTRIBUTE_NVP_NAME);
    }

    protected void deserializeAttributes() {
        if (this.attributes != null) {
            return;
        }
        try {
            if (this.encodedSessionString != null && this.encodedSessionString.trim().length() > 0) {
                this.setAttributes((Map)Encoder.deserialize(Encoder.decodeHttp64(this.encodedSessionString), false));
                this.modified = false;
            }
            this.valid = true;
        }
        catch (Exception e) {
            this.valid = false;
            Log.log(64, "Exception while deserializing client session", e);
        }
    }

    public boolean isValid() {
        this.ensureAttributes();
        return this.valid;
    }

    protected void ensureAttributes() {
        if (this.attributes == null) {
            this.deserializeAttributes();
        }
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
    }

    protected Map getAttributes() {
        this.ensureAttributes();
        return this.attributes;
    }

    protected void setAttributes(Map value) {
        this.attributes = value;
        this.modified = true;
    }

    public boolean hasAttributes() {
        return this.attributes != null && this.attributes.size() > 0 || this.encodedSessionString != null && this.encodedSessionString.trim().length() > 0;
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.getAttributes().keySet());
    }

    public Object getAttribute(String name) {
        return this.getAttributes().get(name);
    }

    public void setAttribute(String name, Serializable value) {
        if (value != null) {
            this.getAttributes().put(name, value);
            this.modified = true;
        } else {
            this.removeAttribute(name);
        }
    }

    public void removeAttribute(String name) {
        if (this.attributes != null && name != null && this.getAttributes().remove(name) != null) {
            this.modified = true;
        }
    }

    public void clearAttributes() {
        if (this.attributes != null) {
            this.getAttributes().clear();
            this.modified = true;
        }
    }

    public String getEncodedString() throws IOException {
        if (!this.isValid()) {
            this.encodedSessionString = "";
        } else if (this.modified) {
            Map attributes = this.getAttributes();
            if (attributes == null || attributes.size() == 0) {
                this.encodedSessionString = "";
            } else {
                int compressThreshold = 1024;
                this.encodedSessionString = Encoder.encodeHttp64(Encoder.serialize((Serializable)((Object)attributes), false), compressThreshold);
            }
        }
        this.modified = false;
        return this.encodedSessionString;
    }

    public String toString() {
        return "[attributes=" + this.getAttributes() + "]";
    }

    static {
        CLIENT_SESSION_ATTRIBUTE_NVP_NAME = CLIENT_SESSION_ATTRIBUTE_NVP_NAME;
        OPTION_COMPRESS_CLIENT_SESSION = true;
        CLIENT_SESSION_COMPRESSION_THRESHOLD = 1024;
    }
}

