/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.dbtrans.DbTranslation;
import com.iplanet.xslui.dbtrans.DbTranslationTable;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.CacheableXML;
import com.iplanet.xslui.ui.ElementHandler;
import com.iplanet.xslui.ui.FormHandler;
import com.iplanet.xslui.ui.ProcessingHandler;
import com.iplanet.xslui.ui.XSLUILocator;
import com.iplanet.xslui.ui.XSLUILocatorHandler;
import com.iplanet.xslui.ui.XSLXMLCache;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLDOMContentHandler;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import com.iplanet.xslui.xslutil.XSLProcessorPool;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public class XSLUIEngine {
    public static final String CONFIG_FILENAME = "xsluiengine.properties";
    public static final String CONFIG_RELOADONCHANGE = "reloadonchange";
    public static final String CONFIG_USETRANSLETS = "useTranslets";
    public static final String CONFIG_XMLHANDLER_PREFIX = "xmlhandler.";
    public static final String CONFIG_HANDLER_XLATEPATH = ".xlatepath";
    public static final String CONFIG_XSLUILOCATORHANDLER = "xsluilocatorhandler";
    public static final String CONFIG_FORMHANDLER_PREFIX = "formhandler.";
    public static final String CONFIG_FORMHANDLER_ACTION = "actionattributename";
    public static final String CONFIG_FORMHANDLER_NEXTVIEW = ".nextview";
    public static final String CONFIG_FORMHANDLER_ERRORVIEW = ".errorview";
    public static final String CONFIG_PROCHANDLER_PREFIX = "prochandler.";
    public static final String CONFIG_ROOTPATH = "defaultxsluilocatorhandler.rootpath";
    private HashMap _elementHandlerTable = null;
    private HashMap _formHandlerTable = null;
    private HashMap _procHandlerTable = null;
    private XSLXMLCache _xslxmlCache = null;
    private XSLUILocatorHandler _locatorHandler = null;
    private XSLXMLLogHandler _logHandler = null;
    private XMLDOMBuilder _xmlBuilder = null;
    private DbTranslationTable _dbTransTable = null;
    private boolean _useGzip = false;
    private boolean _useTranslets = false;
    private String _formActionAttribute = null;
    private String[] _weekday = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private String _uiRootPath = null;

    public XSLUIEngine(File configPath, XSLXMLLogHandler logHandler) throws IOException {
        String key;
        String tmpPath = null;
        this._logHandler = logHandler;
        PropertyReader propertyReader = null;
        try {
            propertyReader = new PropertyReader(configPath, CONFIG_FILENAME);
        }
        catch (Exception ex) {
            throw new IOException("XSLUIEngine: can't open configuration file at " + configPath.toString() + " : " + ex.getMessage());
        }
        boolean reload = propertyReader.getBooleanProperty(CONFIG_RELOADONCHANGE, "false");
        tmpPath = propertyReader.getStringProperty(CONFIG_ROOTPATH, "../ui");
        this._uiRootPath = new File(configPath, tmpPath).getAbsolutePath();
        this._xslxmlCache = new XSLXMLCache(reload, this._logHandler, this._uiRootPath);
        this._useTranslets = propertyReader.getBooleanProperty(CONFIG_USETRANSLETS, "false");
        this._formActionAttribute = propertyReader.getStringProperty("formhandler.actionattributename", "myaction");
        this._dbTransTable = DbTranslationTable.getInstance();
        this._elementHandlerTable = new HashMap();
        Enumeration enumeration = propertyReader.getKeyProperty(CONFIG_XMLHANDLER_PREFIX, ".class");
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            this.loadXMLHandler(propertyReader, key);
        }
        this._formHandlerTable = new HashMap();
        enumeration = propertyReader.getKeyProperty(CONFIG_FORMHANDLER_PREFIX, ".class");
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            this.loadFormHandler(propertyReader, key);
        }
        this._procHandlerTable = new HashMap();
        enumeration = propertyReader.getKeyProperty(CONFIG_PROCHANDLER_PREFIX, ".class");
        while (enumeration.hasMoreElements()) {
            key = (String)enumeration.nextElement();
            this.loadProcHandler(propertyReader, key);
        }
        try {
            this._locatorHandler = (XSLUILocatorHandler)propertyReader.getObjectProperty(CONFIG_XSLUILOCATORHANDLER, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("XSLUIEngine: couldn't load locator: " + ex.getMessage());
        }
        if (this._locatorHandler == null) {
            throw new IOException("XSLUIEngine: couldn't load locator: xsluilocatorhandler");
        }
        boolean initialized = this._locatorHandler.init(configPath, propertyReader.getProperties(), this._logHandler);
        if (!initialized) {
            throw new IOException("XSLUIEngine: couldn't initialize locator");
        }
        try {
            this._xmlBuilder = XMLDOMBuilder.getInstance((XSLXMLLogHandler)this._logHandler);
        }
        catch (XMLProcessingException xpe) {
            throw new IOException("XSLUIEngine.process: Couldn't create XMLDOMBuilder: " + xpe.getMessage());
        }
    }

    public void process(HttpServletRequest req, HttpServletResponse resp, String xmlTemplate) throws IOException {
        String cset;
        String[] pathList;
        Element errorRootElt;
        Document errorDoc;
        XSLUILocator locator;
        Date tBegining;
        ServletOutputStream out;
        block55: {
            out = null;
            tBegining = new Date();
            locator = this._locatorHandler.getLocator(req);
            if (locator == null) {
                resp.sendError(404, "XSLUIEngine.process: couldn't find locator");
                return;
            }
            errorDoc = null;
            errorRootElt = null;
            errorDoc = this._xmlBuilder.newDocument();
            try {
                errorRootElt = errorDoc.createElement("errormessages");
            }
            catch (DOMException e) {
                if (!this._logHandler.isLogEnabled()) break block55;
                this._logHandler.error("XSLUIEngine.process: Could not create errorRootElt: " + e.getMessage());
            }
        }
        String action = null;
        String next_view = null;
        next_view = req.getParameter("nextview");
        String[] actionTable = req.getParameterValues(this._formActionAttribute);
        if (actionTable != null) {
            if (actionTable.length == 1) {
                if (actionTable[0].length() > 0) {
                    action = actionTable[0];
                    FormHandler formHandler = (FormHandler)this._formHandlerTable.get(action);
                    if (formHandler != null) {
                        boolean success = formHandler.process(req, errorRootElt);
                        xmlTemplate = success ? (next_view != null && next_view.length() > 0 ? next_view : formHandler.getNextView()) : formHandler.getErrorView();
                    } else if (this._logHandler.isLogEnabled()) {
                        this._logHandler.error("XSLUIEngine.process: unrecognized action: " + action);
                    }
                }
            } else if (this._logHandler.isLogEnabled()) {
                this._logHandler.error("XSLUIEngine.process: more than one action: " + actionTable.length);
            }
        }
        if (xmlTemplate == null && (xmlTemplate = locator.getXMLTemplate()) == null) {
            resp.sendError(404, "XSLUIEngine.process: Couldn't find template name");
            return;
        }
        if (!xmlTemplate.endsWith(".xml") && !xmlTemplate.endsWith(".xsl")) {
            int separator = xmlTemplate.lastIndexOf(".");
            xmlTemplate = separator > 0 ? xmlTemplate.substring(0, separator) + ".xml" : xmlTemplate + ".xml";
        }
        if ((pathList = locator.getPathList()) == null) {
            resp.sendError(404, "XSLUIEngine.process: Couldn't find path list");
            return;
        }
        String dictionaryName = locator.getDictionaryName();
        out = resp.getOutputStream();
        CacheableXML cachedXMLDoc = null;
        Document xmlDoc = null;
        try {
            cachedXMLDoc = this._xslxmlCache.getXMLTemplateCacheable(xmlTemplate, pathList);
        }
        catch (XMLProcessingException xe) {
            xe.printStackTrace(new PrintStream((OutputStream)out));
            return;
        }
        if (cachedXMLDoc == null) {
            out.close();
            resp.sendError(404, "XSLUIEngine.process: couldn't find template Document " + xmlTemplate);
            return;
        }
        xmlDoc = (Document)cachedXMLDoc.getObject();
        if (xmlDoc == null) {
            out.close();
            resp.sendError(404, "XSLUIEngine.process: couldn't find XML Document " + xmlTemplate);
            return;
        }
        ProcInstruction procInstruction = new ProcInstruction(xmlDoc);
        String processingTemplateName = procInstruction.getHRef();
        if (processingTemplateName == null) {
            if (dictionaryName != null) {
                try {
                    cachedXMLDoc = this._xslxmlCache.getXMLTemplateCacheable(xmlTemplate, dictionaryName, pathList);
                }
                catch (XMLProcessingException xe) {
                    xe.printStackTrace(new PrintStream((OutputStream)out));
                    return;
                }
                if (cachedXMLDoc == null) {
                    throw new IOException("XSLUIEngine.process: Couldn't find translated template Document");
                }
                xmlDoc = (Document)cachedXMLDoc.getObject();
                if (xmlDoc == null) {
                    throw new IOException("XSLUIEngine.process: Couldn't find XML translated Document " + xmlTemplate);
                }
            }
            long lCacheDateServerSide = cachedXMLDoc.getLastLoaded();
            Date dCacheDateServerSide = new Date(lCacheDateServerSide);
            long lCacheDateClientSide = req.getDateHeader("If-Modified-Since");
            if (lCacheDateClientSide < 0L || lCacheDateServerSide - lCacheDateClientSide >= 1000L) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(dCacheDateServerSide);
                String dow_CacheDateServerSide = this._weekday[cal.get(7) - 1];
                byte[] xml2return = cachedXMLDoc.getXMLContent();
                resp.setContentType("text/xml");
                resp.setHeader("Last-Modified", dow_CacheDateServerSide + ", " + dCacheDateServerSide.toGMTString());
                resp.setHeader("Content-Length", String.valueOf(xml2return.length));
                out.write(xml2return);
            } else {
                if (this._logHandler.isLogEnabled()) {
                    this._logHandler.debug("XSLUIEngine.process GET request for file : " + xmlTemplate + ". Client cached file up to date. Returning status " + 304 + ".");
                }
                resp.setStatus(304);
            }
            out.close();
            return;
        }
        Date tBeforeExpand = new Date();
        XMLExpandHandler expander = new XMLExpandHandler(req, this._elementHandlerTable, errorDoc, errorRootElt);
        Document expandedDoc = null;
        try {
            expandedDoc = this._xmlBuilder.newDocument(xmlDoc);
            expandedDoc.removeChild(expandedDoc.getDocumentElement());
            expandedDoc.appendChild(this._xmlBuilder.copyNode((Node)xmlDoc.getDocumentElement(), expandedDoc, (XMLDOMContentHandler)expander));
            if (errorRootElt.hasChildNodes()) {
                expandedDoc.getDocumentElement().appendChild(this._xmlBuilder.copyNode((Node)errorRootElt, expandedDoc));
            }
        }
        catch (XMLProcessingException xpe) {
            throw new IOException("XSLUIEngine.process: Error while expanding tree: " + xpe.getMessage());
        }
        Date tAfterExpand = new Date();
        String encodedURL = resp.encodeURL("/").substring(1);
        if (req.isRequestedSessionIdFromURL()) {
            encodedURL = ";jsessionid=" + req.getRequestedSessionId();
        }
        Element rootElement = expandedDoc.getDocumentElement();
        rootElement.setAttribute("sessionstring", encodedURL);
        String contextURI = req.getContextPath();
        if (contextURI == null || contextURI != null && contextURI.trim().length() == 0) {
            contextURI = "";
        }
        rootElement.setAttribute("contexturi", contextURI);
        if (action != null) {
            rootElement.setAttribute("uiaction", action);
        }
        if (!xmlTemplate.equalsIgnoreCase(next_view) && next_view != null) {
            rootElement.setAttribute("nextview", next_view);
        } else {
            rootElement.setAttribute("nextview", "");
        }
        String dumpXML = req.getParameter("dumpXML");
        if (dumpXML == null) {
            dumpXML = rootElement.getAttribute("dumpXML");
        }
        if (dumpXML != null && dumpXML.equals("1")) {
            Date tBeforeDumping = new Date();
            resp.setContentType("text/xml");
            try {
                for (Node child = expandedDoc.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNodeType() != 7) continue;
                    expandedDoc.removeChild(child);
                }
                XMLDOMBuilder.dumpNode((Node)expandedDoc, (OutputStream)out);
            }
            catch (XMLProcessingException xpe) {
                throw new IOException("XSLUIEngine.process: Couldn't dump expanded XML" + xmlTemplate + " : " + xpe.getMessage());
            }
            out.close();
            if (this._logHandler.isLogEnabled()) {
                Date tAfterDumping = new Date();
                Date tEnd = new Date();
                long tTotal = tEnd.getTime() - tBegining.getTime();
                long tPreproc = tBeforeExpand.getTime() - tBegining.getTime();
                long tExpand = tAfterExpand.getTime() - tBeforeExpand.getTime();
                long tInter = tBeforeDumping.getTime() - tAfterExpand.getTime();
                long tDumping = tAfterDumping.getTime() - tBeforeDumping.getTime();
                long tFinal = tEnd.getTime() - tAfterDumping.getTime();
                this._logHandler.debug("Total       time: " + tTotal);
                this._logHandler.debug("Preprocess  time: " + tPreproc + " (" + tPreproc * 100L / tTotal + "%)");
                this._logHandler.debug("Expand      time: " + tExpand + " (" + tExpand * 100L / tTotal + "%)");
                this._logHandler.debug("Inter proc  time: " + tInter + " (" + tInter * 100L / tTotal + "%)");
                this._logHandler.debug("Dumping     time: " + tDumping + " (" + tDumping * 100L / tTotal + "%)");
            }
            return;
        }
        boolean isXSLProcessing = procInstruction.isTypeXSL();
        if (isXSLProcessing && locator.supportClientXSLProcessing()) {
            Date tBeforeDumping = new Date();
            resp.setContentType("text/xml");
            try {
                XMLDOMBuilder.dumpNode((Node)expandedDoc, (OutputStream)out);
            }
            catch (XMLProcessingException xpe) {
                throw new IOException("XSLUIEngine.process: Couldn't dump expanded XML" + xmlTemplate + " : " + xpe.getMessage());
            }
            Date tAfterDumping = new Date();
            out.close();
            Date tEnd = new Date();
            long tTotal = tEnd.getTime() - tBegining.getTime();
            long tPreproc = tBeforeExpand.getTime() - tBegining.getTime();
            long tExpand = tAfterExpand.getTime() - tBeforeExpand.getTime();
            long tInter = tBeforeDumping.getTime() - tAfterExpand.getTime();
            long tDumping = tAfterDumping.getTime() - tBeforeDumping.getTime();
            long tFinal = tEnd.getTime() - tAfterDumping.getTime();
            this._logHandler.debug("Total       time: " + tTotal);
            this._logHandler.debug("Preprocess  time: " + tPreproc + " (" + tPreproc * 100L / tTotal + "%)");
            this._logHandler.debug("Expand      time: " + tExpand + " (" + tExpand * 100L / tTotal + "%)");
            this._logHandler.debug("Inter proc  time: " + tInter + " (" + tInter * 100L / tTotal + "%)");
            this._logHandler.debug("Dumping     time: " + tDumping + " (" + tDumping * 100L / tTotal + "%)");
            return;
        }
        String contentTypeString = null;
        String ctype = rootElement.getAttribute("content-type");
        if (ctype == null || ctype.length() <= 0) {
            ctype = "text/html";
        }
        if ((cset = rootElement.getAttribute("charset")) == null || cset.length() > 0) {
            cset = "UTF-8";
        }
        contentTypeString = ctype + "; " + "charset" + "=" + cset;
        resp.setContentType(contentTypeString);
        if (!isXSLProcessing) {
            ProcessingHandler hook = (ProcessingHandler)this._procHandlerTable.get(processingTemplateName);
            if (hook != null) {
                try {
                    hook.process(req, expandedDoc, (OutputStream)out);
                }
                catch (Exception e) {
                    this._logHandler.error("ProcessingHandler hook: Error while processing: " + e.getClass() + ": " + e.getMessage());
                    e.printStackTrace();
                }
                out.close();
                return;
            }
            this._logHandler.error("ProcessingHandler hook: hook not found: " + processingTemplateName);
        }
        XSLProcessorPool xslProcessorPool = null;
        try {
            xslProcessorPool = this._xslxmlCache.getXSLProcessorPool(processingTemplateName, dictionaryName, pathList);
        }
        catch (XMLProcessingException xe) {
            xe.printStackTrace(new PrintStream((OutputStream)out));
            return;
        }
        if (xslProcessorPool == null) {
            throw new IOException("XSLUIEngine.process: Couldn't find XSLProcessorPool: " + processingTemplateName);
        }
        Date tBeforeProcessing = new Date();
        try {
            xslProcessorPool.process(expandedDoc, (OutputStream)out, this._useTranslets);
        }
        catch (XSLProcessingException xpe) {
            PrintStream pstream = new PrintStream((OutputStream)out);
            pstream.println("Error while processing " + processingTemplateName);
            xpe.printStackTrace(pstream);
            return;
        }
        Date tAfterProcessing = new Date();
        out.close();
        Date tEnd = new Date();
        long tTotal = tEnd.getTime() - tBegining.getTime();
        long tPreproc = tBeforeExpand.getTime() - tBegining.getTime();
        long tExpand = tAfterExpand.getTime() - tBeforeExpand.getTime();
        long tInter = tBeforeProcessing.getTime() - tAfterExpand.getTime();
        long tProcessing = tAfterProcessing.getTime() - tBeforeProcessing.getTime();
        long tFinal = tEnd.getTime() - tAfterProcessing.getTime();
        this._logHandler.debug("Total       time: " + tTotal);
        this._logHandler.debug("Preprocess  time: " + tPreproc + " (" + tPreproc * 100L / tTotal + "%)");
        this._logHandler.debug("Expand      time: " + tExpand + " (" + tExpand * 100L / tTotal + "%)");
        this._logHandler.debug("Inter proc  time: " + tInter + " (" + tInter * 100L / tTotal + "%)");
        this._logHandler.debug("Process     time: " + tProcessing + " (" + tProcessing * 100L / tTotal + "%)");
        this._logHandler.debug("Final       time: " + tFinal + " (" + tFinal * 100L / tTotal + "%)");
    }

    private void loadXMLHandler(PropertyReader propertyReader, String key) {
        ElementHandler handler = null;
        try {
            handler = (ElementHandler)propertyReader.getObjectProperty(CONFIG_XMLHANDLER_PREFIX + key, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this._logHandler.error("XSLUIEngine: couldn't load " + key + " : " + ex.getMessage());
            return;
        }
        boolean initialized = handler.init(propertyReader, this._logHandler);
        if (initialized) {
            File xlateConfigPath = propertyReader.getFileProperty(CONFIG_XMLHANDLER_PREFIX + key + CONFIG_HANDLER_XLATEPATH, "");
            if (xlateConfigPath != null) {
                DbTranslation translator = null;
                try {
                    translator = this._dbTransTable.getDbTransObj(xlateConfigPath);
                }
                catch (Exception dte) {
                    dte.printStackTrace();
                    this._logHandler.error("XSLUIEngine: couldn't load xlator for " + key + " : " + dte + " : " + dte.getMessage());
                    return;
                }
                handler.setTranslator(translator);
            }
            this._elementHandlerTable.put(key, handler);
            this._logHandler.debug("XSLUIEngine.loadElementHandler: adding a handler for element " + key);
        } else {
            this._logHandler.error("XSLUIEngine: couldn't initialize " + key);
        }
    }

    private void loadFormHandler(PropertyReader propertyReader, String key) {
        FormHandler handler = null;
        handler = (FormHandler)this._formHandlerTable.get(key);
        if (handler != null) {
            return;
        }
        try {
            handler = (FormHandler)propertyReader.getObjectProperty(CONFIG_FORMHANDLER_PREFIX + key, false);
        }
        catch (Exception ex) {
            this._logHandler.error("XSLUIEngine.loadFormHandler: couldn't load " + key + " : " + ex.getMessage());
            ex.printStackTrace();
            return;
        }
        boolean initialized = handler.init(key, propertyReader, this._logHandler);
        if (!initialized) {
            this._logHandler.error("XSLUIEngine.loadFormHandler: couldn't initialize " + key);
        }
        String view = propertyReader.getStringProperty(CONFIG_FORMHANDLER_PREFIX + key + CONFIG_FORMHANDLER_NEXTVIEW, null);
        handler.setNextView(view);
        view = propertyReader.getStringProperty(CONFIG_FORMHANDLER_PREFIX + key + CONFIG_FORMHANDLER_ERRORVIEW, null);
        handler.setErrorView(view);
        File xlateConfigPath = propertyReader.getFileProperty(CONFIG_FORMHANDLER_PREFIX + key + CONFIG_HANDLER_XLATEPATH, "");
        if (xlateConfigPath != null) {
            DbTranslation translator = null;
            try {
                translator = this._dbTransTable.getDbTransObj(xlateConfigPath);
            }
            catch (Exception dte) {
                this._logHandler.error("XSLUIEngine: couldn't load xlator" + key + " : " + dte.getMessage());
                return;
            }
            handler.setTranslator(translator);
        }
        this._formHandlerTable.put(key, handler);
        this._logHandler.debug("XSLUIEngine.loadFormHandler: adding a handler for action " + key);
    }

    private void loadProcHandler(PropertyReader propertyReader, String key) {
        ProcessingHandler handler = null;
        try {
            handler = (ProcessingHandler)propertyReader.getObjectProperty(CONFIG_PROCHANDLER_PREFIX + key, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this._logHandler.error("XSLUIEngine: couldn't load " + key + " : " + ex.getMessage());
            return;
        }
        boolean initialized = handler.init(propertyReader, this._logHandler);
        if (initialized) {
            File xlateConfigPath = propertyReader.getFileProperty(CONFIG_PROCHANDLER_PREFIX + key + CONFIG_HANDLER_XLATEPATH, "");
            if (xlateConfigPath != null) {
                DbTranslation translator = null;
                try {
                    translator = this._dbTransTable.getDbTransObj(xlateConfigPath);
                }
                catch (Exception dte) {
                    this._logHandler.error("XSLUIEngine: couldn't load xlator for " + key + " : " + dte + " : " + dte.getMessage());
                    return;
                }
                handler.setTranslator(translator);
            }
            this._procHandlerTable.put(key, handler);
            this._logHandler.debug("XSLUIEngine.loadProcHandler: adding a handler for element " + key);
        } else {
            this._logHandler.error("XSLUIEngine: couldn't initialize " + key);
        }
    }

    private class XMLExpandHandler
    extends XMLDOMContentHandler {
        private HashMap _elementHandlerTable = null;
        private HttpServletRequest _httpRequest = null;
        private Document _errorDoc = null;
        private Element _errorRootElt = null;

        public XMLExpandHandler(HttpServletRequest httpRequest, HashMap elementHandlerTable, Document errorDoc, Element errorRootElt) {
            this._elementHandlerTable = elementHandlerTable;
            this._httpRequest = httpRequest;
            this._errorDoc = errorDoc;
            this._errorRootElt = errorRootElt;
        }

        public void preElementHandler(Element element, Document doc) {
            ElementHandler elementHandler = (ElementHandler)this._elementHandlerTable.get(element.getTagName());
            if (elementHandler == null) {
                return;
            }
            try {
                elementHandler.preExpand(this._httpRequest, element, this._errorRootElt);
            }
            catch (Exception e) {
                XSLUIEngine.this._logHandler.error("XMLExpandHandler.preElementHandler: Error while pre-processing <" + element.getTagName() + ">: " + e.getClass() + ": " + e.getMessage());
            }
        }

        public void elementHandler(Element element, Document doc) {
            ElementHandler elementHandler = (ElementHandler)this._elementHandlerTable.get(element.getTagName());
            if (elementHandler == null) {
                return;
            }
            try {
                elementHandler.expand(this._httpRequest, element, this._errorRootElt);
            }
            catch (Exception e) {
                e.printStackTrace();
                XSLUIEngine.this._logHandler.error("XMLExpandHandler.elementHandler: Error while processing <" + element.getTagName() + ">: " + e.getClass() + ": " + e.getMessage());
            }
        }
    }

    private class ProcInstruction {
        private String _type = null;
        private String _href = null;

        public ProcInstruction(Document doc) {
            for (Node child = doc.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
                int endHref;
                int beginHref;
                int endType;
                int beginType;
                ProcessingInstruction pi;
                String piContent;
                if (child.getNodeType() != 7 || (piContent = (pi = (ProcessingInstruction)child).getData()) == null || (beginType = piContent.indexOf("type") + 6) == -1 || (endType = piContent.indexOf("\"", beginType)) == -1 || (beginHref = piContent.indexOf("href") + 6) == -1 || (endHref = piContent.indexOf("\"", beginHref)) == -1) continue;
                this._type = piContent.substring(beginType, endType);
                this._href = piContent.substring(beginHref, endHref);
            }
        }

        public String getType() {
            return this._type;
        }

        public String getHRef() {
            return this._href;
        }

        public boolean isTypeXSL() {
            return this._type != null && this._type.equals("text/xsl");
        }
    }
}

