/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.ui.CacheableObject;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XMLTranslator;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;

public class CacheableTranslator
extends CacheableObject {
    private File _xmlFile = null;
    private long _lastModified = 0L;

    public CacheableTranslator(XSLXMLLogHandler errorHandler) {
        super(errorHandler);
    }

    public CacheableTranslator(File xmlFile, XSLXMLLogHandler errorHandler) throws XMLProcessingException {
        super(errorHandler);
        this._xmlFile = xmlFile;
        this.checkReloadLeaf();
        super.setLastLoaded();
    }

    protected synchronized boolean checkReloadLeaf() throws XMLProcessingException {
        if (this._xmlFile == null) {
            throw new XMLProcessingException("xmlFile is null");
        }
        if (!this._xmlFile.exists()) {
            throw new XMLProcessingException("CacheableTranslator.checkReloadLeaf: xmlFile (" + this._xmlFile.toString() + ") doesn't exist");
        }
        long lastModified = this._xmlFile.lastModified();
        if (this._lastModified >= lastModified) {
            return false;
        }
        XMLTranslator translator = new XMLTranslator(this._xmlFile, this._errorHandler);
        super.setObject(translator);
        super.setLastLoaded();
        this._lastModified = lastModified;
        return true;
    }
}

