/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.xslutil;

import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XSLIncludeResolver;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import com.iplanet.xslui.xslutil.XSLProcessor;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.OutputStream;
import org.w3c.dom.Document;

public class XSLProcessorPool {
    private Document _xslDoc = null;
    private XSLProcessor _xslProcessor = null;
    private XSLIncludeResolver _xslCache = null;
    private XSLXMLLogHandler _errorHandler = null;
    private String _id = null;

    public synchronized void setXSLDoc(Document xslDoc) {
        this._xslDoc = xslDoc;
        this.clear();
    }

    public Document getXSLDoc() {
        return this._xslDoc;
    }

    public void setCacheHandler(XSLIncludeResolver xslCache) {
        this._xslCache = xslCache;
        this.clear();
    }

    public void setErrorHandler(XSLXMLLogHandler errorHandler) {
        this._errorHandler = errorHandler;
        this.clear();
    }

    public void setId(String id) {
        this._id = id;
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Document xmlDoc, OutputStream outputStream, boolean useTranslets) throws XSLProcessingException {
        XSLProcessor xslProcessor;
        Document document = this._xslDoc;
        synchronized (document) {
            if (this._xslProcessor == null) {
                this._xslProcessor = new XSLProcessor(this._xslDoc, this._xslCache, this._errorHandler, this._id, useTranslets);
            }
            xslProcessor = this._xslProcessor;
        }
        xslProcessor.process(xmlDoc, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        if (this._xslDoc != null) {
            Document document = this._xslDoc;
            synchronized (document) {
                this._xslProcessor = null;
            }
        }
    }

    public static void main(String[] args) {
        Document xmldoc = null;
        Document xsldoc = null;
        if (args.length != 2) {
            System.err.println("Usage: XSLProcessorPool <XML file> <XSLT file>");
            System.exit(1);
        }
        String xmlfilename = args[0];
        String xslfilename = args[1];
        XMLDOMBuilder parser = null;
        try {
            parser = new XMLDOMBuilder();
            xmldoc = parser.parse(xmlfilename);
        }
        catch (XMLProcessingException xe) {
            System.err.println("Couldn't parse " + xmlfilename + " : " + xe.getMessage());
            System.exit(1);
        }
        try {
            xsldoc = parser.parse(xslfilename);
        }
        catch (XMLProcessingException xe) {
            System.err.println("Couldn't parse " + xslfilename + " : " + xe.getMessage());
            System.exit(1);
        }
        XSLProcessorPool processorPool = null;
        try {
            processorPool = new XSLProcessorPool();
            processorPool.setXSLDoc(xsldoc);
            processorPool.process(xmldoc, System.out, false);
        }
        catch (XSLProcessingException xe) {
            System.err.println("Couldn't process " + xslfilename + " : " + xe.getMessage());
            System.exit(1);
        }
    }
}

