/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.tools;

import com.iplanet.xslui.tools.MultipartHttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class MultipartRequest {
    private Hashtable _paramTable = null;
    private Hashtable _fileTable = null;

    public MultipartRequest(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("null inputStream");
        }
        this._paramTable = new Hashtable();
        this._fileTable = new Hashtable();
        MimeMessage m = null;
        MimeMultipart mmp = null;
        try {
            m = new MimeMessage(Session.getDefaultInstance((Properties)new Properties(), null), inputStream);
        }
        catch (MessagingException me) {
            throw new IOException("MimeMessage creation failed: " + me.getMessage());
        }
        try {
            mmp = (MimeMultipart)m.getContent();
        }
        catch (MessagingException me) {
            throw new IOException("getContent failed: " + me.getMessage());
        }
        catch (ClassCastException cce) {
            throw new IOException("getContent failed: not Mime content-type " + cce.getMessage());
        }
        try {
            MultipartHttpServletRequest.parseMultiPart(mmp, this._paramTable, this._fileTable);
        }
        catch (IOException ex) {
            throw new IOException("parseMultiPart has thrown IOException: " + ex.getMessage());
        }
        catch (MessagingException ex) {
            throw new IOException("parseMultiPart has thrown MessagingException: " + ex.getMessage());
        }
    }

    public String getParameter(String name) {
        if (name == null) {
            return null;
        }
        String[] paramValues = (String[])this._paramTable.get(name);
        if (paramValues != null) {
            return paramValues[0];
        }
        return null;
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            return null;
        }
        return (String[])this._paramTable.get(name);
    }

    public Enumeration getParameterNames() {
        return this._paramTable.keys();
    }

    public Enumeration getFileParameterNames() {
        return this._fileTable.keys();
    }

    public InputStream getFileParameter(String name) {
        if (name == null) {
            return null;
        }
        return (InputStream)this._fileTable.get(name);
    }

    public static String inputStreamToString(InputStream in) throws IOException {
        return MultipartHttpServletRequest.inputStreamToString(in);
    }
}

