/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.dbtrans;

import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslation;
import com.iplanet.xslui.dbtrans.XML2DbTranslatable;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TwoWayDbTranslation
extends DbTranslation {
    public TwoWayDbTranslation(File configPath) throws DbTransException {
        super(configPath);
    }

    public static void dump(Node node, int depth) {
        if (2 == node.getNodeType()) {
            String value = node.getNodeValue();
            Logging.trace((int)32, (String)("node:(" + depth + ")Attr> " + node.getNodeName() + " (" + node.getPrefix() + "|" + node.getNamespaceURI() + "|" + node.getLocalName() + ") [" + value + "]"));
        } else {
            Node n;
            int i;
            Logging.trace((int)32, (String)("node:(" + depth + ")Name> " + node.getNodeName() + " (" + node.getPrefix() + "|" + node.getNamespaceURI() + "|" + node.getLocalName() + ")"));
            Logging.trace((int)32, (String)("node:(" + depth + ")Class> " + node.getClass().getName() + " Type > " + node.getNodeType()));
            String value = node.getNodeValue();
            if (null != value) {
                Logging.trace((int)32, (String)("node:(" + depth + ")Value> " + value));
            }
            if (node.hasAttributes()) {
                NamedNodeMap map = node.getAttributes();
                for (i = 0; i < map.getLength(); ++i) {
                    n = map.item(i);
                    TwoWayDbTranslation.dump(n, depth + 2);
                }
            }
            if (node.hasChildNodes()) {
                NodeList nl = node.getChildNodes();
                for (i = 0; i < nl.getLength(); ++i) {
                    n = nl.item(i);
                    TwoWayDbTranslation.dump(n, depth + 1);
                }
            }
        }
    }

    public void reverseTranslate(Element entryElement, XML2DbTranslatable dbEntry) throws DbTransException {
        this.reverseTranslate(entryElement, dbEntry, false);
    }

    public void reverseTranslate(Element entryElement, XML2DbTranslatable dbEntry, boolean orderCheck) throws DbTransException {
        if (entryElement == null) {
            throw new DbTransException(10, "null entryElement");
        }
        if (dbEntry == null) {
            throw new DbTransException(10, "null dbEntry");
        }
        String entryType = entryElement.getTagName();
        Document xlateDoc = super.getXlateTreeForXMLType(entryType);
        Element xlateElt = xlateDoc.getDocumentElement();
        String dbType = super.getDbTypeForXMLType(entryType);
        if (dbType == null) {
            throw new DbTransException(7, "getDbTypeForXMLType: can't find xlate template for " + entryType);
        }
        dbEntry.setDbType(dbType);
        boolean success = this.convertWriteTree(xlateElt, entryElement, dbEntry, false, orderCheck);
        if (!success) {
            throw new DbTransException(11);
        }
    }

    private boolean convertWriteTree(Element xlateElt, Element dataElt, XML2DbTranslatable dbEntry, boolean cursing, boolean orderCheck) throws DbTransException {
        Element currentXlateElt = xlateElt;
        Element currentDataElt = dataElt;
        String attrToWriteName = null;
        ArrayList<String> attrToWriteValues = null;
        ArrayList<String> xlateEltsMatched = new ArrayList<String>();
        HashMap removeDbFields = new HashMap(3);
        do {
            if (currentXlateElt == null) {
                if (attrToWriteName == null) break;
                dbEntry.setDbValues(attrToWriteName, attrToWriteValues.toArray(new String[1]));
                attrToWriteName = null;
                break;
            }
            String dataEltName = null;
            String xlateEltName = currentXlateElt.getNodeName();
            if (!xlateEltName.equals(dataEltName = currentDataElt.getNodeName())) {
                if (attrToWriteName != null) {
                    dbEntry.setDbValues(attrToWriteName, attrToWriteValues.toArray(new String[1]));
                    attrToWriteName = null;
                }
                if ((currentXlateElt = this.getNextElementSibling(currentXlateElt)) != null) continue;
                if (!orderCheck || xlateEltsMatched.contains(dataEltName)) break;
                return false;
            }
            Element matchingXlateElt = currentXlateElt;
            boolean found = false;
            HashMap<String, String> tempAttrs = new HashMap<String, String>(3);
            HashMap<String, String> tempRemoveAttrs = new HashMap<String, String>(3);
            boolean fixed_attr = false;
            Object varDataVal = null;
            while (!found && matchingXlateElt != null && matchingXlateElt.getNodeName().equals(currentDataElt.getNodeName())) {
                Attr dataattr;
                boolean isVarExpr = false;
                fixed_attr = false;
                tempAttrs.clear();
                tempRemoveAttrs.clear();
                int i = 0;
                NamedNodeMap data_attr_list = currentDataElt.getAttributes();
                boolean match = true;
                while (match && data_attr_list != null && (dataattr = (Attr)data_attr_list.item(i++)) != null) {
                    String fieldValue;
                    String dataname = dataattr.getName();
                    Attr xlateattr = matchingXlateElt.getAttributeNode(dataname);
                    if (xlateattr == null) {
                        if (!orderCheck) continue;
                        return false;
                    }
                    String axlatename = xlateattr.getName();
                    String axlateval = xlateattr.getValue();
                    boolean is_db = false;
                    boolean is_oc = false;
                    if (axlateval.startsWith("db:var:")) {
                        isVarExpr = true;
                    }
                    if (axlateval.startsWith("db:")) {
                        is_db = true;
                    } else if (axlateval.startsWith("oc:")) {
                        is_oc = true;
                    }
                    String adataval = null;
                    dataattr = currentDataElt.getAttributeNode(axlatename);
                    if (dataattr != null) {
                        adataval = dataattr.getValue();
                    }
                    boolean varExprContainVal = false;
                    if (isVarExpr && axlateval.indexOf("=") > -1) {
                        varExprContainVal = true;
                    }
                    if (!is_db && !is_oc || varExprContainVal) {
                        fixed_attr = true;
                        String valToCompare = axlateval;
                        int x = axlateval.indexOf("=");
                        if (varExprContainVal) {
                            valToCompare = axlateval.substring(x + 1);
                        }
                        if (adataval != null && !valToCompare.equals(adataval)) {
                            match = false;
                            break;
                        }
                        if (varExprContainVal) {
                            String field = axlateval.substring("db:var:".length(), x);
                            int index = this.getVarExprIndex(field);
                            field = field.substring(0, field.indexOf("["));
                            adataval = this.updateVarExprValue((String)tempAttrs.get(field), adataval, index);
                            tempAttrs.put(field, adataval);
                        }
                    } else {
                        if (axlateval.startsWith("db:xml:") || axlateval.startsWith("db:expr:") || axlateval.startsWith("db:count:")) continue;
                        String field = null;
                        int index = 0;
                        if (isVarExpr) {
                            field = axlateval.substring("db:var:".length());
                            index = this.getVarExprIndex(field);
                            if (index < 0) {
                                throw new DbTransException(2, "Invalid expression for field");
                            }
                            field = field.substring(0, field.indexOf("["));
                        } else {
                            field = axlateval.substring("db:".length());
                        }
                        tempRemoveAttrs.put(field, "");
                        if (adataval != null) {
                            if (isVarExpr) {
                                adataval = this.updateVarExprValue((String)tempAttrs.get(field), adataval, index);
                            }
                            tempAttrs.put(field, adataval);
                        }
                    }
                    if (!is_oc || (fieldValue = axlateval.substring("oc:".length())).length() <= 0) continue;
                    tempAttrs.put("objectclass", fieldValue);
                }
                if (match) {
                    if (orderCheck && !xlateEltsMatched.contains(xlateEltName)) {
                        xlateEltsMatched.add(xlateEltName);
                    }
                    found = true;
                    continue;
                }
                matchingXlateElt = this.getNextElementSibling(matchingXlateElt);
            }
            if (!found) {
                if (orderCheck) {
                    return false;
                }
                if ((currentDataElt = this.getNextElementSibling(currentDataElt)) != null) continue;
                break;
            }
            boolean hasTextualContent = true;
            String xlateval = DbTranslation.getElementContent(matchingXlateElt);
            if (xlateval == null) {
                hasTextualContent = false;
                if (tempAttrs.size() > 0) {
                    this.writeAttrFromMap(dbEntry, tempAttrs, true);
                }
            } else if (xlateval.startsWith("db:")) {
                Node prev;
                String dataval = DbTranslation.getElementContent(currentDataElt);
                String fieldname = xlateval.substring(xlateval.lastIndexOf(":") + 1);
                if (xlateval.startsWith("db:expr:")) {
                    int j;
                    fieldname = xlateval;
                    int i = "db:expr:".length();
                    i = fieldname.indexOf("db:", i);
                    char ch = fieldname.charAt(j);
                    for (j = i + "db:".length(); ch != '+' && ch != '|' && j < fieldname.length(); ++j) {
                        ch = fieldname.charAt(j);
                    }
                    if (j < fieldname.length()) {
                        --j;
                    }
                    fieldname = fieldname.substring(i + "db:".length(), j);
                }
                if (xlateval.startsWith("db:var:")) {
                    int index = this.getVarExprIndex(fieldname);
                    int x = fieldname.indexOf("[");
                    if (x > -1) {
                        fieldname = fieldname.substring(0, x);
                    }
                    dataval = this.updateVarExprValue((String)tempAttrs.get(fieldname), dataval, index);
                    tempAttrs.put(fieldname, dataval);
                }
                if ((prev = currentDataElt.getPreviousSibling()) != null && !fixed_attr && currentDataElt.getNodeName().equals(prev.getNodeName())) {
                    if (dataval != null && dataval.trim().length() > 0) {
                        if (attrToWriteName == null) {
                            attrToWriteName = fieldname;
                            attrToWriteValues = new ArrayList<String>();
                        }
                        attrToWriteValues.add(dataval);
                        removeDbFields.remove(fieldname);
                        if (tempAttrs.size() > 0) {
                            this.writeAttrFromMap(dbEntry, tempAttrs, true);
                        }
                    }
                } else {
                    Object write_val = null;
                    int x = fieldname.indexOf("[");
                    if (x > -1) {
                        fieldname = fieldname.substring(0, x);
                    }
                    if (xlateval.startsWith("db:xml:")) {
                        ByteArrayOutputStream ostream = new ByteArrayOutputStream(64);
                        try {
                            XMLDOMBuilder.dumpNode(currentDataElt, ostream, false);
                        }
                        catch (Exception xpe) {
                            throw new DbTransException(3, "Couldn't dump Elt " + currentDataElt.getTagName() + ":" + xpe.getMessage());
                        }
                        dataval = ostream.toString();
                        int index1 = dataval.indexOf(">");
                        int index2 = dataval.lastIndexOf("<");
                        if (index1 < 0 || index2 < 0) {
                            throw new DbTransException(3, "Couldn't dump/analyze Elt " + currentDataElt.getTagName());
                        }
                        dataval = dataval.substring(index1 + 1, index2);
                    }
                    if (attrToWriteName != null) {
                        dbEntry.setDbValues(attrToWriteName, attrToWriteValues.toArray(new String[1]));
                        attrToWriteName = null;
                    }
                    if (dataval == null || dataval != null && dataval.trim().length() == 0) {
                        removeDbFields.put(fieldname, tempRemoveAttrs);
                    } else {
                        if (tempAttrs.size() > 0) {
                            this.writeAttrFromMap(dbEntry, tempAttrs, true);
                        }
                        if (!xlateval.startsWith("db:var:")) {
                            attrToWriteName = fieldname;
                            attrToWriteValues = new ArrayList();
                            attrToWriteValues.add(dataval);
                        }
                    }
                }
            }
            if (!hasTextualContent && matchingXlateElt.hasChildNodes() && currentDataElt.hasChildNodes()) {
                Node xlateFirstChild = matchingXlateElt.getFirstChild();
                if (!(xlateFirstChild instanceof Element)) {
                    throw new DbTransException(2, "converWriteTree: Non Element child found in " + matchingXlateElt.getTagName());
                }
                Node dataFirstChild = currentDataElt.getFirstChild();
                if (!(dataFirstChild instanceof Element)) {
                    throw new DbTransException(4, "converWriteTree: Non Element child found in " + currentDataElt.getTagName());
                }
                boolean success = this.convertWriteTree((Element)xlateFirstChild, (Element)dataFirstChild, dbEntry, true, orderCheck);
                if (!success) {
                    return false;
                }
            }
            if (!cursing) break;
            currentDataElt = this.getNextElementSibling(currentDataElt);
        } while (currentDataElt != null);
        if (!removeDbFields.isEmpty() && removeDbFields.size() > 0) {
            Set keysSet = removeDbFields.keySet();
            String[] keys = keysSet.toArray(new String[0]);
            for (int i = 0; i < keys.length; ++i) {
                String fieldname = keys[i];
                dbEntry.removeDbValues(fieldname);
                HashMap removeAttrsMap = (HashMap)removeDbFields.get(fieldname);
                if (removeAttrsMap.size() <= 0) continue;
                this.writeAttrFromMap(dbEntry, removeAttrsMap, false);
            }
        }
        if (attrToWriteName != null) {
            dbEntry.setDbValues(attrToWriteName, attrToWriteValues.toArray(new String[1]));
        }
        return true;
    }

    private void writeAttrFromMap(XML2DbTranslatable dbEntry, HashMap tempAttrs, boolean isWrite) {
        Iterator attrIterator = tempAttrs.entrySet().iterator();
        while (attrIterator.hasNext()) {
            Map.Entry mapEntry = attrIterator.next();
            String attrName = (String)mapEntry.getKey();
            String[] attrValues = new String[]{(String)mapEntry.getValue()};
            if (isWrite) {
                dbEntry.setDbValues(attrName, attrValues);
                continue;
            }
            dbEntry.removeDbValues(attrName);
        }
    }

    private Element getNextElementSibling(Node node) {
        Node currNode = node.getNextSibling();
        while (currNode != null && !(currNode instanceof Element)) {
            currNode = node.getNextSibling();
            String val = currNode.getNodeValue();
            if (val == null || val.trim().length() != 0) continue;
            Logging.trace((int)2, (String)"hitting edge case no more siblings returning null");
            currNode = null;
            break;
        }
        return (Element)currNode;
    }

    private String updateVarExprValue(String existingADataval, String adataval, int index) {
        if (existingADataval != null && existingADataval.length() > 0) {
            String[] adatavalTokens = existingADataval.split("\\|");
            StringBuffer newadatavalBuf = new StringBuffer();
            int loopCount = 0;
            loopCount = index >= adatavalTokens.length ? index : adatavalTokens.length;
            for (int k = 0; k <= loopCount; ++k) {
                if (k == index) {
                    newadatavalBuf.append(adataval);
                } else if (adatavalTokens[k] != null) {
                    newadatavalBuf.append(adatavalTokens[k]);
                }
                if (k >= loopCount) continue;
                newadatavalBuf.append("|");
            }
            return newadatavalBuf.toString();
        }
        return adataval;
    }

    private int getVarExprIndex(String field) {
        int x = field.indexOf("[");
        int y = field.indexOf("]");
        if (x > -1 && y > -1) {
            try {
                return Integer.parseInt(field.substring(x + 1, y));
            }
            catch (Exception e) {
                Logging.error((int)2, (String)("Error in var parsing -- " + e.getMessage()));
                return -1;
            }
        }
        return 0;
    }
}

