/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.dbtrans;

import com.iplanet.xslui.dbtrans.DbTransException;
import com.iplanet.xslui.dbtrans.DbTranslatable;
import com.iplanet.xslui.dbtrans.XlateFilenameFilter;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XPathTools;
import com.iplanet.xslui.xslutil.XSLProcessingException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DbTranslation {
    protected XMLDOMBuilder _domBuilder = null;
    private Document[] _dom_tables = null;
    private Hashtable _return_attributes = null;
    private ArrayList _xlate_entry_types = null;
    private ArrayList _xlate_names = null;

    public DbTranslation(File configPath) throws DbTransException {
        if (configPath == null) {
            throw new DbTransException(10, "null configPath");
        }
        try {
            this._domBuilder = XMLDOMBuilder.getInstance();
        }
        catch (XMLProcessingException e) {
            throw new DbTransException(3, "Can not create XMLDOMBuilder : " + e.getMessage());
        }
        this._xlate_entry_types = new ArrayList();
        this._xlate_names = new ArrayList();
        this._dom_tables = this.loadXlateDocs(this._xlate_entry_types, this._xlate_names, configPath);
        this._return_attributes = DbTranslation.loadRetAttribs(this._xlate_entry_types, this._dom_tables);
    }

    public Element translate(DbTranslatable dbEntry, Element docHanger) throws DbTransException {
        if (dbEntry == null) {
            throw new DbTransException(10, "null dbEntry");
        }
        if (docHanger == null) {
            throw new DbTransException(10, "null docHanger");
        }
        Document resultTree = docHanger.getOwnerDocument();
        if (resultTree == null) {
            throw new DbTransException(10, "null resultTree");
        }
        String[] dbTypes = dbEntry.getDbTypes();
        if (dbTypes == null) {
            throw new DbTransException(7, "translate: getDbTypes returned null");
        }
        int xlateIndex = -1;
        for (int i = 0; i < dbTypes.length; ++i) {
            if (dbTypes[i] == null) {
                throw new DbTransException(7, "translate: null dbType");
            }
            xlateIndex = this._xlate_names.indexOf(dbTypes[i].toUpperCase());
            if (xlateIndex != -1) break;
        }
        if (xlateIndex == -1) {
            throw new DbTransException(7, "translate: can't find xlate template for " + dbTypes[0]);
        }
        Document xlateDoc = this._dom_tables[xlateIndex];
        if (xlateDoc == null) {
            throw new DbTransException(7, "translate: wrong xlate template: " + xlateIndex + " for " + dbTypes.toString());
        }
        DocumentFragment docFrag = resultTree.createDocumentFragment();
        this.processXlateTree(xlateDoc.getDocumentElement(), dbEntry, false, docFrag, resultTree, null);
        if (!docFrag.hasChildNodes()) {
            throw new DbTransException(8, "translate: doc fragment has no child");
        }
        Element elt = (Element)docFrag.getFirstChild();
        if (elt == null) {
            throw new DbTransException(7, "translate: doc fragment has null child");
        }
        docHanger.appendChild(docFrag);
        return elt;
    }

    public Element translate(DbTranslatable dbEntry) throws DbTransException {
        if (dbEntry == null) {
            throw new DbTransException(10, "null dbEntry");
        }
        Document dummyDoc = null;
        Element dummyElement = null;
        try {
            dummyDoc = this._domBuilder.newDocument();
            dummyElement = dummyDoc.createElement("dummyElement");
            dummyDoc.appendChild(dummyElement);
        }
        catch (DOMException e) {
            throw new DbTransException(3, "DbTranslation.translate: Creation of dummyDoc failed : " + e.getMessage());
        }
        return this.translate(dbEntry, dummyElement);
    }

    public String getDbTypeForXMLType(String xmlType) {
        int xlateIndex = this._xlate_entry_types.indexOf(xmlType);
        if (xlateIndex == -1) {
            return null;
        }
        return (String)this._xlate_names.get(xlateIndex);
    }

    public String[] getXMLTypes() {
        return this._xlate_entry_types.toArray(new String[this._xlate_entry_types.size()]);
    }

    public String[] getDbAttributeList(ArrayList dbTypes) {
        if (dbTypes == null) {
            return null;
        }
        ArrayList<String> tmp = new ArrayList<String>();
        String[] sTmp = null;
        for (int i = 0; i < dbTypes.size(); ++i) {
            if (dbTypes.get(i) == null || (sTmp = (String[])this._return_attributes.get(dbTypes.get(i))) == null || sTmp.length <= 0) continue;
            for (int j = 0; j < sTmp.length; ++j) {
                if (DbTranslation.containsCaseInsensitive(tmp, sTmp[j]) || sTmp[j] == null || sTmp[j].length() <= 0) continue;
                tmp.add(sTmp[j].toLowerCase());
            }
        }
        String[] res = null;
        if (tmp.size() != 0) {
            res = tmp.toArray(new String[0]);
            return res;
        }
        return null;
    }

    public String[] getAllDbAttributeList() {
        String[] all = (String[])this._return_attributes.get("All");
        return all;
    }

    public ArrayList xlateXPathField(String xpathField, boolean deepSearch, ArrayList entryTypes) throws DbTransException {
        ArrayList dbFieldArray = new ArrayList();
        this.xlateXPathField(xpathField, deepSearch, entryTypes, dbFieldArray);
        if (dbFieldArray.isEmpty()) {
            return null;
        }
        return dbFieldArray;
    }

    public void xlateXPathField(String xpathField, boolean deepSearch, ArrayList entryTypes, ArrayList dbAttrs) throws DbTransException {
        if (xpathField == null) {
            throw new DbTransException(10, "null xpathField");
        }
        if (dbAttrs == null) {
            throw new DbTransException(10, "null dbAttrs");
        }
        Document[] xlates = null;
        if (entryTypes != null && !entryTypes.isEmpty()) {
            xlates = new Document[entryTypes.size()];
            for (int i = entryTypes.size() - 1; i >= 0; --i) {
                xlates[i] = this.getXlateTreeForXMLType((String)entryTypes.get(i));
            }
        } else {
            xlates = this._dom_tables;
        }
        boolean is_db = false;
        Object tmpstr = null;
        for (int ets = 0; ets < xlates.length; ++ets) {
            Document xlate_doc = xlates[ets];
            ArrayList found_nodes = new ArrayList(6);
            Element xlatebase = xlate_doc.getDocumentElement();
            try {
                XPathTools.getNodesByXPath(xlatebase, xpathField, found_nodes);
            }
            catch (XSLProcessingException xpe) {
                throw new DbTransException(3, "XSL Exception is: " + xpe.toString());
            }
            for (int i = 0; i < found_nodes.size(); ++i) {
                Node found_node = (Node)found_nodes.get(i);
                if (found_node instanceof Element && deepSearch) {
                    DbTranslation.addChildren(found_node, dbAttrs);
                    continue;
                }
                is_db = DbTranslation.getNodeContent(found_node, dbAttrs);
            }
        }
    }

    private Document[] loadXlateDocs(ArrayList entry_types, ArrayList xlate_names, File db_config_dir) throws DbTransException {
        XlateFilenameFilter xlate_filter = new XlateFilenameFilter();
        String[] xlate_list = db_config_dir.list(xlate_filter);
        if (xlate_list == null) {
            throw new DbTransException(1, "loadXlateDocs: directory doesn't exist " + db_config_dir.toString());
        }
        if (xlate_list.length <= 0) {
            throw new DbTransException(1, "loadXlateDocs: no xlate-*.xml file found under " + db_config_dir.toString());
        }
        Document[] dom_tables = new Document[xlate_list.length];
        Object tmp = null;
        for (int x = 0; x < xlate_list.length; ++x) {
            String entry_type;
            Document xlate_doc;
            String xlate_filename = xlate_list[x];
            File db_xlate_file = new File(db_config_dir, xlate_filename);
            if (!db_xlate_file.canRead()) {
                throw new DbTransException(1, db_config_dir + xlate_filename);
            }
            try {
                xlate_doc = this._domBuilder.parse(db_xlate_file);
                entry_type = xlate_doc.getDocumentElement().getNodeName();
            }
            catch (XMLProcessingException xpe) {
                throw new DbTransException(2, db_config_dir + xlate_filename);
            }
            entry_types.add(entry_type);
            xlate_names.add(xlate_filename.toUpperCase().substring(6, xlate_filename.length() - 4));
            dom_tables[x] = xlate_doc;
        }
        return dom_tables;
    }

    private static boolean processDBexpr(String tmpstr, ArrayList retDBattribs) {
        boolean retval = false;
        if (tmpstr.indexOf(58, 3) == -1) {
            retDBattribs.add(tmpstr.substring(3));
            retval = true;
        } else {
            block0 : switch (tmpstr.charAt(3)) {
                case 'x': {
                    retDBattribs.add(tmpstr.substring(7));
                    retval = true;
                    break;
                }
                case 'v': {
                    String valToRet = tmpstr.substring("db:var:".length());
                    int x = valToRet.indexOf("[");
                    if (x > -1) {
                        valToRet = valToRet.substring(0, x);
                    }
                    retDBattribs.add(valToRet);
                    retval = true;
                    break;
                }
                case 'c': {
                    break;
                }
                case 'e': {
                    int start_index = 0;
                    while ((start_index = tmpstr.indexOf("db:", start_index)) != -1) {
                        retval = true;
                        int end_index = tmpstr.indexOf(43, start_index);
                        if (end_index != -1) {
                            while (tmpstr.charAt(end_index - 1) == ' ') {
                                --end_index;
                            }
                        }
                        if (end_index == -1) {
                            retDBattribs.add(tmpstr.substring(start_index));
                            break block0;
                        }
                        retDBattribs.add(tmpstr.substring(start_index++, end_index - 1));
                    }
                    break;
                }
            }
        }
        return retval;
    }

    private static void addChildren(Node enode, ArrayList retDBattribs) {
        if (enode.getNodeType() == 3) {
            String tmpstr = enode.getNodeValue();
            if (tmpstr.startsWith("db:")) {
                DbTranslation.processDBexpr(tmpstr, retDBattribs);
            }
        } else if (enode instanceof Element) {
            if (enode.hasAttributes()) {
                NamedNodeMap attrs = enode.getAttributes();
                int att_cnt = attrs.getLength();
                for (int ac = 0; ac < att_cnt; ++ac) {
                    Attr attr = (Attr)attrs.item(ac);
                    String tmpstr = attr.getValue();
                    if (tmpstr == null || !tmpstr.startsWith("db:")) continue;
                    DbTranslation.processDBexpr(tmpstr, retDBattribs);
                }
            }
            if (enode.hasChildNodes()) {
                NodeList subs = enode.getChildNodes();
                int node_cnt = subs.getLength();
                for (int sl = 0; sl < node_cnt; ++sl) {
                    Node snode = subs.item(sl);
                    DbTranslation.addChildren(snode, retDBattribs);
                }
            }
        }
    }

    private static boolean getNodeContent(Node node, ArrayList conv_fields) {
        String value = null;
        boolean is_db = false;
        if (node instanceof Attr) {
            value = node.getNodeValue();
        } else if (node instanceof Element) {
            value = DbTranslation.getElementContent(node);
        }
        if (value != null && value.startsWith("db:")) {
            is_db = DbTranslation.processDBexpr(value, conv_fields);
        } else if (value != null && value.length() > 0) {
            conv_fields.add(value);
        }
        return is_db;
    }

    protected static String getElementContent(Node node) {
        Node curNode;
        for (curNode = node.getFirstChild(); curNode != null && curNode.getNodeType() != 3; curNode = curNode.getNextSibling()) {
        }
        if (curNode != null) {
            return curNode.getNodeValue();
        }
        return null;
    }

    private static String parseSubExpr(String dbfield, DbTranslatable dbEntry) throws DbTransException {
        int char_at = 0;
        String[] dbvals = null;
        String fieldName = null;
        String[] tmp = null;
        dbvals = new String[]{""};
        while (char_at < dbfield.length() && char_at >= 0) {
            char curchar = dbfield.charAt(char_at);
            switch (curchar) {
                case '+': {
                    ++char_at;
                    break;
                }
                case ' ': {
                    ++char_at;
                    break;
                }
                case '\'': {
                    int endstr = dbfield.indexOf(39, char_at + 1);
                    dbvals[0] = dbvals[0] + dbfield.substring(char_at + 1, endstr);
                    char_at = endstr + 1;
                    break;
                }
                case 'd': {
                    int end_index = dbfield.indexOf(43, char_at);
                    if (end_index != -1) {
                        while (dbfield.charAt(end_index - 1) == ' ') {
                            --end_index;
                        }
                    }
                    fieldName = end_index == -1 ? dbfield.substring(dbfield.indexOf("db:", char_at) + "db:".length()) : dbfield.substring(dbfield.indexOf("db:", char_at) + "db:".length(), end_index);
                    char_at = end_index;
                    tmp = null;
                    tmp = new String[1];
                    try {
                        tmp = dbEntry.getDbValue(fieldName);
                    }
                    catch (Exception ex) {
                        throw new DbTransException(7, "dbReadinst db: " + ex.getMessage());
                    }
                    if (tmp != null) {
                        dbvals[0] = dbvals[0] + tmp[0];
                        break;
                    }
                    if (end_index != -1) break;
                    return null;
                }
            }
        }
        if (dbvals != null) {
            return dbvals[0];
        }
        return null;
    }

    private static String[] parseDbExpr(String dbfield, DbTranslatable dbEntry, int counter) throws DbTransException {
        String[] dbvals = null;
        String[] tmp = null;
        String fieldName = null;
        int end_index = 0;
        if (dbfield.startsWith("db:param:")) {
            fieldName = dbfield.substring("db:param:".length());
            dbvals = new String[1];
            try {
                tmp = dbEntry.getDbValue(fieldName);
                if (tmp != null) {
                    dbvals[0] = tmp[0];
                }
                dbvals = null;
            }
            catch (Exception ex) {
                throw new DbTransException(7, "dbReadinst db:param:" + ex.getMessage());
            }
        } else if (dbfield.startsWith("db:count:")) {
            dbvals = new String[]{Integer.toString(counter + 1)};
        } else if (dbfield.startsWith("db:var:")) {
            fieldName = dbfield.substring("db:var:".length());
            int x = fieldName.indexOf("[");
            int y = fieldName.indexOf("]");
            int index = 0;
            if (x < 0 && y < 0) {
                throw new DbTransException(7, "dbReadinst - invalid variable definition");
            }
            try {
                index = Integer.parseInt(fieldName.substring(x + 1, y));
            }
            catch (Exception e) {
                throw new DbTransException(7, "dbReadinst - invalid variable definition" + e.getMessage());
            }
            fieldName = fieldName.substring(0, x);
            dbvals = dbEntry.getDbValue(fieldName);
        } else if (dbfield.startsWith("db:expr:")) {
            int nbDbFound = 0;
            int nbDbNull = 0;
            String subExpr = null;
            String res = null;
            int curChar = 0;
            boolean allOrProcessed = false;
            fieldName = dbfield.substring("db:expr:".length());
            dbvals = new String[1];
            while (curChar < dbfield.length() && curChar >= 0 && !allOrProcessed) {
                ++nbDbFound;
                end_index = fieldName.indexOf("||", curChar);
                if (end_index == -1) {
                    allOrProcessed = true;
                    res = DbTranslation.parseSubExpr(fieldName = fieldName.substring(curChar), dbEntry);
                    if (res != null) {
                        dbvals[0] = res;
                        continue;
                    }
                    dbvals = null;
                    continue;
                }
                subExpr = fieldName.substring(curChar, end_index);
                try {
                    res = DbTranslation.parseSubExpr(subExpr, dbEntry);
                }
                catch (DbTransException ex) {
                    throw new DbTransException(7, "dbReadinst db:param:" + ex.getMessage());
                }
                curChar = end_index + 2;
                if (res == null) {
                    ++nbDbNull;
                    continue;
                }
                allOrProcessed = true;
                dbvals[0] = res;
            }
            if (nbDbNull == nbDbFound) {
                dbvals = null;
            }
        } else {
            fieldName = dbfield.substring(dbfield.lastIndexOf(58) + 1);
            try {
                dbvals = dbEntry.getDbValue(fieldName);
            }
            catch (Exception ex) {
                throw new DbTransException(7, "dbReadinst db: " + ex.getMessage());
            }
        }
        return dbvals;
    }

    private boolean processXlateTree(Node pres_node, DbTranslatable dbEntry, boolean taking_children, DocumentFragment doc_frag, Document doc, String db_type) throws DbTransException {
        DocumentFragment current_hanger = doc_frag;
        boolean ret_val = false;
        boolean no_data = true;
        String precNodeName = null;
        int count = 0;
        while (pres_node != null) {
            no_data = true;
            NamedNodeMap attrs = null;
            if (pres_node.hasAttributes()) {
                attrs = pres_node.getAttributes();
            }
            if (pres_node instanceof Element) {
                boolean now_taking_children = taking_children;
                Element e = null;
                boolean this_node_attached = false;
                String[] dbvals = null;
                String dbfield = DbTranslation.getElementContent(pres_node);
                String curNodeName = null;
                curNodeName = pres_node.getNodeName();
                if (dbfield != null) {
                    if (dbfield.startsWith("db:")) {
                        dbvals = DbTranslation.parseDbExpr(dbfield, dbEntry, count);
                    } else if (now_taking_children) {
                        dbvals = new String[]{dbfield};
                    }
                    if (dbvals != null) {
                        for (int vals = 0; vals < dbvals.length; ++vals) {
                            String dbfieldName = DbTranslation.getDBFieldName(dbfield);
                            e = doc.createElement(pres_node.getNodeName());
                            current_hanger.appendChild(e);
                            if (dbfield.startsWith("db:var:") && attrs != null) {
                                int att_cnt = attrs.getLength();
                                for (int ac = 0; ac < att_cnt; ++ac) {
                                    String attrfieldName;
                                    Attr attr = (Attr)attrs.item(ac);
                                    String attr_field = attr.getValue();
                                    if (attr_field == null || !dbfieldName.equalsIgnoreCase(attrfieldName = DbTranslation.getDBFieldName(attr_field))) continue;
                                    String dbval = dbvals[vals];
                                    int index = DbTranslation.getVarExprIndex(attr_field);
                                    if (dbval == null || dbval.length() <= 0 || (dbval = DbTranslation.getVarExprVal(dbval, index)) == null) continue;
                                    Attr new_attr = doc.createAttribute(attr.getName());
                                    new_attr.setValue(dbval);
                                    e.setAttributeNode(new_attr);
                                }
                            }
                            if (dbfield.startsWith("db:xml:")) {
                                try {
                                    dbvals[vals] = URLDecoder.decode(dbvals[vals], "UTF-8");
                                    this._domBuilder.insertNodeFromString(doc, e, dbvals[vals]);
                                    continue;
                                }
                                catch (XMLProcessingException xpe) {
                                    throw new DbTransException(4, "field = " + dbfield + ", value = " + dbvals[vals]);
                                }
                                catch (UnsupportedEncodingException ue) {
                                    continue;
                                }
                            }
                            if (dbvals[vals] != null) {
                                String dbval = dbvals[vals];
                                if (dbfield.startsWith("db:var:")) {
                                    int index = DbTranslation.getVarExprIndex(dbfield);
                                    dbval = DbTranslation.getVarExprVal(dbval, index);
                                }
                                Text cdata = doc.createTextNode(dbval);
                                e.appendChild(cdata);
                            }
                            this_node_attached = true;
                            now_taking_children = true;
                        }
                        no_data = false;
                    } else {
                        no_data = true;
                    }
                }
                boolean child_found = false;
                DocumentFragment new_doc_frag = null;
                if (pres_node.hasChildNodes()) {
                    new_doc_frag = doc.createDocumentFragment();
                    child_found = this.processXlateTree(pres_node.getFirstChild(), dbEntry, now_taking_children, new_doc_frag, doc, db_type);
                }
                ArrayList<Attr> attr_list = new ArrayList<Attr>(8);
                boolean attr_found = false;
                boolean countexpr = false;
                dbvals = null;
                if (attrs != null) {
                    int att_cnt = attrs.getLength();
                    for (int ac = 0; ac < att_cnt; ++ac) {
                        Attr attr = (Attr)attrs.item(ac);
                        dbfield = attr.getValue();
                        if (dbfield != null) {
                            if (dbfield.startsWith("db:var:")) continue;
                            countexpr = dbfield.startsWith("db:count:");
                            if (countexpr && !no_data) {
                                count = !curNodeName.equals(precNodeName) ? 0 : ++count;
                                precNodeName = curNodeName;
                            }
                            if (dbfield.startsWith("db:")) {
                                dbvals = DbTranslation.parseDbExpr(dbfield, dbEntry, count);
                                int index = -1;
                                if (dbfield.startsWith("db:var:")) {
                                    String[] varExprVals;
                                    index = DbTranslation.getVarExprIndex(dbfield);
                                    dbvals[0] = index >= (varExprVals = dbvals[0].split("\\|")).length ? null : varExprVals[index];
                                }
                                if (dbvals != null && !countexpr) {
                                    attr_found = true;
                                }
                            } else if (now_taking_children || child_found) {
                                dbvals = new String[]{dbfield};
                            }
                        }
                        if (dbvals == null) continue;
                        Attr new_attr = doc.createAttribute(attr.getName());
                        new_attr.setValue(dbvals[0]);
                        attr_list.add(new_attr);
                    }
                }
                if ((child_found || attr_found) && !this_node_attached) {
                    e = doc.createElement(pres_node.getNodeName());
                    current_hanger.appendChild(e);
                    this_node_attached = true;
                }
                if (this_node_attached && attr_list.size() > 0) {
                    for (int i = 0; i < attr_list.size(); ++i) {
                        e.setAttributeNode((Attr)attr_list.get(i));
                    }
                }
                if (child_found) {
                    e.appendChild(new_doc_frag);
                }
                if (this_node_attached) {
                    ret_val = true;
                }
            }
            pres_node = pres_node.getNextSibling();
        }
        return ret_val;
    }

    protected Document getXlateTreeForXMLType(String xmlType) throws DbTransException {
        int xlateIndex = this._xlate_entry_types.indexOf(xmlType);
        if (xlateIndex == -1) {
            throw new DbTransException(7, "getXlateTreeForXMLType: can't find xlate template for " + xmlType);
        }
        Document xlateDoc = this._dom_tables[xlateIndex];
        if (xlateDoc == null) {
            throw new DbTransException(7, "getXlateTreeForXMLType: null xlate template for " + xmlType);
        }
        return xlateDoc;
    }

    private static ArrayList getAttribContent(Node node) {
        ArrayList<String> values = new ArrayList<String>();
        String value = null;
        int ch = 32;
        if (node == null) {
            return null;
        }
        value = node.getNodeValue();
        if (value != null && value.startsWith("db:xml:")) {
            values.add(value.substring("db:xml:".length()));
            return values;
        }
        if (value != null && value.startsWith("db:var:")) {
            int x = (value = value.substring("db:var:".length())).indexOf("[");
            if (x > -1) {
                value = value.substring(0, x);
            }
            values.add(value);
            return values;
        }
        if (value != null && value.startsWith("db:expr:")) {
            int i = "db:expr:".length();
            int j = 0;
            i = value.indexOf("db:", i);
            while (i != -1 && i < value.length()) {
                ch = value.charAt(j);
                for (j = i + "db:".length(); ch != 43 && ch != 124 && j < value.length(); ++j) {
                    ch = value.charAt(j);
                }
                if (j < value.length()) {
                    --j;
                }
                values.add(value.substring(i + "db:".length(), j));
                i = value.indexOf("db:", j);
            }
            return values;
        }
        if (value != null && value.startsWith("db:")) {
            values.add(value.substring("db:".length()));
            return values;
        }
        return null;
    }

    private static Hashtable loadRetAttribs(ArrayList xlateNames, Document[] xlateDocs) {
        if (xlateNames == null || xlateDocs == null) {
            return null;
        }
        Hashtable<String, String[]> retAttribs = new Hashtable<String, String[]>();
        ArrayList vAllRetAttribs = new ArrayList();
        ArrayList vAttrs = null;
        for (int i = 0; i < xlateNames.size(); ++i) {
            Document doc = null;
            doc = DbTranslation.getXlateDoc(xlateDocs, (String)xlateNames.get(i));
            Element root = doc.getDocumentElement();
            if (doc == null) {
                return null;
            }
            vAttrs = DbTranslation.getNodeAttributes(doc, vAttrs);
            String[] sAttrs = null;
            sAttrs = vAttrs.toArray(new String[0]);
            vAttrs = null;
            retAttribs.put((String)xlateNames.get(i), sAttrs);
        }
        vAttrs = null;
        for (int j = 0; j < xlateDocs.length; ++j) {
            vAttrs = DbTranslation.getNodeAttributes(xlateDocs[j], vAttrs);
        }
        String[] sAllRetAttribs = vAttrs.toArray(new String[0]);
        retAttribs.put("All", sAllRetAttribs);
        return retAttribs;
    }

    private static boolean containsCaseInsensitive(ArrayList v, String value) {
        if (v == null || value == null) {
            return false;
        }
        for (int j = 0; j < v.size(); ++j) {
            if (!value.equalsIgnoreCase((String)v.get(j))) continue;
            return true;
        }
        return false;
    }

    private static int getVarExprIndex(String field) {
        int x = field.indexOf("[");
        int y = field.indexOf("]");
        if (x > -1 && y > -1) {
            try {
                return Integer.parseInt(field.substring(x + 1, y));
            }
            catch (Exception e) {
                Logging.error((int)2, (String)("Error in var parsing -- " + e.getMessage()));
                return -1;
            }
        }
        return -1;
    }

    private static ArrayList getNodeAttributes(Node presNode, ArrayList attribs) {
        if (presNode == null) {
            return null;
        }
        if (attribs == null) {
            attribs = new ArrayList();
        }
        ArrayList values = null;
        String value = null;
        while (presNode != null) {
            NamedNodeMap list;
            values = DbTranslation.getAttribContent(presNode);
            if (values != null) {
                for (int i = 0; i < values.size(); ++i) {
                    value = (String)values.get(i);
                    if (DbTranslation.containsCaseInsensitive(attribs, value)) continue;
                    attribs.add(value.toLowerCase());
                }
            }
            if ((list = presNode.getAttributes()) != null) {
                for (int j = 0; j < list.getLength(); ++j) {
                    attribs = DbTranslation.getNodeAttributes(list.item(j), attribs);
                }
            }
            if (presNode.hasChildNodes()) {
                attribs = DbTranslation.getNodeAttributes(presNode.getFirstChild(), attribs);
            }
            presNode = presNode.getNextSibling();
        }
        return attribs;
    }

    private static String getVarExprVal(String dbval, int index) {
        String[] varExprVals = dbval.split("\\|");
        if (index >= varExprVals.length) {
            return null;
        }
        return varExprVals[index];
    }

    private static String getDBFieldName(String dbfield) {
        String resultString = dbfield;
        if (dbfield.startsWith("db:var:")) {
            resultString = dbfield.substring("db:var:".length());
            int bracIndex = resultString.indexOf("[");
            if (bracIndex > -1) {
                resultString = resultString.substring(0, bracIndex);
            }
        } else if (dbfield.startsWith("db:")) {
            resultString = dbfield.substring("db:".length());
        } else if (dbfield.startsWith("db:count:")) {
            resultString = dbfield.substring("db:count:".length());
        } else if (dbfield.startsWith("db:param:")) {
            resultString = dbfield.substring("db:param:".length());
        }
        return resultString;
    }

    private static Document getXlateDoc(Document[] docs, String xlateName) {
        for (int i = 0; i < docs.length; ++i) {
            Element root = docs[i].getDocumentElement();
            if (!root.getNodeName().equals(xlateName)) continue;
            return docs[i];
        }
        return null;
    }
}

