/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.util.Date;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class ConnectionPool {
    private int poolSize;
    private int poolMax;
    private String host;
    private int port;
    private String authdn;
    private String authpw;
    private LDAPConnection ldc = null;
    private Vector pool;
    private boolean debugMode;

    public ConnectionPool(int n, int n2, String string, int n3, String string2, String string3) throws LDAPException {
        this(n, n2, string, n3, string2, string3, null);
    }

    public ConnectionPool(int n, int n2, String string, int n3) throws LDAPException {
        this(n, n2, string, n3, "", "");
    }

    public ConnectionPool(String string, int n) throws LDAPException {
        this(10, 20, string, n, "", "");
    }

    public ConnectionPool(int n, int n2, LDAPConnection lDAPConnection) throws LDAPException {
        this(n, n2, lDAPConnection.getHost(), lDAPConnection.getPort(), lDAPConnection.getAuthenticationDN(), lDAPConnection.getAuthenticationPassword(), lDAPConnection);
    }

    private ConnectionPool(int n, int n2, String string, int n3, String string2, String string3, LDAPConnection lDAPConnection) throws LDAPException {
        this.poolSize = n;
        this.poolMax = n2;
        this.host = string;
        this.port = n3;
        this.authdn = string2;
        this.authpw = string3;
        this.ldc = lDAPConnection;
        this.debugMode = false;
        this.createPool();
    }

    public void destroy() {
        for (int i = 0; i < this.pool.size(); ++i) {
            this.disconnect((LDAPConnectionObject)this.pool.elementAt(i));
        }
        this.pool.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConnection getConnection() {
        LDAPConnection lDAPConnection;
        while ((lDAPConnection = this.getConnFromPool()) == null) {
            Vector vector = this.pool;
            synchronized (vector) {
                try {
                    this.pool.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return lDAPConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConnection getConnection(int n) {
        LDAPConnection lDAPConnection;
        while ((lDAPConnection = this.getConnFromPool()) == null) {
            long l = System.currentTimeMillis();
            if (n <= 0) {
                return lDAPConnection;
            }
            Vector vector = this.pool;
            synchronized (vector) {
                try {
                    this.pool.wait(n);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
            long l2 = System.currentTimeMillis();
            n = (int)((long)n - (l2 - l));
        }
        return lDAPConnection;
    }

    protected synchronized LDAPConnection getConnFromPool() {
        int n;
        LDAPConnection lDAPConnection = null;
        LDAPConnectionObject lDAPConnectionObject = null;
        int n2 = this.pool.size();
        for (n = 0; n < n2; ++n) {
            LDAPConnectionObject lDAPConnectionObject2 = (LDAPConnectionObject)this.pool.elementAt(n);
            if (!lDAPConnectionObject2.isAvailable()) continue;
            lDAPConnectionObject = lDAPConnectionObject2;
            break;
        }
        if (lDAPConnectionObject == null) {
            if (this.poolMax < 0 || this.poolMax > 0 && n2 < this.poolMax) {
                n = this.addConnection();
                if (n >= 0) {
                    lDAPConnectionObject = (LDAPConnectionObject)this.pool.elementAt(n);
                }
            } else {
                this.debug("All pool connections in use");
            }
        }
        if (lDAPConnectionObject != null) {
            lDAPConnectionObject.setInUse(true);
            lDAPConnection = lDAPConnectionObject.getLDAPConn();
        }
        return lDAPConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(LDAPConnection lDAPConnection) {
        int n = this.find(lDAPConnection);
        if (n != -1) {
            LDAPConnectionObject lDAPConnectionObject = (LDAPConnectionObject)this.pool.elementAt(n);
            lDAPConnectionObject.setInUse(false);
            Vector vector = this.pool;
            synchronized (vector) {
                this.pool.notifyAll();
            }
        }
    }

    public void printPool() {
        System.out.println("--ConnectionPool--");
        for (int i = 0; i < this.pool.size(); ++i) {
            LDAPConnectionObject lDAPConnectionObject = (LDAPConnectionObject)this.pool.elementAt(i);
            System.out.println("" + i + "=" + lDAPConnectionObject);
        }
    }

    private void disconnect(LDAPConnectionObject lDAPConnectionObject) {
        if (lDAPConnectionObject != null && lDAPConnectionObject.isAvailable()) {
            LDAPConnection lDAPConnection = lDAPConnectionObject.getLDAPConn();
            if (lDAPConnection != null && lDAPConnection.isConnected()) {
                try {
                    lDAPConnection.disconnect();
                }
                catch (LDAPException lDAPException) {
                    this.debug("disconnect: " + lDAPException.toString());
                }
            }
            lDAPConnectionObject.setLDAPConn(null);
        }
    }

    private void createPool() throws LDAPException {
        if (this.poolSize <= 0) {
            throw new LDAPException("ConnectionPoolSize invalid");
        }
        if (this.poolMax < this.poolSize) {
            this.debug("ConnectionPoolMax is invalid, set to " + this.poolSize);
            this.poolMax = this.poolSize;
        }
        this.debug("****Initializing LDAP Pool****");
        this.debug("LDAP host = " + this.host + " on port " + this.port);
        this.debug("Number of connections=" + this.poolSize);
        this.debug("Maximum number of connections=" + this.poolMax);
        this.debug("******");
        this.pool = new Vector();
        this.setUpPool(this.poolSize);
    }

    private int addConnection() {
        int n = -1;
        this.debug("adding a connection to pool...");
        try {
            int n2 = this.pool.size() + 1;
            this.setUpPool(n2);
            if (n2 == this.pool.size()) {
                n = n2 - 1;
            }
        }
        catch (Exception exception) {
            this.debug("Adding a connection: " + exception.toString());
        }
        return n;
    }

    private synchronized void setUpPool(int n) throws LDAPException {
        while (this.pool.size() < n) {
            LDAPConnectionObject lDAPConnectionObject = new LDAPConnectionObject();
            LDAPConnection lDAPConnection = this.ldc != null ? (LDAPConnection)this.ldc.clone() : new LDAPConnection();
            lDAPConnectionObject.setLDAPConn(lDAPConnection);
            try {
                if (lDAPConnection.isConnected()) {
                    lDAPConnection.reconnect();
                } else {
                    lDAPConnection.connect(this.host, this.port, this.authdn, this.authpw);
                }
            }
            catch (LDAPException lDAPException) {
                this.debug("Creating pool:" + lDAPException.toString());
                this.debug("aborting....");
                throw lDAPException;
            }
            lDAPConnectionObject.setInUse(false);
            this.pool.addElement(lDAPConnectionObject);
        }
    }

    private int find(LDAPConnection lDAPConnection) {
        if (lDAPConnection != null) {
            for (int i = 0; i < this.pool.size(); ++i) {
                LDAPConnectionObject lDAPConnectionObject = (LDAPConnectionObject)this.pool.elementAt(i);
                if (lDAPConnectionObject.getLDAPConn() != lDAPConnection) continue;
                return i;
            }
        }
        return -1;
    }

    public synchronized void setDebug(boolean bl) {
        this.debugMode = bl;
    }

    public boolean getDebug() {
        return this.debugMode;
    }

    private void debug(String string) {
        if (this.debugMode) {
            System.out.println("ConnectionPool (" + new Date() + ") : " + string);
        }
    }

    private void debug(String string, boolean bl) {
        if (this.debugMode || bl) {
            System.out.println("ConnectionPool (" + new Date() + ") : " + string);
        }
    }

    class LDAPConnectionObject {
        private LDAPConnection ld;
        private boolean inUse;

        LDAPConnectionObject() {
        }

        LDAPConnection getLDAPConn() {
            return this.ld;
        }

        void setLDAPConn(LDAPConnection lDAPConnection) {
            this.ld = lDAPConnection;
        }

        void setInUse(boolean bl) {
            this.inUse = bl;
        }

        boolean isAvailable() {
            return !this.inUse;
        }

        public String toString() {
            return "LDAPConnection=" + this.ld + ",inUse=" + this.inUse;
        }
    }
}

