/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.beans;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import netscape.ldap.beans.LDAPBasePropertySupport;
import netscape.ldap.util.DN;

public class LDAPIsMember
extends LDAPBasePropertySupport
implements Serializable {
    public static final int OK = 0;
    public static final int INVALID_PARAMETER = 1;
    public static final int CONNECT_ERROR = 2;
    public static final int AUTHENTICATION_ERROR = 3;
    public static final int PROPERTY_NOT_FOUND = 4;
    public static final int AMBIGUOUS_RESULTS = 5;
    public static final int NO_SUCH_OBJECT = 5;
    private String _group = new String("");
    private String _member = new String("");
    private String _result = new String("");

    public LDAPIsMember() {
    }

    public LDAPIsMember(String string, int n, String string2) {
        this.setHost(string);
        this.setPort(n);
        this.setGroup(string2);
    }

    public LDAPIsMember(String string, int n, String string2, String string3, String string4) {
        this.setHost(string);
        this.setPort(n);
        this.setGroup(string4);
        this.setAuthDN(string2);
        this.setAuthPassword(string3);
    }

    private void notifyResult(String string) {
        this.firePropertyChange("result", this._result, string);
        this._result = string;
    }

    public boolean isMember() {
        int n;
        LDAPConnection lDAPConnection;
        boolean bl;
        String string;
        block26: {
            String string2 = this.getHost();
            int n2 = this.getPort();
            String string3 = this.getAuthDN();
            String string4 = this.getAuthPassword();
            string = this.getGroup();
            String string5 = this.getMember();
            this._result = new String("");
            if (string2 == null || string2.length() < 1) {
                this.printDebug("Invalid host name");
                this.setErrorCode(1);
                this.notifyResult(null);
                return false;
            }
            if (string5 == null || string == null || string5.length() < 1 || string.length() < 1) {
                this.printDebug("Invalid member or group name");
                this.setErrorCode(1);
                this.notifyResult(null);
                return false;
            }
            bl = false;
            try {
                lDAPConnection = new LDAPConnection();
                this.printDebug("Connecting to " + string2 + " " + n2);
                this.connect(lDAPConnection, this.getHost(), this.getPort());
            }
            catch (Exception exception) {
                this.printDebug("Failed to connect to " + string2 + ": " + exception.toString());
                this.setErrorCode(2);
                this.notifyResult(null);
                return false;
            }
            if (string3 != null && string4 != null && string3.length() > 0 && string4.length() > 0) {
                this.printDebug("Authenticating " + string3 + " - " + string4);
                try {
                    lDAPConnection.authenticate(string3, string4);
                }
                catch (Exception exception) {
                    this.printDebug("Failed to authenticate to " + string2 + ": " + exception.toString());
                    this.setErrorCode(3);
                    this.notifyResult(null);
                    return false;
                }
            }
            n = 0;
            try {
                Object object;
                String[] stringArray = new String[]{"member", "uniqueMember", "memberOfGroup", "memberurl"};
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 0, "objectclass=*", stringArray, false);
                LDAPEntry lDAPEntry = null;
                LDAPEntry lDAPEntry2 = null;
                while (lDAPSearchResults.hasMoreElements()) {
                    try {
                        lDAPEntry2 = lDAPSearchResults.next();
                        if (n == 0) {
                            lDAPEntry = lDAPEntry2;
                        }
                        if (++n <= 1) continue;
                        this.printDebug("More than one entry found for " + this.getFilter());
                        this.setErrorCode(5);
                        break;
                    }
                    catch (LDAPReferralException lDAPReferralException) {
                        if (!this.getDebug()) continue;
                        this.notifyResult("Referral URLs: ");
                        object = lDAPReferralException.getURLs();
                        for (int i = 0; i < ((LDAPUrl[])object).length; ++i) {
                            this.notifyResult(object[i].getUrl());
                        }
                    }
                    catch (LDAPException lDAPException) {
                        if (!this.getDebug()) continue;
                        this.notifyResult(lDAPException.toString());
                    }
                }
                if (n != true) break block26;
                this.printDebug("... " + lDAPEntry.getDN());
                String string6 = this.normalizeDN(string5);
                object = lDAPEntry.getAttributeSet();
                Enumeration enumeration = ((LDAPAttributeSet)object).getAttributes();
                block13: while (enumeration.hasMoreElements() && !bl) {
                    LDAPAttribute lDAPAttribute = (LDAPAttribute)enumeration.nextElement();
                    this.printDebug(lDAPAttribute.getName() + " = ");
                    boolean bl2 = lDAPAttribute.getName().equalsIgnoreCase("memberurl");
                    Enumeration enumeration2 = lDAPAttribute.getStringValues();
                    if (enumeration2 != null) {
                        while (enumeration2.hasMoreElements()) {
                            String string7 = (String)enumeration2.nextElement();
                            if (bl2 && this.URLMatch(lDAPConnection, string7, string6)) {
                                bl = true;
                                this.setErrorCode(0);
                                continue block13;
                            }
                            this.printDebug("\t\t" + string7);
                            String string8 = this.normalizeDN(string7);
                            if (!string6.equals(string8)) continue;
                            bl = true;
                            this.setErrorCode(0);
                            continue block13;
                        }
                        continue;
                    }
                    this.setErrorCode(4);
                    this.printDebug("Failed to do string conversion for " + lDAPAttribute.getName());
                }
                if (!bl) {
                    this.setErrorCode(4);
                }
            }
            catch (Exception exception) {
                this.printDebug("Failed to search for " + string + ": " + exception.toString());
                this.setErrorCode(5);
            }
        }
        if (n == 0) {
            this.printDebug("No entries found for " + string);
            this.setErrorCode(5);
        }
        try {
            if (lDAPConnection != null && lDAPConnection.isConnected()) {
                lDAPConnection.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            this.notifyResult("Y");
        } else {
            this.notifyResult("N");
        }
        return bl;
    }

    public boolean isMember(String string, int n, String string2, String string3, String string4, String string5) {
        this.setHost(string);
        this.setPort(n);
        this.setAuthDN(string2);
        this.setAuthPassword(string3);
        this.setGroup(string4);
        this.setMember(string5);
        return this.isMember();
    }

    public void isMember(ActionEvent actionEvent) {
        this.isMember();
    }

    public String getGroup() {
        return this._group;
    }

    public void setGroup(String string) {
        this._group = string;
    }

    public String getMember() {
        return this._member;
    }

    public void setMember(String string) {
        this._member = string;
    }

    private String normalizeDN(String string) {
        return new DN(string).toRFCString().toUpperCase();
    }

    private boolean URLMatch(LDAPConnection lDAPConnection, String string, String string2) {
        LDAPUrl lDAPUrl;
        String string3 = string;
        boolean bl = false;
        int n = string.indexOf(":///");
        if (n > 0) {
            string3 = string.substring(0, n) + "://" + lDAPConnection.getHost() + ":" + lDAPConnection.getPort() + string.substring(n + 3);
        }
        this.printDebug("URLMatch: url = " + string3 + ", member DN = " + string2);
        try {
            lDAPUrl = new LDAPUrl(string3);
            this.printDebug("URL ->" + lDAPUrl.getUrl());
        }
        catch (MalformedURLException malformedURLException) {
            this.printDebug("bad URL");
            return bl;
        }
        try {
            LDAPSearchResults lDAPSearchResults = LDAPConnection.search(lDAPUrl);
            String string4 = "";
            while (lDAPSearchResults.hasMoreElements() && !bl) {
                try {
                    string4 = lDAPSearchResults.next().getDN();
                    String string5 = this.normalizeDN(string4);
                    if (!string5.equals(string2)) continue;
                    bl = true;
                    break;
                }
                catch (LDAPReferralException lDAPReferralException) {
                    if (!this.getDebug()) continue;
                    this.notifyResult("Referral URLs: ");
                    LDAPUrl[] lDAPUrlArray = lDAPReferralException.getURLs();
                    for (int i = 0; i < lDAPUrlArray.length; ++i) {
                        this.notifyResult(lDAPUrlArray[i].getUrl());
                    }
                }
                catch (LDAPException lDAPException) {
                    if (!this.getDebug()) continue;
                    this.notifyResult(lDAPException.toString());
                }
            }
        }
        catch (LDAPException lDAPException) {
            this.printDebug("Failed search for url " + lDAPUrl.getUrl());
            this.setErrorCode(5);
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 4) {
            System.out.println("Usage: LDAPIsMember host port group member");
            System.exit(1);
        }
        LDAPIsMember lDAPIsMember = new LDAPIsMember();
        lDAPIsMember.setHost(stringArray[0]);
        lDAPIsMember.setPort(Integer.parseInt(stringArray[1]));
        lDAPIsMember.setGroup(stringArray[2]);
        lDAPIsMember.setMember(stringArray[3]);
        boolean bl = lDAPIsMember.isMember();
        if (!bl) {
            System.out.println("Not a member");
        } else {
            System.out.println("Is a member");
        }
        System.exit(0);
    }
}

