/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.beans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;

public class LDAPBasePropertySupport
implements Serializable {
    public static final int OK = 0;
    public static final int INVALID_PARAMETER = 1;
    public static final int CONNECT_ERROR = 2;
    public static final int AUTHENTICATION_ERROR = 3;
    public static final int PROPERTY_NOT_FOUND = 4;
    public static final int AMBIGUOUS_RESULTS = 5;
    public static final int NO_SUCH_OBJECT = 6;
    private boolean _debug = false;
    private int _errCode = 0;
    private String _host = new String("localhost");
    private int _port = 389;
    private int _scope = 2;
    private String _base = new String("");
    private String _filter = new String("");
    private String _authDN = new String("");
    private String _authPassword = new String("");
    private String _userName = new String("");
    private String _userID = new String("");
    private transient PropertyChangeSupport m_propSupport = new PropertyChangeSupport(this);

    public String getHost() {
        return this._host;
    }

    public void setHost(String string) {
        this._host = string;
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int n) {
        this._port = n;
    }

    public String getBase() {
        return this._base;
    }

    public void setBase(String string) {
        this._base = string;
    }

    public String getAuthDN() {
        return this._authDN;
    }

    public void setAuthDN(String string) {
        this._authDN = string;
    }

    public String getAuthPassword() {
        return this._authPassword;
    }

    public void setAuthPassword(String string) {
        this._authPassword = string;
    }

    public String getUserName() {
        return this._userName;
    }

    public void setUserName(String string) {
        this._userName = string;
    }

    public String getUserID() {
        return this._userID;
    }

    public void setUserID(String string) {
        this._userID = string;
    }

    public int getScope() {
        return this._scope;
    }

    public void setScope(int n) {
        this._scope = n;
    }

    public String getFilter() {
        return this._filter;
    }

    public void setFilter(String string) {
        this._filter = string;
    }

    public boolean getDebug() {
        return this._debug;
    }

    public void setDebug(boolean bl) {
        this._debug = bl;
    }

    public int getErrorCode() {
        return this._errCode;
    }

    public void setErrorCode(int n) {
        this._errCode = n;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.printDebug("Adding listener " + propertyChangeListener);
        this.m_propSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.m_propSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        if (this.m_propSupport == null) {
            this.m_propSupport = new PropertyChangeSupport(this);
        }
        this.m_propSupport.firePropertyChange(string, object, object2);
    }

    protected void printDebug(String string) {
        if (this._debug) {
            System.out.println(string);
        }
    }

    protected void connect(LDAPConnection lDAPConnection, String string, int n) throws LDAPException {
        block14: {
            boolean bl = true;
            SecurityManager securityManager = System.getSecurityManager();
            this.printDebug("Security manager = " + securityManager);
            if (securityManager == null) {
                this.printDebug("No security manager");
                bl = false;
            } else if (securityManager.toString().startsWith("java.lang.NullSecurityManager")) {
                this.printDebug("No security manager");
                bl = false;
            } else if (securityManager.toString().startsWith("netscape.security.AppletSecurity")) {
                try {
                    if (string.equalsIgnoreCase(InetAddress.getLocalHost().getHostName())) {
                        bl = false;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            if (bl) {
                String string2 = "netscape.security.PrivilegeManager";
                try {
                    Class<?> clazz = Class.forName(string2);
                    Method[] methodArray = clazz.getMethods();
                    if (methodArray == null) break block14;
                    for (int i = 0; i < methodArray.length; ++i) {
                        if (!methodArray[i].getName().equals("enablePrivilege")) continue;
                        try {
                            Object[] objectArray = new Object[]{new String("UniversalConnect")};
                            methodArray[i].invoke(null, objectArray);
                            this.printDebug("UniversalConnect enabled");
                            objectArray[0] = new String("UniversalPropertyRead");
                            methodArray[i].invoke(null, objectArray);
                            this.printDebug("UniversalPropertyRead enabled");
                        }
                        catch (Exception exception) {
                            this.printDebug("Exception on invoking enablePrivilege: " + exception.toString());
                        }
                        break;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.printDebug("no " + string2);
                }
            }
        }
        lDAPConnection.connect(string, n);
        this.setDefaultReferralCredentials(lDAPConnection);
    }

    protected void setDefaultReferralCredentials(LDAPConnection lDAPConnection) {
        final LDAPConnection lDAPConnection2 = lDAPConnection;
        LDAPRebind lDAPRebind = new LDAPRebind(){

            public LDAPRebindAuth getRebindAuthentication(String string, int n) {
                return new LDAPRebindAuth(lDAPConnection2.getAuthenticationDN(), lDAPConnection2.getAuthenticationPassword());
            }
        };
        try {
            lDAPConnection.setOption(8, Boolean.TRUE);
            lDAPConnection.setOption(9, lDAPRebind);
        }
        catch (LDAPException lDAPException) {
            // empty catch block
        }
    }

    public String convertToString(String[] stringArray) {
        String string = "";
        if (null != stringArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + stringArray[i] + "\n";
            }
        }
        return string;
    }
}

