/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSchema;

public abstract class LDAPSchemaElement
implements Serializable {
    static final long serialVersionUID = -3972153461950418863L;
    public static final int unknown = 0;
    public static final int cis = 1;
    public static final int binary = 2;
    public static final int telephone = 3;
    public static final int ces = 4;
    public static final int dn = 5;
    public static final int integer = 6;
    protected static final String cisString = "1.3.6.1.4.1.1466.115.121.1.15";
    protected static final String binaryString = "1.3.6.1.4.1.1466.115.121.1.5";
    protected static final String telephoneString = "1.3.6.1.4.1.1466.115.121.1.50";
    protected static final String cesString = "1.3.6.1.4.1.1466.115.121.1.26";
    protected static final String intString = "1.3.6.1.4.1.1466.115.121.1.27";
    protected static final String dnString = "1.3.6.1.4.1.1466.115.121.1.12";
    public static final String OBSOLETE = "OBSOLETE";
    public static final String SUPERIOR = "SUP";
    public static final String SYNTAX = "SYNTAX";
    protected String oid = null;
    protected String name = "";
    protected String description = "";
    protected String attrName = null;
    protected String rawValue = null;
    protected String[] aliases = null;
    protected Hashtable properties = null;
    protected static Hashtable novalsTable = new Hashtable();

    protected LDAPSchemaElement() {
    }

    protected LDAPSchemaElement(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    protected LDAPSchemaElement(String string, String string2, String string3, String[] stringArray) {
        if (string2 == null) {
            throw new IllegalArgumentException("OID required");
        }
        this.name = string;
        this.oid = string2;
        this.description = string3;
        if (stringArray != null && stringArray.length > 0) {
            this.aliases = stringArray;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.oid;
    }

    public String getOID() {
        return this.getID();
    }

    public String getDescription() {
        return this.description;
    }

    protected void update(LDAPConnection lDAPConnection, int n, LDAPAttribute lDAPAttribute, String string) throws LDAPException {
        LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[]{lDAPAttribute};
        this.update(lDAPConnection, n, lDAPAttributeArray, string);
    }

    protected void update(LDAPConnection lDAPConnection, int n, LDAPAttribute[] lDAPAttributeArray, String string) throws LDAPException {
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        for (int i = 0; i < lDAPAttributeArray.length; ++i) {
            lDAPModificationSet.add(n, lDAPAttributeArray[i]);
        }
        String string2 = LDAPSchema.getSchemaDN(lDAPConnection, string);
        lDAPConnection.modify(string2, lDAPModificationSet);
    }

    protected void update(LDAPConnection lDAPConnection, int n, String string, String string2) throws LDAPException {
        boolean bl = !LDAPSchema.isAttributeSyntaxStandardsCompliant(lDAPConnection);
        LDAPAttribute lDAPAttribute = new LDAPAttribute(string, this.getValue(bl));
        this.update(lDAPConnection, n, lDAPAttribute, string2);
    }

    public void add(LDAPConnection lDAPConnection, String string) throws LDAPException {
        this.update(lDAPConnection, 0, this.attrName, string);
    }

    public void add(LDAPConnection lDAPConnection) throws LDAPException {
        this.add(lDAPConnection, "");
    }

    public void modify(LDAPConnection lDAPConnection, LDAPSchemaElement lDAPSchemaElement, String string) throws LDAPException {
        boolean bl = !LDAPSchema.isAttributeSyntaxStandardsCompliant(lDAPConnection);
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        lDAPModificationSet.add(1, new LDAPAttribute(this.attrName, this.getValue(bl)));
        lDAPModificationSet.add(0, new LDAPAttribute(this.attrName, lDAPSchemaElement.getValue(bl)));
        String string2 = LDAPSchema.getSchemaDN(lDAPConnection, string);
        lDAPConnection.modify(string2, lDAPModificationSet);
    }

    public void modify(LDAPConnection lDAPConnection, LDAPSchemaElement lDAPSchemaElement) throws LDAPException {
        this.modify(lDAPConnection, lDAPSchemaElement, "");
    }

    public void remove(LDAPConnection lDAPConnection, String string) throws LDAPException {
        this.update(lDAPConnection, 1, this.attrName, string);
    }

    public void remove(LDAPConnection lDAPConnection) throws LDAPException {
        this.remove(lDAPConnection, "");
    }

    public boolean isObsolete() {
        return this.properties == null ? false : this.properties.containsKey(OBSOLETE);
    }

    protected void parseValue(String string) {
        String[] stringArray;
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        --n;
        while (cArray[n] == ' ') {
            --n;
        }
        int n2 = 0;
        while (cArray[n2] == ' ') {
            ++n2;
        }
        int n3 = (n2 += 2) + 1;
        while (cArray[n3] != ' ') {
            ++n3;
        }
        this.oid = new String(cArray, n2, n3 - n2);
        ++n3;
        while (n3 < n) {
            String string2;
            int n4;
            while (cArray[n3] == ' ') {
                ++n3;
            }
            for (n4 = n3 + 1; n4 < n && cArray[n4] != ' '; ++n4) {
            }
            if (n4 < n) {
                string2 = new String(cArray, n3, n4 - n3);
                if (novalsTable.containsKey(string2)) {
                    this.properties.put(string2, "");
                    continue;
                }
            } else {
                string2 = "";
                n3 = n;
                break;
            }
            for (n3 = n4; n3 < n && cArray[n3] == ' '; ++n3) {
            }
            if (n3 >= n) break;
            boolean bl = false;
            boolean bl2 = false;
            if (cArray[n3] == '\'') {
                bl = true;
                ++n3;
                while (n4 < n && cArray[n4] != '\'') {
                    ++n4;
                }
            } else if (cArray[n3] == '(') {
                bl2 = true;
                ++n3;
                while (n4 < n && cArray[n4] != ')') {
                    ++n4;
                }
            } else {
                for (n4 = n3 + 1; n4 < n && cArray[n4] != ' '; ++n4) {
                }
            }
            if (n3 < n4 && n4 <= n) {
                String string3;
                if (bl2) {
                    Vector<String> vector = new Vector<String>();
                    if (cArray[n3] == ' ') {
                        ++n3;
                    }
                    String string4 = (string3 = new String(cArray, n3, n4 - n3 - 1)).indexOf(39) >= 0 ? "'" : " ";
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, string4);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken().trim();
                        if (string5.length() <= 0 || string5.equals("$")) continue;
                        vector.addElement(string5);
                    }
                    this.properties.put(string2, vector);
                } else {
                    string3 = new String(cArray, n3, n4 - n3);
                    if (string2.equals("NAME")) {
                        this.name = string3;
                    } else if (string2.equals("DESC")) {
                        this.description = string3;
                    } else {
                        this.properties.put(string2, string3);
                    }
                    if (bl) {
                        ++n4;
                    }
                }
            }
            n3 = n4 + 1;
        }
        if ((stringArray = this.getQualifier("NAME")) != null && stringArray.length > 0) {
            this.name = stringArray[0];
            if (stringArray.length > 1) {
                this.aliases = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 1, this.aliases, 0, this.aliases.length);
            }
        }
    }

    public String getValue() {
        return this.getValue(false);
    }

    String getValue(boolean bl) {
        return null;
    }

    String getValuePrefix() {
        String string = "( " + this.oid + ' ';
        if (this.name != null && this.name.length() > 0) {
            string = string + "NAME ";
            if (this.aliases != null) {
                string = string + "( '" + this.name + "' ";
                for (int i = 0; i < this.aliases.length; ++i) {
                    string = string + '\'' + this.aliases[i] + "' ";
                }
                string = string + ") ";
            } else {
                string = string + '\'' + this.name + "' ";
            }
        }
        if (this.description != null) {
            string = string + "DESC '" + this.description + "' ";
        }
        if (this.isObsolete()) {
            string = string + "OBSOLETE ";
        }
        return string;
    }

    protected String getOptionalValues(String[] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = this.getQualifier(stringArray[i]);
            if (stringArray2 == null || stringArray2.length <= 0) continue;
            string = string + stringArray[i] + ' ' + stringArray2[0];
        }
        return string;
    }

    protected String getCustomValues() {
        String string = "";
        Enumeration enumeration = this.properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith("X-")) continue;
            string = string + this.getValue(string2, true, false) + ' ';
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == ' ') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    String getValue(String string, boolean bl, boolean bl2) {
        String string2 = "";
        Object v = this.properties.get(string);
        if (v == null) {
            return string2;
        }
        if (v instanceof String) {
            if (((String)v).length() > 0) {
                string2 = string2 + string + ' ';
                if (bl) {
                    string2 = string2 + '\'';
                }
                string2 = string2 + (String)v;
                if (bl) {
                    string2 = string2 + '\'';
                }
            }
        } else {
            string2 = string2 + string + " ( ";
            Vector vector = (Vector)v;
            for (int i = 0; i < vector.size(); ++i) {
                if (bl) {
                    string2 = string2 + '\'';
                }
                string2 = string2 + (String)vector.elementAt(i);
                if (bl) {
                    string2 = string2 + '\'';
                }
                string2 = string2 + ' ';
                if (!bl2 || i >= vector.size() - 1) continue;
                string2 = string2 + "$ ";
            }
            string2 = string2 + ')';
        }
        return string2;
    }

    String getValue(String string, boolean bl) {
        return this.getValue(string, bl, true);
    }

    public void setQualifier(String string, String string2) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        if (string2 != null) {
            this.properties.put(string, string2);
        } else {
            this.properties.remove(string);
        }
    }

    public void setQualifier(String string, String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.addElement(stringArray[i]);
        }
        this.properties.put(string, vector);
    }

    public String[] getQualifier(String string) {
        if (this.properties == null) {
            return null;
        }
        Object v = this.properties.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof Vector) {
            Vector vector = (Vector)v;
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        String string2 = (String)v;
        if (string2.length() < 1) {
            return new String[0];
        }
        return new String[]{string2};
    }

    public Enumeration getQualifierNames() {
        return this.properties.keys();
    }

    public String[] getAliases() {
        return this.aliases;
    }

    String getQualifierString(String[] stringArray) {
        Hashtable<String, String> hashtable = null;
        if (stringArray != null) {
            hashtable = new Hashtable<String, String>();
            for (int i = 0; i < stringArray.length; ++i) {
                hashtable.put(stringArray[i], stringArray[i]);
            }
        }
        String string = "";
        Enumeration enumeration = this.getQualifierNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (hashtable != null && hashtable.containsKey(string2)) continue;
            string = string + "; " + string2;
            String[] stringArray2 = this.getQualifier(string2);
            if (stringArray2 == null) {
                string = string + ' ';
                continue;
            }
            string = string + ": ";
            for (int i = 0; i < stringArray2.length; ++i) {
                string = string + stringArray2[i] + ' ';
            }
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == ' ') {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    String getAliasString() {
        if (this.aliases != null) {
            String string = "; aliases:";
            for (int i = 0; i < this.aliases.length; ++i) {
                string = string + ' ' + this.aliases[i];
            }
            return string;
        }
        return "";
    }
}

