/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Vector;
import netscape.ldap.LDAPSchemaElement;

public class LDAPNameFormSchema
extends LDAPSchemaElement {
    static final long serialVersionUID = 1665316286199590403L;
    private Vector must = new Vector();
    private Vector may = new Vector();
    private String objectClass = null;
    static final String[] NOVALS = new String[]{"OBSOLETE"};
    static final String[] IGNOREVALS;

    public LDAPNameFormSchema(String string, String string2, String string3, boolean bl, String string4, String[] stringArray, String[] stringArray2) {
        super(string, string2, string3, null);
        int n;
        this.attrName = "nameforms";
        if (bl) {
            this.setQualifier("OBSOLETE", "");
        }
        this.objectClass = string4;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                this.must.addElement(stringArray[n]);
            }
        }
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                this.may.addElement(stringArray2[n]);
            }
        }
    }

    public LDAPNameFormSchema(String string) {
        this.attrName = "objectclasses";
        this.parseValue(string);
        Object v = this.properties.get("MAY");
        if (v != null) {
            if (v instanceof Vector) {
                this.may = (Vector)v;
            } else {
                this.may.addElement(v);
            }
        }
        if ((v = this.properties.get("MUST")) != null) {
            if (v instanceof Vector) {
                this.must = (Vector)v;
            } else {
                this.must.addElement(v);
            }
        }
        if ((v = this.properties.get("OC")) != null) {
            this.objectClass = (String)v;
        }
    }

    public String[] getRequiredNamingAttributes() {
        Object[] objectArray = new String[this.must.size()];
        this.must.copyInto(objectArray);
        return objectArray;
    }

    public String[] getOptionalNamingAttributes() {
        Object[] objectArray = new String[this.may.size()];
        this.may.copyInto(objectArray);
        return objectArray;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    String getValue(boolean bl) {
        String string = this.getValuePrefix();
        String string2 = this.getOptionalValues(NOVALS);
        if (string2.length() > 0) {
            string = string + string2 + ' ';
        }
        string = string + "OC " + this.objectClass + ' ';
        if (this.must.size() > 0) {
            string = string + "MUST " + this.vectorToList(this.must);
            string = string + ' ';
        }
        if (this.may.size() > 0) {
            string = string + "MAY " + this.vectorToList(this.may);
            string = string + ' ';
        }
        if ((string2 = this.getCustomValues()).length() > 0) {
            string = string + string2 + ' ';
        }
        string = string + ')';
        return string;
    }

    public String toString() {
        int n;
        String string = "Name: " + this.name + "; OID: " + this.oid;
        string = string + "; Description: " + this.description + "; Required: ";
        String[] stringArray = this.getRequiredNamingAttributes();
        for (n = 0; n < stringArray.length; ++n) {
            if (n > 0) {
                string = string + ", ";
            }
            string = string + stringArray[n];
        }
        string = string + "; Optional: ";
        stringArray = this.getOptionalNamingAttributes();
        for (n = 0; n < stringArray.length; ++n) {
            if (n > 0) {
                string = string + ", ";
            }
            string = string + stringArray[n];
        }
        if (this.isObsolete()) {
            string = string + "; OBSOLETE";
        }
        string = string + this.getQualifierString(IGNOREVALS);
        return string;
    }

    protected String vectorToList(Vector vector) {
        String string = "( ";
        for (int i = 0; i < vector.size(); ++i) {
            string = string + (String)vector.elementAt(i) + ' ';
            if (i >= vector.size() - 1) continue;
            string = string + "$ ";
        }
        string = string + ')';
        return string;
    }

    static {
        for (int i = 0; i < NOVALS.length; ++i) {
            novalsTable.put(NOVALS[i], NOVALS[i]);
        }
        IGNOREVALS = new String[]{"MUST", "MAY", "OBJECTCLASS", "OBSOLETE"};
    }
}

