/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPCache;
import netscape.ldap.LDAPConnSetupMgr;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMessage;
import netscape.ldap.LDAPMessageQueue;
import netscape.ldap.LDAPResponse;
import netscape.ldap.LDAPResponseControl;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchListener;
import netscape.ldap.LDAPSearchResult;
import netscape.ldap.LDAPSearchResultReference;
import netscape.ldap.LDAPTraceWriter;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.client.opers.JDAPAbandonRequest;
import netscape.ldap.client.opers.JDAPProtocolOp;
import netscape.ldap.client.opers.JDAPUnbindRequest;

class LDAPConnThread
extends Thread {
    private static final int MAXMSGID = Integer.MAX_VALUE;
    private static final int BACKLOG_CHKCNT = 50;
    private static transient int m_highMsgId;
    private transient InputStream m_serverInput;
    private transient OutputStream m_serverOutput;
    private transient Hashtable m_requests;
    private transient Hashtable m_messages = null;
    private transient Vector m_registered;
    private transient boolean m_disconnected = false;
    private transient LDAPCache m_cache = null;
    private transient boolean m_doRun = true;
    private Socket m_socket = null;
    private transient Thread m_thread = null;
    transient Object m_sendRequestLock = new Object();
    transient LDAPConnSetupMgr m_connMgr = null;
    transient Object m_traceOutput = null;
    private transient int m_backlogCheckCounter = 50;
    static SimpleDateFormat m_timeFormat;

    public LDAPConnThread(LDAPConnSetupMgr lDAPConnSetupMgr, LDAPCache lDAPCache, Object object) throws LDAPException {
        super("LDAPConnThread " + lDAPConnSetupMgr.getHost() + ":" + lDAPConnSetupMgr.getPort());
        this.m_requests = new Hashtable();
        this.m_registered = new Vector();
        this.m_connMgr = lDAPConnSetupMgr;
        this.m_socket = lDAPConnSetupMgr.getSocket();
        this.setCache(lDAPCache);
        this.setTraceOutput(object);
        this.setDaemon(true);
        try {
            this.m_serverInput = new BufferedInputStream(this.m_socket.getInputStream());
            this.m_serverOutput = new BufferedOutputStream(this.m_socket.getOutputStream());
        }
        catch (IOException iOException) {
            this.m_doRun = false;
            this.start();
            throw new LDAPException("failed to connect to server " + this.m_connMgr.getHost(), 91);
        }
        if (object != null) {
            StringBuffer stringBuffer = new StringBuffer(" connected to ");
            stringBuffer.append(this.m_connMgr.getLDAPUrl());
            this.logTraceMessage(stringBuffer);
        }
        this.start();
    }

    InputStream getInputStream() {
        return this.m_serverInput;
    }

    void setInputStream(InputStream inputStream) {
        this.m_serverInput = inputStream;
    }

    OutputStream getOutputStream() {
        return this.m_serverOutput;
    }

    void setOutputStream(OutputStream outputStream) {
        this.m_serverOutput = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTraceOutput(Object object) {
        Object object2 = this.m_sendRequestLock;
        synchronized (object2) {
            if (object == null) {
                this.m_traceOutput = null;
            } else if (object instanceof OutputStream) {
                this.m_traceOutput = new PrintWriter((OutputStream)object);
            } else if (object instanceof LDAPTraceWriter) {
                this.m_traceOutput = object;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logTraceMessage(StringBuffer stringBuffer) {
        String string = m_timeFormat.format(new Date());
        StringBuffer stringBuffer2 = new StringBuffer(string);
        stringBuffer2.append(" ldc=");
        stringBuffer2.append(this.m_connMgr.getID());
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            if (this.m_traceOutput instanceof PrintWriter) {
                PrintWriter printWriter = (PrintWriter)this.m_traceOutput;
                printWriter.print(stringBuffer2);
                printWriter.println(stringBuffer);
                printWriter.flush();
            } else if (this.m_traceOutput instanceof LDAPTraceWriter) {
                stringBuffer2.append(stringBuffer);
                ((LDAPTraceWriter)this.m_traceOutput).write(stringBuffer2.toString());
            }
        }
    }

    synchronized void setCache(LDAPCache lDAPCache) {
        this.m_cache = lDAPCache;
        this.m_messages = this.m_cache != null ? new Hashtable() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int allocateId() {
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            m_highMsgId = (m_highMsgId + 1) % Integer.MAX_VALUE;
            return m_highMsgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRequest(LDAPConnection lDAPConnection, JDAPProtocolOp jDAPProtocolOp, LDAPMessageQueue lDAPMessageQueue, LDAPConstraints lDAPConstraints) throws LDAPException {
        if (!this.m_doRun) {
            throw new LDAPException("not connected to a server", 81);
        }
        LDAPMessage lDAPMessage = new LDAPMessage(this.allocateId(), jDAPProtocolOp, lDAPConstraints.getServerControls());
        if (lDAPMessageQueue != null) {
            if (!(jDAPProtocolOp instanceof JDAPAbandonRequest) && !(jDAPProtocolOp instanceof JDAPUnbindRequest)) {
                this.m_requests.put(new Integer(lDAPMessage.getMessageID()), lDAPMessageQueue);
                this.resultRetrieved();
            }
            lDAPMessageQueue.addRequest(lDAPMessage.getMessageID(), lDAPConnection, this, lDAPConstraints.getTimeLimit());
        }
        Object object = this.m_sendRequestLock;
        synchronized (object) {
            try {
                if (this.m_traceOutput != null) {
                    this.logTraceMessage(lDAPMessage.toTraceString());
                }
                lDAPMessage.write(this.m_serverOutput);
                this.m_serverOutput.flush();
            }
            catch (IOException iOException) {
                this.networkError(iOException);
            }
        }
    }

    public synchronized void register(LDAPConnection lDAPConnection) {
        if (!this.m_registered.contains(lDAPConnection)) {
            this.m_registered.addElement(lDAPConnection);
        }
    }

    int getClientCount() {
        return this.m_registered.size();
    }

    boolean isRunning() {
        return this.m_doRun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deregister(LDAPConnection lDAPConnection) {
        this.m_registered.removeElement(lDAPConnection);
        if (this.m_registered.size() == 0) {
            try {
                if (!this.m_disconnected) {
                    LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
                    this.sendRequest(null, new JDAPUnbindRequest(), null, lDAPSearchConstraints);
                }
                this.m_doRun = false;
                if (this.m_thread != null && this.m_thread != Thread.currentThread()) {
                    this.m_thread.interrupt();
                    try {
                        this.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                LDAPConnection.printDebug(exception.toString());
            }
            finally {
                this.cleanUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        if (!this.m_disconnected) {
            Object object;
            Object object2;
            try {
                this.m_serverOutput.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.m_serverOutput = null;
            }
            try {
                this.m_serverInput.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.m_serverInput = null;
            }
            try {
                this.m_socket.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.m_socket = null;
            }
            this.m_disconnected = true;
            this.m_connMgr.disconnect();
            if (this.m_requests != null) {
                object2 = this.m_requests.elements();
                while (object2.hasMoreElements()) {
                    object = (LDAPMessageQueue)object2.nextElement();
                    ((LDAPMessageQueue)object).removeAllRequests(this);
                }
            }
            if (this.m_registered != null) {
                object2 = (Vector)this.m_registered.clone();
                object = ((Vector)object2).elements();
                while (object.hasMoreElements()) {
                    LDAPConnection lDAPConnection = (LDAPConnection)object.nextElement();
                    lDAPConnection.deregisterConnection();
                }
            }
            this.m_registered.clear();
            this.m_requests.clear();
            this.m_messages = null;
            this.m_cache = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBacklog() throws InterruptedException {
        while (this.m_requests.size() != 0) {
            Object object;
            Enumeration enumeration = this.m_requests.elements();
            while (enumeration.hasMoreElements()) {
                object = (LDAPMessageQueue)enumeration.nextElement();
                if (!(object instanceof LDAPSearchListener)) {
                    return;
                }
                LDAPSearchListener lDAPSearchListener = (LDAPSearchListener)object;
                if (lDAPSearchListener.getSearchConstraints() == null) {
                    return;
                }
                int n = lDAPSearchListener.getSearchConstraints().getMaxBacklog();
                int n2 = lDAPSearchListener.getSearchConstraints().getBatchSize();
                if (n == 0) {
                    return;
                }
                if (!lDAPSearchListener.isAsynchOp() && n2 == 0) {
                    return;
                }
                if (lDAPSearchListener.getMessageCount() >= n) continue;
                return;
            }
            object = this;
            synchronized (object) {
                this.wait(3000L);
            }
        }
        return;
    }

    synchronized void resultRetrieved() {
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.m_doRun) {
            return;
        }
        this.m_thread = Thread.currentThread();
        LDAPMessage lDAPMessage = null;
        JDAPBERTagDecoder jDAPBERTagDecoder = new JDAPBERTagDecoder();
        while (this.m_doRun) {
            LDAPConnThread.yield();
            int[] nArray = new int[]{0};
            try {
                if (--this.m_backlogCheckCounter <= 0) {
                    this.m_backlogCheckCounter = 50;
                    this.checkBacklog();
                }
                BERElement bERElement = BERElement.getElement(jDAPBERTagDecoder, this.m_serverInput, nArray);
                lDAPMessage = LDAPMessage.parseMessage(bERElement);
                if (this.m_traceOutput != null) {
                    this.logTraceMessage(lDAPMessage.toTraceString());
                }
                this.processResponse(lDAPMessage, nArray[0]);
            }
            catch (Exception exception) {
                if (this.m_doRun) {
                    this.networkError(exception);
                    continue;
                }
                LDAPConnThread lDAPConnThread = this;
                synchronized (lDAPConnThread) {
                    this.m_thread = null;
                    this.notifyAll();
                }
            }
        }
    }

    private void processResponse(LDAPMessage lDAPMessage, int n) {
        int n2;
        LDAPConnection lDAPConnection;
        LDAPControl[] lDAPControlArray;
        Integer n3 = new Integer(lDAPMessage.getMessageID());
        LDAPMessageQueue lDAPMessageQueue = (LDAPMessageQueue)this.m_requests.get(n3);
        if (lDAPMessageQueue == null) {
            return;
        }
        if (!lDAPMessageQueue.isAsynchOp() && (lDAPControlArray = lDAPMessage.getControls()) != null && (lDAPConnection = lDAPMessageQueue.getConnection(n2 = lDAPMessage.getMessageID())) != null) {
            lDAPConnection.setResponseControls(this, new LDAPResponseControl(lDAPConnection, n2, lDAPControlArray));
        }
        if (this.m_cache != null && lDAPMessageQueue instanceof LDAPSearchListener) {
            this.cacheSearchResult((LDAPSearchListener)lDAPMessageQueue, lDAPMessage, n);
        }
        lDAPMessageQueue.addMessage(lDAPMessage);
        if (lDAPMessage instanceof LDAPResponse) {
            this.m_requests.remove(n3);
            if (this.m_requests.size() == 0) {
                this.m_backlogCheckCounter = 50;
            }
        }
    }

    private synchronized void cacheSearchResult(LDAPSearchListener lDAPSearchListener, LDAPMessage lDAPMessage, int n) {
        Integer n2 = new Integer(lDAPMessage.getMessageID());
        Long l = lDAPSearchListener.getKey();
        Vector vector = null;
        if (this.m_cache == null || l == null) {
            return;
        }
        if (lDAPMessage instanceof LDAPSearchResult) {
            vector = (Vector)this.m_messages.get(n2);
            if (vector == null) {
                vector = new Vector();
                this.m_messages.put(n2, vector);
                vector.addElement(new Long(0L));
            }
            if ((Long)vector.firstElement() == -1L) {
                return;
            }
            long l2 = (Long)vector.firstElement() + (long)n;
            if (l2 > this.m_cache.getSize()) {
                vector.removeAllElements();
                vector.addElement(new Long(-1L));
                return;
            }
            vector.setElementAt(new Long(l2), 0);
            vector.addElement(((LDAPSearchResult)lDAPMessage).getEntry());
        } else if (lDAPMessage instanceof LDAPSearchResultReference) {
            vector = (Vector)this.m_messages.get(n2);
            if (vector == null) {
                vector = new Vector();
                this.m_messages.put(n2, vector);
            } else {
                vector.removeAllElements();
            }
            vector.addElement(new Long(-1L));
        } else if (lDAPMessage instanceof LDAPResponse) {
            boolean bl = ((LDAPResponse)lDAPMessage).getResultCode() > 0;
            vector = (Vector)this.m_messages.remove(n2);
            if (!bl) {
                if (vector == null) {
                    vector = new Vector();
                    vector.addElement(new Long(0L));
                }
                if ((Long)vector.firstElement() != -1L) {
                    this.m_cache.addEntry(l, vector);
                }
            }
        }
    }

    void abandon(int n) {
        if (!this.m_doRun) {
            return;
        }
        LDAPMessageQueue lDAPMessageQueue = (LDAPMessageQueue)this.m_requests.remove(new Integer(n));
        if (this.m_messages != null) {
            this.m_messages.remove(new Integer(n));
        }
        if (lDAPMessageQueue != null) {
            lDAPMessageQueue.removeRequest(n);
        }
        this.resultRetrieved();
    }

    LDAPMessageQueue changeListener(int n, LDAPMessageQueue lDAPMessageQueue) {
        if (!this.m_doRun) {
            lDAPMessageQueue.setException(this, new LDAPException("Server or network error", 81));
            return null;
        }
        return this.m_requests.put(new Integer(n), lDAPMessageQueue);
    }

    private synchronized void networkError(Exception exception) {
        this.m_doRun = false;
        this.m_connMgr.invalidateConnection();
        try {
            Enumeration enumeration = this.m_requests.elements();
            while (enumeration.hasMoreElements()) {
                LDAPMessageQueue lDAPMessageQueue = (LDAPMessageQueue)enumeration.nextElement();
                lDAPMessageQueue.setException(this, new LDAPException("Server or network error", 81));
            }
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("Exception: " + nullPointerException.toString());
        }
        this.cleanUp();
    }

    static {
        m_timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    }
}

