/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPInterruptedException;
import netscape.ldap.LDAPSocketFactory;

class LDAPConnSetupMgr
implements Cloneable,
Serializable {
    static final long serialVersionUID = 1519402748245755306L;
    private static final int SERIAL = 0;
    private static final int PARALLEL = 1;
    private static final int CONNECTED = 0;
    private static final int DISCONNECTED = 1;
    private static final int NEVER_USED = 2;
    private static final int INTERRUPTED = 3;
    private static final int FAILED = 4;
    private Socket m_socket = null;
    private LDAPException m_connException = null;
    ServerEntry[] m_dsList;
    private int m_dsIdx = -1;
    LDAPSocketFactory m_factory;
    int m_policy = 0;
    int m_connSetupDelay = -1;
    int m_connectTimeout = 0;
    private transient int m_attemptCnt = 0;
    private static int m_nextId;
    private int m_id;

    LDAPConnSetupMgr(String[] stringArray, int[] nArray, LDAPSocketFactory lDAPSocketFactory) {
        this.m_dsList = new ServerEntry[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_dsList[i] = new ServerEntry(stringArray[i], nArray[i], 2);
        }
        this.m_factory = lDAPSocketFactory;
        this.m_id = m_nextId++;
    }

    synchronized Socket openConnection() throws LDAPException {
        long l = 0L;
        long l2 = Long.MAX_VALUE;
        Thread thread = null;
        this.reset();
        this.sortDsList();
        if (this.m_connectTimeout == 0) {
            this.connect();
        } else {
            l2 = System.currentTimeMillis() + (long)this.m_connectTimeout;
            thread = new Thread(new Runnable(){

                public void run() {
                    LDAPConnSetupMgr.this.connect();
                }
            }, "ConnSetupMgr");
            thread.setDaemon(true);
            thread.start();
            while (this.m_socket == null && this.m_attemptCnt < this.m_dsList.length && (l = System.currentTimeMillis()) < l2) {
                try {
                    this.wait(l2 - l);
                }
                catch (InterruptedException interruptedException) {
                    thread.interrupt();
                    this.cleanup();
                    throw new LDAPInterruptedException("Interrupted connect operation");
                }
            }
        }
        if (this.m_socket != null) {
            return this.m_socket;
        }
        if (thread != null && (l = System.currentTimeMillis()) >= l2) {
            thread.interrupt();
            this.cleanup();
            throw new LDAPException("connect timeout, " + this.getServerList() + " might be unreachable", 91);
        }
        if (this.m_connException != null && this.m_dsList.length == 1) {
            throw this.m_connException;
        }
        throw new LDAPException("failed to connect to server " + this.getServerList(), 91);
    }

    private void reset() {
        this.m_socket = null;
        this.m_connException = null;
        this.m_attemptCnt = 0;
        for (int i = 0; i < this.m_dsList.length; ++i) {
            this.m_dsList[i].connSetupThread = null;
        }
    }

    private String getServerList() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.m_dsList.length; ++i) {
            stringBuffer.append(i == 0 ? "" : " ");
            stringBuffer.append(this.m_dsList[i].host);
            stringBuffer.append(":");
            stringBuffer.append(this.m_dsList[i].port);
        }
        return stringBuffer.toString();
    }

    private void connect() {
        if (this.m_policy == 0 || this.m_dsList.length == 1) {
            this.openSerial();
        } else {
            this.openParallel();
        }
    }

    synchronized void invalidateConnection() {
        if (this.m_socket != null) {
            this.m_dsList[this.m_dsIdx].connSetupStatus = 4;
            int n = this.m_dsList.length;
            int n2 = 0;
            ServerEntry[] serverEntryArray = new ServerEntry[this.m_dsList.length];
            for (int i = 0; i < n; ++i) {
                if (i == this.m_dsIdx) continue;
                serverEntryArray[n2++] = this.m_dsList[i];
            }
            serverEntryArray[n2] = this.m_dsList[this.m_dsIdx];
            this.m_dsList = serverEntryArray;
            this.m_dsIdx = n2;
        }
        this.m_socket = null;
    }

    void disconnect() {
        if (this.m_socket != null) {
            this.m_dsList[this.m_dsIdx].connSetupStatus = 1;
        }
        this.m_socket = null;
    }

    Socket getSocket() {
        return this.m_socket;
    }

    String getHost() {
        if (this.m_dsIdx >= 0) {
            return this.m_dsList[this.m_dsIdx].host;
        }
        return this.m_dsList[0].host;
    }

    int getPort() {
        if (this.m_dsIdx >= 0) {
            return this.m_dsList[this.m_dsIdx].port;
        }
        return this.m_dsList[0].port;
    }

    int getConnSetupDelay() {
        return this.m_connSetupDelay / 1000;
    }

    void setConnSetupDelay(int n) {
        this.m_policy = n < 0 ? 0 : 1;
        this.m_connSetupDelay = n * 1000;
    }

    int getConnectTimeout() {
        return this.m_connectTimeout / 1000;
    }

    void setConnectTimeout(int n) {
        this.m_connectTimeout = n * 1000;
    }

    boolean isUserDisconnected() {
        return this.m_dsIdx >= 0 && this.m_dsList[this.m_dsIdx].connSetupStatus == 1;
    }

    private void openSerial() {
        for (int i = 0; i < this.m_dsList.length; ++i) {
            this.m_dsList[i].connSetupThread = Thread.currentThread();
            this.connectServer(i);
            if (this.m_socket == null) continue;
            return;
        }
    }

    private synchronized void openParallel() {
        for (int i = 0; this.m_socket == null && i < this.m_dsList.length; ++i) {
            Thread thread;
            final int n = i;
            String string = "ConnSetupMgr " + this.m_dsList[n].host + ":" + this.m_dsList[n].port;
            this.m_dsList[n].connSetupThread = thread = new Thread(new Runnable(){

                public void run() {
                    LDAPConnSetupMgr.this.connectServer(n);
                }
            }, string);
            thread.setDaemon(true);
            thread.start();
            if (this.m_connSetupDelay == 0 || i >= this.m_dsList.length - 1) continue;
            try {
                this.wait(this.m_connSetupDelay);
                continue;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        while (this.m_socket == null && this.m_attemptCnt < this.m_dsList.length) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectServer(int n) {
        ServerEntry serverEntry = this.m_dsList[n];
        Thread thread = Thread.currentThread();
        Socket socket = null;
        LDAPException lDAPException = null;
        try {
            socket = this.m_factory == null ? new Socket(serverEntry.host, serverEntry.port) : this.m_factory.makeSocket(serverEntry.host, serverEntry.port);
        }
        catch (IOException iOException) {
            lDAPException = new LDAPException("failed to connect to server " + serverEntry.host + ":" + serverEntry.port, 91);
        }
        catch (LDAPException lDAPException2) {
            lDAPException = lDAPException2;
        }
        if (thread.isInterrupted()) {
            return;
        }
        LDAPConnSetupMgr lDAPConnSetupMgr = this;
        synchronized (lDAPConnSetupMgr) {
            if (this.m_socket == null && serverEntry.connSetupThread == thread) {
                serverEntry.connSetupThread = null;
                if (socket != null) {
                    serverEntry.connSetupStatus = 0;
                    this.m_socket = socket;
                    this.m_dsIdx = n;
                    this.cleanup();
                } else {
                    serverEntry.connSetupStatus = 4;
                    this.m_connException = lDAPException;
                }
                ++this.m_attemptCnt;
                this.notifyAll();
            }
        }
    }

    private synchronized void cleanup() {
        Thread thread = Thread.currentThread();
        for (int i = 0; i < this.m_dsList.length; ++i) {
            ServerEntry serverEntry = this.m_dsList[i];
            if (serverEntry.connSetupThread == null || serverEntry.connSetupThread == thread) continue;
            serverEntry.connSetupStatus = 3;
            serverEntry.connSetupThread.interrupt();
            serverEntry.connSetupThread = null;
        }
    }

    private void sortDsList() {
        int n = this.m_dsList.length;
        for (int i = 1; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                if (this.m_dsList[i].connSetupStatus >= this.m_dsList[j].connSetupStatus) continue;
                ServerEntry serverEntry = this.m_dsList[j];
                this.m_dsList[j] = this.m_dsList[i];
                this.m_dsList[i] = serverEntry;
            }
        }
    }

    boolean breakConnection() {
        try {
            this.m_socket.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        String string = "dsIdx=" + this.m_dsIdx + " dsList=";
        for (int i = 0; i < this.m_dsList.length; ++i) {
            string = string + this.m_dsList[i] + " ";
        }
        return string;
    }

    int getID() {
        return this.m_id;
    }

    String getLDAPUrl() {
        return (this.m_factory == null ? "ldap" : "ldaps") + "://" + this.getHost() + ":" + this.getPort();
    }

    public Object clone() {
        try {
            LDAPConnSetupMgr lDAPConnSetupMgr = (LDAPConnSetupMgr)super.clone();
            lDAPConnSetupMgr.m_dsList = new ServerEntry[this.m_dsList.length];
            for (int i = 0; i < this.m_dsList.length; ++i) {
                ServerEntry serverEntry = this.m_dsList[i];
                lDAPConnSetupMgr.m_dsList[i] = new ServerEntry(serverEntry.host, serverEntry.port, serverEntry.connSetupStatus);
            }
            return lDAPConnSetupMgr;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    class ServerEntry {
        String host;
        int port;
        int connSetupStatus;
        Thread connSetupThread;

        ServerEntry(String string, int n, int n2) {
            this.host = string;
            this.port = n;
            this.connSetupStatus = n2;
            this.connSetupThread = null;
        }

        public String toString() {
            return "{" + this.host + ":" + this.port + " status=" + this.connSetupStatus + "}";
        }
    }
}

