/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.util;

import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCPreferencesFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UWCPreferences
extends Preferences {
    private static final Logger _logger = UWCLogger.getLogger("uwc");
    private static final String NODE_DELIMITER = ";";
    private String _rootdir = null;
    private String _filename = null;
    private final String _name;
    private final String _absolutePath;
    private final UWCPreferences _parent;
    private final UWCPreferences _root;
    private final Properties _config = new Properties();
    private Hashtable dateFormatTable = new Hashtable();
    private Hashtable timeFormatTable = new Hashtable();
    protected final Object lock = new Object();
    private Map kidCache = new HashMap();
    private boolean removed = false;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static Preferences userRoot() {
        return new UWCPreferences();
    }

    public static Preferences systemRoot() {
        return new UWCPreferences();
    }

    private UWCPreferences(UWCPreferences uWCPreferences, String string, boolean bl, String string2) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("Name must be provided to the node");
        }
        if (uWCPreferences == null) {
            if (!string.equals("")) {
                throw new IllegalArgumentException("Root name '" + string + "' must be \"\"");
            }
            this._absolutePath = "/";
            this._root = this;
        } else {
            if (string.indexOf(47) != -1) {
                throw new IllegalArgumentException("Name '" + string + "' contains '/'");
            }
            if (string.equals("")) {
                throw new IllegalArgumentException("Illegal name: empty string");
            }
            this._root = uWCPreferences._root;
            this._absolutePath = uWCPreferences == this._root ? "/" + string : uWCPreferences.absolutePath() + "/" + string;
        }
        this._name = string;
        this._parent = uWCPreferences;
        if (bl && string2 != null) {
            this.updateNodeCache(string2);
        }
    }

    private UWCPreferences() {
        this._absolutePath = "/";
        this._root = this;
        this._name = "";
        this._parent = null;
    }

    public static UWCPreferences getSystemRootInstance() {
        return UWCPreferences.getSystemRootInstance(null);
    }

    public static UWCPreferences getSystemRootInstance(String string) {
        UWCPreferencesFactory uWCPreferencesFactory = new UWCPreferencesFactory();
        UWCPreferences uWCPreferences = (UWCPreferences)uWCPreferencesFactory.systemRoot();
        uWCPreferences.setRootPath(string);
        return uWCPreferences;
    }

    public static UWCPreferences getUserRootInstance() {
        return UWCPreferences.getUserRootInstance(null);
    }

    public static UWCPreferences getUserRootInstance(String string) {
        UWCPreferencesFactory uWCPreferencesFactory = new UWCPreferencesFactory();
        UWCPreferences uWCPreferences = (UWCPreferences)uWCPreferencesFactory.userRoot();
        uWCPreferences.setRootPath(string);
        return uWCPreferences;
    }

    public void setRootPath(String string) {
        this._rootdir = string;
    }

    private void updateNodeCache(String string) throws IOException {
        File file = null;
        file = new File(string);
        this._config.load(new FileInputStream(file));
    }

    public UWCPreferences loadNode(String string) throws UWCException {
        return this.loadNode(string, "/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UWCPreferences loadNode(String string, String string2) throws UWCException {
        try {
            if (string == null) {
                throw new UWCException(15, "Filename to be loaded must be provided");
            }
            Object object = this.lock;
            synchronized (object) {
                try {
                    this._filename = this._rootdir == null ? string : this._rootdir + File.separator + string;
                    UWCPreferences uWCPreferences = (UWCPreferences)this.node(string2);
                    return uWCPreferences;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new UWCException(47, illegalArgumentException.getMessage());
                    }
                }
            }
        }
        finally {
            this._filename = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UWCPreferences getNode(String string) {
        try {
            Object object = this.lock;
            synchronized (object) {
                return (UWCPreferences)this.node(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            _logger.warning(illegalArgumentException.getMessage());
            return null;
        }
    }

    public Properties getProperties() {
        return this._config;
    }

    public Preferences node(String string) {
        if (string == null || string.equals("")) {
            return this;
        }
        if (string.equals("/")) {
            if (this._filename != null) {
                try {
                    this.updateNodeCache(this._filename);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(iOException.getMessage());
                }
            }
            return this._root;
        }
        return this._root.node(new StringTokenizer(string, "/"), this._filename);
    }

    private Preferences node(StringTokenizer stringTokenizer, String string) {
        boolean bl;
        String string2 = stringTokenizer.nextToken();
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Consecutive slashes in path");
        }
        UWCPreferences uWCPreferences = (UWCPreferences)this.kidCache.get(string2);
        boolean bl2 = bl = !stringTokenizer.hasMoreTokens();
        if (uWCPreferences == null) {
            if (string2.length() > 80) {
                throw new IllegalArgumentException("Node name " + string2 + " too long");
            }
            try {
                uWCPreferences = new UWCPreferences(this, string2, bl, string);
            }
            catch (IOException iOException) {
                _logger.severe("Could not load the file: " + iOException.getMessage());
                throw new IllegalArgumentException(iOException.getMessage());
            }
            this.kidCache.put(string2, uWCPreferences);
        }
        if (bl) {
            return uWCPreferences;
        }
        return uWCPreferences.node(stringTokenizer, string);
    }

    public boolean nodeExists(String string) throws BackingStoreException {
        if (string.equals("")) {
            return true;
        }
        if (string.equals("/")) {
            return true;
        }
        if (string.charAt(0) != '/') {
            return this.nodeExists(new StringTokenizer(string, "/"));
        }
        return this._root.nodeExists(new StringTokenizer(string.substring(1), "/"));
    }

    private boolean nodeExists(StringTokenizer stringTokenizer) throws BackingStoreException {
        String string = stringTokenizer.nextToken();
        if (string.equals("/")) {
            throw new IllegalArgumentException("Consecutive slashes in path");
        }
        UWCPreferences uWCPreferences = (UWCPreferences)this.kidCache.get(string);
        if (uWCPreferences == null) {
            uWCPreferences = this.getChild(string);
        }
        if (uWCPreferences == null) {
            return false;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return true;
        }
        return uWCPreferences.nodeExists(stringTokenizer);
    }

    public void put(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        if (string.length() > 80) {
            throw new IllegalArgumentException("Key too long: " + string);
        }
        if (string2.length() > 8192) {
            throw new IllegalArgumentException("Value too long: " + string2);
        }
        this._config.setProperty(string, string2);
    }

    public String get(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null key");
        }
        if (this._config == null) {
            return string2;
        }
        return this._config.getProperty(string, string2);
    }

    public static String[] getKeyProperty(Preferences preferences, String string, String string2) {
        try {
            if (preferences == null) {
                return null;
            }
            String[] stringArray = preferences.keys();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                String string3 = stringArray[i];
                if (string != null && string2 == null && string3.startsWith(string)) {
                    bl2 = true;
                    bl4 = true;
                }
                if (string2 != null && string == null && string3.startsWith(string2)) {
                    bl = true;
                    bl4 = true;
                }
                if (string != null && string2 != null && string3.startsWith(string) && string3.endsWith(string2)) {
                    bl3 = true;
                    bl4 = true;
                }
                if (!bl4) continue;
                String string4 = null;
                if (bl3) {
                    string4 = string3.split(string)[1];
                    string4 = string4.split(string2)[0];
                } else {
                    string4 = bl2 ? string3.split(string)[1] : string3.split(string2)[0];
                }
                if (string4 == null || string4.length() <= 0) continue;
                arrayList.add(string4);
            }
            return arrayList.toArray(EMPTY_STRING_ARRAY);
        }
        catch (BackingStoreException backingStoreException) {
            _logger.severe("Can't obtain the node to get the keys");
            return null;
        }
    }

    public void remove(String string) {
    }

    public void clear() throws BackingStoreException {
        String[] stringArray = this.keys();
        for (int i = 0; i < stringArray.length; ++i) {
            this.remove(stringArray[i]);
        }
    }

    public void putInt(String string, int n) {
        this.put(string, Integer.toString(n));
    }

    public int getInt(String string, int n) {
        int n2 = n;
        try {
            String string2 = this.get(string, null);
            if (string2 != null) {
                n2 = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n2;
    }

    public void putLong(String string, long l) {
        this.put(string, Long.toString(l));
    }

    public long getLong(String string, long l) {
        long l2 = l;
        try {
            String string2 = this.get(string, null);
            if (string2 != null) {
                l2 = Long.parseLong(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l2;
    }

    public void putBoolean(String string, boolean bl) {
        this.put(string, String.valueOf(bl));
    }

    public boolean getBoolean(String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = this.get(string, null);
        if (string2 != null) {
            if (string2.equalsIgnoreCase("true")) {
                bl2 = true;
            } else if (string2.equalsIgnoreCase("false")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    public void putFloat(String string, float f) {
        this.put(string, Float.toString(f));
    }

    public float getFloat(String string, float f) {
        float f2 = f;
        try {
            String string2 = this.get(string, null);
            if (string2 != null) {
                f2 = Float.parseFloat(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return f2;
    }

    public void putDouble(String string, double d) {
        this.put(string, Double.toString(d));
    }

    public double getDouble(String string, double d) {
        double d2 = d;
        try {
            String string2 = this.get(string, null);
            if (string2 != null) {
                d2 = Double.parseDouble(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d2;
    }

    public void putByteArray(String string, byte[] byArray) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getByteArray(String string, byte[] byArray) {
        byte[] byArray2 = byArray;
        String string2 = this.get(string, null);
        try {
            if (string2 == null) return byArray2;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return byArray2;
    }

    public DateFormat getDateFormat(String string, int n, Locale locale) {
        DateFormat dateFormat = (DateFormat)this.dateFormatTable.get(string);
        if (dateFormat != null) {
            return dateFormat;
        }
        String string2 = this.get(string, null);
        if (string2 != null && string2.length() > 0) {
            string2 = string2.replaceAll("&#39;", "'");
            try {
                dateFormat = new SimpleDateFormat(string2, locale);
                dateFormat.setLenient(false);
                this.dateFormatTable.put(string, dateFormat);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                _logger.warning("The date format " + string2 + " for locale " + locale.getLanguage() + " is illegal" + illegalArgumentException.getMessage());
            }
        }
        if (dateFormat == null) {
            _logger.warning("Date Pattern missing or invalid. Hence falling-back to style =" + n);
            dateFormat = (DateFormat)this.dateFormatTable.get(new Integer(n));
            if (dateFormat == null) {
                dateFormat = DateFormat.getDateInstance(n, locale);
                dateFormat.setLenient(false);
                this.dateFormatTable.put(new Integer(n), dateFormat);
            }
        }
        return dateFormat;
    }

    public DateFormat getTimeFormat(String string, int n, Locale locale) {
        DateFormat dateFormat = (DateFormat)this.timeFormatTable.get(string);
        if (dateFormat != null) {
            return dateFormat;
        }
        String string2 = this.get(string, null);
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        String[] stringArray = new String[]{this.get("uwc-common-am", "am"), this.get("uwc-common-pm", "pm")};
        dateFormatSymbols.setAmPmStrings(stringArray);
        if (string2 != null) {
            try {
                dateFormat = new SimpleDateFormat(string2, locale);
                dateFormat.setLenient(false);
                ((SimpleDateFormat)dateFormat).setDateFormatSymbols(dateFormatSymbols);
                this.timeFormatTable.put(string, dateFormat);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                _logger.warning("The date format " + string2 + " for locale " + locale.getLanguage() + " is illegal" + illegalArgumentException.getMessage());
            }
        }
        if (dateFormat == null) {
            _logger.warning("Time Pattern missing or invalid. Hence falling-back to style =" + n);
            dateFormat = (DateFormat)this.timeFormatTable.get(new Integer(n));
            if (dateFormat == null) {
                dateFormat = DateFormat.getTimeInstance(n, locale);
                dateFormat.setLenient(false);
                this.timeFormatTable.put(new Integer(n), dateFormat);
            }
        }
        return dateFormat;
    }

    public String[] keys() throws BackingStoreException {
        Set<Object> set = this._config.keySet();
        return set.toArray(EMPTY_STRING_ARRAY);
    }

    public String[] childrenNames() throws BackingStoreException {
        Set set = this.kidCache.keySet();
        return set.toArray(EMPTY_STRING_ARRAY);
    }

    public Preferences parent() {
        return this._parent;
    }

    public void removeNode() throws BackingStoreException {
        if (this == this._root) {
            throw new UnsupportedOperationException("Can't remove the root!");
        }
        this._parent.kidCache.remove(this._name);
    }

    public String name() {
        return this._name;
    }

    public String absolutePath() {
        return this._absolutePath;
    }

    public boolean isUserNode() {
        return this._root == Preferences.userRoot();
    }

    private UWCPreferences getChild(String string) throws BackingStoreException {
        String[] stringArray = this.childrenNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            try {
                return new UWCPreferences(this, stringArray[i], false, null);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage());
            }
        }
        return null;
    }

    public void addPreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
        if (preferenceChangeListener == null) {
            throw new NullPointerException("Change listener is null.");
        }
    }

    public void removePreferenceChangeListener(PreferenceChangeListener preferenceChangeListener) {
    }

    public void addNodeChangeListener(NodeChangeListener nodeChangeListener) {
        if (nodeChangeListener == null) {
            throw new NullPointerException("Change listener is null.");
        }
    }

    public void removeNodeChangeListener(NodeChangeListener nodeChangeListener) {
    }

    public String toString() {
        return (this.isUserNode() ? "User" : "System") + " Preference Node: " + this.absolutePath();
    }

    public void sync() throws BackingStoreException {
    }

    public void flush() throws BackingStoreException {
    }

    public void exportNode(OutputStream outputStream) throws IOException, BackingStoreException {
    }

    public void exportSubtree(OutputStream outputStream) throws IOException, BackingStoreException {
    }

    public void importXMLPreferences(InputStream inputStream) throws UWCException {
        try {
            XMLDOMBuilder xMLDOMBuilder = new XMLDOMBuilder();
            Document document = xMLDOMBuilder.parse(inputStream, true);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String string = node.getNodeName();
                String string2 = node.getFirstChild().getNodeValue();
                if (this._config == null) continue;
                this._config.put(string, string2);
            }
        }
        catch (XMLProcessingException xMLProcessingException) {
            throw new UWCException(xMLProcessingException.getMessage());
        }
    }
}

