/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.util;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.uwc.common.UWCException;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCPreferences;
import com.sun.uwc.common.util.UWCUtils;
import java.io.File;
import java.util.HashMap;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;

public class UWCDomainCache {
    public static final String ZN_LOCALE = "zh";
    public static final String ZN_FALLBACK_LOCALE = "zh-cn";
    public static final String UNDERSCORE = "_";
    public static final String HYPHEN = "-";
    private HashMap rbmap = new HashMap();
    private HashMap themescache = new HashMap();
    private String domain;
    private boolean isDomainPresent = true;
    private String defaultLocale;
    private String configroot;
    private UWCPreferences uwcdomainconfig;
    private UWCPreferences prefs;
    private static final String SEP = File.separator;
    private static final Logger log = UWCLogger.getLogger("uwc");
    private static final String CLASS_NAME = "UWCDomaincache";
    private static final String DOUBLE_QUOT = "&#34;";
    private static final String SINGLE_QUOT = "&#39;";

    public UWCDomainCache(String string, String string2, UWCPreferences uWCPreferences, String string3) {
        this.domain = string;
        this.configroot = string2;
        this.prefs = uWCPreferences;
        this.defaultLocale = string3;
        this.loadUWCDomainProperties();
    }

    public boolean isResourceBundleLoaded(String string) {
        return this.rbmap.containsKey(string);
    }

    public boolean isThemeLoaded(String string) {
        return this.themescache.containsKey(string);
    }

    public void loadUWCDomainProperties() {
        log.entering(CLASS_NAME, "loadUWCDomainProperties()");
        try {
            this.uwcdomainconfig = this.prefs.loadNode(this.configroot + SEP + "domain" + SEP + this.domain + SEP + "uwcdomainconfig.properties", "domain/" + this.domain);
        }
        catch (UWCException uWCException) {
            log.warning("Unable to load domain configuration file for domain" + this.domain);
        }
        if (this.uwcdomainconfig == null) {
            this.isDomainPresent = false;
            this.uwcdomainconfig = this.prefs.getNode("domain/defaultdomain");
        }
        this.loadDefaultResourceBundle();
        String string = this.uwcdomainconfig.get("uwc-user-attr-SunUCTheme", null);
        this.themescache.put(new String("default"), string);
    }

    public boolean loadUWCResourceBundle(String string) {
        log.entering(CLASS_NAME, "loadUWCResourceBundle(" + string + ")");
        try {
            UWCPreferences uWCPreferences = null;
            String string2 = (String)this.rbmap.get(string);
            if (string2 == null) {
                uWCPreferences = this.isDomainPresent ? this.prefs.loadNode(this.configroot + SEP + "domain" + SEP + this.domain + SEP + string + SEP + "i18n.properties", "domain/" + this.domain + "/" + string) : this.prefs.loadNode(this.configroot + SEP + "domain" + SEP + string + SEP + "i18n.properties", "domain/" + this.domain + "/" + string);
                if (uWCPreferences != null) {
                    this.htmlEscapeValues(uWCPreferences);
                    this.rbmap.put(string, "domain/" + this.domain + "/" + string);
                    return true;
                }
                return false;
            }
        }
        catch (UWCException uWCException) {
            log.warning("Unable to load default resource bundle for domain " + this.domain + "and locale" + string);
            return false;
        }
        return true;
    }

    public boolean loadUWCTheme(String string) {
        String string2 = this.uwcdomainconfig.get("uwc-user-attr-SunUCTheme-" + string, null);
        if (string2 != null) {
            this.themescache.put(string, string2);
            return true;
        }
        log.warning("Theme for locale" + string + "and" + this.domain + " is not configured");
        return false;
    }

    public String resolveLocale(String string, String string2) {
        String[] stringArray;
        log.entering(CLASS_NAME, "resolveLocale(" + string + "," + string2 + ")");
        log.finest("Prefered locale is " + string);
        log.finest("accept locale is " + string2);
        if (null != string) {
            string = string.trim();
            string = UWCUtils.convertUnderScoreToHypen(string);
        }
        log.finest("Prefered locale after conversion =  " + string);
        if (null != string2) {
            string2 = UWCUtils.convertUnderScoreToHypen(string2);
        }
        log.finest("accept locale after conversion =  " + string2);
        boolean bl = false;
        if (null != string && string.length() > 0) {
            if (string.equals(ZN_LOCALE)) {
                bl = true;
            }
            if (this.loadUWCResourceBundle(string)) {
                return string;
            }
            stringArray = string.split(HYPHEN, 2);
            if (null != stringArray && stringArray.length > 0 && this.loadUWCResourceBundle(stringArray[0])) {
                return stringArray[0];
            }
            if (bl && this.loadUWCResourceBundle(ZN_FALLBACK_LOCALE)) {
                return ZN_FALLBACK_LOCALE;
            }
        }
        if (string2 != null && (stringArray = string2.split(",")) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(";");
                if (stringArray2 == null) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    if (this.loadUWCResourceBundle(stringArray2[j])) {
                        return stringArray2[j];
                    }
                    String[] stringArray3 = stringArray2[0].split(HYPHEN, 2);
                    log.fine(" sublangs .." + stringArray3[0]);
                    if (!this.loadUWCResourceBundle(stringArray3[0])) continue;
                    return stringArray3[0];
                }
            }
        }
        return this.defaultLocale;
    }

    public void setrootpreferences(UWCPreferences uWCPreferences) {
        this.prefs = uWCPreferences;
    }

    public void setroot(String string) {
        this.configroot = string;
    }

    public UWCPreferences getResourceBundle(String string) {
        String string2 = (String)this.rbmap.get(string);
        if (string2 == null) {
            if (this.loadUWCResourceBundle(string)) {
                string2 = (String)this.rbmap.get(string);
            } else if (string.equals(this.defaultLocale)) {
                string2 = (String)this.rbmap.get("default");
            } else {
                return null;
            }
        }
        return this.prefs.getNode(string2);
    }

    public String getTheme(String string) {
        if (this.themescache.containsKey(string)) {
            return (String)this.themescache.get(string);
        }
        if (this.loadUWCTheme(string)) {
            return (String)this.themescache.get(string);
        }
        return null;
    }

    public UWCPreferences getDomainProperties() {
        return this.uwcdomainconfig;
    }

    public String getDefaultTheme() {
        String string = (String)this.themescache.get("default");
        if (string == null) {
            log.warning("Default theme for domain " + this.domain + " has not been configured");
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean loadDefaultResourceBundle() {
        try {
            UWCPreferences uWCPreferences = null;
            if (this.isDomainPresent) {
                uWCPreferences = this.prefs.loadNode(this.configroot + SEP + "domain" + SEP + this.domain + SEP + this.defaultLocale + SEP + "i18n.properties", "domain/" + this.domain + "defaultresourcebundle");
                if (uWCPreferences == null) return false;
                this.htmlEscapeValues(uWCPreferences);
                this.rbmap.put("default", "domain/" + this.domain + "defaultresourcebundle");
                this.rbmap.put(this.defaultLocale, "domain/" + this.domain + "defaultresourcebundle");
                return true;
            } else {
                uWCPreferences = this.prefs.loadNode(this.configroot + SEP + "domain" + SEP + this.defaultLocale + SEP + "i18n.properties", "domain/" + this.domain + "defaultresourcebundle");
                if (uWCPreferences == null) return false;
                this.htmlEscapeValues(uWCPreferences);
                this.rbmap.put("default", "domain/" + this.domain + "defaultresourcebundle");
                this.rbmap.put(this.defaultLocale, "domain/" + this.domain + "defaultresourcebundle");
            }
            return true;
        }
        catch (UWCException uWCException) {
            log.warning("Unable to load default resource bundle for domain " + this.domain);
            return false;
        }
    }

    public UWCPreferences getDefaultResourceBundle() {
        String string = (String)this.rbmap.get("default");
        if (string != null) {
            return this.prefs.getNode(string);
        }
        log.warning("Default ResourceBundle for domain" + this.domain + "is not available/loaded");
        return null;
    }

    private void htmlEscapeValues(UWCPreferences uWCPreferences) {
        try {
            String[] stringArray = uWCPreferences.keys();
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = uWCPreferences.get(stringArray[i], null);
                    if (string == null) continue;
                    string = string.replaceAll("\\'", SINGLE_QUOT);
                    string = string.replaceAll("\\\"", DOUBLE_QUOT);
                    uWCPreferences.put(stringArray[i], string);
                }
            }
        }
        catch (BackingStoreException backingStoreException) {
            log.severe("Unable to HTML escape the values due to BackingStoreException");
        }
        catch (IllegalStateException illegalStateException) {
            log.severe("Unable to HTML escape the values due to IllegalStateException");
        }
    }

    public static String escape(String string) {
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer();
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\'': {
                    nonSyncStringBuffer.append(SINGLE_QUOT);
                    continue block4;
                }
                case '\"': {
                    nonSyncStringBuffer.append(DOUBLE_QUOT);
                    continue block4;
                }
                default: {
                    nonSyncStringBuffer.append(c);
                }
            }
        }
        return nonSyncStringBuffer.toString();
    }
}

