/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.util;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.html.Option;
import com.sun.comclient.calendar.Attendee;
import com.sun.uwc.common.util.UWCUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class AttendeeData
implements Serializable {
    public String choice;
    public String value;
    public String commonName;
    public String displayName;
    public boolean rsvp;
    public String partstat;
    public String userType;
    public String role;

    public AttendeeData(Attendee attendee) {
        if (null == attendee) {
            this._init(null, null, null, null, true, null, null, null);
            return;
        }
        String string = attendee.getValue();
        String string2 = attendee.getCommonName();
        String string3 = UWCUtils.getCalendarNameToDisplay(string, string2, 40, 20);
        this._init(string3, string, string2, string2, attendee.isRSVPRequired(), attendee.getParticipantStatus(), attendee.getUserType(), attendee.getRole());
    }

    public AttendeeData(String string, String string2) {
        this._init(string, string2, null, null, true, null, null, null);
    }

    public AttendeeData(String string, String string2, String string3, String string4, boolean bl) {
        this._init(string, string2, string3, string4, bl, null, null, null);
    }

    public AttendeeData(String string, String string2, String string3, String string4, boolean bl, String string5, String string6, String string7) {
        this._init(string, string2, string3, string4, bl, string5, string6, string7);
    }

    private void _init(String string, String string2, String string3, String string4, boolean bl, String string5, String string6, String string7) {
        this.choice = null == string ? "" : string;
        this.value = null == string2 ? "" : string2;
        this.commonName = null == string3 ? "" : string3;
        this.displayName = null == string4 ? "" : string4;
        this.rsvp = bl;
        this.partstat = null == string5 ? "NEEDS-ACTION" : string5;
        this.userType = null == string6 ? "INDIVIDUAL" : string6;
        this.role = null == string7 ? "REQ-PARTICIPANT" : string7;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.choice);
        objectOutputStream.writeUTF(this.value);
        objectOutputStream.writeUTF(this.displayName);
        objectOutputStream.writeUTF(this.commonName);
        objectOutputStream.writeBoolean(this.rsvp);
        objectOutputStream.writeUTF(this.partstat);
        objectOutputStream.writeUTF(this.userType);
        objectOutputStream.writeUTF(this.role);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.choice = objectInputStream.readUTF();
        this.value = objectInputStream.readUTF();
        this.displayName = objectInputStream.readUTF();
        this.commonName = objectInputStream.readUTF();
        this.rsvp = objectInputStream.readBoolean();
        this.partstat = objectInputStream.readUTF();
        this.userType = objectInputStream.readUTF();
        this.role = objectInputStream.readUTF();
    }

    public Attendee getAttendee() {
        Attendee attendee = null;
        try {
            attendee = new Attendee(this.userType, this.role, this.value);
            attendee.setParticipantStatus(this.partstat);
        }
        catch (Exception exception) {
            return null;
        }
        attendee.setCommonName(this.commonName);
        attendee.setRSVPRequired(this.rsvp);
        return attendee;
    }

    public void setAttendee(Attendee attendee) {
        if (null == attendee) {
            this._init(null, null, null, null, true, null, null, null);
        } else {
            this.choice = "choice-" + attendee.getValue();
            this.value = attendee.getValue();
            this.displayName = "disp-" + attendee.getValue();
            this.commonName = attendee.getCommonName();
            this.rsvp = attendee.isRSVPRequired();
            this.partstat = attendee.getParticipantStatus();
            this.userType = attendee.getUserType();
            this.role = attendee.getRole();
        }
    }

    public Option getOption() {
        return new Option(this.choice, this.value);
    }

    public String toString() {
        NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer(128);
        nonSyncStringBuffer.append("AttendeeData[");
        nonSyncStringBuffer.append("choice=" + this.choice);
        nonSyncStringBuffer.append("; value=" + this.value);
        nonSyncStringBuffer.append("; displayName=" + this.displayName);
        nonSyncStringBuffer.append("; commonName=" + this.commonName);
        nonSyncStringBuffer.append("; rsvp=" + this.rsvp);
        nonSyncStringBuffer.append("; partstat=" + this.partstat);
        nonSyncStringBuffer.append("; userType=" + this.userType);
        nonSyncStringBuffer.append("; role=" + this.role);
        nonSyncStringBuffer.append("]");
        return nonSyncStringBuffer.toString();
    }
}

