/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.model;

import com.iplanet.jato.RequestContext;
import com.sun.uwc.common.model.FilterAction;
import com.sun.uwc.common.model.FilterCondition;
import com.sun.uwc.common.model.FilterConstants;
import com.sun.uwc.common.model.Token;
import com.sun.uwc.common.util.UWCLogger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;

public class FilterRecord
implements Comparator {
    String name;
    String order;
    FilterCondition[] condList;
    FilterAction[] actionList;
    boolean isConjunction;
    int numConditions;
    int numActions;
    int mobileIndex = -1;
    String type;
    String extraComments = "";
    protected static Logger _frLogger = null;
    private static final transient String CLASS_NAME = "FilterRecord";
    private RequestContext _reqCtx;
    public static final String ALL_INCOMING_MESG = "ALL_INCOMING_MESG";
    public static final String TIMED_ALL_INCOMING_MESG = "TIMED_ALL_INCOMING_MESG";
    public static final String SPAM_DETECT = "SPAM_DETECT";
    public static final String DEFAULT_TYPE = "DEFAULT_TYPE";
    public static final String SENDER_HEADERS = "From,Sender,Resent-from,Resent-sender,Return-path";
    public static final String RECIP_HEADERS = "To,Cc,Bcc,Resent-to,Resent-cc,Resent-bcc";
    public static final String TO_HEADERS = "To,Resent-to";
    public static final String CC_HEADERS = "Cc,Resent-cc";
    public static final String SUBJECT_HEADERS = "Subject, Comments, Keywords";
    public static final String BeginFilterMark = "#BEGINFILTER";
    public static final String EndFilterMark = "#ENDFILTER";
    private static HashMap actCmdRequireMap;
    private static HashMap testCmdRequireMap;

    public FilterRecord(String string, String string2, boolean bl, FilterCondition[] filterConditionArray, FilterAction[] filterActionArray, RequestContext requestContext) {
        this.name = string;
        this.order = string2;
        this.isConjunction = bl;
        this.condList = filterConditionArray;
        this.actionList = filterActionArray;
        this.numConditions = this.condList.length;
        this.numActions = this.actionList.length;
        this.type = DEFAULT_TYPE;
        this._reqCtx = requestContext;
    }

    public FilterRecord(FilterRecord filterRecord, RequestContext requestContext) {
        this(filterRecord.name, filterRecord.order, filterRecord.isConjunction, filterRecord.condList, filterRecord.actionList, requestContext);
        this.type = filterRecord.type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FilterRecord(String string, String string2, String string3, String string4, RequestContext requestContext) {
        Object object;
        String[] stringArray;
        Object object2;
        String string5;
        String string6;
        Object object3;
        Object object4;
        _frLogger.entering(CLASS_NAME, "FilterRecord(name, ord, type, sieve)");
        String string7 = "^((\\s*?)\\ballof\\b(\\s*)\\((\\s*)(\\banyof|\\ballof)(.)*)";
        int n = -1;
        _frLogger.fine("DEBUG: sieve syntax: " + string4);
        if (string4 != null && string4.trim().equals("")) {
            throw new IllegalArgumentException("Invalid Sieve syntax");
        }
        n = string4.lastIndexOf("){");
        if (n == -1) {
            throw new IllegalArgumentException("No action found");
        }
        if (string4.matches(string7)) {
            object4 = "(\\((anyof|allof)(.)*(\\),anyof\\(allof))";
            object3 = new Token(string4, (String)object4);
            string6 = ((Token)object3).getNextToken();
            if (string6 == null) throw new IllegalArgumentException("No condition found");
            int n2 = string6.lastIndexOf("),anyof(allof");
            if (n2 == -1) {
                throw new IllegalArgumentException("No condition found");
            }
            string5 = string6.substring(0, n2 + 1);
            _frLogger.fine("DEBUG: nested condtion found " + string5);
        } else {
            string5 = string4.substring(0, n + 1);
            _frLogger.fine("DEBUG: old/nordirect type condtion found " + string5);
        }
        String string8 = string4.substring(n + 1);
        _frLogger.fine("DEBUG: action str is " + string8);
        if (string8 == null) throw new IllegalArgumentException("No action found-2");
        if (string8.charAt(0) != '{' || string8.charAt(string8.length() - 1) != '}') {
            throw new IllegalArgumentException("No action found-1");
        }
        string8 = string8.substring(1, string8.length() - 1);
        object4 = new Token(string5, FilterConstants.testListOp.getRegex());
        object3 = new Vector();
        this.name = string;
        this.order = string2;
        this.type = string3;
        this.mobileIndex = -1;
        string6 = ((Token)object4).getNextToken(FilterConstants.testListOp);
        if (string6 != null) {
            this.isConjunction = string6.equals("allof");
            object2 = new Token(string5, FilterConstants.totalSingleTestCmdRegex.getRegex());
            if (string3.equals(ALL_INCOMING_MESG) || string3.equals(TIMED_ALL_INCOMING_MESG)) {
                _frLogger.fine("All incoming msg");
                ((Vector)object3).addElement(FilterCondition.getAllTrueCondition());
            } else {
                _frLogger.fine("multiple conditions");
                stringArray = ((Token)object2).getNextToken();
                while (stringArray != null) {
                    object = new FilterCondition((String)stringArray, requestContext);
                    ((Vector)object3).addElement(object);
                    stringArray = ((Token)object2).getNextToken();
                }
                if (object3 == null) {
                    throw new IllegalArgumentException("Condition is not provided or invalid");
                }
            }
        } else {
            _frLogger.fine("single condition");
            object2 = new Token(string5, FilterConstants.totalSingleTestCmdRegex.getRegex());
            stringArray = ((Token)object2).getNextToken(FilterConstants.totalSingleTestCmdRegex);
            if (stringArray == null) {
                throw new IllegalArgumentException("Condition is not provided or invalid");
            }
            object = new FilterCondition((String)stringArray, requestContext);
            ((Vector)object3).addElement(object);
            this.isConjunction = true;
        }
        this.condList = new FilterCondition[((Vector)object3).size()];
        this.condList = ((Vector)object3).toArray(this.condList);
        this.numConditions = ((Vector)object3).size();
        object2 = new Vector();
        if (string8 != null) {
            _frLogger.fine("DEBUG: creating action");
            stringArray = string8.split(";");
            object = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || ((String)(object = stringArray[i].trim())).equals("")) continue;
                FilterAction filterAction = new FilterAction(stringArray[i]);
                ((Vector)object2).addElement(filterAction);
            }
            this.actionList = new FilterAction[((Vector)object2).size()];
            this.actionList = ((Vector)object2).toArray(this.actionList);
            this.numActions = ((Vector)object2).size();
            _frLogger.fine("DEBUG: successfully created all action");
        }
        this._reqCtx = requestContext;
        _frLogger.exiting(CLASS_NAME, "FilterRecord(name, ord, type, sieve)");
    }

    public FilterRecord(String string, String string2, String string3, RequestContext requestContext) {
        this(string, string2, DEFAULT_TYPE, string3, requestContext);
    }

    public String getName() {
        return this.name;
    }

    public String getOrder() {
        return this.order;
    }

    public boolean isEnabled() {
        return this.order == null || !this.order.startsWith("-");
    }

    public void toggleStatus() {
        this.order = this.order != null && this.order.startsWith("-") ? this.order.substring(1) : "-" + this.order;
    }

    public FilterCondition[] getConditionList() {
        return this.condList;
    }

    public FilterAction[] getActionList() {
        return this.actionList;
    }

    public int getNumConditions() {
        return this.numConditions;
    }

    public int getNumActions() {
        return this.numActions;
    }

    public String getType() {
        return this.type;
    }

    public int getMobileIndex() {
        return this.mobileIndex;
    }

    public boolean isAnd() {
        return this.isConjunction;
    }

    public void setOrder(String string) {
        this.order = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void setMobileIndex(int n) {
        this.mobileIndex = n;
    }

    public void setExtraComments(String string) {
        this.extraComments = string;
    }

    public String getNameLine() {
        String string = "#RULE: $Name=\"" + this.name + "\"   $Order=" + this.order + "   $Type=\"" + this.type + "\"";
        string = this.mobileIndex != -1 ? string + "   $Mobile=" + this.mobileIndex + "\n" : string + "\n";
        return string;
    }

    public String toSieve(boolean bl) {
        Object object;
        Object object2;
        String string;
        String string2;
        String string3 = this.isConjunction ? "allof" : "anyof";
        String string4 = this.condList[0].toSieve();
        String string5 = (String)testCmdRequireMap.get(this.condList[0].getCommandName());
        if (string5 == null) {
            string5 = "";
        }
        for (int i = 1; i < this.numConditions; ++i) {
            string2 = (String)testCmdRequireMap.get(this.condList[i].getCommandName());
            if (string2 != null) {
                string5 = string5 + string2;
            }
            string4 = string4 + "," + this.condList[i].toSieve();
        }
        string4 = "(" + string4.trim() + ")";
        string3 = string3 + string4;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        string2 = this.actionList[0].toSieve();
        String string6 = new String();
        String string7 = (String)actCmdRequireMap.get(this.actionList[0].getCommandName());
        boolean bl2 = false;
        if (this.actionList[0].getCommandName().equals("notify")) {
            bl2 = true;
        }
        if (string7 != null) {
            hashMap.put(this.actionList[0].getCommandName(), string7);
            string7 = "";
        } else {
            string7 = "";
        }
        for (int i = 1; i < this.numActions; ++i) {
            string6 = this.actionList[i].getCommandName();
            string = (String)actCmdRequireMap.get(string6);
            if (string != null) {
                hashMap.put(string6, string);
            }
            string2 = string2 + "\n" + this.actionList[i].toSieve();
            if (!string6.equals("notify")) continue;
            bl2 = true;
        }
        Iterator iterator = hashMap.values().iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (string == null) continue;
                string7 = string7 + string;
            }
        }
        if (bl2) {
            object2 = new String[]{"*"};
            object = SUBJECT_HEADERS.split(",");
            FilterCondition filterCondition = new FilterCondition("header", (String[])object, ":matches", (String[])object2, false, false);
            String[] stringArray = new String[]{"POSTMASTER-AUTO-FW:*", "postmaster-auto-fw:*"};
            FilterCondition filterCondition2 = new FilterCondition("header", (String[])object, ":matches", stringArray, true, false);
            string3 = "allof(" + string3;
            string3 = string3 + ",anyof(allof(" + filterCondition2.toSieve() + "," + filterCondition.toSieve() + "),true))";
        }
        object2 = "#BEGINFILTER\nif " + string3 + "{\n" + string2 + "\n}\n" + EndFilterMark + "\n";
        if (this.extraComments.length() > 0) {
            this.extraComments = "\n\n" + this.extraComments;
        }
        object = (bl ? "" : this.getNameLine()) + string5 + string7 + (String)object2 + this.extraComments;
        return object;
    }

    public String toSieve() {
        return this.toSieve(false);
    }

    public static void sort(FilterRecord[] filterRecordArray) {
        Arrays.sort(filterRecordArray, filterRecordArray[0]);
    }

    public int compare(Object object, Object object2) {
        FilterRecord filterRecord = (FilterRecord)object;
        FilterRecord filterRecord2 = (FilterRecord)object2;
        int n = 0;
        int n2 = 0;
        try {
            n = Math.abs(Integer.parseInt(filterRecord.order));
            n2 = Math.abs(Integer.parseInt(filterRecord2.order));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n - n2;
    }

    public static void main(String[] stringArray) {
    }

    static {
        _frLogger = UWCLogger.getLogger("uwc");
        actCmdRequireMap = new HashMap();
        testCmdRequireMap = new HashMap();
        testCmdRequireMap.put("envelope", "require \"envelope\";\n");
        actCmdRequireMap.put("fileinto", "require \"fileinto\";\n");
        actCmdRequireMap.put("notify", "require \"notify\";\nrequire \"variables\";\n");
    }
}

