/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ExecutingModel;
import com.iplanet.jato.model.InsertingModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.ModelExecutionContext;
import com.iplanet.jato.model.RetrievingModel;
import com.iplanet.jato.model.custom.SimpleCustomModel;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.FilterCondition;
import com.sun.uwc.common.model.FilterConstants;
import com.sun.uwc.common.model.MailFilterModelExecutionContext;
import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCUtils;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;

public class FilterConditionListModel
extends SimpleCustomModel
implements ExecutingModel,
RetrievingModel,
InsertingModel {
    private static final long serialVersionUID = 1L;
    public static final String FIELD_ROW_INDEX = "rowIndex";
    public static final String FIELD_HEADER_TYPE = "headerType";
    public static final String FIELD_MATCH_TYPE = "matchType";
    public static final String FIELD_HEADER_VALUE = "headerValue";
    public static final String FIELD_CHECK_CASE = "checkCase";
    private FilterCondition[] fclist;
    private RequestContext _context;
    private static Logger _newFilterLogger = null;

    public FilterConditionListModel() {
        _newFilterLogger.fine("DEBUG: In FilterConditionListModel constructor");
    }

    public Object execute(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        String string = modelExecutionContext.getOperationName();
        _newFilterLogger.fine("execute: DEBUG: oprName: " + string);
        if (string.equals(MailFilterModelExecutionContext.OPERATION_RETRIEVE_NEW) || string.equals(MailFilterModelExecutionContext.OPERATION_RETRIEVE_EDIT)) {
            this.retrieve(modelExecutionContext);
        } else if (modelExecutionContext.getOperationName().equals("insert")) {
            this.insert(modelExecutionContext);
        } else if (modelExecutionContext.getOperationName().equals(MailFilterModelExecutionContext.OPERATION_CREATE_FILTER_CONDITION)) {
            return this.createFilterConditionArray(modelExecutionContext);
        }
        return null;
    }

    public Object retrieve(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        if (modelExecutionContext.getOperationName().equals(MailFilterModelExecutionContext.OPERATION_RETRIEVE_NEW)) {
            if (this.getNumRows() == 0) {
                this.appendRow();
                this.setValue(FIELD_ROW_INDEX, "0");
            }
            this.beforeFirst();
        } else if (modelExecutionContext.getOperationName().equals(MailFilterModelExecutionContext.OPERATION_RETRIEVE_EDIT)) {
            this.populateData();
            this.beforeFirst();
        }
        return null;
    }

    private void populateData() throws ModelControlException {
        _newFilterLogger.fine("populateData: DEBUG: no of rows at start: " + this.getNumRows());
        _newFilterLogger.fine("populateData: DEBUG: fclist.length: " + this.fclist.length);
        _newFilterLogger.fine("populateData: DEBUG: fclist[0].isSizePresent(): " + this.fclist[0].isSizePresent());
        if (this.getNumRows() == 0) {
            for (int i = 0; i < this.fclist.length; ++i) {
                String string;
                String string2;
                String string3;
                Object object;
                if (this.fclist[i].isSizePresent()) {
                    object = this.fclist[i];
                    if (object == null) continue;
                    this.appendRow();
                    string3 = ((FilterCondition)object).getFieldValueList()[0];
                    string3 = string3.substring(0, string3.length() - 1);
                    string2 = ((FilterCondition)object).getCompOperator();
                    string = string2.equals(":under") ? "0" : "1";
                    _newFilterLogger.fine("populateData: DEBUG: op is - " + string);
                    this.setValue(FIELD_HEADER_TYPE, FilterConstants.HEADERTYPE_MESSAGE_SIZE);
                    this.setValue(FIELD_MATCH_TYPE, string);
                    this.setValue(FIELD_HEADER_VALUE, string3);
                    this.setValue(FIELD_ROW_INDEX, String.valueOf(this.getNumRows() - 1));
                    continue;
                }
                object = this.fclist[i].getFieldNameList()[0];
                string3 = this.fclist[i].getFieldNameList()[1];
                string2 = this.fclist[i].getFieldValueList()[0];
                string = this.fclist[i].getCompOperator();
                boolean bl = this.fclist[i].isCaseSensitive();
                String string4 = Boolean.toString(bl);
                _newFilterLogger.fine("populateData: DEBUG: check case is - " + string4);
                boolean bl2 = this.fclist[i].isNegated();
                if (string2 != null) {
                    string2 = UWCUtils.unEscape(string2);
                }
                String string5 = null;
                if (string != null && string.length() > 0 && (string5 = (string = string.trim()).substring(1)) != null) {
                    if (string5.equals(FilterConstants.MATCHTYPE_CONTAINS) && bl2) {
                        string5 = FilterConstants.MATCHTYPE_DOES_NOT_CONTAIN;
                    }
                    if (string5.equals(FilterConstants.MATCHTYPE_IS) && bl2) {
                        string5 = FilterConstants.MATCHTYPE_IS_NOT;
                    }
                    if (string5.equals(FilterConstants.MATCHTYPE_MATCHES) && string2 != null && string2.length() > 0) {
                        if ((string2 = string2.trim()).startsWith("*")) {
                            string2 = string2.substring(1);
                            string5 = FilterConstants.MATCHTYPE_ENDS_WITH;
                        }
                        if (string2.endsWith("*")) {
                            int n = string2.length() - 1;
                            string2 = string2.substring(0, n);
                            string5 = FilterConstants.MATCHTYPE_BEGINS_WITH;
                        }
                    }
                }
                if (((String)object).equals("From")) {
                    this.appendRow();
                    this.setValue(FIELD_HEADER_TYPE, FilterConstants.HEADERTYPE_SENDER);
                    if (string5 != null) {
                        this.setValue(FIELD_MATCH_TYPE, string5);
                    }
                    this.setValue(FIELD_HEADER_VALUE, string2);
                    this.setValue(FIELD_CHECK_CASE, string4);
                    this.setValue(FIELD_ROW_INDEX, String.valueOf(this.getNumRows() - 1));
                }
                if (((String)object).equals("To")) {
                    if (string3.equals("Cc")) {
                        this.appendRow();
                        this.setValue(FIELD_HEADER_TYPE, FilterConstants.HEADERTYPE_RECIPIENT);
                        if (string5 != null) {
                            this.setValue(FIELD_MATCH_TYPE, string5);
                        }
                        this.setValue(FIELD_HEADER_VALUE, string2);
                        this.setValue(FIELD_CHECK_CASE, string4);
                        this.setValue(FIELD_ROW_INDEX, String.valueOf(this.getNumRows() - 1));
                    } else if (string3.equals("Resent-to")) {
                        this.appendRow();
                        this.setValue(FIELD_HEADER_TYPE, FilterConstants.HEADERTYPE_TO);
                        if (string5 != null) {
                            this.setValue(FIELD_MATCH_TYPE, string5);
                        }
                        this.setValue(FIELD_HEADER_VALUE, string2);
                        this.setValue(FIELD_CHECK_CASE, string4);
                        this.setValue(FIELD_ROW_INDEX, String.valueOf(this.getNumRows() - 1));
                    }
                }
                if (((String)object).equals("Cc")) {
                    this.appendRow();
                    this.setValue(FIELD_HEADER_TYPE, FilterConstants.HEADERTYPE_CC);
                    if (string5 != null) {
                        this.setValue(FIELD_MATCH_TYPE, string5);
                    }
                    this.setValue(FIELD_HEADER_VALUE, string2);
                    this.setValue(FIELD_CHECK_CASE, string4);
                    this.setValue(FIELD_ROW_INDEX, String.valueOf(this.getNumRows() - 1));
                }
                if (!((String)object).equals("Subject")) continue;
                this.appendRow();
                this.setValue(FIELD_HEADER_TYPE, FilterConstants.HEADERTYPE_SUBJECT);
                if (string5 != null) {
                    this.setValue(FIELD_MATCH_TYPE, string5);
                }
                this.setValue(FIELD_HEADER_VALUE, string2);
                this.setValue(FIELD_CHECK_CASE, string4);
                this.setValue(FIELD_ROW_INDEX, String.valueOf(this.getNumRows() - 1));
            }
        }
        _newFilterLogger.fine("populateData: DEBUG: no of rows at end: " + this.getNumRows());
    }

    public void reindex() throws ModelControlException {
        this.first();
        for (int i = 0; i < this.getNumRows(); ++i) {
            this.setValue(FIELD_ROW_INDEX, String.valueOf(i));
            this.next();
        }
        this.beforeFirst();
    }

    public void deleteRow(String string) throws ModelControlException {
        _newFilterLogger.fine("deleteRow: getLocation - " + this.getLocation());
        _newFilterLogger.fine("deleteRow: getSize - " + this.getSize());
        int n = Integer.parseInt(string);
        if (this.getLocation() > -1 && this.getLocation() < this.getSize()) {
            this.getRowList().remove(n);
            this.setLocation(n - 1);
        }
    }

    public Object insert(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        this.last();
        _newFilterLogger.fine("insert: DEBUG: value map: " + this.getValueMap());
        Map map = this.getValueMap();
        if (map.size() == 1) {
            this.deleteRow("0");
        }
        this.appendRow();
        String string = UWCUserHelper.getLocalizedLabel(this._context, "filter-headerTypeList", "uwc-mail-options-");
        String[] stringArray = string.split(",");
        this.setValue(FIELD_HEADER_TYPE, stringArray[0]);
        String string2 = UWCUserHelper.getLocalizedLabel(this._context, "filter-oprLabels", "uwc-mail-options-");
        String[] stringArray2 = string2.split(",");
        this.setValue(FIELD_MATCH_TYPE, stringArray2[0]);
        this.setValue(FIELD_HEADER_VALUE, "");
        this.setValue(FIELD_ROW_INDEX, String.valueOf(this.getNumRows() - 1));
        this.beforeFirst();
        return null;
    }

    public Vector createFilterConditionArray(ModelExecutionContext modelExecutionContext) throws ModelControlException {
        Vector<FilterCondition> vector = new Vector<FilterCondition>();
        this.first();
        _newFilterLogger.fine("createFilterConditionArray: DEBUG: no of rows: " + this.getNumRows());
        for (int i = 0; i < this.getNumRows(); ++i) {
            String string = (String)this.getValue(FIELD_HEADER_TYPE);
            _newFilterLogger.fine("createFilterConditionArray: DEBUG: headerType value - " + string);
            String string2 = (String)this.getValue(FIELD_MATCH_TYPE);
            _newFilterLogger.fine("createFilterConditionArray: DEBUG: matchType value - " + string2);
            String string3 = (String)this.getValue(FIELD_HEADER_VALUE);
            String string4 = (String)this.getValue(FIELD_CHECK_CASE);
            if (string3 == null) {
                this.next();
                continue;
            }
            if (string3.matches("\\s*")) {
                this.next();
                continue;
            }
            String string5 = null;
            if (string.equals(FilterConstants.HEADERTYPE_SENDER)) {
                string5 = "From,Sender,Resent-from,Resent-sender,Return-path";
            } else if (string.equals(FilterConstants.HEADERTYPE_SUBJECT)) {
                string5 = "Subject, Comments, Keywords";
            } else if (string.equals(FilterConstants.HEADERTYPE_RECIPIENT)) {
                string5 = "To,Cc,Bcc,Resent-to,Resent-cc,Resent-bcc";
            } else if (string.equals(FilterConstants.HEADERTYPE_TO)) {
                string5 = "To,Resent-to";
            } else if (string.equals(FilterConstants.HEADERTYPE_CC)) {
                string5 = "Cc,Resent-cc";
            }
            if (string.equals(FilterConstants.HEADERTYPE_MESSAGE_SIZE)) {
                String string6 = string2;
                String string7 = string3;
                if (string7 != null && string7.matches("\\d+")) {
                    float f = Float.parseFloat(string7);
                    int n = (int)f;
                    String string8 = n + "K";
                    FilterCondition filterCondition = null;
                    if (string6.equals("0")) {
                        filterCondition = FilterCondition.getSizeCondition(false, string8, false);
                    } else if (string6.equals("1")) {
                        filterCondition = FilterCondition.getSizeCondition(true, string8, false);
                    }
                    vector.add(filterCondition);
                }
                this.next();
                continue;
            }
            vector.add(this._getFilterCondition(string5, string2, string3, string4));
            this.next();
        }
        return vector;
    }

    private FilterCondition _getFilterCondition(String string, String string2, String string3, String string4) {
        String[] stringArray = string.split(",");
        boolean bl = false;
        boolean bl2 = Boolean.valueOf(string4);
        String string5 = "header";
        String string6 = ":contains";
        string3 = UWCUtils.escape(string3);
        if (string2.equals(FilterConstants.MATCHTYPE_CONTAINS)) {
            string6 = ":contains";
            bl = false;
        } else if (string2.equals(FilterConstants.MATCHTYPE_DOES_NOT_CONTAIN)) {
            string6 = ":contains";
            bl = true;
        } else if (string2.equals(FilterConstants.MATCHTYPE_IS)) {
            string6 = ":is";
            bl = false;
        } else if (string2.equals(FilterConstants.MATCHTYPE_IS_NOT)) {
            string6 = ":is";
            bl = true;
        } else if (string2.equals(FilterConstants.MATCHTYPE_BEGINS_WITH)) {
            string6 = ":matches";
            bl = false;
            string3 = string3 + "*";
        } else if (string2.equals(FilterConstants.MATCHTYPE_ENDS_WITH)) {
            string6 = ":matches";
            bl = false;
            string3 = "*" + string3;
        } else if (string2.equals(FilterConstants.MATCHTYPE_MATCHES)) {
            string6 = ":matches";
            bl = false;
        }
        String[] stringArray2 = new String[]{string3};
        FilterCondition filterCondition = new FilterCondition(string5, stringArray, string6, stringArray2, bl, bl2);
        return filterCondition;
    }

    public void setFilterCondition(FilterCondition[] filterConditionArray) {
        this.fclist = filterConditionArray;
    }

    public void setRequestContext(RequestContext requestContext) {
        this._context = requestContext;
    }

    static {
        _newFilterLogger = UWCLogger.getLogger("uwc.mail.options");
    }
}

