/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.model;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.uwc.common.UWCUserHelper;
import com.sun.uwc.common.model.FilterConstants;
import com.sun.uwc.common.model.Token;
import com.sun.uwc.common.util.UWCLogger;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilterCondition {
    String commandName;
    String compOperator;
    String type;
    String[] fieldNameList;
    String[] fieldValueList;
    boolean negate;
    boolean isCasesensitive = false;
    boolean sizeFlag = false;
    private static RequestContext _reqCtx = null;
    protected static Logger _fcLogger = null;
    private static final transient String CLASS_NAME = "FilterCondition";
    private final String containsOpr = ":contains";
    private final String isOpr = ":is";
    private final String matchesOpr = ":matches";

    public FilterCondition() {
        this.compOperator = "";
        this.commandName = "";
        this.type = "DEFAULT_TYPE";
        this.fieldValueList = null;
        this.fieldNameList = null;
        this.negate = false;
        this.isCasesensitive = false;
    }

    public FilterCondition(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl, String string3) {
        this.commandName = string;
        this.compOperator = string2;
        this.fieldNameList = stringArray;
        this.fieldValueList = stringArray2;
        this.negate = bl;
        this.type = string3;
    }

    public FilterCondition(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl, String string3, boolean bl2) {
        this(string, stringArray, string2, stringArray2, bl, string3);
        this.isCasesensitive = string2.equals(":contains") | string2.equals(":is") | string2.equals(":matches") && bl2 ? bl2 : false;
    }

    public FilterCondition(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl) {
        this(string, stringArray, string2, stringArray2, bl, "DEFAULT_TYPE");
    }

    public FilterCondition(String string, String[] stringArray, String string2, String[] stringArray2, boolean bl, boolean bl2) {
        this(string, stringArray, string2, stringArray2, bl, "DEFAULT_TYPE", bl2);
    }

    public FilterCondition(FilterCondition filterCondition) {
        this(filterCondition.commandName, filterCondition.fieldNameList, filterCondition.compOperator, filterCondition.fieldValueList, filterCondition.negate, filterCondition.isCasesensitive);
    }

    public FilterCondition(String string, String string2, RequestContext requestContext) {
        Object object;
        _fcLogger.entering(CLASS_NAME, "FilterCondition(sieveSyntax, tp, reqCtx)");
        if (requestContext == null) {
            requestContext = RequestManager.getRequestContext();
        }
        _reqCtx = requestContext;
        Token token = new Token(string = string.trim());
        String string3 = token.getNextToken("not");
        this.negate = string3 != null;
        this.type = string2;
        this.commandName = token.getNextToken(FilterConstants.cmdRegex);
        this.sizeFlag = this.commandName.equals("size");
        this.compOperator = token.getNextToken(FilterConstants.opRegex);
        if (this.compOperator != null) {
            int n = this.compOperator.indexOf(":comparator \"i;octet\"");
            if (n != -1) {
                this.isCasesensitive = true;
                object = new Token(this.compOperator);
                this.compOperator = ((Token)object).getNextToken(FilterConstants.caseInsensitiveopRegex);
                _fcLogger.fine("DEBUG: striping of case operator " + this.compOperator);
            } else {
                this.isCasesensitive = false;
            }
        } else {
            this.isCasesensitive = false;
        }
        string3 = token.getNextToken(FilterConstants.fieldListRegex);
        _fcLogger.fine("Name list token is: " + string3);
        this.fieldNameList = this._processFieldList(string3);
        string3 = token.getNextToken(FilterConstants.fieldListRegex);
        _fcLogger.fine("Value list token is: " + string3);
        if (string3 != null) {
            this.fieldValueList = this._processFieldList(string3);
        } else {
            this.fieldValueList = this.fieldNameList;
            String string4 = this.fieldValueList[0].trim();
            char c = string4.charAt(string4.length() - 1);
            int n = 1;
            if (c == 'M') {
                n = 1024;
            } else if (c == 'G') {
                n = 0x100000;
            }
            int n2 = 0;
            try {
                n2 = Integer.parseInt(string4.substring(0, string4.length() - 1));
                n2 *= n;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.sizeFlag) {
                this.fieldValueList[0] = n2 + "K";
            }
            this.fieldNameList = null;
        }
        if (_fcLogger.isLoggable(Level.FINE)) {
            _fcLogger.fine("checking for Spam detection...");
        }
        String string5 = UWCUserHelper.getPerDomainConfigAttrValue(_reqCtx, "uwc-mail-options-", "isSpamDetectEnabled", "false");
        if (_fcLogger.isLoggable(Level.FINE)) {
            _fcLogger.fine("isSpamDetectEnabled: " + string5);
        }
        if (string5 != null && (string5.equalsIgnoreCase("true") || string5.equalsIgnoreCase("yes"))) {
            object = UWCUserHelper.getLocalizedLabel(_reqCtx, "spamHeaderName", "uwc-mail-options-", "");
            String string6 = UWCUserHelper.getLocalizedLabel(_reqCtx, "spamHeaderValue", "uwc-mail-options-", "");
            if (this.fieldNameList != null && this.fieldNameList[0].equalsIgnoreCase((String)object) && this.fieldValueList != null && this.fieldValueList[0].equalsIgnoreCase(string6)) {
                this.type = "SPAM_DETECT";
            }
        }
        _fcLogger.exiting(CLASS_NAME, "FilterCondition(sieveSyntax, tp)");
    }

    public FilterCondition(String string, RequestContext requestContext) {
        this(string, "DEFAULT_TYPE", requestContext);
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getCompOperator() {
        return this.compOperator;
    }

    public String[] getFieldNameList() {
        return this.fieldNameList;
    }

    public String[] getFieldValueList() {
        return this.fieldValueList;
    }

    public boolean isNegated() {
        return this.negate;
    }

    public boolean isCaseSensitive() {
        return this.isCasesensitive;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSizePresent() {
        return this.sizeFlag;
    }

    public static FilterCondition getAllTrueCondition() {
        FilterCondition filterCondition = new FilterCondition();
        filterCondition.type = "ALL_INCOMING_MESG";
        return filterCondition;
    }

    public static FilterCondition getSpamDetectCondition() {
        if (_reqCtx == null) {
            _reqCtx = RequestManager.getRequestContext();
        }
        String string = UWCUserHelper.getLocalizedLabel(_reqCtx, "spamHeaderName", "uwc-mail-options-", "");
        String string2 = UWCUserHelper.getLocalizedLabel(_reqCtx, "spamHeaderValue", "uwc-mail-options-", "");
        String[] stringArray = new String[]{string};
        String[] stringArray2 = new String[]{string2};
        FilterCondition filterCondition = new FilterCondition();
        filterCondition.type = "SPAM_DETECT";
        filterCondition.fieldNameList = stringArray;
        filterCondition.fieldValueList = stringArray2;
        filterCondition.commandName = "header";
        filterCondition.compOperator = ":contains";
        return filterCondition;
    }

    public static FilterCondition getSpamDetectCondition(boolean bl) {
        FilterCondition filterCondition = FilterCondition.getSpamDetectCondition();
        filterCondition.isCasesensitive = bl;
        return filterCondition;
    }

    public static FilterCondition getSizeCondition(boolean bl, String string, boolean bl2) {
        FilterCondition filterCondition = new FilterCondition();
        filterCondition.sizeFlag = true;
        filterCondition.commandName = "size";
        filterCondition.compOperator = bl ? ":over" : ":under";
        filterCondition.fieldValueList = new String[]{string};
        filterCondition.negate = bl2;
        filterCondition.isCasesensitive = false;
        return filterCondition;
    }

    public String toSieve() {
        if (this.type.equals("ALL_INCOMING_MESG")) {
            return "true";
        }
        _fcLogger.fine("DEBUG: compOperator before" + this.compOperator);
        String string = this.isCasesensitive ? this.compOperator.concat(" :comparator \"i;octet\"") : this.compOperator;
        _fcLogger.fine("DEBUG: compOperator after" + this.compOperator);
        String string2 = this.commandName + " " + string + " ";
        String string3 = "";
        if (this.fieldNameList != null) {
            string3 = "\"" + this.fieldNameList[0] + "\"";
            if (this.fieldNameList.length > 1) {
                for (int i = 1; i < this.fieldNameList.length; ++i) {
                    string3 = string3 + ",\"" + this.fieldNameList[i] + "\"";
                }
                string3 = "[" + string3 + "]";
            }
        }
        String string4 = this.fieldValueList[0];
        if (!this.sizeFlag) {
            string4 = "\"" + string4 + "\"";
        }
        if (this.fieldValueList.length > 1) {
            for (int i = 1; i < this.fieldValueList.length; ++i) {
                string4 = string4 + ",\"" + this.fieldValueList[i] + "\"";
            }
            string4 = "[" + string4 + "]";
        }
        string2 = string2 + (string3.length() > 0 ? string3 + " " : "") + string4;
        if (this.negate) {
            string2 = "not " + string2;
        }
        return string2;
    }

    private String[] _processFieldList(String string) {
        Object object;
        _fcLogger.entering(CLASS_NAME, "_processFieldList");
        String[] stringArray = null;
        if (string.startsWith("[")) {
            object = new Token(string);
            Vector<String> vector = new Vector<String>();
            String string2 = ((Token)object).getNextToken(FilterConstants.singleArg);
            while (string2 != null) {
                String[] stringArray2 = string2.split("\"");
                String string3 = stringArray2[stringArray2.length - 1];
                vector.addElement(string3);
                string2 = ((Token)object).getNextToken(FilterConstants.singleArg);
            }
            stringArray = new String[vector.size()];
            stringArray = vector.toArray(stringArray);
        } else {
            object = string.trim();
            if (((String)object).length() > 1) {
                stringArray = new String[]{((String)object).substring(1, ((String)object).length() - 1)};
            }
        }
        _fcLogger.exiting(CLASS_NAME, "_processFieldList");
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                _fcLogger.fine("list[" + i + "]=" + stringArray[i]);
            }
        } else {
            _fcLogger.fine("list is null");
        }
        return stringArray;
    }

    static {
        _fcLogger = UWCLogger.getLogger("uwc");
    }
}

