/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.ldap;

import com.sun.uwc.common.ldap.LDAPRebindImpl;
import com.sun.uwc.common.ldap.PasswordExpiringException;
import com.sun.uwc.common.ldap.PasswordResetException;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModification;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSocketFactory;

public class LDAPUtil {
    private static final String LDAP_USER_PASSWORD_ATTR_NAME = "userPassword";
    private Hashtable _attrVals = null;
    private LDAPConnection _ldc = null;
    private String _DN = null;
    private int _version = 3;
    private String _sslClass = "com.sun.uwc.common.ldap.LdapSslSocketFactoryImpl";
    private boolean _enableSSL = false;
    private boolean _readControls = false;
    private boolean _hasProxyAuthSupport = false;
    private boolean _enablePasswordReset = false;
    private static final String LDAP_VERSION = "ldapversion";
    private static final String LDAP_READ_CONTROLS = "readcontrols";
    private static final String ENABLE_SSL = "enablessl";
    private static final String LDAP_SSL_FACTORY_CLASS = "ldapsslfactoryclass";
    private static final String LDAP_ENABLE_PASSWORD_RESET = "enablepasswordreset";
    private static final String[] ZERO_STRING_ARRAY = new String[0];

    public LDAPUtil(LDAPConnection lDAPConnection, String string) throws IllegalArgumentException {
        this.setDN(string);
        if (null == lDAPConnection) {
            throw new IllegalArgumentException("null LDAP connection: null ldc argument");
        }
        this._ldc = lDAPConnection;
    }

    public LDAPUtil(LDAPConnection lDAPConnection, String string, String string2, String string3, boolean bl) throws IllegalArgumentException, LDAPException, PasswordResetException, PasswordExpiringException {
        this.setDN(string3);
        if (null == lDAPConnection) {
            throw new IllegalArgumentException("null LDAP connection: null ldc argument");
        }
        this._ldc = lDAPConnection;
        this.authenticate(string, string2, bl);
    }

    public LDAPUtil(String string, int n, String string2, String string3) throws IllegalArgumentException, LDAPException, PasswordResetException, PasswordExpiringException {
        this(string, n, string2, string3, string2, null);
    }

    public LDAPUtil(String string, int n, String string2, String string3, String string4) throws IllegalArgumentException, LDAPException, PasswordResetException, PasswordExpiringException {
        this(string, n, string2, string3, string4, null);
    }

    public LDAPUtil(String string, int n, String string2, String string3, String string4, Properties properties) throws IllegalArgumentException, LDAPException, PasswordResetException, PasswordExpiringException {
        this.setDN(string4);
        this.parseProperties(properties);
        LDAPConnection lDAPConnection = null;
        LDAPRebindImpl lDAPRebindImpl = null;
        if (!this._enableSSL) {
            lDAPConnection = new LDAPConnection();
        } else {
            try {
                Class<?> clazz = Class.forName(this._sslClass);
                Class[] classArray = new Class[]{};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{};
                LDAPSocketFactory lDAPSocketFactory = (LDAPSocketFactory)constructor.newInstance(objectArray);
                lDAPConnection = new LDAPConnection(lDAPSocketFactory);
                lDAPRebindImpl = new LDAPRebindImpl(string2, string3);
            }
            catch (Exception exception) {
                throw new LDAPException("ERROR initializing LDAP SSL socket factory class: \"" + this._sslClass + "\"");
            }
        }
        lDAPConnection.setOption(17, (Object)new Integer(this._version));
        lDAPConnection.setOption(8, (Object)new Boolean(true));
        lDAPConnection.setOption(9, lDAPRebindImpl);
        lDAPConnection.connect(string, n);
        this._ldc = lDAPConnection;
        this.authenticate(string2, string3, this._readControls);
    }

    public void authenticate(String string, String string2, boolean bl) throws LDAPException, PasswordResetException, PasswordExpiringException {
        try {
            this._ldc.authenticate(string, string2);
        }
        catch (LDAPException lDAPException) {
            LDAPControl[] lDAPControlArray;
            if (bl && null != (lDAPControlArray = this._ldc.getResponseControls())) {
                for (int i = 0; i < lDAPControlArray.length; ++i) {
                    String string3 = lDAPControlArray[i].getID();
                    if (string3.equals("2.16.840.1.113730.3.4.4")) {
                        throw new PasswordResetException();
                    }
                    if (!string3.equals("2.16.840.1.113730.3.4.5")) continue;
                    throw new PasswordExpiringException(new String(lDAPControlArray[i].getValue()));
                }
            }
            throw lDAPException;
        }
        this._attrVals = null;
    }

    public void disconnect() throws LDAPException {
        this._ldc.disconnect();
    }

    private void parseProperties(Properties properties) {
        if (null == properties) {
            return;
        }
        try {
            this._version = Integer.parseInt(properties.getProperty(LDAP_VERSION));
        }
        catch (Exception exception) {
            this._version = 3;
        }
        this._enablePasswordReset = Boolean.valueOf(properties.getProperty(LDAP_ENABLE_PASSWORD_RESET));
        this._readControls = Boolean.valueOf(properties.getProperty(LDAP_READ_CONTROLS));
        this._enableSSL = Boolean.valueOf(properties.getProperty(ENABLE_SSL));
        this._sslClass = properties.getProperty(LDAP_SSL_FACTORY_CLASS, "com.sun.uwc.common.ldap.LdapSslSocketFactoryImpl");
    }

    private boolean isProxyAuthSupported(LDAPConnection lDAPConnection) {
        if (null == lDAPConnection) {
            return false;
        }
        try {
            LDAPAttribute lDAPAttribute;
            String string = "supportedcontrol";
            LDAPEntry lDAPEntry = lDAPConnection.read("", new String[]{string});
            if (null != lDAPEntry && null != (lDAPAttribute = lDAPEntry.getAttribute(string))) {
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (string2 == null || !string2.equals("2.16.840.1.113730.3.4.12")) continue;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public LDAPConnection getLDAPConnection() {
        return this._ldc;
    }

    public String getDN() {
        return this._DN;
    }

    public void setDN(String string) throws IllegalArgumentException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("no target DN: null or blank DN argument");
        }
        if (!string.equals(this._DN)) {
            this._attrVals = null;
        }
        this._DN = string;
    }

    public LDAPControl[] getResponseControls() {
        return this._ldc.getResponseControls();
    }

    public void loadValues() throws LDAPException {
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        LDAPSearchResults lDAPSearchResults = this._ldc.search(this._DN, 0, null, null, false);
        if (lDAPSearchResults.hasMoreElements()) {
            LDAPEntry lDAPEntry = lDAPSearchResults.next();
            LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
            for (int i = 0; i < lDAPAttributeSet.size(); ++i) {
                LDAPAttribute lDAPAttribute = lDAPAttributeSet.elementAt(i);
                hashtable.put(lDAPAttribute.getName(), lDAPAttribute.getStringValueArray());
            }
        }
        this._attrVals = hashtable;
    }

    public static String getValue(LDAPEntry lDAPEntry, String string) {
        String[] stringArray = LDAPUtil.getValues(lDAPEntry, string);
        if (null != stringArray && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public static String[] getValues(LDAPEntry lDAPEntry, String string) {
        if (null == lDAPEntry || null == string) {
            return null;
        }
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
        return lDAPAttribute.getStringValueArray();
    }

    public boolean isAttributePresent(String string) {
        return null != this.getStringValue(string, null);
    }

    public boolean isValuePresentIgnoreCase(String string, String string2) {
        if (null == string || null == string2) {
            return false;
        }
        String[] stringArray = this.getStringArrayValue(string, null);
        if (null == stringArray) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isValuePresent(String string, String string2) {
        if (null == string || null == string2) {
            return false;
        }
        String[] stringArray = this.getStringArrayValue(string, null);
        if (null == stringArray) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public String getPassword() throws LDAPException {
        return this.getValue(LDAP_USER_PASSWORD_ATTR_NAME);
    }

    public void setPassword(String string) throws LDAPException, IllegalArgumentException {
        if (null == string) {
            throw new IllegalArgumentException("null password");
        }
        this.modifyAttribute(2, LDAP_USER_PASSWORD_ATTR_NAME, string);
    }

    public String getValue(String string) throws LDAPException {
        String[] stringArray = this.getValues(string);
        if (null != stringArray && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public String[] getValues(String string) throws LDAPException {
        String[] stringArray;
        if (null == string) {
            return null;
        }
        if (null == this._attrVals) {
            this.loadValues();
        }
        if (null != (stringArray = (String[])this._attrVals.get(string))) {
            return stringArray;
        }
        Enumeration enumeration = this._attrVals.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string.equalsIgnoreCase(string2)) continue;
            return (String[])this._attrVals.get(string2);
        }
        return null;
    }

    public Hashtable getValues() throws LDAPException {
        if (null == this._attrVals) {
            this.loadValues();
        }
        return this._attrVals;
    }

    public String[] getAttributeNames() throws LDAPException {
        if (null == this._attrVals) {
            this.loadValues();
        }
        return this._attrVals.keySet().toArray(ZERO_STRING_ARRAY);
    }

    private Hashtable getClonedAttributeValues(Hashtable hashtable) {
        if (null == hashtable) {
            return null;
        }
        String[] stringArray = hashtable.keySet().toArray(ZERO_STRING_ARRAY);
        Hashtable<String, String[]> hashtable2 = new Hashtable<String, String[]>();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String[] stringArray2 = (String[])hashtable.get(stringArray[i]);
                if (null == stringArray2) continue;
                String[] stringArray3 = new String[stringArray2.length];
                for (int j = 0; j < stringArray2.length; ++j) {
                    stringArray3[j] = new String(stringArray2[j]);
                }
                hashtable2.put(new String(stringArray[i]), stringArray3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return hashtable2;
    }

    public void modifyAttribute(int n, String string, String string2) throws LDAPException {
        if (null == string) {
            return;
        }
        this._ldc.modify(this._DN, new LDAPModification(n, new LDAPAttribute(string, string2)));
        this._attrVals = null;
    }

    public void modifyAttribute(int n, String string, String[] stringArray) throws LDAPException {
        if (null == string) {
            return;
        }
        this._ldc.modify(this._DN, new LDAPModification(n, new LDAPAttribute(string, stringArray)));
        this._attrVals = null;
    }

    public void modifyAttribute(int n, Hashtable hashtable) throws LDAPException {
        if (null == hashtable) {
            return;
        }
        String[] stringArray = hashtable.keySet().toArray(ZERO_STRING_ARRAY);
        LDAPModificationSet lDAPModificationSet = new LDAPModificationSet();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                Object v = hashtable.get(stringArray[i]);
                if (null == v || v instanceof String) {
                    lDAPModificationSet.add(n, new LDAPAttribute(stringArray[i], new String[]{(String)v}));
                    continue;
                }
                lDAPModificationSet.add(n, new LDAPAttribute(stringArray[i], (String[])v));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._ldc.modify(this._DN, lDAPModificationSet);
        this._attrVals = null;
    }

    public String getStringValue(String string, String string2) {
        String string3 = null;
        try {
            string3 = this.getValue(string);
        }
        catch (Exception exception) {
            string3 = null;
        }
        return null == string3 ? string2 : string3;
    }

    public String[] getStringArrayValue(String string, String[] stringArray) {
        String[] stringArray2 = null;
        try {
            stringArray2 = this.getValues(string);
        }
        catch (Exception exception) {
            stringArray2 = null;
        }
        return null == stringArray2 ? stringArray : stringArray2;
    }

    public String getLowerCaseStringValue(String string, String string2) {
        String string3 = this.getStringValue(string, null);
        return null == string3 ? string2 : string3.toLowerCase();
    }

    public String getUpperCaseStringValue(String string, String string2) {
        String string3 = this.getStringValue(string, null);
        return null == string3 ? string2 : string3.toUpperCase();
    }

    public int getIntValue(String string, int n) {
        int n2 = n;
        String string2 = this.getStringValue(string, null);
        if (null != string2) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = n;
            }
        }
        return n2;
    }

    public boolean getBooleanValue(String string, boolean bl) {
        String string2 = this.getStringValue(string, null);
        return null == string2 ? bl : Boolean.valueOf(string2);
    }

    public long getLongValue(String string, long l) {
        long l2 = l;
        String string2 = this.getStringValue(string, null);
        if (null != string2) {
            try {
                l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                l2 = l;
            }
        }
        return l2;
    }

    public float getFloatValue(String string, float f) {
        float f2 = f;
        String string2 = this.getStringValue(string, null);
        if (null != string2) {
            try {
                f2 = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                f2 = f;
            }
        }
        return f2;
    }

    public File getFileValue(String string, String string2) {
        String string3 = this.getStringValue(string, string2);
        if (null == string3 || string3.length() <= 0) {
            return null;
        }
        return new File(string3);
    }
}

