/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.auth;

import com.sun.uwc.common.util.UWCLogger;
import com.sun.uwc.common.util.UWCPreferences;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;

public class MessagingSSO {
    public static final String UWC_AUTH = "uwcauth.";
    public static final String CONFIG_SSO_PREFIX = "messagingsso.";
    public static final String CONFIG_ENABLE = "enable";
    public static final String CONFIG_SESSIONCOOKIE = "sessioncookie";
    public static final String CONFIG_APPPREFIX = "appprefix";
    public static final String CONFIG_APPID = "appid";
    public static final String CONFIG_COOKIEDOMAIN = "cookiedomain";
    public static final String CONFIG_COOKIEPATH = "cookiepath";
    public static final String CONFIG_URL = ".url";
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    public static final String CLIENTIP = "client";
    static Logger ssoLogger = UWCLogger.getLogger("uwc.common.auth");
    private String _defaultDomain = null;
    private boolean _enabled = true;
    private String _appPrefix = null;
    private String _appID = null;
    private String _mySSOCookieName = null;
    private Cookie _ssoCookie = null;
    private String _sessionCookieName = null;
    private HashMap _verifySSOMap = null;

    public MessagingSSO(Preferences preferences) {
        ssoLogger.fine("Read Messaging SSO Properties....");
        this._enabled = preferences.getBoolean("uwcauth.messagingsso.enable", false);
        ssoLogger.finest("enabled is : " + this._enabled);
        this._sessionCookieName = preferences.get("uwcauth.sessioncookie", "JSESSIONID");
        ssoLogger.finest("sessionCookieName is : " + this._sessionCookieName);
        this._appPrefix = preferences.get("uwcauth.appprefix", "ssogrp1");
        if (this._appPrefix != null) {
            this._appPrefix = this._appPrefix.trim();
        }
        ssoLogger.finest("appPrefix is : " + this._appPrefix);
        this._appID = preferences.get("uwcauth.appid", "uwc");
        ssoLogger.finest("appID is : " + this._appID);
        this._mySSOCookieName = this._appPrefix + "-" + this._appID;
        String string = preferences.get("uwcauth.cookiedomain", "iplanet.com");
        ssoLogger.finest("cookieDomain is : " + string);
        String string2 = preferences.get("uwcauth.messagingsso.cookiepath", "/");
        this._ssoCookie = new Cookie(this._mySSOCookieName, "");
        this._ssoCookie.setDomain(string);
        this._ssoCookie.setPath(string2);
        this._verifySSOMap = new HashMap();
        String[] stringArray = UWCPreferences.getKeyProperty(preferences, CONFIG_SSO_PREFIX, CONFIG_URL);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            String string4 = preferences.get(CONFIG_SSO_PREFIX + string3 + CONFIG_URL, "");
            String string5 = this._appPrefix + "-" + string3;
            if (string4 == null || string4.length() <= 0) continue;
            this._verifySSOMap.put(string5, string4);
        }
        ssoLogger.finest("verifySSOMap is : " + this._verifySSOMap.toString());
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public Vector verifySSO(Cookie[] cookieArray, String string, boolean bl) {
        ssoLogger.entering("MessagingSSO:", " verifySSO");
        if (!this._enabled) {
            ssoLogger.exiting("MessagingSSO:", " verifySSO");
            return null;
        }
        if (cookieArray == null || cookieArray.length == 0) {
            ssoLogger.finest("SSO  Cookies are null");
            ssoLogger.exiting("MessagingSSO:", " verifySSO");
            return null;
        }
        int n = cookieArray.length;
        Vector vector = null;
        String string2 = null;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            String string3;
            string2 = cookieArray[i].getName();
            ssoLogger.finest("cookieName:" + string2);
            bl2 = this._mySSOCookieName.equals(string2);
            if (bl2 && bl || (string3 = (String)this._verifySSOMap.get(string2)) == null) continue;
            ssoLogger.finest("Validate cookie" + string2 + " from:" + string3);
            string3 = string3 + CLIENTIP + "=" + string;
            vector = bl2 ? this.verifyOneSSO(string3, this._sessionCookieName, cookieArray[i].getValue()) : this.verifyOneSSO(string3, string2, cookieArray[i].getValue());
            if (vector == null || vector.size() < 2 || !this.isCredValid(vector)) continue;
            ssoLogger.fine("SSO cookie:" + string2 + " Valid");
            break;
        }
        ssoLogger.exiting("MessagingSSO:", " verifySSO");
        return vector;
    }

    public Cookie getSSOCookie(HttpSession httpSession) {
        Cookie cookie = (Cookie)this._ssoCookie.clone();
        cookie.setValue(httpSession.getId());
        return cookie;
    }

    public Cookie getSSOCookie(HttpSession httpSession, String string) {
        Cookie cookie = (Cookie)this._ssoCookie.clone();
        if (string.indexOf(cookie.getDomain()) == -1) {
            cookie.setDomain("");
        }
        cookie.setValue(httpSession.getId());
        ssoLogger.finest("cookie setting:" + cookie.getDomain());
        ssoLogger.finest("cookie setting:" + cookie.toString());
        return cookie;
    }

    public final void sendSuccess(ServletOutputStream servletOutputStream, String string, String string2) throws IOException {
        servletOutputStream.println("fquid=" + string);
        servletOutputStream.println("authtype=" + string2);
    }

    public final void relaySuccess(ServletOutputStream servletOutputStream, Vector vector) throws IOException {
        for (int i = 0; i < vector.size(); ++i) {
            servletOutputStream.println((String)vector.elementAt(i));
        }
    }

    public final void sendError(ServletOutputStream servletOutputStream, String string) throws IOException {
        ssoLogger.severe("sending the following error to messagingserver:" + string);
        servletOutputStream.println("Error=" + string);
    }

    public final boolean hasSessionCookie(Cookie[] cookieArray) {
        int n = cookieArray.length;
        for (int i = 0; i < n; ++i) {
            if (!this._sessionCookieName.equals(cookieArray[i].getName())) continue;
            return true;
        }
        return false;
    }

    private Vector verifyOneSSO(String string, String string2, String string3) {
        Vector<String> vector = new Vector<String>();
        try {
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Accept-Language", "en");
            String string4 = string2 + "=" + URLEncoder.encode(string3);
            httpURLConnection.setRequestProperty("Cookie", string4);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            String string5 = null;
            while ((string5 = bufferedReader.readLine()) != null) {
                vector.addElement(string5);
            }
            httpURLConnection.disconnect();
        }
        catch (Exception exception) {
            return null;
        }
        if (vector.size() <= 0) {
            vector = null;
        }
        return vector;
    }

    private boolean isCredValid(Vector vector) {
        boolean bl = true;
        if (vector == null || vector.size() < 2) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (string.toLowerCase().indexOf("error") == -1) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

