/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.auth;

import com.sun.uwc.common.auth.Domain;
import com.sun.uwc.common.auth.DomainMap;
import com.sun.uwc.common.auth.LDAPConfig;
import com.sun.uwc.common.auth.LDAPDomain;
import com.sun.uwc.common.util.UWCLogger;
import java.util.Hashtable;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class LDAPDomainMap
implements DomainMap {
    static Logger authLogger = UWCLogger.getLogger("uwc.common.auth");
    private static LDAPDomainMap instance;
    private LDAPConfig _ldapConfig = null;
    private Hashtable _domainMap = null;
    private Hashtable _ugDomainMap;

    public static synchronized LDAPDomainMap getInstance(Preferences preferences) {
        if (instance == null) {
            instance = new LDAPDomainMap(preferences);
        }
        return instance;
    }

    protected LDAPDomainMap(Preferences preferences) {
        this.init(preferences);
    }

    public boolean init(Preferences preferences) {
        this._ldapConfig = new LDAPConfig(preferences);
        this._domainMap = new Hashtable();
        this._ugDomainMap = new Hashtable();
        return true;
    }

    public Domain getDomainObject(String string) {
        return this.getDomainObject(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Domain getDomainObject(String string, boolean bl) {
        String[] stringArray;
        LDAPEntry lDAPEntry;
        Object object;
        int n;
        boolean bl2 = false;
        Domain domain = (Domain)this._domainMap.get(string);
        if (domain != null) {
            return domain;
        }
        String string2 = "dc=";
        int n2 = 0;
        while ((n = string.indexOf(46, n2)) != -1) {
            string2 = string2 + string.substring(n2, n) + ",dc=";
            n2 = n + 1;
        }
        string2 = string2 + string.substring(n2) + "," + this._ldapConfig.getDCRoot(bl);
        authLogger.fine("domaindn is " + string2);
        LDAPConnection lDAPConnection = null;
        try {
            lDAPConnection = this._ldapConfig.getConnection(bl);
        }
        catch (LDAPException lDAPException) {
            authLogger.fine("ldap connect failure: " + lDAPException.getMessage());
            return null;
        }
        if (lDAPConnection == null) {
            return null;
        }
        lDAPConnection.bind(this._ldapConfig.getBindDN(bl), this._ldapConfig.getBindCred(bl));
        authLogger.fine("binddn is " + this._ldapConfig.getBindDN(bl));
        boolean bl3 = false;
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string2, 0, this._ldapConfig.getDomainFilter(bl), this._ldapConfig.getDomainAttrs(bl), false);
        if (lDAPSearchResults.hasMoreElements() && (object = (lDAPEntry = lDAPSearchResults.next()).getAttribute("aliasedObjectName")) != null) {
            stringArray = object.getStringValues();
            while (stringArray.hasMoreElements()) {
                string2 = (String)stringArray.nextElement();
            }
            bl3 = true;
        }
        if ((lDAPEntry = lDAPConnection.search(string2, 0, this._ldapConfig.getDomainFilter(bl), this._ldapConfig.getDomainAttrs(bl), false)).hasMoreElements()) {
            object = lDAPEntry.next();
            domain = new LDAPDomain(string, (LDAPEntry)object);
            if (bl3) {
                domain.setIfDomainAlias(true);
            }
        } else {
            authLogger.fine(" Failed. could not find:" + string2);
            bl2 = true;
        }
        object = "";
        if (bl3) {
            authLogger.fine("DEBUG:: domaindn = " + string2);
            stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length - 1; ++i) {
                object = (String)object + stringArray[i].trim().substring(3) + ".";
            }
            object = ((String)object).substring(0, ((String)object).length() - 1);
            authLogger.fine("DEBUG:: realDomainName = " + (String)object);
        } else {
            object = string;
        }
        domain.setRealDomainName((String)object);
        Object var15_17 = null;
        try {
            this._ldapConfig.closeConnection(lDAPConnection, bl);
        }
        catch (Exception exception) {
            authLogger.fine(" unable to disconnect");
        }
        if (!bl2) {
            if (!bl) {
                this._domainMap.put(string, domain);
            } else {
                this._ugDomainMap.put(string, domain);
            }
            return domain;
        }
        return null;
        {
            catch (LDAPException lDAPException) {
                authLogger.fine(" Failed. unable to search for domaindn");
                bl2 = true;
                Object var15_18 = null;
                try {
                    this._ldapConfig.closeConnection(lDAPConnection, bl);
                }
                catch (Exception exception) {
                    authLogger.fine(" unable to disconnect");
                }
                if (!bl2) {
                    if (!bl) {
                        this._domainMap.put(string, domain);
                    } else {
                        this._ugDomainMap.put(string, domain);
                    }
                    return domain;
                }
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var15_19 = null;
            try {
                this._ldapConfig.closeConnection(lDAPConnection, bl);
            }
            catch (Exception exception) {
                authLogger.fine(" unable to disconnect");
            }
            if (!bl2) {
                if (!bl) {
                    this._domainMap.put(string, domain);
                } else {
                    this._ugDomainMap.put(string, domain);
                }
                return domain;
            }
            return null;
        }
    }
}

