/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.auth;

import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.ldap.LDAPPool;
import com.sun.uwc.common.util.UWCLogger;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class LDAPConfig {
    public static final String AUTH_PREFIX = "ldapauth.";
    public static final String UG_PREFIX = "ldapusersession.";
    public static final String LDAPHOST = "ldaphost";
    public static final String LDAPPORT = "ldapport";
    public static final String ENABLE_SSL = "enablessl";
    public static final String LDAPDCROOT = "dcroot";
    public static final String LDAP_BINDDN = "ldapbinddn";
    public static final String LDAP_BINDCRED = "ldapbindcred";
    public static final String LDAPDOMAINFILTER = "domainfilter";
    public static final String LDAPDOMAINATTR = "domainattr";
    public static final String DEFAULT_DOMAIN = "defaultdomain";
    public static final String UWC_AUTH = "uwcauth.";
    public static final String CONFIG_COOKIEDOMAIN = "cookiedomain";
    public static final String CONFIG_COOKIEPATH = "cookiepath";
    public static final String CONFIG_APPPREFIX = "appprefix";
    public static final String CONFIG_APPID = "appid";
    protected static boolean _initialized = false;
    protected static String _ldapHost = new String();
    protected static int _ldapPort = 389;
    protected static boolean _useSSL = false;
    protected static String _ldapdcRoot = null;
    protected static String _ldapbinddn = null;
    protected static String _ldapbindcred = null;
    protected static String _ldapDomainAttr = null;
    protected static String _defaultdomain = null;
    protected static String _ldapDomainFilter = null;
    protected static String[] domainAttrs = null;
    protected static String _ugldapHost = new String();
    protected static int _ugldapPort = 389;
    protected static boolean _uguseSSL = false;
    protected static String _ugldapdcRoot = null;
    protected static String _ugldapbinddn = null;
    protected static String _ugldapbindcred = null;
    protected static String _ugldapDomainAttr = null;
    protected static String _ugdefaultdomain = null;
    protected static String _ugldapDomainFilter = null;
    protected static String[] ugdomainAttrs = null;
    private Cookie _uwcCookie = null;
    private static String cookieDomain = null;

    public LDAPConfig(Preferences preferences) {
        if (!_initialized) {
            this.init(preferences);
            this.initUG(preferences);
        }
    }

    protected void init(Preferences preferences) {
        Logger logger = UWCLogger.getLogger("uwc.common.auth");
        _defaultdomain = preferences.get(DEFAULT_DOMAIN, "sun.com");
        logger.fine(" Read defaultdomain:" + _defaultdomain);
        _ldapHost = preferences.get("ldapauth.ldaphost", null);
        if (_ldapHost != null) {
            logger.fine(" Read ldap host:" + _ldapHost);
            _ldapPort = preferences.getInt("ldapauth.ldapport", 389);
            logger.fine(" Read ldap port:" + _ldapPort);
            _useSSL = preferences.getBoolean("ldapauth.enablessl", false);
            _ldapdcRoot = preferences.get("ldapauth.dcroot", "o=internet");
            logger.fine(" Read ldap dcroot:" + _ldapdcRoot);
            _ldapbinddn = preferences.get("ldapauth.ldapbinddn", null);
            _ldapbindcred = preferences.get("ldapauth.ldapbindcred", null);
            _ldapDomainAttr = preferences.get("ldapauth.domainattr", "inetDomainBaseDN,inetDomainStatus,inetDomainSearchFilter,domainUidSeparator,preferredLanguage,aliasedObjectName");
            logger.fine(" Read ldap domainAttr:" + _ldapDomainAttr);
            _ldapDomainFilter = preferences.get("ldapauth.domainfilter", "(|(objectclass=inetDomain)(objectclass=inetDomainAlias))");
            logger.fine(" read ldap domainfilter:" + _ldapDomainFilter);
        } else {
            _ldapHost = preferences.get("ldapusersession.ldaphost", null);
            logger.fine(" Read ldap host:" + _ldapHost);
            _ldapPort = preferences.getInt("ldapusersession.ldapport", 389);
            logger.fine(" Read ldap port:" + _ldapPort);
            _useSSL = preferences.getBoolean("ldapusersession.enablessl", false);
            _ldapdcRoot = preferences.get("ldapusersession.dcroot", "o=internet");
            logger.fine(" Read ldap dcroot:" + _ldapdcRoot);
            _ldapbinddn = preferences.get("ldapusersession.ldapbinddn", null);
            _ldapbindcred = preferences.get("ldapusersession.ldapbindcred", null);
            _ldapDomainAttr = preferences.get("ldapusersession.domainattr", "inetDomainBaseDN,inetDomainStatus,inetDomainSearchFilter,domainUidSeparator,preferredLanguage,aliasedObjectName");
            logger.fine(" Read ldap domainAttr:" + _ldapDomainAttr);
            _ldapDomainFilter = preferences.get("ldapusersession.domainfilter", "(|(objectclass=inetDomain)(objectclass=inetDomainAlias))");
            logger.fine(" read ldap domainfilter:" + _ldapDomainFilter);
        }
        domainAttrs = _ldapDomainAttr.split(",");
        String string = preferences.get("uwcauth.appprefix", "ssogrp1");
        if (string != null) {
            string = string.trim();
        }
        logger.finest("appPrefix is : " + string);
        String string2 = preferences.get("uwcauth.appid", "uwc");
        logger.finest("appID is : " + string2);
        cookieDomain = preferences.get("uwcauth.cookiedomain", "iplanet.com");
        logger.finest("cookieDomain is : " + cookieDomain);
        String string3 = preferences.get("uwcauth.cookiepath", "/");
        String string4 = string + "-" + string2;
        this._uwcCookie = new Cookie(string4, "");
        this._uwcCookie.setPath(string3);
        _initialized = true;
    }

    protected void initUG(Preferences preferences) {
        _ugldapHost = preferences.get("ldapusersession.ldaphost", null);
        _ugldapPort = preferences.getInt("ldapusersession.ldapport", 389);
        _uguseSSL = preferences.getBoolean("ldapusersession.enablessl", false);
        _ugldapdcRoot = preferences.get("ldapusersession.dcroot", "o=internet");
        _ugldapbinddn = preferences.get("ldapusersession.ldapbinddn", null);
        _ugldapbindcred = preferences.get("ldapusersession.ldapbindcred", null);
        _ugldapDomainAttr = preferences.get("ldapusersession.domainattr", "inetDomainBaseDN,inetDomainStatus,inetDomainSearchFilter,domainUidSeparator,preferredLanguage,aliasedObjectName");
        _ugldapDomainFilter = preferences.get("ldapusersession.domainfilter", "(|(objectclass=inetDomain)(objectclass=inetDomainAlias))");
        ugdomainAttrs = _ugldapDomainAttr.split(",");
    }

    public LDAPConnection getConnection(boolean bl) throws LDAPException {
        LDAPConnection lDAPConnection = null;
        if (!bl) {
            lDAPConnection = new LDAPConnection();
        } else {
            LDAPPool lDAPPool = UWCApplicationHelper.getLDAPPool();
            if (lDAPPool == null) {
                throw new LDAPException("LDAP pool not created yet.");
            }
            lDAPConnection = lDAPPool.getConnection();
        }
        lDAPConnection.connect(_ldapHost, _ldapPort);
        return lDAPConnection;
    }

    public void closeConnection(LDAPConnection lDAPConnection, boolean bl) throws LDAPException {
        if (bl) {
            LDAPPool lDAPPool = UWCApplicationHelper.getLDAPPool();
            if (lDAPPool == null) {
                return;
            }
            if (lDAPConnection != null) {
                lDAPPool.close(lDAPConnection);
            }
        } else if (lDAPConnection.isConnected()) {
            lDAPConnection.disconnect();
        }
    }

    public String getDCRoot(boolean bl) {
        return bl ? _ugldapdcRoot : _ldapdcRoot;
    }

    public String getDomainFilter(boolean bl) {
        return bl ? _ugldapDomainFilter : _ldapDomainFilter;
    }

    public String[] getDomainAttrs(boolean bl) {
        return bl ? ugdomainAttrs : domainAttrs;
    }

    public String getDefaultDomain() {
        return _defaultdomain;
    }

    public String getRdnAttribute(String string) {
        if (string.equalsIgnoreCase("USER")) {
            return "uid";
        }
        if (string.equalsIgnoreCase("DOMAIN")) {
            return "o";
        }
        if (string.equalsIgnoreCase("DOMAINORGANIZATION")) {
            return "ou";
        }
        return "uid";
    }

    public String getStatusAttr(String string) {
        if (string.equalsIgnoreCase("USER")) {
            return "inetuserstatus";
        }
        if (string.equalsIgnoreCase("DOMAIN")) {
            return "inetdomainstatus";
        }
        return null;
    }

    public String getBindDN(boolean bl) {
        return bl ? _ugldapbinddn : _ldapbinddn;
    }

    public String getBindCred(boolean bl) {
        return bl ? _ugldapbindcred : _ldapbindcred;
    }

    public String getAuthHost() {
        return _ldapHost;
    }

    public String getAuthPort() {
        return Integer.toString(_ldapPort);
    }

    public Cookie getUWCCookie(HttpSession httpSession) {
        Cookie cookie = (Cookie)this._uwcCookie.clone();
        cookie.setValue(httpSession.getId());
        return cookie;
    }

    public Cookie getUWCCookie(HttpSession httpSession, String string) {
        Cookie cookie = (Cookie)this._uwcCookie.clone();
        if (string.indexOf(cookieDomain) != -1) {
            cookie.setDomain(cookieDomain);
        }
        cookie.setValue(httpSession.getId());
        return cookie;
    }
}

