/*
 * Decompiled with CFR 0.152.
 */
package com.sun.uwc.common.auth;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.comclient.calendar.DateTime;
import com.sun.uwc.UWCServletBase;
import com.sun.uwc.common.ISUserHelper;
import com.sun.uwc.common.UWCApplicationHelper;
import com.sun.uwc.common.auth.AuthFilter;
import com.sun.uwc.common.auth.IdentitySSO;
import com.sun.uwc.common.auth.UWCIdentitySSOTokenListener;
import com.sun.uwc.common.util.UWCDomainManager;
import com.sun.uwc.common.util.UWCUtils;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.TimeZone;
import java.util.prefs.Preferences;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class IdentitySSOAuthFilter
extends AuthFilter {
    public static final String CONFIG_FILENAME = "uwcauth.properties";
    public static final String CONFIG_IDENTITY_URL = "uwcauth.identity.login.url";
    public static final String CONFIG_IDENTITY_COOKIE = "uwcauth.identity.cookiename";
    private final transient String IS_AUTH_ERR_INDICATOR = "err";
    private static final String AUTH_ONLY_PARAM = "authOnly";
    public String AUTH_ERROR = "autherror";
    private String _defaultDomain = null;
    private static String _identityCookieName = null;
    private static String _cookieDomain = null;
    private String _config_filename = null;
    private String _identityURL = null;
    private boolean _enabled = true;
    private boolean _sslEnabled = false;
    private IdentitySSO _identitySSO = null;
    private Hashtable _orgToDomainMap;
    static int _uwcPort = 80;
    static int _uwcSSLPort = 443;

    public void init(FilterConfig filterConfig) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(filterConfig);
        Preferences preferences = super.getPreferences();
        this._defaultDomain = preferences.get("defaultdomain", "iplanet.com");
        this._sslEnabled = preferences.getBoolean("uwcauth.ssl.enabled", false);
        _uwcSSLPort = preferences.getInt("uwcauth.https.port", 443);
        _uwcPort = preferences.getInt("uwcauth.http.port", 80);
        this._identityURL = preferences.get(CONFIG_IDENTITY_URL, null);
        _identityCookieName = preferences.get(CONFIG_IDENTITY_COOKIE, "iPlanetDirectoryPro");
        _cookieDomain = preferences.get("uwcauth.cookiedomain", "iplanet.com");
        this._identitySSO = new IdentitySSO(preferences);
        this._orgToDomainMap = new Hashtable(3);
    }

    public static int getdcount(String string) {
        int n = 0;
        while (string.indexOf(".") != -1) {
            ++n;
            string = string.substring(string.indexOf(".") + 1);
        }
        return n;
    }

    private String extractISHostFromURL() {
        int n = this._identityURL.indexOf("//");
        int n2 = this._identityURL.indexOf("/", n + 3);
        return this._identityURL.substring(n + 2, n2);
    }

    private String isPortFromURL() {
        String string = this.extractISHostFromURL();
        int n = string.indexOf(":");
        if (n != -1) {
            return string.substring(n);
        }
        return "";
    }

    private String constructIsHost(HttpServletRequest httpServletRequest) {
        String string = this.extractISHostFromURL();
        String string2 = UWCUtils.getHostHeaderFromURL(httpServletRequest);
        return string.substring(0, string.indexOf(".") + 1) + string2.substring(string2.indexOf(".") + 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
        Object object;
        boolean bl;
        String string;
        String string2;
        HttpSession httpSession;
        HttpServletRequest httpServletRequest;
        boolean bl2;
        String string3;
        String string4;
        block60: {
            String string5;
            String string6;
            Object object2;
            authLogger.entering("IdentitySSOAuthFilter:", " doFilter");
            if (!this._identityEnabled) {
                authLogger.entering("IdentitySSOAuthFilter:", " identity not enabled");
                authLogger.exiting("IdentitySSOAuthFilter:", " doFilter");
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            String string7 = "false";
            string4 = null;
            string3 = null;
            bl2 = false;
            httpServletRequest = (HttpServletRequest)servletRequest;
            httpSession = httpServletRequest.getSession(false);
            if (httpSession != null) {
                authLogger.exiting("IdentitySSOAuthFilter:", " doFilter");
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            String string8 = this._identityURL;
            UWCDomainManager uWCDomainManager = UWCServletBase.getApplicationConfigMgr().getDomainManager();
            string3 = UWCUtils.domainFromURL(httpServletRequest, uWCDomainManager);
            if (string3 != null) {
                object2 = super.getPreferences();
                string5 = ((Preferences)object2).get((string6 = UWCUtils.getHostHeaderFromURL(httpServletRequest)) + ".isvirtualhostname", null);
                if (string5 == null) {
                    string5 = this.constructIsHost(httpServletRequest);
                }
                string5 = string5 + this.isPortFromURL();
                try {
                    if (string5 != null) {
                        int n = this._identityURL.indexOf("//");
                        string8 = this._identityURL.substring(0, n + 2);
                        n = this._identityURL.indexOf("/", n + 3);
                        string8 = string8 + string5 + this._identityURL.substring(n);
                    }
                }
                catch (Exception exception) {
                    this.dump_stack(exception);
                }
            }
            if (string3 == null) {
                string3 = this._defaultDomain;
            }
            httpServletRequest.setAttribute("identityURL", (Object)string8);
            object2 = httpServletRequest.getServerName();
            string6 = httpServletRequest.getContextPath();
            if (string6 == null || string6 != null && string6.equals("/")) {
                string6 = "";
            }
            string5 = new NonSyncStringBuffer();
            if (this._sslEnabled) {
                string5.append("https://");
                string5.append((String)object2);
                string5.append(":");
                string5.append(_uwcSSLPort);
                string5.append(string6);
                string5.append("/");
            } else {
                string5.append("http://");
                string5.append((String)object2);
                string5.append(":");
                string5.append(_uwcPort);
                string5.append(string6);
                string5.append("/");
            }
            String string9 = "goto=" + string5.toString();
            httpServletRequest.setAttribute("goto=", (Object)string9);
            NonSyncStringBuffer nonSyncStringBuffer = new NonSyncStringBuffer("gotoOnFail=");
            nonSyncStringBuffer.append(string5.toString());
            nonSyncStringBuffer.append("?");
            nonSyncStringBuffer.append("err");
            nonSyncStringBuffer.append("=1");
            string9 = nonSyncStringBuffer.toString();
            httpServletRequest.setAttribute("gotoOnFail=", (Object)string9);
            httpServletRequest.setAttribute("defaultdomain", (Object)this._defaultDomain);
            httpServletRequest.setAttribute("domain_name", (Object)string3);
            string2 = IdentitySSOAuthFilter.getProxyUserFromRequest(httpServletRequest);
            String string10 = IdentitySSOAuthFilter.getUserFromRequest(httpServletRequest);
            string = IdentitySSOAuthFilter.getPasswordFromRequest(httpServletRequest);
            String string11 = httpServletRequest.getParameter("fromlogin");
            bl = false;
            bl = IdentitySSOAuthFilter.isProxyRequest(httpServletRequest);
            if (string10 != null && string10.length() > 0 && string != null && string.length() > 0) {
                int n = string10.lastIndexOf("@");
                if (n != -1) {
                    string4 = string10.substring(0, n);
                    string3 = string10.substring(n + 1);
                } else {
                    string4 = string10;
                    if (string3 == null) {
                        string3 = this._defaultDomain;
                    }
                }
                if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                    authLogger.fine("uid... " + string4 + "domain..." + string3);
                }
                authLogger.fine("username... " + string10);
                object = httpServletRequest.getParameter(AUTH_ONLY_PARAM);
                if (object != null && ((String)object).equalsIgnoreCase("true")) {
                    bl2 = true;
                    break block60;
                } else {
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
            }
            Map map = httpServletRequest.getParameterMap();
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                authLogger.fine("IdentitySSOAuthFilter: Resolved domain? " + string3);
            }
            if (map != null && map.containsKey("err")) {
                authLogger.warning("IS Auth Error!");
                string7 = "true";
                servletRequest.setAttribute(this.AUTH_ERROR, (Object)string7);
                servletRequest.setAttribute("domain_name", (Object)string3);
                servletRequest.setAttribute("defaultdomain", (Object)this._defaultDomain);
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
            if (string11 != null && string11.equals("true")) {
                string7 = "true";
                servletRequest.setAttribute(this.AUTH_ERROR, (Object)string7);
                servletRequest.setAttribute("defaultdomain", (Object)this._defaultDomain);
                servletRequest.setAttribute("domain_name", (Object)string3);
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }
        }
        try {
            String string12;
            String string13;
            String string14;
            String string15;
            String string16;
            Object object3;
            SSOTokenManager sSOTokenManager;
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                authLogger.fine("1. session is not present.. get token manager.. ");
            }
            String string17 = null;
            object = null;
            AMStoreConnection aMStoreConnection = this._identitySSO.getAdminStoreConnection();
            if (bl2) {
                string17 = this.getSearchBase(string3, aMStoreConnection);
                this._orgToDomainMap.put(string3, string17);
                object = IdentitySSO.getSSOToken(string17, string4, string);
                if (object == null) {
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
            } else {
                boolean bl3;
                sSOTokenManager = SSOTokenManager.getInstance();
                object = sSOTokenManager.createSSOToken(httpServletRequest);
                if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                    authLogger.fine("2. check for the token validity ");
                }
                if (!(bl3 = sSOTokenManager.isValidToken((SSOToken)object))) {
                    authLogger.fine("3. Invalid Response");
                    authLogger.exiting("IdentitySSOAuthFilter:", " doFilter");
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
            }
            sSOTokenManager = new AMStoreConnection((SSOToken)object);
            AMUser aMUser = null;
            if (bl) {
                authLogger.fine("ProxyAuth Request ....");
                object3 = null;
                string16 = null;
                int n = string2.lastIndexOf("@");
                if (n != -1) {
                    object3 = string2.substring(0, n);
                    string16 = string2.substring(n + 1);
                } else {
                    object3 = string2;
                    string16 = string3;
                }
                authLogger.fine("Proxy user id =" + (String)object3);
                authLogger.fine("Proxy Domain " + string16);
                if (!this.isUserProxyAdmin(string4, string3)) {
                    authLogger.fine("Invalid Proxy Admin");
                    filterChain.doFilter(servletRequest, servletResponse);
                    return;
                }
                authLogger.fine("Admin is Valid ....");
                string15 = this._identitySSO.getAdminStoreConnection();
                if (!string16.equals(string3)) {
                    string17 = this.getSearchBase(string16, (AMStoreConnection)string15);
                    this._orgToDomainMap.put(string3, string17);
                    if (string17 == null) {
                        filterChain.doFilter(servletRequest, servletResponse);
                        return;
                    }
                }
                if (null != (string14 = string15.getOrganization(string17))) {
                    authLogger.fine("Org Object is not NULL");
                }
                if (null == (aMUser = string14.getUser((String)object3, null))) {
                    authLogger.fine("amuser is NULL!!");
                }
            } else {
                aMUser = sSOTokenManager.getUser(object.getPrincipal().getName());
            }
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                authLogger.fine("3. Valid Response create session");
            }
            httpSession = httpServletRequest.getSession(true);
            object3 = object.getTokenID();
            httpSession.setAttribute("identitytokenid", (Object)object3.toString());
            string16 = new DateTime(TimeZone.getTimeZone("GMT")).toISO8601();
            object.setProperty("uwcstatus", "active");
            httpSession.setAttribute("identitylastaccessGMTtime", (Object)string16);
            String string18 = aMUser.getStringAttribute("uid");
            string17 = aMUser.getOrganizationDN();
            string15 = aMUser.getDN();
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                authLogger.fine("6. userDN is " + string15);
            }
            string14 = aMUser.getStringAttribute("mail");
            String string19 = aMUser.getStringAttribute("cn");
            String string20 = aMUser.getStringAttribute("inetUserStatus");
            if (string20 != null && string20.length() == 0) {
                string20 = null;
            }
            String string21 = aMUser.getStringAttribute("preferredLanguage");
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                authLogger.fine("9. preferredLanguage is " + string21);
            }
            if ((string13 = aMUser.getStringAttribute("cn;lang-" + string21)) == null || string13 != null && string13.length() == 0) {
                string13 = aMUser.getStringAttribute("cn");
            }
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                authLogger.fine("10. commonName is " + string13);
            }
            AMOrganization aMOrganization = aMStoreConnection.getOrganization(string17);
            string3 = aMOrganization.getStringAttribute("sunPreferredDomain");
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                authLogger.fine("11. domainName is " + string3);
            }
            if ((string12 = aMOrganization.getStringAttribute("inetDomainStatus")) != null && string12.length() == 0) {
                string12 = null;
            }
            if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                authLogger.fine("12. inetDomainStatus is " + string12);
            }
            if (string12 != null && string12.equalsIgnoreCase("inactive")) {
                httpSession.setAttribute("mail.service.enabled", (Object)"false");
                httpSession.setAttribute("calendar.service.enabled", (Object)"false");
            } else {
                boolean bl4 = ISUserHelper.getMailServiceStatus(aMUser, aMOrganization);
                httpSession.setAttribute("mail.service.enabled", (Object)String.valueOf(bl4));
                if (UWCApplicationHelper.IS_FINE_LVL_LOGGABLE) {
                    authLogger.fine("13. MailService:  " + bl4);
                }
                bl4 = ISUserHelper.getCalendarServiceStatus(aMUser, aMOrganization);
                httpSession.setAttribute("calendar.service.enabled", (Object)String.valueOf(bl4));
            }
            String string22 = null;
            httpSession.setAttribute("uid", (Object)string18);
            httpSession.setAttribute("userdn", (Object)string15);
            httpSession.setAttribute("userauthdn", (Object)string15);
            httpSession.setAttribute("domaindn", (Object)string17);
            httpSession.setAttribute("domainname", (Object)string3);
            httpSession.setAttribute("userlang", (Object)string21);
            if (string14 != null) {
                httpSession.setAttribute("email", (Object)string14);
            }
            if (string19 != null) {
                httpSession.setAttribute("cn", (Object)string19);
            }
            httpSession.setAttribute("com.sun.uwc.newsession", (Object)"true");
            string22 = httpServletRequest.getHeader("user-agent");
            if (string22 != null) {
                httpSession.setAttribute("useragent", (Object)string22);
            }
            if ((string22 = httpServletRequest.getHeader("accept-language")) != null) {
                httpSession.setAttribute("acceptlang", (Object)string22);
            }
            if ((string22 = httpServletRequest.getHeader("accept-charset")) != null) {
                httpSession.setAttribute("charsetenc", (Object)string22);
            }
            httpSession.setAttribute("username", (Object)string13);
            authLogger.fine("Valid Response");
            UWCIdentitySSOTokenListener uWCIdentitySSOTokenListener = new UWCIdentitySSOTokenListener(object3.toString());
            object.addSSOTokenListener((SSOTokenListener)uWCIdentitySSOTokenListener);
            httpSession.setAttribute("IdentitySSOTokenListener", (Object)uWCIdentitySSOTokenListener);
            authLogger.exiting("IdentitySSOAuthFilter:", " doFilter");
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        catch (SSOException sSOException) {
            authLogger.warning("SSOException.." + sSOException.getMessage());
            if (httpSession != null) {
                httpSession.invalidate();
            }
            ISUserHelper.removeIdentityCookie(servletRequest, servletResponse);
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        catch (AMException aMException) {
            authLogger.warning("AMException.." + aMException.getMessage());
            if (httpSession != null) {
                httpSession.invalidate();
            }
            ISUserHelper.removeIdentityCookie(servletRequest, servletResponse);
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            authLogger.warning("Exception.." + exception.getMessage());
            if (httpSession != null) {
                httpSession.invalidate();
            }
            ISUserHelper.removeIdentityCookie(servletRequest, servletResponse);
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
    }

    private void dump_stack(Exception exception) {
        authLogger.finest("*** Start Stack Trace ******");
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            authLogger.finest(stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "@" + stackTraceElement.getLineNumber());
        }
        authLogger.finest("****** End Stack Trace ******");
    }

    public void destroy() {
    }

    public String getSearchBase(String string, AMStoreConnection aMStoreConnection) throws SSOException {
        String string2 = null;
        if (this._orgToDomainMap.containsKey(string)) {
            return (String)this._orgToDomainMap.get(string);
        }
        try {
            if (aMStoreConnection != null) {
                string2 = aMStoreConnection.getOrganizationDN(string, null);
            }
        }
        catch (AMException aMException) {
            throw new SSOException(aMException.toString());
        }
        return string2;
    }

    public static String getIdentityCookieName() {
        return _identityCookieName;
    }

    public static String getIdentityCookieDomain() {
        return _cookieDomain;
    }
}

